<?php
/**
 * This file creates the States Table in Database
 */
// Terminate if accessed directly
if(!defined('ABSPATH')){
    die();
}

/**
 * Dumping data to table `$wp_iws_states` if table is created
 */
if($table_created){
    $query = "INSERT INTO `".esc_sql($wp_iws_states)."` (`id`, `name`, `country_id`, `country_code`, `latitude`, `longitude`) VALUES
        (1, 'Southern Nations, Nationalities, and Peoples\' Region', 70, 'ET', '6.51569110', '36.95410700'),
        (2, 'Somali Region', 70, 'ET', '6.66122930', '43.79084530'),
        (3, 'Amhara Region', 70, 'ET', '11.34942470', '37.97845850'),
        (4, 'Tigray Region', 70, 'ET', '14.03233360', '38.31657250'),
        (5, 'Oromia Region', 70, 'ET', '7.54603770', '40.63468510'),
        (6, 'Afar Region', 70, 'ET', '11.75593880', '40.95868800'),
        (7, 'Harari Region', 70, 'ET', '9.31486600', '42.19677160'),
        (8, 'Dire Dawa', 70, 'ET', '9.60087470', '41.85014200'),
        (9, 'Benishangul-Gumuz Region', 70, 'ET', '10.78028890', '35.56578620'),
        (10, 'Gambela Region', 70, 'ET', '7.92196870', '34.15319470'),
        (11, 'Addis Ababa', 70, 'ET', '8.98060340', '38.75776050'),
        (12, 'Petnjica Municipality', 147, 'ME', '42.93534800', '20.02114490'),
        (13, 'Bar Municipality', 147, 'ME', '42.12781190', '19.14043800'),
        (14, 'Danilovgrad Municipality', 147, 'ME', '42.58357000', '19.14043800'),
        (15, 'Rožaje Municipality', 147, 'ME', '42.84083890', '20.16706280'),
        (16, 'Plužine Municipality', 147, 'ME', '43.15933840', '18.85514840'),
        (17, 'Nikšić Municipality', 147, 'ME', '42.79971840', '18.76009630'),
        (18, 'Šavnik Municipality', 147, 'ME', '42.96037560', '19.14043800'),
        (19, 'Plav Municipality', 147, 'ME', '42.60013370', '19.94075410'),
        (20, 'Pljevlja Municipality', 147, 'ME', '43.27233830', '19.28315310'),
        (21, 'Berane Municipality', 147, 'ME', '42.82572890', '19.90205090'),
        (22, 'Mojkovac Municipality', 147, 'ME', '42.96880180', '19.52110630'),
        (23, 'Andrijevica Municipality', 147, 'ME', '42.73624770', '19.78595560'),
        (24, 'Gusinje Municipality', 147, 'ME', '42.55634550', '19.83060510'),
        (25, 'Bijelo Polje Municipality', 147, 'ME', '43.08465260', '19.71154720'),
        (26, 'Kotor Municipality', 147, 'ME', '42.57402610', '18.64131450'),
        (27, 'Podgorica Municipality', 147, 'ME', '42.36938340', '19.28315310'),
        (28, 'Old Royal Capital Cetinje', 147, 'ME', '42.39309590', '18.91159640'),
        (29, 'Tivat Municipality', 147, 'ME', '42.42348000', '18.71851840'),
        (30, 'Budva Municipality', 147, 'ME', '42.31407200', '18.83138320'),
        (31, 'Kolašin Municipality', 147, 'ME', '42.76019160', '19.42591140'),
        (32, 'Žabljak Municipality', 147, 'ME', '43.15551520', '19.12260180'),
        (33, 'Ulcinj Municipality', 147, 'ME', '41.96527950', '19.30694320'),
        (34, 'Kunene Region', 152, 'NA', '-19.40863170', '13.91439900'),
        (35, 'Kavango West Region', 152, 'NA', '-18.27104800', '18.42760470'),
        (36, 'Kavango East Region', 152, 'NA', '-18.27104800', '18.42760470'),
        (37, 'Oshana Region', 152, 'NA', '-18.43050640', '15.68817880'),
        (38, 'Hardap Region', 152, 'NA', '-24.23101340', '17.66888700'),
        (39, 'Omusati Region', 152, 'NA', '-18.40702940', '14.84546190'),
        (40, 'Ohangwena Region', 152, 'NA', '-17.59792910', '16.81783770'),
        (41, 'Omaheke Region', 152, 'NA', '-21.84666510', '19.18800470'),
        (42, 'Oshikoto Region', 152, 'NA', '-18.41525750', '16.91225100'),
        (43, 'Erongo Region', 152, 'NA', '-22.25656820', '15.40680790'),
        (44, 'Khomas Region', 152, 'NA', '-22.63778540', '17.10119310'),
        (45, 'Karas Region', 152, 'NA', '-26.84296450', '17.29028390'),
        (46, 'Otjozondjupa Region', 152, 'NA', '-20.54869160', '17.66888700'),
        (47, 'Zambezi Region', 152, 'NA', '-17.81934190', '23.95364660'),
        (48, 'Ashanti Region', 83, 'GH', '6.74704360', '-1.52086240'),
        (49, 'Western Region', 83, 'GH', NULL, NULL),
        (50, 'Eastern Region', 83, 'GH', NULL, NULL),
        (51, 'Northern Region', 83, 'GH', NULL, NULL),
        (52, 'Central Region', 83, 'GH', NULL, NULL),
        (53, 'Brong-Ahafo Region', 83, 'GH', '7.95592470', '-1.67606910'),
        (54, 'Greater Accra Region', 83, 'GH', '5.81428360', '0.07467670'),
        (55, 'Upper East Region', 83, 'GH', '10.70824990', '-0.98206680'),
        (56, 'Volta Region', 83, 'GH', '6.57813730', '0.45023680'),
        (57, 'Upper West Region', 83, 'GH', '10.25297570', '-2.14502450'),
        (58, 'San Marino', 192, 'SM', '43.94236000', '12.45777700'),
        (59, 'Acquaviva', 192, 'SM', '41.86715970', '14.74694790'),
        (60, 'Chiesanuova', 192, 'SM', '45.42261720', '7.65038540'),
        (61, 'Borgo Maggiore', 192, 'SM', '43.95748820', '12.45525460'),
        (62, 'Faetano', 192, 'SM', '43.93489670', '12.48965540'),
        (63, 'Montegiardino', 192, 'SM', '43.90529990', '12.48105420'),
        (64, 'Domagnano', 192, 'SM', '43.95019290', '12.46815370'),
        (65, 'Serravalle', 192, 'SM', '44.72320840', '8.85740050'),
        (66, 'Fiorentino', 192, 'SM', '43.90783370', '12.45812090'),
        (67, 'Tillabéri Region', 160, 'NE', '14.64895250', '2.14502450'),
        (68, 'Dosso Region', 160, 'NE', '13.15139470', '3.41955270'),
        (69, 'Zinder Region', 160, 'NE', '15.17188810', '10.26001250'),
        (70, 'Maradi Region', 160, 'NE', '13.80180740', '7.43813550'),
        (71, 'Agadez Region', 160, 'NE', '20.66707520', '12.07182810'),
        (72, 'Diffa Region', 160, 'NE', '13.67686470', '12.71351210'),
        (73, 'Tahoua Region', 160, 'NE', '16.09025430', '5.39395510'),
        (74, 'Mqabba', 135, 'MT', '35.84441430', '14.46941860'),
        (75, 'San Ġwann', 135, 'MT', '35.90773650', '14.47524160'),
        (76, 'Żurrieq', 135, 'MT', '35.82163060', '14.48106480'),
        (77, 'Luqa', 135, 'MT', '35.85828650', '14.48688830'),
        (78, 'Marsaxlokk', 135, 'MT', '35.84116990', '14.53930970'),
        (79, 'Qala', 135, 'MT', '36.03886280', '14.31810100'),
        (80, 'Żebbuġ Malta', 135, 'MT', '35.87646480', '14.43908400'),
        (81, 'Xgħajra', 135, 'MT', '35.88682820', '14.54723910'),
        (82, 'Kirkop', 135, 'MT', '35.84378620', '14.48543240'),
        (83, 'Rabat', 135, 'MT', '33.97159040', '-6.84981290'),
        (84, 'Floriana', 135, 'MT', '45.49521850', '-73.71395760'),
        (85, 'Żebbuġ Gozo', 135, 'MT', '36.07164030', '14.24540800'),
        (86, 'Swieqi', 135, 'MT', '35.91911820', '14.46941860'),
        (87, 'Saint Lawrence', 135, 'MT', '38.95780560', '-95.25656890'),
        (88, 'Birżebbuġa', 135, 'MT', '35.81359890', '14.52474630'),
        (89, 'Mdina', 135, 'MT', '35.88809300', '14.40683570'),
        (90, 'Santa Venera', 135, 'MT', '35.89022010', '14.47669740'),
        (91, 'Kerċem', 135, 'MT', '36.04479390', '14.22506050'),
        (92, 'Għarb', 135, 'MT', '36.06890900', '14.20180980'),
        (93, 'Iklin', 135, 'MT', '35.90987740', '14.45777320'),
        (94, 'Santa Luċija', 135, 'MT', '35.85614200', '14.50436000'),
        (95, 'Valletta', 135, 'MT', '35.89890850', '14.51455280'),
        (96, 'Msida', 135, 'MT', '35.89563880', '14.48688830'),
        (97, 'Birkirkara', 135, 'MT', '35.89547060', '14.46650720'),
        (98, 'Siġġiewi', 135, 'MT', '35.84637420', '14.43157460'),
        (99, 'Kalkara', 135, 'MT', '35.89142420', '14.53202780'),
        (100, 'St. Julian\'s', 135, 'MT', '42.21225130', '-85.89171270'),
        (101, 'Victoria', 135, 'MT', '28.80526740', '-97.00359820'),
        (102, 'Mellieħa', 135, 'MT', '35.95235290', '14.35009750'),
        (103, 'Tarxien', 135, 'MT', '35.86725520', '14.51164050'),
        (104, 'Sliema', 135, 'MT', '35.91100810', '14.50290400'),
        (105, 'Ħamrun', 135, 'MT', '35.88612370', '14.48834420'),
        (106, 'Għasri', 135, 'MT', '36.06680750', '14.21924750'),
        (107, 'Birgu', 135, 'MT', '35.88792140', '14.52256200'),
        (108, 'Balzan', 135, 'MT', '35.89574140', '14.45340650'),
        (109, 'Mġarr', 135, 'MT', '35.91893270', '14.36173430'),
        (110, 'Attard', 135, 'MT', '35.89049670', '14.41993220'),
        (111, 'Qrendi', 135, 'MT', '35.83284880', '14.45486210'),
        (112, 'Naxxar', 135, 'MT', '35.93175180', '14.43157460'),
        (113, 'Gżira', 135, 'MT', '35.90589700', '14.49533380'),
        (114, 'Xagħra', 135, 'MT', '36.05084500', '14.26748200'),
        (115, 'Paola', 135, 'MT', '38.57223530', '-94.87912940'),
        (116, 'Sannat', 135, 'MT', '36.01926430', '14.25994370'),
        (117, 'Dingli', 135, 'MT', '35.86273090', '14.38501070'),
        (118, 'Gudja', 135, 'MT', '35.84698030', '14.50290400'),
        (119, 'Qormi', 135, 'MT', '35.87643880', '14.46941860'),
        (120, 'Għargħur', 135, 'MT', '35.92205690', '14.45631760'),
        (121, 'Xewkija', 135, 'MT', '36.02992360', '14.25994370'),
        (122, 'Ta\' Xbiex', 135, 'MT', '35.89914480', '14.49635190'),
        (123, 'Żabbar', 135, 'MT', '35.87247150', '14.54513540'),
        (124, 'Għaxaq', 135, 'MT', '35.84403590', '14.51600900'),
        (125, 'Pembroke', 135, 'MT', '34.68016260', '-79.19503730'),
        (126, 'Lija', 135, 'MT', '49.18007600', '-123.10331700'),
        (127, 'Pietà', 135, 'MT', '42.21862000', '-83.73464700'),
        (128, 'Marsa', 135, 'MT', '34.03195870', '-118.44555350'),
        (129, 'Fgura', 135, 'MT', '35.87382690', '14.52329010'),
        (130, 'Għajnsielem', 135, 'MT', '36.02479660', '14.28029610'),
        (131, 'Mtarfa', 135, 'MT', '35.88951250', '14.39519530'),
        (132, 'Munxar', 135, 'MT', '36.02880580', '14.22506050'),
        (133, 'Nadur', 135, 'MT', '36.04470190', '14.29192730'),
        (134, 'Fontana', 135, 'MT', '34.09223350', '-117.43504800'),
        (135, 'Żejtun', 135, 'MT', '35.85487140', '14.53639690'),
        (136, 'Senglea', 135, 'MT', '35.88730410', '14.51673710'),
        (137, 'Marsaskala', 135, 'MT', '35.86036400', '14.55678760'),
        (138, 'Cospicua', 135, 'MT', '35.88067530', '14.52183380'),
        (139, 'St. Paul\'s Bay', 135, 'MT', '35.93601700', '14.39665030'),
        (140, 'Mosta', 135, 'MT', '35.91415040', '14.42284270'),
        (141, 'Mangystau Region', 112, 'KZ', '44.59080200', '53.84995080'),
        (142, 'Kyzylorda Region', 112, 'KZ', '44.69226130', '62.65718850'),
        (143, 'Almaty Region', 112, 'KZ', '45.01192270', '78.42293920'),
        (144, 'North Kazakhstan Region', 112, 'KZ', '54.16220660', '69.93870710'),
        (145, 'Akmola Region', 112, 'KZ', '51.91653200', '69.41104940'),
        (146, 'Pavlodar Region', 112, 'KZ', '52.28784440', '76.97334530'),
        (147, 'Jambyl Region', 112, 'KZ', '44.22203080', '72.36579670'),
        (148, 'West Kazakhstan Province', 112, 'KZ', '49.56797270', '50.80666160'),
        (149, 'Turkestan Region', 112, 'KZ', '43.36669580', '68.40944050'),
        (150, 'Karaganda Region', 112, 'KZ', '47.90221820', '71.77068070'),
        (151, 'Aktobe Region', 112, 'KZ', '48.77970780', '57.99743780'),
        (152, 'Almaty', 112, 'KZ', '43.22201460', '76.85124850'),
        (153, 'Atyrau Region', 112, 'KZ', '47.10761880', '51.91413300'),
        (154, 'East Kazakhstan Region', 112, 'KZ', '48.70626870', '80.79225340'),
        (155, 'Baikonur', 112, 'KZ', '45.96458510', '63.30524280'),
        (156, 'Nur-Sultan', 112, 'KZ', '51.16052270', '71.47035580'),
        (157, 'Kostanay Region', 112, 'KZ', '51.50770960', '64.04790730'),
        (158, 'Kakamega County', 113, 'KE', '0.30789400', '34.77407930'),
        (159, 'Kisii County', 113, 'KE', '-0.67733400', '34.77960300'),
        (160, 'Central Province', 113, 'KE', NULL, NULL),
        (161, 'Busia County', 113, 'KE', '0.43465060', '34.24215970'),
        (162, 'North Eastern Province', 113, 'KE', '7.78530510', '81.42789840'),
        (163, 'Embu County', 113, 'KE', '-0.65604770', '37.72376780'),
        (164, 'Laikipia County', 113, 'KE', '0.36060630', '36.78195050'),
        (165, 'Nandi District', 113, 'KE', '0.18358670', '35.12687810'),
        (166, 'Lamu County', 113, 'KE', '-2.23550580', '40.47200040'),
        (167, 'Kirinyaga County', 113, 'KE', '-0.65905650', '37.38272340'),
        (168, 'Bungoma County', 113, 'KE', '0.56952520', '34.55837660'),
        (169, 'Uasin Gishu', 113, 'KE', '0.55276380', '35.30272260'),
        (170, 'Isiolo County', 113, 'KE', '0.35243520', '38.48499230'),
        (171, 'Kisumu County', 113, 'KE', '-0.09170160', '34.76795680'),
        (172, 'Coast Province', 113, 'KE', '39.13733050', '-76.72941440'),
        (173, 'Kwale County', 113, 'KE', '-4.18161150', '39.46056120'),
        (174, 'Kilifi County', 113, 'KE', '-3.51065080', '39.90932690'),
        (175, 'Narok County', 113, 'KE', '-1.10411100', '36.08934060'),
        (176, 'Taita–Taveta County', 113, 'KE', '-3.31606870', '38.48499230'),
        (177, 'Western Province', 113, 'KE', NULL, NULL),
        (178, 'Muranga County', 113, 'KE', '-0.78392810', '37.04003390'),
        (179, 'Rift Valley Province', 113, 'KE', '11.40987370', '41.28085770'),
        (180, 'Nyeri County', 113, 'KE', '-0.41969150', '37.04003390'),
        (181, 'Baringo County', 113, 'KE', '0.85549880', '36.08934060'),
        (182, 'Wajir County', 113, 'KE', '1.63604750', '40.30886260'),
        (183, 'Trans-Nzoia District', 113, 'KE', '1.05666670', '34.95066250'),
        (184, 'Machakos County', 113, 'KE', '-1.51768370', '37.26341460'),
        (185, 'Tharaka Nithi County', 113, 'KE', '-0.29648510', '37.72376780'),
        (186, 'Siaya County', 113, 'KE', '-0.06173280', '34.24215970'),
        (187, 'Mandera County', 113, 'KE', '3.57379910', '40.95868800'),
        (188, 'Makueni County', 113, 'KE', '-2.25587340', '37.89366630'),
        (189, 'Eastern Province', 113, 'KE', NULL, NULL),
        (190, 'Migori County', 113, 'KE', '-0.93657020', '34.41982430'),
        (191, 'Nairobi', 113, 'KE', '-1.29206590', '36.82194620'),
        (192, 'Nyandarua County', 113, 'KE', '-0.18038550', '36.52296410'),
        (193, 'Kericho County', 113, 'KE', '-0.18279130', '35.47819260'),
        (194, 'Marsabit County', 113, 'KE', '2.44264030', '37.97845850'),
        (195, 'Homa Bay County', 113, 'KE', '-0.62206550', '34.33103640'),
        (196, 'Garissa County', 113, 'KE', '-0.45322930', '39.64609880'),
        (197, 'Kajiado County', 113, 'KE', '-2.09807510', '36.78195050'),
        (198, 'Meru County', 113, 'KE', '0.35571740', '37.80876930'),
        (199, 'Kiambu County', 113, 'KE', '-1.03137010', '36.86807910'),
        (200, 'Mombasa County', 113, 'KE', '-3.97682910', '39.71371810'),
        (201, 'Elgeyo-Marakwet County', 113, 'KE', '1.04982370', '35.47819260'),
        (202, 'Vihiga County', 113, 'KE', '0.07675530', '34.70776650'),
        (203, 'Nakuru County', 113, 'KE', '-0.30309880', '36.08002600'),
        (204, 'Nyanza Province', 113, 'KE', '-0.08898940', '34.77179120'),
        (205, 'Tana River County', 113, 'KE', '-1.65184680', '39.65181650'),
        (206, 'Turkana County', 113, 'KE', '3.31224770', '35.56578620'),
        (207, 'Samburu County', 113, 'KE', '1.21545060', '36.95410700'),
        (208, 'West Pokot County', 113, 'KE', '1.62100760', '35.39050460'),
        (209, 'Nyamira County', 113, 'KE', '-0.56694050', '34.93412340'),
        (210, 'Bomet County', 113, 'KE', '-0.80150090', '35.30272260'),
        (211, 'Kitui County', 113, 'KE', '-1.68328220', '38.31657250'),
        (212, 'Bié Province', 7, 'AO', '-12.57279070', '17.66888700'),
        (213, 'Huambo Province', 7, 'AO', '-12.52682210', '15.59433880'),
        (214, 'Zaire Province', 7, 'AO', '-6.57334580', '13.17403480'),
        (215, 'Cunene Province', 7, 'AO', '-16.28022210', '16.15809370'),
        (216, 'Cuanza Sul', 7, 'AO', '-10.59519100', '15.40680790'),
        (217, 'Cuanza Norte Province', 7, 'AO', '-9.23985130', '14.65878210'),
        (218, 'Benguela Province', 7, 'AO', '-12.80037440', '13.91439900'),
        (219, 'Moxico Province', 7, 'AO', '-13.42935790', '20.33088140'),
        (220, 'Lunda Sul Province', 7, 'AO', '-10.28665780', '20.71224650'),
        (221, 'Bengo Province', 7, 'AO', '-9.10422570', '13.72891670'),
        (222, 'Luanda Province', 7, 'AO', '-9.03508800', '13.26634790'),
        (223, 'Lunda Norte Province', 7, 'AO', '-8.35250220', '19.18800470'),
        (224, 'Uíge Province', 7, 'AO', '-7.17367320', '15.40680790'),
        (225, 'Huíla Province', 7, 'AO', '-14.92805530', '14.65878210'),
        (226, 'Cuando Cubango Province', 7, 'AO', '-16.41808240', '18.80761950'),
        (227, 'Malanje Province', 7, 'AO', '-9.82511830', '16.91225100'),
        (228, 'Cabinda Province', 7, 'AO', '-5.02487490', '12.34638750'),
        (229, 'Gasa District', 26, 'BT', '28.01858860', '89.92532330'),
        (230, 'Tsirang District', 26, 'BT', '27.03220700', '90.18696440'),
        (231, 'Wangdue Phodrang District', 26, 'BT', '27.45260460', '90.06749280'),
        (232, 'Haa District', 26, 'BT', '27.26516690', '89.17059980'),
        (233, 'Zhemgang District', 26, 'BT', '27.07697500', '90.82940020'),
        (234, 'Lhuntse District', 26, 'BT', '27.82649890', '91.13530200'),
        (235, 'Punakha District', 26, 'BT', '27.69037160', '89.88793040'),
        (236, 'Trashigang District', 26, 'BT', '27.25667950', '91.75388170'),
        (237, 'Paro District', 26, 'BT', '27.42859490', '89.41665160'),
        (238, 'Dagana District', 26, 'BT', '27.03228610', '89.88793040'),
        (239, 'Chukha District', 26, 'BT', '27.07843040', '89.47421770'),
        (240, 'Bumthang District', 26, 'BT', '27.64183900', '90.67730460'),
        (241, 'Thimphu District', 26, 'BT', '27.47122160', '89.63390410'),
        (242, 'Mongar District', 26, 'BT', '27.26170590', '91.28910360'),
        (243, 'Samdrup Jongkhar District', 26, 'BT', '26.80356820', '91.50392070'),
        (244, 'Pemagatshel District', 26, 'BT', '27.00238200', '91.34692470'),
        (245, 'Trongsa District', 26, 'BT', '27.50022690', '90.50806340'),
        (246, 'Samtse District', 26, 'BT', '27.02918320', '89.05615320'),
        (247, 'Sarpang District', 26, 'BT', '26.93730410', '90.48799160'),
        (248, 'Tombouctou Region', 134, 'ML', '21.05267060', '-3.74350900'),
        (249, 'Ségou Region', 134, 'ML', '13.83944560', '-6.06791940'),
        (250, 'Koulikoro Region', 134, 'ML', '13.80180740', '-7.43813550'),
        (251, 'Ménaka Region', 134, 'ML', '15.91564210', '2.39617400'),
        (252, 'Kayes Region', 134, 'ML', '14.08183080', '-9.90181310'),
        (253, 'Bamako', 134, 'ML', '12.63923160', '-8.00288920'),
        (254, 'Sikasso Region', 134, 'ML', '10.89051860', '-7.43813550'),
        (255, 'Mopti Region', 134, 'ML', '14.63380390', '-3.41955270'),
        (256, 'Taoudénit Region', 134, 'ML', '22.67641320', '-3.97891430'),
        (257, 'Kidal Region', 134, 'ML', '18.79868320', '1.83183340'),
        (258, 'Gao Region', 134, 'ML', '16.90663320', '1.52086240'),
        (259, 'Southern Province', 183, 'RW', NULL, NULL),
        (260, 'Western Province', 183, 'RW', NULL, NULL),
        (261, 'Eastern Province', 183, 'RW', NULL, NULL),
        (262, 'Kigali district', 183, 'RW', '-1.94407270', '30.06188510'),
        (263, 'Northern Province', 183, 'RW', NULL, NULL),
        (264, 'Belize District', 23, 'BZ', '17.56776790', '-88.40160410'),
        (265, 'Stann Creek District', 23, 'BZ', '16.81166310', '-88.40160410'),
        (266, 'Corozal District', 23, 'BZ', '18.13492380', '-88.24611830'),
        (267, 'Toledo District', 23, 'BZ', '16.24919230', '-88.86469800'),
        (268, 'Orange Walk District', 23, 'BZ', '17.76035300', '-88.86469800'),
        (269, 'Cayo District', 23, 'BZ', '17.09844450', '-88.94138650'),
        (270, 'Príncipe Province', 193, 'ST', '1.61393810', '7.40569280'),
        (271, 'São Tomé Province', 193, 'ST', '0.33019240', '6.73334300'),
        (272, 'Havana Province', 56, 'CU', '23.05406980', '-82.34518900'),
        (273, 'Santiago de Cuba Province', 56, 'CU', '20.23976820', '-75.99276520'),
        (274, 'Sancti Spíritus Province', 56, 'CU', '21.99382140', '-79.47038850'),
        (275, 'Granma Province', 56, 'CU', '20.38449020', '-76.64127120'),
        (276, 'Mayabeque Province', 56, 'CU', '22.89265290', '-81.95348150'),
        (277, 'Pinar del Río Province', 56, 'CU', '22.40762560', '-83.84730150'),
        (278, 'Isla de la Juventud', 56, 'CU', '21.70847370', '-82.82202320'),
        (279, 'Holguín Province', 56, 'CU', '20.78378930', '-75.80690820'),
        (280, 'Villa Clara Province', 56, 'CU', '22.49372040', '-79.91927020'),
        (281, 'Las Tunas Province', 56, 'CU', '21.06051620', '-76.91820970'),
        (282, 'Ciego de Ávila Province', 56, 'CU', '21.93295150', '-78.56608520'),
        (283, 'Artemisa Province', 56, 'CU', '22.75229030', '-82.99316070'),
        (284, 'Matanzas Province', 56, 'CU', '22.57671230', '-81.33994140'),
        (285, 'Guantánamo Province', 56, 'CU', '20.14559170', '-74.87410450'),
        (286, 'Camagüey Province', 56, 'CU', '21.21672470', '-77.74520810'),
        (287, 'Cienfuegos Province', 56, 'CU', '22.23797830', '-80.36586500'),
        (288, 'Jigawa', 161, 'NG', '12.22801200', '9.56158670'),
        (289, 'Enugu', 161, 'NG', '6.53635300', '7.43561940'),
        (290, 'Kebbi', 161, 'NG', '11.49420030', '4.23333550'),
        (291, 'Benue', 161, 'NG', '7.33690240', '8.74036870'),
        (292, 'Sokoto', 161, 'NG', '13.05331430', '5.32227220'),
        (293, 'Abuja Federal Capital Territory', 161, 'NG', '8.89406910', '7.18604020'),
        (294, 'Kaduna', 161, 'NG', '10.37640060', '7.70945370'),
        (295, 'Kwara', 161, 'NG', '8.96689610', '4.38740510'),
        (296, 'Oyo', 161, 'NG', '8.15738090', '3.61465340'),
        (297, 'Yobe', 161, 'NG', '12.29387600', '11.43904110'),
        (298, 'Kogi', 161, 'NG', '7.73373250', '6.69058360'),
        (299, 'Zamfara', 161, 'NG', '12.12218050', '6.22358190'),
        (300, 'Kano', 161, 'NG', '11.74706980', '8.52471070'),
        (301, 'Nasarawa', 161, 'NG', '8.49979080', '8.19969370'),
        (302, 'Plateau', 161, 'NG', '9.21820930', '9.51794880'),
        (303, 'Abia', 161, 'NG', '5.45273540', '7.52484140'),
        (304, 'Akwa Ibom', 161, 'NG', '4.90573710', '7.85366750'),
        (305, 'Bayelsa', 161, 'NG', '4.77190710', '6.06985260'),
        (306, 'Lagos', 161, 'NG', '6.52437930', '3.37920570'),
        (307, 'Borno', 161, 'NG', '11.88463560', '13.15196650'),
        (308, 'Imo', 161, 'NG', '5.57201220', '7.05882190'),
        (309, 'Ekiti', 161, 'NG', '7.71898620', '5.31095050'),
        (310, 'Gombe', 161, 'NG', '10.36377950', '11.19275870'),
        (311, 'Ebonyi', 161, 'NG', '6.26492320', '8.01373020'),
        (312, 'Bauchi', 161, 'NG', '10.77606240', '9.99919430'),
        (313, 'Katsina', 161, 'NG', '12.37967070', '7.63057480'),
        (314, 'Cross River', 161, 'NG', '5.87017240', '8.59880140'),
        (315, 'Anambra', 161, 'NG', '6.22089970', '6.93695590'),
        (316, 'Delta', 161, 'NG', '33.74537840', '-90.73545080'),
        (317, 'Niger', 161, 'NG', '9.93092240', '5.59832100'),
        (318, 'Edo', 161, 'NG', '6.63418310', '5.93040560'),
        (319, 'Taraba', 161, 'NG', '7.99936160', '10.77398630'),
        (320, 'Adamawa', 161, 'NG', '9.32647510', '12.39838530'),
        (321, 'Ondo', 161, 'NG', '6.91486820', '5.14781440'),
        (322, 'Osun', 161, 'NG', '7.56289640', '4.51995930'),
        (323, 'Ogun', 161, 'NG', '6.99797470', '3.47373780'),
        (324, 'Rukungiri District', 229, 'UG', '-0.75184900', '29.92779470'),
        (325, 'Kyankwanzi District', 229, 'UG', '1.09660370', '31.71954590'),
        (326, 'Kabarole District', 229, 'UG', '0.58507910', '30.25127280'),
        (327, 'Mpigi District', 229, 'UG', '0.22735280', '32.32492360'),
        (328, 'Apac District', 229, 'UG', '1.87302630', '32.62774550'),
        (329, 'Abim District', 229, 'UG', '2.70669800', '33.65953370'),
        (330, 'Yumbe District', 229, 'UG', '3.46980230', '31.24832910'),
        (331, 'Rukiga District', 229, 'UG', '-1.13263370', '30.04341200'),
        (332, 'Northern Region', 229, 'UG', '9.54392690', '-0.90566230'),
        (333, 'Serere District', 229, 'UG', '1.49940330', '33.54900780'),
        (334, 'Kamuli District', 229, 'UG', '0.91871070', '33.12390490'),
        (335, 'Amuru District', 229, 'UG', '2.96678780', '32.08374450'),
        (336, 'Kaberamaido District', 229, 'UG', '1.69633220', '33.21385100'),
        (337, 'Namutumba District', 229, 'UG', '0.84926100', '33.66233010'),
        (338, 'Kibuku District', 229, 'UG', '1.04528740', '33.79925360'),
        (339, 'Ibanda District', 229, 'UG', '-0.09648900', '30.57395790'),
        (340, 'Iganga District', 229, 'UG', '0.66001370', '33.48319060'),
        (341, 'Dokolo District', 229, 'UG', '1.96364210', '33.03387670'),
        (342, 'Lira District', 229, 'UG', '2.23161690', '32.94376670'),
        (343, 'Bukedea District', 229, 'UG', '1.35568980', '34.10867930'),
        (344, 'Alebtong District', 229, 'UG', '2.25457730', '33.34861470'),
        (345, 'Koboko District', 229, 'UG', '3.52370580', '31.03351000'),
        (346, 'Kiryandongo District', 229, 'UG', '2.01799070', '32.08374450'),
        (347, 'Kiboga District', 229, 'UG', '0.96575900', '31.71954590'),
        (348, 'Kitgum District', 229, 'UG', '3.33968290', '33.16888830'),
        (349, 'Bududa District', 229, 'UG', '1.00296930', '34.33381230'),
        (350, 'Mbale District', 229, 'UG', '1.03442740', '34.19768820'),
        (351, 'Namayingo District', 229, 'UG', '-0.28035750', '33.75177230'),
        (352, 'Amuria District', 229, 'UG', '2.03017000', '33.64275330'),
        (353, 'Amudat District', 229, 'UG', '1.79162240', '34.90655100'),
        (354, 'Masindi District', 229, 'UG', '1.49203630', '31.71954590'),
        (355, 'Kiruhura District', 229, 'UG', '-0.19279980', '30.80394740'),
        (356, 'Masaka District', 229, 'UG', '-0.44636910', '31.90179540'),
        (357, 'Pakwach District', 229, 'UG', '2.46071410', '31.49417380'),
        (358, 'Rubanda District', 229, 'UG', '-1.18611900', '29.84535760'),
        (359, 'Tororo District', 229, 'UG', '0.68709940', '34.06414190'),
        (360, 'Kamwenge District', 229, 'UG', '0.22579300', '30.48184460'),
        (361, 'Adjumani District', 229, 'UG', '3.25485270', '31.71954590'),
        (362, 'Wakiso District', 229, 'UG', '0.06301900', '32.44672380'),
        (363, 'Moyo District', 229, 'UG', '3.56964640', '31.67393710'),
        (364, 'Mityana District', 229, 'UG', '0.44548450', '32.08374450'),
        (365, 'Butaleja District', 229, 'UG', '0.84749220', '33.84112880'),
        (366, 'Gomba District', 229, 'UG', '0.22297910', '31.67393710'),
        (367, 'Jinja District', 229, 'UG', '0.53437430', '33.30371430'),
        (368, 'Kayunga District', 229, 'UG', '0.98601820', '32.85357550'),
        (369, 'Kween District', 229, 'UG', '1.44387900', '34.59713200'),
        (370, 'Western Region', 229, 'UG', '40.76672150', '-111.88772030'),
        (371, 'Mubende District', 229, 'UG', '0.57727580', '31.53700030'),
        (372, 'Eastern Region', 229, 'UG', '6.23740360', '-0.45023680'),
        (373, 'Kanungu District', 229, 'UG', '-0.81952530', '29.74260400'),
        (374, 'Omoro District', 229, 'UG', '2.71522300', '32.49200880'),
        (375, 'Bukomansimbi District', 229, 'UG', '-0.14327520', '31.60548930'),
        (376, 'Lyantonde District', 229, 'UG', '-0.22406960', '31.21684660'),
        (377, 'Buikwe District', 229, 'UG', '0.31440460', '32.98883190'),
        (378, 'Nwoya District', 229, 'UG', '2.56244400', '31.90179540'),
        (379, 'Zombo District', 229, 'UG', '2.55442930', '30.94173680'),
        (380, 'Buyende District', 229, 'UG', '1.24136820', '33.12390490'),
        (381, 'Bunyangabu District', 229, 'UG', '0.48709180', '30.20510960'),
        (382, 'Kampala District', 229, 'UG', '0.34759640', '32.58251970'),
        (383, 'Isingiro District', 229, 'UG', '-0.84354300', '30.80394740'),
        (384, 'Butambala District', 229, 'UG', '0.17425000', '32.10646680'),
        (385, 'Bukwo District', 229, 'UG', '1.28186510', '34.72987650'),
        (386, 'Bushenyi District', 229, 'UG', '-0.48709180', '30.20510960'),
        (387, 'Bugiri District', 229, 'UG', '0.53161270', '33.75177230'),
        (388, 'Butebo District', 229, 'UG', '1.21411240', '33.90808960'),
        (389, 'Buliisa District', 229, 'UG', '2.02996070', '31.53700030'),
        (390, 'Otuke District', 229, 'UG', '2.52140590', '33.34861470'),
        (391, 'Buhweju District', 229, 'UG', '-0.29113590', '30.29741990'),
        (392, 'Agago District', 229, 'UG', '2.92508200', '33.34861470'),
        (393, 'Nakapiripirit District', 229, 'UG', '1.96061730', '34.59713200'),
        (394, 'Kalungu District', 229, 'UG', '-0.09528310', '31.76513620'),
        (395, 'Moroto District', 229, 'UG', '2.61685450', '34.59713200'),
        (396, 'Central Region', 229, 'UG', '44.29687500', '-94.74017330'),
        (397, 'Oyam District', 229, 'UG', '2.27762810', '32.44672380'),
        (398, 'Kaliro District', 229, 'UG', '1.04311070', '33.48319060'),
        (399, 'Kakumiro District', 229, 'UG', '0.78080350', '31.32413890'),
        (400, 'Namisindwa District', 229, 'UG', '0.90710100', '34.35740370'),
        (401, 'Kole District', 229, 'UG', '2.37010970', '32.76330360'),
        (402, 'Kyenjojo District', 229, 'UG', '0.60929230', '30.64012310'),
        (403, 'Kagadi District', 229, 'UG', '0.94007610', '30.81256380'),
        (404, 'Ntungamo District', 229, 'UG', '-0.98073410', '30.25127280'),
        (405, 'Kalangala District', 229, 'UG', '-0.63505780', '32.53727410'),
        (406, 'Nakasongola District', 229, 'UG', '1.34897210', '32.44672380'),
        (407, 'Sheema District', 229, 'UG', '-0.55152980', '30.38966510'),
        (408, 'Pader District', 229, 'UG', '2.94306820', '32.80844960'),
        (409, 'Kisoro District', 229, 'UG', '-1.22094300', '29.64991620'),
        (410, 'Mukono District', 229, 'UG', '0.28354760', '32.76330360'),
        (411, 'Lamwo District', 229, 'UG', '3.57075680', '32.53727410'),
        (412, 'Pallisa District', 229, 'UG', '1.23242060', '33.75177230'),
        (413, 'Gulu District', 229, 'UG', '2.81857760', '32.44672380'),
        (414, 'Buvuma District', 229, 'UG', '-0.37649120', '33.25879300'),
        (415, 'Mbarara District', 229, 'UG', '-0.60715960', '30.65450220'),
        (416, 'Amolatar District', 229, 'UG', '1.60544020', '32.80844960'),
        (417, 'Lwengo District', 229, 'UG', '-0.41652880', '31.39989950'),
        (418, 'Mayuge District', 229, 'UG', '-0.21829820', '33.57280270'),
        (419, 'Bundibugyo District', 229, 'UG', '0.68517630', '30.02029640'),
        (420, 'Katakwi District', 229, 'UG', '1.97310300', '34.06414190'),
        (421, 'Maracha District', 229, 'UG', '3.28731270', '30.94030230'),
        (422, 'Ntoroko District', 229, 'UG', '1.07881780', '30.38966510'),
        (423, 'Nakaseke District', 229, 'UG', '1.22308480', '32.08374450'),
        (424, 'Ngora District', 229, 'UG', '1.49081150', '33.75177230'),
        (425, 'Kumi District', 229, 'UG', '1.48769990', '33.93039910'),
        (426, 'Kabale District', 229, 'UG', '-1.24930840', '30.06652360'),
        (427, 'Sembabule District', 229, 'UG', '0.06377150', '31.35416310'),
        (428, 'Bulambuli District', 229, 'UG', '1.47988460', '34.37544140'),
        (429, 'Sironko District', 229, 'UG', '1.23022740', '34.24910640'),
        (430, 'Napak District', 229, 'UG', '2.36299450', '34.24215970'),
        (431, 'Busia District', 229, 'UG', '0.40447310', '34.01958270'),
        (432, 'Kapchorwa District', 229, 'UG', '1.33502050', '34.39763560'),
        (433, 'Luwero District', 229, 'UG', '0.82711180', '32.62774550'),
        (434, 'Kaabong District', 229, 'UG', '3.51262150', '33.97500180'),
        (435, 'Mitooma District', 229, 'UG', '-0.61932760', '30.02029640'),
        (436, 'Kibaale District', 229, 'UG', '0.90668020', '31.07937050'),
        (437, 'Kyegegwa District', 229, 'UG', '0.48181930', '31.05500930'),
        (438, 'Manafwa District', 229, 'UG', '0.90635990', '34.28660910'),
        (439, 'Rakai District', 229, 'UG', '-0.70691350', '31.53700030'),
        (440, 'Kasese District', 229, 'UG', '0.06462850', '30.06652360'),
        (441, 'Budaka District', 229, 'UG', '1.10162770', '33.93039910'),
        (442, 'Rubirizi District', 229, 'UG', '-0.26424100', '30.10840330'),
        (443, 'Kotido District', 229, 'UG', '3.04156790', '33.88577470'),
        (444, 'Soroti District', 229, 'UG', '1.72291170', '33.52800720'),
        (445, 'Luuka District', 229, 'UG', '0.72505990', '33.30371430'),
        (446, 'Nebbi District', 229, 'UG', '2.44093920', '31.35416310'),
        (447, 'Arua District', 229, 'UG', '2.99598460', '31.17103890'),
        (448, 'Kyotera District', 229, 'UG', '-0.63589880', '31.54556370'),
        (449, 'Schellenberg', 125, 'LI', '47.23096600', '9.54678430'),
        (450, 'Schaan', 125, 'LI', '47.12043400', '9.59416020'),
        (451, 'Eschen', 125, 'LI', '40.76695740', '-73.95228210'),
        (452, 'Vaduz', 125, 'LI', '47.14103030', '9.52092770'),
        (453, 'Ruggell', 125, 'LI', '47.25292220', '9.54021270'),
        (454, 'Planken', 125, 'LI', '40.66505760', '-73.50479800'),
        (455, 'Mauren', 125, 'LI', '47.21892850', '9.54173500'),
        (456, 'Triesenberg', 125, 'LI', '47.12245110', '9.57019850'),
        (457, 'Gamprin', 125, 'LI', '47.21324900', '9.50251950'),
        (458, 'Balzers', 125, 'LI', '42.05283570', '-88.03668480'),
        (459, 'Triesen', 125, 'LI', '47.10979880', '9.52482960'),
        (460, 'Brčko District', 28, 'BA', '44.84059440', '18.74215300'),
        (461, 'Tuzla Canton', 28, 'BA', '44.53434630', '18.69727970'),
        (462, 'Central Bosnia Canton', 28, 'BA', '44.13818560', '17.68667140'),
        (463, 'Herzegovina-Neretva Canton', 28, 'BA', '43.52651590', '17.76362100'),
        (464, 'Posavina Canton', 28, 'BA', '45.07520940', '18.37763040'),
        (465, 'Una-Sana Canton', 28, 'BA', '44.65031160', '16.31716290'),
        (466, 'Sarajevo Canton', 28, 'BA', '43.85125640', '18.29534420'),
        (467, 'Federation of Bosnia and Herzegovina', 28, 'BA', '43.88748970', '17.84279300'),
        (468, 'Zenica-Doboj Canton', 28, 'BA', '44.21271090', '18.16046250'),
        (469, 'West Herzegovina Canton', 28, 'BA', '43.43692440', '17.38488310'),
        (470, 'Republika Srpska', 28, 'BA', '44.72801860', '17.31481360'),
        (471, 'Canton 10', 28, 'BA', '43.95341550', '16.94251870'),
        (472, 'Bosnian Podrinje Canton', 28, 'BA', '43.68749000', '18.82443940'),
        (473, 'Dakar', 195, 'SN', '14.71667700', '-17.46768610'),
        (474, 'Kolda', 195, 'SN', '12.91074950', '-14.95056710'),
        (475, 'Kaffrine', 195, 'SN', '14.10520200', '-15.54157550'),
        (476, 'Matam', 195, 'SN', '15.66002250', '-13.25769060'),
        (477, 'Saint-Louis', 195, 'SN', '38.62700250', '-90.19940420'),
        (478, 'Ziguinchor', 195, 'SN', '12.56414790', '-16.26398250'),
        (479, 'Fatick', 195, 'SN', '14.33901670', '-16.41114250'),
        (480, 'Diourbel Region', 195, 'SN', '14.72830850', '-16.25221430'),
        (481, 'Kédougou', 195, 'SN', '12.56046070', '-12.17470770'),
        (482, 'Sédhiou', 195, 'SN', '12.70460400', '-15.55623040'),
        (483, 'Kaolack', 195, 'SN', '14.16520830', '-16.07577490'),
        (484, 'Thiès Region', 195, 'SN', '14.79100520', '-16.93586040'),
        (485, 'Louga', 195, 'SN', '15.61417680', '-16.22868000'),
        (486, 'Tambacounda Region', 195, 'SN', '13.56190110', '-13.17403480'),
        (487, 'Encamp', 6, 'AD', '42.53597640', '1.58367730'),
        (488, 'Andorra la Vella', 6, 'AD', '42.50631740', '1.52183550'),
        (489, 'Canillo', 6, 'AD', '42.59782490', '1.65663770'),
        (490, 'Sant Julià de Lòria', 6, 'AD', '42.45296310', '1.49182350'),
        (491, 'Ordino', 6, 'AD', '42.59944330', '1.54023270'),
        (492, 'Escaldes-Engordany', 6, 'AD', '42.49093790', '1.58869660'),
        (493, 'La Massana', 6, 'AD', '42.54562500', '1.51473920'),
        (494, 'Mont Buxton', 197, 'SC', '-4.61666670', '55.44577680'),
        (495, 'La Digue', 197, 'SC', '49.76669220', '-97.15466290'),
        (496, 'Saint Louis', 197, 'SC', '38.62700250', '-90.19940420'),
        (497, 'Baie Lazare', 197, 'SC', '-4.74825250', '55.48593630'),
        (498, 'Mont Fleuri', 197, 'SC', '-4.63565430', '55.45546880'),
        (499, 'Les Mamelles', 197, 'SC', '38.82505050', '-90.48345170'),
        (500, 'Grand\'Anse Mahé', 197, 'SC', '-4.67739200', '55.46377700'),
        (501, 'Roche Caiman', 197, 'SC', '-4.63960280', '55.46793150'),
        (502, 'Anse Royale', 197, 'SC', '-4.74079880', '55.50810120'),
        (503, 'Glacis', 197, 'SC', '47.11573030', '-70.30281830'),
        (504, 'Grand\'Anse Praslin', 197, 'SC', '-4.31762190', '55.70783630'),
        (505, 'Bel Ombre', 197, 'SC', '-20.50100950', '57.42596240'),
        (506, 'Anse-aux-Pins', 197, 'SC', '-4.69004430', '55.51502890'),
        (507, 'Port Glaud', 197, 'SC', '-4.64885230', '55.41947530'),
        (508, 'Au Cap', 197, 'SC', '-4.70597230', '55.50810120'),
        (509, 'Takamaka', 197, 'SC', '37.96459170', '-1.22177270'),
        (510, 'Pointe La Rue', 197, 'SC', '-4.68048900', '55.51918570'),
        (511, 'Plaisance', 197, 'SC', '45.60709500', '-75.11427450'),
        (512, 'Beau Vallon', 197, 'SC', '-4.62109670', '55.42778020'),
        (513, 'Anse Boileau', 197, 'SC', '-4.70472680', '55.48593630'),
        (514, 'Baie Sainte Anne', 197, 'SC', '47.05259000', '-64.95245790'),
        (515, 'Bel Air', 197, 'SC', '34.10024550', '-118.45946300'),
        (516, 'La Rivière Anglaise', 197, 'SC', '-4.61061500', '55.45408410'),
        (517, 'Cascade', 197, 'SC', '44.51628210', '-116.04179830'),
        (518, 'Shaki', 16, 'AZ', '41.19747530', '47.15712410'),
        (519, 'Tartar District', 16, 'AZ', '40.34438750', '46.93765190'),
        (520, 'Shirvan', 16, 'AZ', '39.94697070', '48.92239190'),
        (521, 'Qazakh District', 16, 'AZ', '41.09710740', '45.35163310'),
        (522, 'Sadarak District', 16, 'AZ', '39.71051140', '44.88642770'),
        (523, 'Yevlakh District', 16, 'AZ', '40.61966380', '47.15003240'),
        (524, 'Khojali District', 16, 'AZ', '39.91325530', '46.79430500'),
        (525, 'Kalbajar District', 16, 'AZ', '40.10243290', '46.03648720'),
        (526, 'Qakh District', 16, 'AZ', '41.42068270', '46.93201840'),
        (527, 'Fizuli District', 16, 'AZ', '39.53786050', '47.30338770'),
        (528, 'Astara District', 16, 'AZ', '38.49378450', '48.69443650'),
        (529, 'Shamakhi District', 16, 'AZ', '40.63187310', '48.63638010'),
        (530, 'Neftchala District', 16, 'AZ', '39.38810520', '49.24137430'),
        (531, 'Goychay', 16, 'AZ', '40.62361680', '47.74030340'),
        (532, 'Bilasuvar District', 16, 'AZ', '39.45988330', '48.55098130'),
        (533, 'Tovuz District', 16, 'AZ', '40.99545230', '45.61659070'),
        (534, 'Ordubad District', 16, 'AZ', '38.90216220', '46.02376250'),
        (535, 'Sharur District', 16, 'AZ', '39.55363320', '44.98456800'),
        (536, 'Samukh District', 16, 'AZ', '40.76046310', '46.40631810'),
        (537, 'Khizi District', 16, 'AZ', '40.91094890', '49.07292640'),
        (538, 'Yevlakh', 16, 'AZ', '40.61966380', '47.15003240'),
        (539, 'Ujar District', 16, 'AZ', '40.50675250', '47.64896410'),
        (540, 'Absheron District', 16, 'AZ', '40.36296930', '49.27368150'),
        (541, 'Lachin District', 16, 'AZ', '39.63834140', '46.54608530'),
        (542, 'Qabala District', 16, 'AZ', '40.92539250', '47.80161060'),
        (543, 'Agstafa District', 16, 'AZ', '41.26559330', '45.51342910'),
        (544, 'Imishli District', 16, 'AZ', '39.86946860', '48.06652180'),
        (545, 'Salyan District', 16, 'AZ', '28.35248110', '82.12784000'),
        (546, 'Lerik District', 16, 'AZ', '38.77361920', '48.41514830'),
        (547, 'Agsu District', 16, 'AZ', '40.52833390', '48.36508350'),
        (548, 'Qubadli District', 16, 'AZ', '39.27139960', '46.63543120'),
        (549, 'Kurdamir District', 16, 'AZ', '40.36986510', '48.16446260'),
        (550, 'Yardymli District', 16, 'AZ', '38.90589170', '48.24961270'),
        (551, 'Goranboy District', 16, 'AZ', '40.53805060', '46.59908910'),
        (552, 'Baku', 16, 'AZ', '40.40926170', '49.86709240'),
        (553, 'Agdash District', 16, 'AZ', '40.63354270', '47.46743100'),
        (554, 'Beylagan District', 16, 'AZ', '39.77230730', '47.61541660'),
        (555, 'Masally District', 16, 'AZ', '39.03407220', '48.65893540'),
        (556, 'Oghuz District', 16, 'AZ', '41.07279240', '47.46506720'),
        (557, 'Saatly District', 16, 'AZ', '39.90955030', '48.35951220'),
        (558, 'Lankaran District', 16, 'AZ', '38.75286690', '48.84750150'),
        (559, 'Agdam District', 16, 'AZ', '39.99318530', '46.99495620'),
        (560, 'Balakan District', 16, 'AZ', '41.70375090', '46.40442130'),
        (561, 'Dashkasan District', 16, 'AZ', '40.52022570', '46.07793040'),
        (562, 'Nakhchivan Autonomous Republic', 16, 'AZ', '39.32568140', '45.49126480'),
        (563, 'Quba District', 16, 'AZ', '41.15642420', '48.41350210'),
        (564, 'Ismailli District', 16, 'AZ', '40.74299360', '48.21255560'),
        (565, 'Sabirabad District', 16, 'AZ', '39.98706630', '48.46925450'),
        (566, 'Zaqatala District', 16, 'AZ', '41.59068890', '46.72403730'),
        (567, 'Kangarli District', 16, 'AZ', '39.38719400', '45.16398520'),
        (568, 'Martuni', 16, 'AZ', '39.79146930', '47.11008140'),
        (569, 'Barda District', 16, 'AZ', '40.37065550', '47.13789090'),
        (570, 'Jabrayil District', 16, 'AZ', '39.26455440', '46.96215620'),
        (571, 'Hajigabul District', 16, 'AZ', '40.03937700', '48.92025330'),
        (572, 'Julfa District', 16, 'AZ', '38.96049830', '45.62929390'),
        (573, 'Gobustan District', 16, 'AZ', '40.53261040', '48.92737500'),
        (574, 'Goygol District', 16, 'AZ', '40.55953780', '46.33149530'),
        (575, 'Babek District', 16, 'AZ', '39.15076130', '45.44853680'),
        (576, 'Zardab District', 16, 'AZ', '40.21481140', '47.71494400'),
        (577, 'Aghjabadi District', 16, 'AZ', '28.78918410', '77.51607880'),
        (578, 'Jalilabad District', 16, 'AZ', '39.20516320', '48.51006040'),
        (579, 'Shahbuz District', 16, 'AZ', '39.44521030', '45.65680090'),
        (580, 'Mingachevir', 16, 'AZ', '40.77025630', '47.04960150'),
        (581, 'Zangilan District', 16, 'AZ', '39.08568990', '46.65247280'),
        (582, 'Sumqayit', 16, 'AZ', '40.58547650', '49.63174110'),
        (583, 'Shamkir District', 16, 'AZ', '40.82881440', '46.01668790'),
        (584, 'Siazan District', 16, 'AZ', '41.07838330', '49.11184770'),
        (585, 'Ganja', 16, 'AZ', '36.36873380', '-95.99857670'),
        (586, 'Shaki District', 16, 'AZ', '41.11346620', '47.13169270'),
        (587, 'Lankaran', 16, 'AZ', '38.75286690', '48.84750150'),
        (588, 'Qusar District', 16, 'AZ', '41.42668860', '48.43455770'),
        (589, 'Gədəbəy', 16, 'AZ', '40.56996390', '45.81068830'),
        (590, 'Khachmaz District', 16, 'AZ', '41.45911680', '48.80206260'),
        (591, 'Shabran District', 16, 'AZ', '41.22283760', '48.84573040'),
        (592, 'Shusha District', 16, 'AZ', '39.75374380', '46.74647550'),
        (593, 'Skrapar District', 3, 'AL', '40.53499460', '20.28322170'),
        (594, 'Kavajë District', 3, 'AL', '41.18445290', '19.56275960'),
        (595, 'Lezhë District', 3, 'AL', '41.78607300', '19.64607580'),
        (596, 'Librazhd District', 3, 'AL', '41.18292320', '20.31747690'),
        (597, 'Korçë District', 3, 'AL', '40.59056700', '20.61689210'),
        (598, 'Elbasan County', 3, 'AL', '41.12666720', '20.23556470'),
        (599, 'Lushnjë District', 3, 'AL', '40.94198300', '19.69964280'),
        (600, 'Has District', 3, 'AL', '42.79013360', '-83.61220120'),
        (601, 'Kukës County', 3, 'AL', '42.08074640', '20.41429230'),
        (602, 'Malësi e Madhe District', 3, 'AL', '42.42451730', '19.61631850'),
        (603, 'Berat County', 3, 'AL', '40.69530120', '20.04496620'),
        (604, 'Gjirokastër County', 3, 'AL', '40.06728740', '20.10452290'),
        (605, 'Dibër District', 3, 'AL', '41.58881630', '20.23556470'),
        (606, 'Pogradec District', 3, 'AL', '40.90153140', '20.65562890'),
        (607, 'Bulqizë District', 3, 'AL', '41.49425870', '20.21471570'),
        (608, 'Devoll District', 3, 'AL', '40.64473470', '20.95066360'),
        (609, 'Lezhë County', 3, 'AL', '41.78137590', '19.80679160'),
        (610, 'Dibër County', 3, 'AL', '41.58881630', '20.23556470'),
        (611, 'Shkodër County', 3, 'AL', '42.15037100', '19.66393090'),
        (612, 'Kuçovë District', 3, 'AL', '40.78370630', '19.87823480'),
        (613, 'Vlorë District', 3, 'AL', '40.46606680', '19.49135600'),
        (614, 'Krujë District', 3, 'AL', '41.50947650', '19.77107320'),
        (615, 'Tirana County', 3, 'AL', '41.24275980', '19.80679160'),
        (616, 'Tepelenë District', 3, 'AL', '40.29666320', '20.01816730'),
        (617, 'Gramsh District', 3, 'AL', '40.86698730', '20.18493230'),
        (618, 'Delvinë District', 3, 'AL', '39.94813640', '20.09558910'),
        (619, 'Peqin District', 3, 'AL', '41.04709020', '19.75023840'),
        (620, 'Pukë District', 3, 'AL', '42.04697720', '19.89609680'),
        (621, 'Gjirokastër District', 3, 'AL', '40.06728740', '20.10452290'),
        (622, 'Kurbin District', 3, 'AL', '41.64126440', '19.70559500'),
        (623, 'Kukës District', 3, 'AL', '42.08074640', '20.41429230'),
        (624, 'Sarandë District', 3, 'AL', '39.85921190', '20.02710010'),
        (625, 'Përmet District', 3, 'AL', '40.23618370', '20.35173340'),
        (626, 'Shkodër District', 3, 'AL', '42.06929850', '19.50325590'),
        (627, 'Fier District', 3, 'AL', '40.72750400', '19.56275960'),
        (628, 'Kolonjë District', 3, 'AL', '40.33732620', '20.67946760'),
        (629, 'Berat District', 3, 'AL', '40.70863770', '19.94373140'),
        (630, 'Korçë County', 3, 'AL', '40.59056700', '20.61689210'),
        (631, 'Fier County', 3, 'AL', '40.91913920', '19.66393090'),
        (632, 'Durrës County', 3, 'AL', '41.50809720', '19.61631850'),
        (633, 'Tirana District', 3, 'AL', '41.32754590', '19.81869820'),
        (634, 'Vlorë County', 3, 'AL', '40.15009600', '19.80679160'),
        (635, 'Mat District', 3, 'AL', '41.59376750', '19.99732440'),
        (636, 'Tropojë District', 3, 'AL', '42.39821510', '20.16259550'),
        (637, 'Mallakastër District', 3, 'AL', '40.52733760', '19.78297910'),
        (638, 'Mirditë District', 3, 'AL', '41.76428600', '19.90205090'),
        (639, 'Durrës District', 3, 'AL', '41.37065170', '19.52110630'),
        (640, 'Sveti Nikole Municipality', 129, 'MK', '41.89803120', '21.99994350'),
        (641, 'Kratovo Municipality', 129, 'MK', '42.05371410', '22.07148350'),
        (642, 'Zajas Municipality', 129, 'MK', '41.60303280', '20.87913430'),
        (643, 'Staro Nagoričane Municipality', 129, 'MK', '42.21916920', '21.90455410'),
        (644, 'Češinovo-Obleševo Municipality', 129, 'MK', '41.86393160', '22.26224600'),
        (645, 'Debarca Municipality', 129, 'MK', '41.35840770', '20.85529190'),
        (646, 'Probištip Municipality', 129, 'MK', '41.95891460', '22.16686700'),
        (647, 'Krivogaštani Municipality', 129, 'MK', '41.30823060', '21.36796890'),
        (648, 'Gevgelija Municipality', 129, 'MK', '41.21186060', '22.38146240'),
        (649, 'Bogdanci Municipality', 129, 'MK', '41.18696160', '22.59602680'),
        (650, 'Vraneštica Municipality', 129, 'MK', '41.48290870', '21.05796320'),
        (651, 'Veles Municipality', 129, 'MK', '41.72744260', '21.71376940'),
        (652, 'Bosilovo Municipality', 129, 'MK', '41.49048640', '22.78671740'),
        (653, 'Mogila Municipality', 129, 'MK', '41.14796450', '21.45143690'),
        (654, 'Tearce Municipality', 129, 'MK', '42.07775110', '21.05349230'),
        (655, 'Demir Kapija Municipality', 129, 'MK', '41.37955380', '22.21455710'),
        (656, 'Aračinovo Municipality', 129, 'MK', '42.02473810', '21.57664070'),
        (657, 'Drugovo Municipality', 129, 'MK', '41.44081530', '20.92682010'),
        (658, 'Vasilevo Municipality', 129, 'MK', '41.47416990', '22.64221280'),
        (659, 'Lipkovo Municipality', 129, 'MK', '42.20066260', '21.61837550'),
        (660, 'Brvenica Municipality', 129, 'MK', '41.96814820', '20.98195860'),
        (661, 'Štip Municipality', 129, 'MK', '41.70792970', '22.19071220'),
        (662, 'Vevčani Municipality', 129, 'MK', '41.24075430', '20.59156490'),
        (663, 'Tetovo Municipality', 129, 'MK', '42.02748600', '20.95066360'),
        (664, 'Negotino Municipality', 129, 'MK', '41.49899850', '22.09532970'),
        (665, 'Konče Municipality', 129, 'MK', '41.51710110', '22.38146240'),
        (666, 'Prilep Municipality', 129, 'MK', '41.26931420', '21.71376940'),
        (667, 'Saraj Municipality', 129, 'MK', '41.98694960', '21.26065540'),
        (668, 'Želino Municipality', 129, 'MK', '41.90065310', '21.11757670'),
        (669, 'Mavrovo and Rostuša Municipality', 129, 'MK', '41.60924270', '20.60124880'),
        (670, 'Plasnica Municipality', 129, 'MK', '41.45463490', '21.10565390'),
        (671, 'Valandovo Municipality', 129, 'MK', '41.32119090', '22.50066930'),
        (672, 'Vinica Municipality', 129, 'MK', '41.85710200', '22.57218810'),
        (673, 'Zrnovci Municipality', 129, 'MK', '41.82282210', '22.41722560'),
        (674, 'Karbinci', 129, 'MK', '41.81801590', '22.23247580'),
        (675, 'Dolneni Municipality', 129, 'MK', '41.46409350', '21.40374070'),
        (676, 'Čaška Municipality', 129, 'MK', '41.64743800', '21.69141150'),
        (677, 'Kriva Palanka Municipality', 129, 'MK', '42.20584540', '22.33079650'),
        (678, 'Jegunovce Municipality', 129, 'MK', '42.07407200', '21.12204780'),
        (679, 'Bitola Municipality', 129, 'MK', '41.03633020', '21.33219740'),
        (680, 'Šuto Orizari Municipality', 129, 'MK', '42.02904160', '21.40970270'),
        (681, 'Karpoš Municipality', 129, 'MK', '41.97096610', '21.39181680'),
        (682, 'Oslomej Municipality', 129, 'MK', '41.57583910', '21.02219600'),
        (683, 'Kumanovo Municipality', 129, 'MK', '42.07326130', '21.78531430'),
        (684, 'Greater Skopje', 129, 'MK', '41.99812940', '21.42543550'),
        (685, 'Pehčevo Municipality', 129, 'MK', '41.77371320', '22.88204890'),
        (686, 'Kisela Voda Municipality', 129, 'MK', '41.92748000', '21.49317130'),
        (687, 'Demir Hisar Municipality', 129, 'MK', '41.22708300', '21.14142260'),
        (688, 'Kičevo Municipality', 129, 'MK', '41.51291120', '20.95250650'),
        (689, 'Vrapčište Municipality', 129, 'MK', '41.87911600', '20.83145000'),
        (690, 'Ilinden Municipality', 129, 'MK', '41.99574430', '21.56769750'),
        (691, 'Rosoman Municipality', 129, 'MK', '41.48480060', '21.88070640'),
        (692, 'Makedonski Brod Municipality', 129, 'MK', '41.51330880', '21.21743290'),
        (693, 'Gostivar Municipality', 129, 'MK', '41.80255410', '20.90893780'),
        (694, 'Butel Municipality', 129, 'MK', '42.08950680', '21.46336100'),
        (695, 'Delčevo Municipality', 129, 'MK', '41.96843870', '22.76288300'),
        (696, 'Novaci Municipality', 129, 'MK', '41.04426610', '21.45888940'),
        (697, 'Dojran Municipality', 129, 'MK', '41.24366720', '22.69137640'),
        (698, 'Petrovec Municipality', 129, 'MK', '41.90298970', '21.68992100'),
        (699, 'Ohrid Municipality', 129, 'MK', '41.06820880', '20.75992660'),
        (700, 'Struga Municipality', 129, 'MK', '41.31737440', '20.66456830'),
        (701, 'Makedonska Kamenica Municipality', 129, 'MK', '42.06946040', '22.54834900'),
        (702, 'Centar Municipality', 129, 'MK', '41.96989340', '21.42162670'),
        (703, 'Aerodrom Municipality', 129, 'MK', '41.94643630', '21.49317130'),
        (704, 'Čair Municipality', 129, 'MK', '41.99303550', '21.43653180'),
        (705, 'Lozovo Municipality', 129, 'MK', '41.78181390', '21.90008270'),
        (706, 'Zelenikovo Municipality', 129, 'MK', '41.87338120', '21.60272500'),
        (707, 'Gazi Baba Municipality', 129, 'MK', '42.01629610', '21.49913340'),
        (708, 'Gradsko Municipality', 129, 'MK', '41.59916080', '21.88070640'),
        (709, 'Radoviš Municipality', 129, 'MK', '41.64955310', '22.47682870'),
        (710, 'Strumica Municipality', 129, 'MK', '41.43780040', '22.64274280'),
        (711, 'Studeničani Municipality', 129, 'MK', '41.92256390', '21.53639650'),
        (712, 'Resen Municipality', 129, 'MK', '40.93680930', '21.04604070'),
        (713, 'Kavadarci Municipality', 129, 'MK', '41.28900680', '21.99994350'),
        (714, 'Kruševo Municipality', 129, 'MK', '41.37693310', '21.26065540'),
        (715, 'Čučer-Sandevo Municipality', 129, 'MK', '42.14839460', '21.40374070'),
        (716, 'Berovo Municipality', 129, 'MK', '41.66619290', '22.76288300'),
        (717, 'Rankovce Municipality', 129, 'MK', '42.18081410', '22.09532970'),
        (718, 'Novo Selo Municipality', 129, 'MK', '41.43255800', '22.88204890'),
        (719, 'Sopište Municipality', 129, 'MK', '41.86384920', '21.30834990'),
        (720, 'Centar Župa Municipality', 129, 'MK', '41.46522590', '20.59305480'),
        (721, 'Bogovinje Municipality', 129, 'MK', '41.92363710', '20.91638870'),
        (722, 'Gjorče Petrov Municipality', 129, 'MK', '42.06063740', '21.32027360'),
        (723, 'Kočani Municipality', 129, 'MK', '41.98583740', '22.40530460'),
        (724, 'Požega-Slavonia County', 55, 'HR', '45.34178680', '17.81143590'),
        (725, 'Split-Dalmatia County', 55, 'HR', '43.52403280', '16.81783770'),
        (726, 'Međimurje County', 55, 'HR', '46.37666440', '16.42132980'),
        (727, 'Zadar County', 55, 'HR', '44.14693900', '15.61649430'),
        (728, 'Dubrovnik-Neretva County', 55, 'HR', '43.07665880', '17.52684710'),
        (729, 'Krapina-Zagorje County', 55, 'HR', '46.10133930', '15.88096930'),
        (730, 'Šibenik-Knin County', 55, 'HR', '43.92814850', '16.10376940'),
        (731, 'Lika-Senj County', 55, 'HR', '44.61922180', '15.47016080'),
        (732, 'Virovitica-Podravina County', 55, 'HR', '45.65579850', '17.79324720'),
        (733, 'Sisak-Moslavina County', 55, 'HR', '45.38379260', '16.53809940'),
        (734, 'Bjelovar-Bilogora County', 55, 'HR', '45.89879720', '16.84230930'),
        (735, 'Primorje-Gorski Kotar County', 55, 'HR', '45.31739960', '14.81674660'),
        (736, 'Zagreb County', 55, 'HR', '45.87066120', '16.39549100'),
        (737, 'Brod-Posavina County', 55, 'HR', '45.26379510', '17.32645620'),
        (738, 'Zagreb', 55, 'HR', '45.81501080', '15.98191890'),
        (739, 'Varaždin County', 55, 'HR', '46.23174730', '16.33605590'),
        (740, 'Osijek-Baranja County', 55, 'HR', '45.55764280', '18.39421410'),
        (741, 'Vukovar-Syrmia County', 55, 'HR', '45.17735520', '18.80535270'),
        (742, 'Koprivnica-Križevci County', 55, 'HR', '46.15689190', '16.83908260'),
        (743, 'Istria County', 55, 'HR', '45.12864550', '13.90154200'),
        (744, 'Kyrenia District', 57, 'CY', '35.29919400', '33.23632460'),
        (745, 'Nicosia District', 57, 'CY', '35.18556590', '33.38227640'),
        (746, 'Paphos District', 57, 'CY', '34.91645940', '32.49200880'),
        (747, 'Larnaca District', 57, 'CY', '34.85072060', '33.48319060'),
        (748, 'Limassol District', 57, 'CY', '34.70713010', '33.02261740'),
        (749, 'Famagusta District', 57, 'CY', '35.28570230', '33.84112880'),
        (750, 'Rangpur Division', 19, 'BD', '25.84833880', '88.94138650'),
        (751, 'Cox\'s Bazar District', 19, 'BD', '21.56406260', '92.02821290'),
        (752, 'Bandarban District', 19, 'BD', '21.83110020', '92.36863210'),
        (753, 'Rajshahi Division', 19, 'BD', '24.71057760', '88.94138650'),
        (754, 'Pabna District', 19, 'BD', '24.15850500', '89.44807180'),
        (755, 'Sherpur District', 19, 'BD', '25.07462350', '90.14949040'),
        (756, 'Bhola District', 19, 'BD', '22.17853150', '90.71010230'),
        (757, 'Jessore District', 19, 'BD', '23.16340140', '89.21816640'),
        (758, 'Mymensingh Division', 19, 'BD', '24.71362000', '90.45023680'),
        (759, 'Rangpur District', 19, 'BD', '25.74679250', '89.25083350'),
        (760, 'Dhaka Division', 19, 'BD', '23.95357420', '90.14949880'),
        (761, 'Chapai Nawabganj District', 19, 'BD', '24.74131110', '88.29120690'),
        (762, 'Faridpur District', 19, 'BD', '23.54239190', '89.63089210'),
        (763, 'Comilla District', 19, 'BD', '23.45756670', '91.18089960'),
        (764, 'Netrokona District', 19, 'BD', '24.81032840', '90.86564150'),
        (765, 'Sylhet Division', 19, 'BD', '24.70498110', '91.67606910'),
        (766, 'Mymensingh District', 19, 'BD', '24.75385750', '90.40729190'),
        (767, 'Sylhet District', 19, 'BD', '24.89933570', '91.87004730'),
        (768, 'Chandpur District', 19, 'BD', '23.25131480', '90.85178460'),
        (769, 'Narail District', 19, 'BD', '23.11629290', '89.58404040'),
        (770, 'Narayanganj District', 19, 'BD', '23.71466010', '90.56360900'),
        (771, 'Dhaka District', 19, 'BD', '23.81051400', '90.33718890'),
        (772, 'Nilphamari District', 19, 'BD', '25.84827980', '88.94141340'),
        (773, 'Rajbari District', 19, 'BD', '23.71513400', '89.58748190'),
        (774, 'Kushtia District', 19, 'BD', '23.89069950', '89.10993680'),
        (775, 'Khulna Division', 19, 'BD', '22.80878160', '89.24671910'),
        (776, 'Meherpur District', 19, 'BD', '23.80519910', '88.67235780'),
        (777, 'Patuakhali District', 19, 'BD', '22.22486320', '90.45475030'),
        (778, 'Jhalokati District', 19, 'BD', '22.57208000', '90.18696440'),
        (779, 'Kishoreganj District', 19, 'BD', '24.42604570', '90.98206680'),
        (780, 'Lalmonirhat District', 19, 'BD', '25.99233980', '89.28472510'),
        (781, 'Sirajganj District', 19, 'BD', '24.31411150', '89.56996150'),
        (782, 'Tangail District', 19, 'BD', '24.39174270', '89.99482570'),
        (783, 'Dinajpur District', 19, 'BD', '25.62791230', '88.63317580'),
        (784, 'Barguna District', 19, 'BD', '22.09529150', '90.11206960'),
        (785, 'Chittagong District', 19, 'BD', '22.51501050', '91.75388170'),
        (786, 'Khagrachari District', 19, 'BD', '23.13217510', '91.94902100'),
        (787, 'Natore District', 19, 'BD', '24.41024300', '89.00761770'),
        (788, 'Chuadanga District', 19, 'BD', '23.61605120', '88.82630060'),
        (789, 'Jhenaidah District', 19, 'BD', '23.54498730', '89.17260310'),
        (790, 'Munshiganj District', 19, 'BD', '23.49809310', '90.41266210'),
        (791, 'Pirojpur District', 19, 'BD', '22.57907440', '89.97592640'),
        (792, 'Gopalganj District', 19, 'BD', '26.48315840', '84.43655000'),
        (793, 'Kurigram District', 19, 'BD', '25.80724140', '89.62947460'),
        (794, 'Moulvibazar District', 19, 'BD', '24.30953440', '91.73149030'),
        (795, 'Gaibandha District', 19, 'BD', '25.32969280', '89.54296520'),
        (796, 'Bagerhat District', 19, 'BD', '22.66024360', '89.78954780'),
        (797, 'Bogra District', 19, 'BD', '24.85104020', '89.36972250'),
        (798, 'Gazipur District', 19, 'BD', '24.09581710', '90.41251810'),
        (799, 'Satkhira District', 19, 'BD', '22.31548120', '89.11145250'),
        (800, 'Panchagarh District', 19, 'BD', '26.27087050', '88.59517510'),
        (801, 'Shariatpur District', 19, 'BD', '23.24232140', '90.43477110'),
        (802, 'Bahadia', 19, 'BD', '23.78987120', '90.16714830'),
        (803, 'Chittagong Division', 19, 'BD', '23.17931570', '91.98815270'),
        (804, 'Thakurgaon District', 19, 'BD', '26.04183920', '88.42826160'),
        (805, 'Habiganj District', 19, 'BD', '24.47712360', '91.45065650'),
        (806, 'Joypurhat District', 19, 'BD', '25.09473490', '89.09449370'),
        (807, 'Barisal Division', 19, 'BD', '22.38111310', '90.33718890'),
        (808, 'Jamalpur District', 19, 'BD', '25.08309260', '89.78532180'),
        (809, 'Rangamati Hill District', 19, 'BD', '22.73241730', '92.29851340'),
        (810, 'Brahmanbaria District', 19, 'BD', '23.96081810', '91.11150140'),
        (811, 'Khulna District', 19, 'BD', '22.67377350', '89.39665810'),
        (812, 'Sunamganj District', 19, 'BD', '25.07145350', '91.39916270'),
        (813, 'Rajshahi District', 19, 'BD', '24.37330870', '88.60487160'),
        (814, 'Naogaon District', 19, 'BD', '24.91315970', '88.75309520'),
        (815, 'Noakhali District', 19, 'BD', '22.87237890', '91.09731840'),
        (816, 'Feni District', 19, 'BD', '22.94087840', '91.40666460'),
        (817, 'Madaripur District', 19, 'BD', '23.23933460', '90.18696440'),
        (818, 'Barisal District', 19, 'BD', '22.70220980', '90.36963160'),
        (819, 'Lakshmipur District', 19, 'BD', '22.94467440', '90.82819070'),
        (820, 'Okayama Prefecture', 109, 'JP', '34.89634070', '133.63753140'),
        (821, 'Chiba Prefecture', 109, 'JP', '35.33541550', '140.18325160'),
        (822, 'Ōita Prefecture', 109, 'JP', '33.15892990', '131.36111210'),
        (823, 'Tokyo', 109, 'JP', '35.67619190', '139.65031060'),
        (824, 'Nara Prefecture', 109, 'JP', '34.29755280', '135.82797340'),
        (825, 'Shizuoka Prefecture', 109, 'JP', '35.09293970', '138.31902760'),
        (826, 'Shimane Prefecture', 109, 'JP', '35.12440940', '132.62934460'),
        (827, 'Aichi Prefecture', 109, 'JP', '35.01825050', '137.29238930'),
        (828, 'Hiroshima Prefecture', 109, 'JP', '34.88234080', '133.01948970'),
        (829, 'Akita Prefecture', 109, 'JP', '40.13762930', '140.33434100'),
        (830, 'Ishikawa Prefecture', 109, 'JP', '36.32603170', '136.52896530'),
        (831, 'Hyōgo Prefecture', 109, 'JP', '34.85795180', '134.54537870'),
        (832, 'Hokkaidō Prefecture', 109, 'JP', '43.22032660', '142.86347370'),
        (833, 'Mie Prefecture', 109, 'JP', '33.81439010', '136.04870470'),
        (834, 'Kyōto Prefecture', 109, 'JP', '35.15666090', '135.52519820'),
        (835, 'Yamaguchi Prefecture', 109, 'JP', '34.27967690', '131.52127420'),
        (836, 'Tokushima Prefecture', 109, 'JP', '33.94196550', '134.32365570'),
        (837, 'Yamagata Prefecture', 109, 'JP', '38.53705640', '140.14351980'),
        (838, 'Toyama Prefecture', 109, 'JP', '36.69582660', '137.21370710'),
        (839, 'Aomori Prefecture', 109, 'JP', '40.76570770', '140.91758790'),
        (840, 'Kagoshima Prefecture', 109, 'JP', '31.39119580', '130.87785860'),
        (841, 'Niigata Prefecture', 109, 'JP', '37.51783860', '138.92697940'),
        (842, 'Kanagawa Prefecture', 109, 'JP', '35.49135350', '139.28414300'),
        (843, 'Nagano Prefecture', 109, 'JP', '36.15439410', '137.92182040'),
        (844, 'Wakayama Prefecture', 109, 'JP', '33.94809140', '135.37453580'),
        (845, 'Shiga Prefecture', 109, 'JP', '35.32920140', '136.05632120'),
        (846, 'Kumamoto Prefecture', 109, 'JP', '32.85944270', '130.79691490'),
        (847, 'Fukushima Prefecture', 109, 'JP', '37.38343730', '140.18325160'),
        (848, 'Fukui Prefecture', 109, 'JP', '35.89622700', '136.21115790'),
        (849, 'Nagasaki Prefecture', 109, 'JP', '33.24885250', '129.69309120'),
        (850, 'Tottori Prefecture', 109, 'JP', '35.35731610', '133.40666180'),
        (851, 'Ibaraki Prefecture', 109, 'JP', '36.21935710', '140.18325160'),
        (852, 'Yamanashi Prefecture', 109, 'JP', '35.66351130', '138.63888790'),
        (853, 'Okinawa Prefecture', 109, 'JP', '26.12019110', '127.70250120'),
        (854, 'Tochigi Prefecture', 109, 'JP', '36.67147390', '139.85472660'),
        (855, 'Miyazaki Prefecture', 109, 'JP', '32.60360220', '131.44125100'),
        (856, 'Iwate Prefecture', 109, 'JP', '39.58329890', '141.25345740'),
        (857, 'Miyagi Prefecture', 109, 'JP', '38.63061200', '141.11930480'),
        (858, 'Gifu Prefecture', 109, 'JP', '35.74374910', '136.98051030'),
        (859, 'Ōsaka Prefecture', 109, 'JP', '34.64133150', '135.56293940'),
        (860, 'Saitama Prefecture', 109, 'JP', '35.99625130', '139.44660050'),
        (861, 'Fukuoka Prefecture', 109, 'JP', '33.56625590', '130.71585700'),
        (862, 'Gunma Prefecture', 109, 'JP', '36.56053880', '138.87999720'),
        (863, 'Saga Prefecture', 109, 'JP', '33.30783710', '130.22712430'),
        (864, 'Kagawa Prefecture', 109, 'JP', '34.22259150', '134.01991520'),
        (865, 'Ehime Prefecture', 109, 'JP', '33.60253060', '132.78575830'),
        (866, 'Ontario', 39, 'CA', '51.25377500', '-85.32321400'),
        (867, 'Manitoba', 39, 'CA', '53.76086080', '-98.81387620'),
        (868, 'New Brunswick', 39, 'CA', '46.56531630', '-66.46191640'),
        (869, 'Yukon', 39, 'CA', '35.50672150', '-97.76254410'),
        (870, 'Saskatchewan', 39, 'CA', '52.93991590', '-106.45086390'),
        (871, 'Prince Edward Island', 39, 'CA', '46.51071200', '-63.41681360'),
        (872, 'Alberta', 39, 'CA', '53.93327060', '-116.57650350'),
        (873, 'Quebec', 39, 'CA', '52.93991590', '-73.54913610'),
        (874, 'Nova Scotia', 39, 'CA', '44.68198660', '-63.74431100'),
        (875, 'British Columbia', 39, 'CA', '53.72666830', '-127.64762050'),
        (876, 'Nunavut', 39, 'CA', '70.29977110', '-83.10757700'),
        (877, 'Newfoundland and Labrador', 39, 'CA', '53.13550910', '-57.66043640'),
        (878, 'Northwest Territories', 39, 'CA', '64.82554410', '-124.84573340'),
        (879, 'White Nile', 209, 'SD', '9.33215160', '31.46153000'),
        (880, 'Red Sea', 209, 'SD', '20.28023200', '38.51257300'),
        (881, 'Khartoum', 209, 'SD', '15.50065440', '32.55989940'),
        (882, 'Sennar', 209, 'SD', '13.56746900', '33.56720450'),
        (883, 'South Kordofan', 209, 'SD', '11.19901920', '29.41793240'),
        (884, 'Kassala', 209, 'SD', '15.45813320', '36.40396290'),
        (885, 'Al Jazirah', 209, 'SD', '14.88596110', '33.43835300'),
        (886, 'Al Qadarif', 209, 'SD', '14.02430700', '35.36856790'),
        (887, 'Blue Nile', 209, 'SD', '47.59867300', '-122.33441900'),
        (888, 'West Darfur', 209, 'SD', '12.84635610', '23.00119890'),
        (889, 'West Kordofan', 209, 'SD', '11.19901920', '29.41793240'),
        (890, 'North Darfur', 209, 'SD', '15.76619690', '24.90422080'),
        (891, 'River Nile', 209, 'SD', '23.97275950', '32.87492060'),
        (892, 'East Darfur', 209, 'SD', '14.37827470', '24.90422080'),
        (893, 'North Kordofan', 209, 'SD', '13.83064410', '29.41793240'),
        (894, 'South Darfur', 209, 'SD', '11.64886390', '24.90422080'),
        (895, 'Northern', 209, 'SD', '38.06381700', '-84.46286480'),
        (896, 'Central Darfur', 209, 'SD', '14.37827470', '24.90422080'),
        (897, 'Khelvachauri Municipality', 81, 'GE', '41.58019260', '41.66107420'),
        (898, 'Senaki Municipality', 81, 'GE', '42.26963600', '42.06568960'),
        (899, 'Tbilisi', 81, 'GE', '41.71513770', '44.82709600'),
        (900, 'Adjara', 81, 'GE', '41.60056260', '42.06883830'),
        (901, 'Autonomous Republic of Abkhazia', 81, 'GE', '43.00155440', '41.02340700'),
        (902, 'Mtskheta-Mtianeti', 81, 'GE', '42.16821850', '44.65060580'),
        (903, 'Shida Kartli', 81, 'GE', '42.07569440', '43.95404620'),
        (904, 'Kvemo Kartli', 81, 'GE', '41.47918330', '44.65604510'),
        (905, 'Imereti', 81, 'GE', '42.23010800', '42.90086640'),
        (906, 'Samtskhe-Javakheti', 81, 'GE', '41.54792960', '43.27764000'),
        (907, 'Guria', 81, 'GE', '41.94427360', '42.04580910'),
        (908, 'Samegrelo-Zemo Svaneti', 81, 'GE', '42.73522470', '42.16893620'),
        (909, 'Racha-Lechkhumi and Kvemo Svaneti', 81, 'GE', '42.67188730', '43.05628360'),
        (910, 'Kakheti', 81, 'GE', '41.64816020', '45.69055540'),
        (911, 'Northern Province', 198, 'SL', NULL, NULL),
        (912, 'Southern Province', 198, 'SL', NULL, NULL),
        (913, 'Western Area', 198, 'SL', '40.25459690', '-80.24554440'),
        (914, 'Eastern Province', 198, 'SL', NULL, NULL),
        (915, 'Hiran', 203, 'SO', '4.32101500', '45.29938620'),
        (916, 'Mudug', 203, 'SO', '6.56567260', '47.76375650'),
        (917, 'Bakool', 203, 'SO', '4.36572210', '44.09603110'),
        (918, 'Galguduud', 203, 'SO', '5.18501280', '46.82528380'),
        (919, 'Sanaag Region', 203, 'SO', '10.39382180', '47.76375650'),
        (920, 'Nugal', 203, 'SO', '43.27938610', '17.03392050'),
        (921, 'Lower Shebelle', 203, 'SO', '1.87664580', '44.24790150'),
        (922, 'Middle Juba', 203, 'SO', '2.07804880', '41.60118140'),
        (923, 'Middle Shebelle', 203, 'SO', '2.92502470', '45.90396890'),
        (924, 'Lower Juba', 203, 'SO', '0.22402100', '41.60118140'),
        (925, 'Awdal Region', 203, 'SO', '10.63342850', '43.32946600'),
        (926, 'Bay', 203, 'SO', '37.03655340', '-95.61747670'),
        (927, 'Banaadir', 203, 'SO', '2.11873750', '45.33694590'),
        (928, 'Gedo', 203, 'SO', '3.50392270', '42.23624350'),
        (929, 'Togdheer Region', 203, 'SO', '9.44605870', '45.29938620'),
        (930, 'Bari', 203, 'SO', '41.11714320', '16.87187150'),
        (931, 'Northern Cape', 204, 'ZA', '-29.04668080', '21.85685860'),
        (932, 'Free State', 204, 'ZA', '37.68585250', '-97.28112560'),
        (933, 'Limpopo', 204, 'ZA', '-23.40129460', '29.41793240'),
        (934, 'North West', 204, 'ZA', '32.75885200', '-97.32880600'),
        (935, 'KwaZulu-Natal', 204, 'ZA', '-28.53055390', '30.89582420'),
        (936, 'Gauteng', 204, 'ZA', '-26.27075930', '28.11226790'),
        (937, 'Mpumalanga', 204, 'ZA', '-25.56533600', '30.52790960'),
        (938, 'Eastern Cape', 204, 'ZA', '-32.29684020', '26.41938900'),
        (939, 'Western Cape', 204, 'ZA', '-33.22779180', '21.85685860'),
        (940, 'Chontales Department', 159, 'NI', '11.93947170', '-85.18940450'),
        (941, 'Managua Department', 159, 'NI', '12.13916990', '-86.33767610'),
        (942, 'Rivas Department', 159, 'NI', '11.40234900', '-85.68457800'),
        (943, 'Granada Department', 159, 'NI', '11.93440730', '-85.95600050'),
        (944, 'León Department', 159, 'NI', '12.50920370', '-86.66110830'),
        (945, 'Estelí Department', 159, 'NI', '13.08511390', '-86.36301970'),
        (946, 'Boaco Department', 159, 'NI', '12.46928400', '-85.66146820'),
        (947, 'Matagalpa Department', 159, 'NI', '12.94984360', '-85.43755740'),
        (948, 'Madriz Department', 159, 'NI', '13.47260050', '-86.45920910'),
        (949, 'Río San Juan Department', 159, 'NI', '11.47816100', '-84.77333250'),
        (950, 'Carazo Department', 159, 'NI', '11.72747290', '-86.21584970'),
        (951, 'North Caribbean Coast Autonomous Region', 159, 'NI', '13.83944560', '-83.93208060'),
        (952, 'South Caribbean Coast Autonomous Region', 159, 'NI', '12.19185020', '-84.10128610'),
        (953, 'Masaya Department', 159, 'NI', '11.97593280', '-86.07334980'),
        (954, 'Chinandega Department', 159, 'NI', '12.88200620', '-87.14228950'),
        (955, 'Jinotega Department', 159, 'NI', '13.08839070', '-85.99939970'),
        (956, 'Karak Governorate', 111, 'JO', '31.18535270', '35.70476820'),
        (957, 'Tafilah Governorate', 111, 'JO', '30.83380630', '35.61605130'),
        (958, 'Madaba Governorate', 111, 'JO', '31.71960970', '35.79327540'),
        (959, 'Aqaba Governorate', 111, 'JO', '29.53208600', '35.00628210'),
        (960, 'Irbid Governorate', 111, 'JO', '32.55696360', '35.84789650'),
        (961, 'Balqa Governorate', 111, 'JO', '32.03668060', '35.72884800'),
        (962, 'Mafraq Governorate', 111, 'JO', '32.34169230', '36.20201750'),
        (963, 'Ajloun Governorate', 111, 'JO', '32.33255840', '35.75168440'),
        (964, 'Ma\'an Governorate', 111, 'JO', '30.19267890', '35.72493190'),
        (965, 'Amman Governorate', 111, 'JO', '31.94536330', '35.92838950'),
        (966, 'Jerash Governorate', 111, 'JO', '32.27472370', '35.89609540'),
        (967, 'Zarqa Governorate', 111, 'JO', '32.06085050', '36.09421210'),
        (968, 'Manzini District', 212, 'SZ', '-26.50819990', '31.37131640'),
        (969, 'Hhohho District', 212, 'SZ', '-26.13656620', '31.35416310'),
        (970, 'Lubombo District', 212, 'SZ', '-26.78517730', '31.81070790'),
        (971, 'Shiselweni District', 212, 'SZ', '-26.98275770', '31.35416310'),
        (972, 'Al Jahra Governorate', 117, 'KW', '29.99318310', '47.76347310'),
        (973, 'Hawalli Governorate', 117, 'KW', '29.30567160', '48.03076130'),
        (974, 'Mubarak Al-Kabeer Governorate', 117, 'KW', '29.21224000', '48.06051080'),
        (975, 'Al Farwaniyah Governorate', 117, 'KW', '29.27335700', '47.94001540'),
        (976, 'Capital Governorate', 117, 'KW', '26.22851610', '50.58604970'),
        (977, 'Al Ahmadi Governorate', 117, 'KW', '28.57451250', '48.10247430'),
        (978, 'Luang Prabang Province', 119, 'LA', '20.06562290', '102.62162110'),
        (979, 'Vientiane Prefecture', 119, 'LA', '18.11054100', '102.52980280'),
        (980, 'Vientiane Province', 119, 'LA', '18.57050630', '102.62162110'),
        (981, 'Salavan Province', 119, 'LA', '15.81710730', '106.25221430'),
        (982, 'Attapeu Province', 119, 'LA', '14.93634000', '107.10119310'),
        (983, 'Xaisomboun Province', 119, 'LA', '18.43629240', '104.47233010'),
        (984, 'Sekong Province', 119, 'LA', '15.57674460', '107.00670310'),
        (985, 'Bolikhamsai Province', 119, 'LA', '18.43629240', '104.47233010'),
        (986, 'Khammouane Province', 119, 'LA', '17.63840660', '105.21948080'),
        (987, 'Phongsaly Province', 119, 'LA', '21.59193770', '102.25479190'),
        (988, 'Oudomxay Province', 119, 'LA', '20.49219290', '101.88917210'),
        (989, 'Houaphanh Province', 119, 'LA', '20.32541750', '104.10013260'),
        (990, 'Savannakhet Province', 119, 'LA', '16.50653810', '105.59433880'),
        (991, 'Bokeo Province', 119, 'LA', '20.28726620', '100.70978670'),
        (992, 'Luang Namtha Province', 119, 'LA', '20.91701870', '101.16173560'),
        (993, 'Sainyabuli Province', 119, 'LA', '19.39078860', '101.52480550'),
        (994, 'Xaisomboun', 119, 'LA', NULL, NULL),
        (995, 'Xiangkhouang Province', 119, 'LA', '19.60930030', '103.72891670'),
        (996, 'Champasak Province', 119, 'LA', '14.65786640', '105.96998780'),
        (997, 'Talas Region', 118, 'KG', '42.28673390', '72.52048270'),
        (998, 'Batken Region', 118, 'KG', '39.97214250', '69.85974060'),
        (999, 'Naryn Region', 118, 'KG', '41.29432270', '75.34121790'),
        (1000, 'Jalal-Abad Region', 118, 'KG', '41.10680800', '72.89880690'),
        (1001, 'Bishkek', 118, 'KG', '42.87462120', '74.56976170'),
        (1002, 'Issyk-Kul Region', 118, 'KG', '42.18594280', '77.56194190'),
        (1003, 'Osh', 118, 'KG', '36.06313990', '-95.91828950'),
        (1004, 'Chuy Region', 118, 'KG', '42.56550000', '74.40566120'),
        (1005, 'Osh Region', 118, 'KG', '39.84073660', '72.89880690'),
        (1006, 'Trøndelag', 165, 'NO', '63.54201250', '10.93692670'),
        (1007, 'Oslo', 165, 'NO', '59.91386880', '10.75224540'),
        (1008, 'Vestfold', 165, 'NO', '59.17078620', '10.11443550'),
        (1009, 'Oppland', 165, 'NO', '61.54227520', '9.71663150'),
        (1010, 'Sør-Trøndelag', 165, 'NO', '63.01368230', '10.34871360'),
        (1011, 'Buskerud', 165, 'NO', '60.48460250', '8.69837640'),
        (1012, 'Nord-Trøndelag', 165, 'NO', '64.43707920', '11.74629500'),
        (1013, 'Svalbard', 165, 'NO', '77.87497250', '20.97518210'),
        (1014, 'Vest-Agder', 165, 'NO', '58.09990810', '6.58698090'),
        (1015, 'Troms', 165, 'NO', '69.81782420', '18.78193650'),
        (1016, 'Finnmark', 165, 'NO', '70.48303880', '26.01351070'),
        (1017, 'Akershus', 165, 'NO', '28.37042030', '-81.54680580'),
        (1018, 'Sogn og Fjordane', 165, 'NO', '61.55394350', '6.33258790'),
        (1019, 'Hedmark', 165, 'NO', '61.39673110', '11.56273690'),
        (1020, 'Møre og Romsdal', 165, 'NO', '62.84068330', '7.00714300'),
        (1021, 'Rogaland', 165, 'NO', '59.14895440', '6.01434320'),
        (1022, 'Østfold', 165, 'NO', '59.25582860', '11.32790060'),
        (1023, 'Hordaland', 165, 'NO', '60.27336740', '5.72201940'),
        (1024, 'Telemark', 165, 'NO', '59.39139850', '8.32112090'),
        (1025, 'Nordland', 165, 'NO', '67.69305800', '12.70739360'),
        (1026, 'Jan Mayen', 165, 'NO', '71.03181800', '-8.29203460'),
        (1027, 'Hódmezővásárhely', 99, 'HU', '46.41812620', '20.33003150'),
        (1028, 'Érd', 99, 'HU', '47.39197180', '18.90454400'),
        (1029, 'Szeged', 99, 'HU', '46.25301020', '20.14142530'),
        (1030, 'Nagykanizsa', 99, 'HU', '46.45902180', '16.98967960'),
        (1031, 'Csongrád County', 99, 'HU', '46.41670500', '20.25661610'),
        (1032, 'Debrecen', 99, 'HU', '47.53160490', '21.62731240'),
        (1033, 'Székesfehérvár', 99, 'HU', '47.18602620', '18.42213580'),
        (1034, 'Nyíregyháza', 99, 'HU', '47.94953240', '21.72440530'),
        (1035, 'Somogy County', 99, 'HU', '46.55485900', '17.58667320'),
        (1036, 'Békéscsaba', 99, 'HU', '46.67359390', '21.08773090'),
        (1037, 'Eger', 99, 'HU', '47.90253480', '20.37722840'),
        (1038, 'Tolna County', 99, 'HU', '46.47627540', '18.55706270'),
        (1039, 'Vas County', 99, 'HU', '47.09291110', '16.68121830'),
        (1040, 'Heves County', 99, 'HU', '47.80576170', '20.20385590'),
        (1041, 'Győr', 99, 'HU', '47.68745690', '17.65039740'),
        (1042, 'Győr-Moson-Sopron County', 99, 'HU', '47.65092850', '17.25058830'),
        (1043, 'Jász-Nagykun-Szolnok County', 99, 'HU', '47.25555790', '20.52324560'),
        (1044, 'Fejér County', 99, 'HU', '47.12179320', '18.52948150'),
        (1045, 'Szabolcs-Szatmár-Bereg County', 99, 'HU', '48.03949540', '22.00333000'),
        (1046, 'Zala County', 99, 'HU', '46.73844040', '16.91522520'),
        (1047, 'Szolnok', 99, 'HU', '47.16213550', '20.18247120'),
        (1048, 'Bács-Kiskun County', 99, 'HU', '46.56614370', '19.42724640'),
        (1049, 'Dunaújváros', 99, 'HU', '46.96190590', '18.93552270'),
        (1050, 'Zalaegerszeg', 99, 'HU', '46.84169360', '16.84163220'),
        (1051, 'Nógrád County', 99, 'HU', '47.90410310', '19.04985040'),
        (1052, 'Szombathely', 99, 'HU', '47.23068510', '16.62184410'),
        (1053, 'Pécs', 99, 'HU', '46.07273450', '18.23226600'),
        (1054, 'Veszprém County', 99, 'HU', '47.09309740', '17.91007630'),
        (1055, 'Baranya County', 99, 'HU', '46.04845850', '18.27191730'),
        (1056, 'Kecskemét', 99, 'HU', '46.89637110', '19.68968610'),
        (1057, 'Sopron', 99, 'HU', '47.68166190', '16.58447950'),
        (1058, 'Borsod-Abaúj-Zemplén County', 99, 'HU', '48.29394010', '20.69341120'),
        (1059, 'Pest County', 99, 'HU', '47.44800010', '19.46181280'),
        (1060, 'Békés County', 99, 'HU', '46.67048990', '21.04349960'),
        (1061, 'Szekszárd', 99, 'HU', '46.34743260', '18.70622930'),
        (1062, 'Veszprém', 99, 'HU', '47.10280870', '17.90930190'),
        (1063, 'Hajdú-Bihar County', 99, 'HU', '47.46883550', '21.54532270'),
        (1064, 'Budapest', 99, 'HU', '47.49791200', '19.04023500'),
        (1065, 'Miskolc', 99, 'HU', '48.10347750', '20.77843840'),
        (1066, 'Tatabánya', 99, 'HU', '47.56924600', '18.40481800'),
        (1067, 'Kaposvár', 99, 'HU', '46.35936060', '17.79676390'),
        (1068, 'Salgótarján', 99, 'HU', '48.09352370', '19.79998130'),
        (1069, 'County Tipperary', 105, 'IE', '52.47378940', '-8.16185140'),
        (1070, 'County Sligo', 105, 'IE', '54.15532770', '-8.60645320'),
        (1071, 'County Donegal', 105, 'IE', '54.65489930', '-8.10409670'),
        (1072, 'County Dublin', 105, 'IE', '53.34980530', '-6.26030970'),
        (1073, 'Leinster', 105, 'IE', '53.32715380', '-7.51408410'),
        (1074, 'County Cork', 105, 'IE', '51.89851430', '-8.47560350'),
        (1075, 'County Monaghan', 105, 'IE', '54.24920460', '-6.96831320'),
        (1076, 'County Longford', 105, 'IE', '53.72749820', '-7.79315270'),
        (1077, 'County Kerry', 105, 'IE', '52.15446070', '-9.56686330'),
        (1078, 'County Offaly', 105, 'IE', '53.23568710', '-7.71222290'),
        (1079, 'County Galway', 105, 'IE', '53.35645090', '-8.85341130'),
        (1080, 'Munster', 105, 'IE', '51.94711970', '7.58453200'),
        (1081, 'County Roscommon', 105, 'IE', '53.75926040', '-8.26816210'),
        (1082, 'County Kildare', 105, 'IE', '53.21204340', '-6.81947080'),
        (1083, 'County Louth', 105, 'IE', '53.92523240', '-6.48894230'),
        (1084, 'County Mayo', 105, 'IE', '54.01526040', '-9.42893690'),
        (1085, 'County Wicklow', 105, 'IE', '52.98623130', '-6.36725430'),
        (1086, 'Ulster', 105, 'IE', '54.76165550', '-6.96122730'),
        (1087, 'Connacht', 105, 'IE', '53.83762430', '-8.95844810'),
        (1088, 'County Cavan', 105, 'IE', '53.97654240', '-7.29966230'),
        (1089, 'County Waterford', 105, 'IE', '52.19435490', '-7.62275120'),
        (1090, 'County Kilkenny', 105, 'IE', '52.57769570', '-7.21800200'),
        (1091, 'County Clare', 105, 'IE', '43.04664000', '-87.89958100'),
        (1092, 'County Meath', 105, 'IE', '53.60554800', '-6.65641690'),
        (1093, 'County Wexford', 105, 'IE', '52.47936030', '-6.58399130'),
        (1094, 'County Limerick', 105, 'IE', '52.50905170', '-8.74749550'),
        (1095, 'County Carlow', 105, 'IE', '52.72322170', '-6.81082950'),
        (1096, 'County Laois', 105, 'IE', '52.99429500', '-7.33230070'),
        (1097, 'County Westmeath', 105, 'IE', '53.53453080', '-7.46532170'),
        (1098, 'Djelfa', 4, 'DZ', '34.67039560', '3.25037610'),
        (1099, 'El Oued', 4, 'DZ', '33.36781100', '6.85165110'),
        (1100, 'El Tarf', 4, 'DZ', '36.75766780', '8.30763430'),
        (1101, 'Oran', 4, 'DZ', '35.60823510', '-0.56360900'),
        (1102, 'Naama', 4, 'DZ', '33.26673170', '-0.31286590'),
        (1103, 'Annaba', 4, 'DZ', '36.80205080', '7.52472430'),
        (1104, 'Bouïra', 4, 'DZ', '36.36918460', '3.90061940'),
        (1105, 'Chlef', 4, 'DZ', '36.16935150', '1.28910360'),
        (1106, 'Tiaret', 4, 'DZ', '35.37086890', '1.32178520'),
        (1107, 'Tlemcen', 4, 'DZ', '34.67802840', '-1.36621600'),
        (1108, 'Béchar', 4, 'DZ', '31.62380980', '-2.21624430'),
        (1109, 'Médéa', 4, 'DZ', '36.26370780', '2.75878570'),
        (1110, 'Skikda', 4, 'DZ', '36.67211980', '6.83509990'),
        (1111, 'Blida', 4, 'DZ', '36.53112300', '2.89762540'),
        (1112, 'Illizi', 4, 'DZ', '26.16900050', '8.48424650'),
        (1113, 'Jijel', 4, 'DZ', '36.71796810', '5.98325770'),
        (1114, 'Biskra', 4, 'DZ', '34.84494370', '5.72485670'),
        (1115, 'Tipasa', 4, 'DZ', '36.54626500', '2.18432850'),
        (1116, 'Bordj Bou Arréridj', 4, 'DZ', '36.07399250', '4.76302710'),
        (1117, 'Tébessa', 4, 'DZ', '35.12906910', '7.95928630'),
        (1118, 'Adrar', 4, 'DZ', '26.41813100', '-0.60147170'),
        (1119, 'Aïn Defla', 4, 'DZ', '36.25094290', '1.93938150'),
        (1120, 'Tindouf', 4, 'DZ', '27.80631190', '-5.72998210'),
        (1121, 'Constantine', 4, 'DZ', '36.33739110', '6.66381200'),
        (1122, 'Aïn Témouchent', 4, 'DZ', '35.29926980', '-1.13927920'),
        (1123, 'Saïda', 4, 'DZ', '34.84152070', '0.14560550'),
        (1124, 'Mascara', 4, 'DZ', '35.39041250', '0.14949880'),
        (1125, 'Boumerdès', 4, 'DZ', '36.68395590', '3.62178020'),
        (1126, 'Khenchela', 4, 'DZ', '35.42694040', '7.14601550'),
        (1127, 'Ghardaïa', 4, 'DZ', '32.49437410', '3.64446000'),
        (1128, 'Béjaïa', 4, 'DZ', '36.75152580', '5.05568370'),
        (1129, 'El Bayadh', 4, 'DZ', '32.71488240', '0.90566230'),
        (1130, 'Relizane', 4, 'DZ', '35.73834050', '0.75328090'),
        (1131, 'Tizi Ouzou', 4, 'DZ', '36.70691100', '4.23333550'),
        (1132, 'Mila', 4, 'DZ', '36.36479570', '6.15269850'),
        (1133, 'Tissemsilt', 4, 'DZ', '35.60537810', '1.81309800'),
        (1134, 'M\'Sila', 4, 'DZ', '35.71866460', '4.52334230'),
        (1135, 'Tamanghasset', 4, 'DZ', '22.79029720', '5.51932680'),
        (1136, 'Oum El Bouaghi', 4, 'DZ', '35.86887890', '7.11082660'),
        (1137, 'Guelma', 4, 'DZ', '36.46274440', '7.43308330'),
        (1138, 'Laghouat', 4, 'DZ', '33.80783410', '2.86282940'),
        (1139, 'Ouargla', 4, 'DZ', '32.22648630', '5.72998210'),
        (1140, 'Mostaganem', 4, 'DZ', '35.95830540', '0.33718890'),
        (1141, 'Sétif', 4, 'DZ', '36.30733890', '5.56172790'),
        (1142, 'Batna', 4, 'DZ', '35.59659540', '5.89871390'),
        (1143, 'Souk Ahras', 4, 'DZ', '36.28010620', '7.93840330'),
        (1144, 'Algiers', 4, 'DZ', '36.69972940', '3.05761990'),
        (1146, 'Burgos Province', 207, 'ES', '42.33807580', '-3.58126920'),
        (1147, 'Salamanca Province', 207, 'ES', '40.95152630', '-6.23759470'),
        (1157, 'Palencia Province', 207, 'ES', '42.00968320', '-4.52879490'),
        (1158, 'Madrid', 207, 'ES', '40.41675150', '-3.70383220'),
        (1159, 'Melilla', 207, 'ES', '35.29227750', '-2.93809730'),
        (1160, 'Asturias', 207, 'ES', '43.36139530', '-5.85932670'),
        (1161, 'Zamora Province', 207, 'ES', '41.60957440', '-5.89871390'),
        (1167, 'Galicia', 207, 'ES', '42.57505540', '-8.13385580'),
        (1170, 'Cantabria', 207, 'ES', '43.18283960', '-3.98784270'),
        (1171, 'La Rioja', 207, 'ES', '42.28707330', '-2.53960300'),
        (1174, 'Balearic Islands', 207, 'ES', '39.35877590', '2.73563280'),
        (1175, 'Valencia', 207, 'ES', '39.48401080', '-0.75328090'),
        (1176, 'Murcia', 207, 'ES', '38.13981410', '-1.36621600'),
        (1177, 'Aragon', 207, 'ES', '41.59762750', '-0.90566230'),
        (1183, 'Valladolid Province', 207, 'ES', '41.65173750', '-4.72449500'),
        (1184, 'Castile and León', 207, 'ES', '41.83568210', '-4.39763570'),
        (1185, 'Canary Islands', 207, 'ES', '28.29156370', '-16.62913040'),
        (1189, 'Ávila', 207, 'ES', '40.69345110', '-4.89356270'),
        (1190, 'Extremadura', 207, 'ES', '39.49373920', '-6.06791940'),
        (1191, 'Basque Country', 207, 'ES', '42.98962480', '-2.61892730'),
        (1192, 'Segovia Province', 207, 'ES', '40.94292960', '-4.10889420'),
        (1193, 'Andalusia', 207, 'ES', '37.54427060', '-4.72775280'),
        (1200, 'Léon', 207, 'ES', '42.59870410', '-5.56708390'),
        (1203, 'Catalonia', 207, 'ES', '41.59115890', '1.52086240'),
        (1204, 'Navarra', 207, 'ES', '42.69539090', '-1.67606910'),
        (1205, 'Castilla La Mancha', 207, 'ES', '39.27956070', '-3.09770200'),
        (1206, 'Ceuta', 207, 'ES', '35.88938740', '-5.32134550'),
        (1208, 'Soria Province', 207, 'ES', '41.76654640', '-2.47903060'),
        (1209, 'Guanacaste Province', 53, 'CR', '10.62673990', '-85.44367060'),
        (1210, 'Puntarenas Province', 53, 'CR', '9.21695310', '-83.33618800'),
        (1211, 'Provincia de Cartago', 53, 'CR', '9.86223110', '-83.92141870'),
        (1212, 'Heredia Province', 53, 'CR', '10.47352300', '-84.01674230'),
        (1213, 'Limón Province', 53, 'CR', '9.98963980', '-83.03324170'),
        (1214, 'San José Province', 53, 'CR', '9.91297270', '-84.07682940'),
        (1215, 'Alajuela Province', 53, 'CR', '10.39158300', '-84.43827210'),
        (1216, 'Brunei-Muara District', 33, 'BN', '4.93112060', '114.95168690'),
        (1217, 'Belait District', 33, 'BN', '4.37507490', '114.61928990'),
        (1218, 'Temburong District', 33, 'BN', '4.62041280', '115.14148400'),
        (1219, 'Tutong District', 33, 'BN', '4.71403730', '114.66679390'),
        (1220, 'Saint Philip', 20, 'BB', '35.23311400', '-89.43640420'),
        (1221, 'Saint Lucy', 20, 'BB', '38.76146250', '-77.44914390'),
        (1222, 'Saint Peter', 20, 'BB', '37.08271190', '-94.51712500'),
        (1223, 'Saint Joseph', 20, 'BB', '39.76745780', '-94.84668100'),
        (1224, 'Saint James', 20, 'BB', '48.52356600', '-1.32378850'),
        (1225, 'Saint Thomas', 20, 'BB', '18.33809650', '-64.89409460'),
        (1226, 'Saint George', 20, 'BB', '37.09652780', '-113.56841640'),
        (1227, 'Saint John', 20, 'BB', '45.27331530', '-66.06330800'),
        (1228, 'Christ Church', 20, 'BB', '36.00604070', '-95.92112100'),
        (1229, 'Saint Andrew', 20, 'BB', NULL, NULL),
        (1230, 'Saint Michael', 20, 'BB', '36.03597700', '-95.84905200'),
        (1231, 'Ta\'izz Governorate', 245, 'YE', '13.57758860', '44.01779890'),
        (1232, 'Sana\'a', 245, 'YE', '15.36944510', '44.19100660'),
        (1233, 'Ibb Governorate', 245, 'YE', '14.14157170', '44.24790150'),
        (1234, 'Ma\'rib Governorate', 245, 'YE', '15.51588800', '45.44980650'),
        (1235, 'Al Mahwit Governorate', 245, 'YE', '15.39632290', '43.56069460'),
        (1236, 'Sana\'a Governorate', 245, 'YE', '15.31689130', '44.47480180'),
        (1237, 'Abyan Governorate', 245, 'YE', '13.63434130', '46.05632120'),
        (1238, 'Hadhramaut Governorate', 245, 'YE', '16.93041350', '49.36531490'),
        (1239, 'Socotra Governorate', 245, 'YE', '12.46342050', '53.82373850'),
        (1240, 'Al Bayda\' Governorate', 245, 'YE', '14.35886620', '45.44980650'),
        (1241, 'Al Hudaydah Governorate', 245, 'YE', '15.30530720', '43.01948970'),
        (1242, '\'Adan Governorate', 245, 'YE', '12.82574810', '44.79438040'),
        (1243, 'Al Jawf Governorate', 245, 'YE', '16.79018190', '45.29938620'),
        (1244, 'Hajjah Governorate', 245, 'YE', '16.11806310', '43.32946600'),
        (1245, 'Lahij Governorate', 245, 'YE', '13.14895880', '44.85054950'),
        (1246, 'Dhamar Governorate', 245, 'YE', '14.71953440', '44.24790150'),
        (1247, 'Shabwah Governorate', 245, 'YE', '14.75463030', '46.51626200'),
        (1248, 'Raymah Governorate', 245, 'YE', '14.62776820', '43.71424840'),
        (1249, 'Saada Governorate', 245, 'YE', '16.84765280', '43.94367880'),
        (1250, '\'Amran Governorate', 245, 'YE', '16.25692140', '43.94367880'),
        (1251, 'Al Mahrah Governorate', 245, 'YE', '16.52384230', '51.68342750'),
        (1252, 'Sangha-Mbaéré', 42, 'CF', '3.43686070', '16.34637910'),
        (1253, 'Nana-Grébizi Economic Prefecture', 42, 'CF', '7.18486070', '19.37832060'),
        (1254, 'Ouham Prefecture', 42, 'CF', '7.09091100', '17.66888700'),
        (1255, 'Ombella-M\'Poko Prefecture', 42, 'CF', '5.11888250', '18.42760470'),
        (1256, 'Lobaye Prefecture', 42, 'CF', '4.35259810', '17.47951730'),
        (1257, 'Mambéré-Kadéï', 42, 'CF', '4.70556530', '15.96998780'),
        (1258, 'Haut-Mbomou Prefecture', 42, 'CF', '6.25371340', '25.47335540'),
        (1259, 'Bamingui-Bangoran Prefecture', 42, 'CF', '8.27334550', '20.71224650'),
        (1260, 'Nana-Mambéré Prefecture', 42, 'CF', '5.69321350', '15.21948080'),
        (1261, 'Vakaga Prefecture', 42, 'CF', '9.51132960', '22.23840170'),
        (1262, 'Bangui', 42, 'CF', '4.39467350', '18.55818990'),
        (1263, 'Kémo Prefecture', 42, 'CF', '5.88677940', '19.37832060'),
        (1264, 'Basse-Kotto Prefecture', 42, 'CF', '4.87193190', '21.28450250'),
        (1265, 'Ouaka Prefecture', 42, 'CF', '6.31682160', '20.71224650'),
        (1266, 'Mbomou Prefecture', 42, 'CF', '5.55683700', '23.76328280'),
        (1267, 'Ouham-Pendé Prefecture', 42, 'CF', '6.48509840', '16.15809370'),
        (1268, 'Haute-Kotto Prefecture', 42, 'CF', '7.79643790', '23.38235450'),
        (1269, 'Romblon', 174, 'PH', '12.57780160', '122.26914600'),
        (1270, 'Bukidnon', 174, 'PH', '8.05150540', '124.92299460'),
        (1271, 'Rizal', 174, 'PH', '14.60374460', '121.30840880'),
        (1272, 'Bohol', 174, 'PH', '9.84999110', '124.14354270'),
        (1273, 'Quirino', 174, 'PH', '16.27004240', '121.53700030'),
        (1274, 'Biliran', 174, 'PH', '11.58331520', '124.46418480'),
        (1275, 'Quezon', 174, 'PH', '14.03139060', '122.11309090'),
        (1276, 'Siquijor', 174, 'PH', '9.19987790', '123.59519250'),
        (1277, 'Sarangani', 174, 'PH', '5.92671750', '124.99475100'),
        (1278, 'Bulacan', 174, 'PH', '14.79427350', '120.87990080'),
        (1279, 'Cagayan', 174, 'PH', '18.24896290', '121.87878330'),
        (1280, 'South Cotabato', 174, 'PH', '6.33575650', '124.77407930'),
        (1281, 'Sorsogon', 174, 'PH', '12.99270950', '124.01474640'),
        (1282, 'Sultan Kudarat', 174, 'PH', '6.50694010', '124.41982430'),
        (1283, 'Camarines Norte', 174, 'PH', '14.13902650', '122.76330360'),
        (1284, 'Southern Leyte', 174, 'PH', '10.33462060', '125.17087410'),
        (1285, 'Camiguin', 174, 'PH', '9.17321640', '124.72987650'),
        (1286, 'Surigao del Norte', 174, 'PH', '9.51482800', '125.69699840'),
        (1287, 'Camarines Sur', 174, 'PH', '13.52501970', '123.34861470'),
        (1288, 'Sulu', 174, 'PH', '5.97490110', '121.03351000'),
        (1289, 'Davao Oriental', 174, 'PH', '7.31715850', '126.54198870'),
        (1290, 'Eastern Samar', 174, 'PH', '11.50007310', '125.49999080'),
        (1291, 'Dinagat Islands', 174, 'PH', '10.12818160', '125.60954740'),
        (1292, 'Capiz', 174, 'PH', '11.55288160', '122.74072300'),
        (1293, 'Tawi-Tawi', 174, 'PH', '5.13381100', '119.95092600'),
        (1294, 'Calabarzon', 174, 'PH', '14.10078030', '121.07937050'),
        (1295, 'Tarlac', 174, 'PH', '15.47547860', '120.59634920'),
        (1296, 'Surigao del Sur', 174, 'PH', '8.54049060', '126.11447580'),
        (1297, 'Zambales', 174, 'PH', '15.50817660', '119.96978080'),
        (1298, 'Ilocos Norte', 174, 'PH', '18.16472810', '120.71155920'),
        (1299, 'Mimaropa', 174, 'PH', '9.84320650', '118.73647830'),
        (1300, 'Ifugao', 174, 'PH', '16.83307920', '121.17103890'),
        (1301, 'Catanduanes', 174, 'PH', '13.70886840', '124.24215970'),
        (1302, 'Zamboanga del Norte', 174, 'PH', '8.38862820', '123.16888830'),
        (1303, 'Guimaras', 174, 'PH', '10.59286610', '122.63250810'),
        (1304, 'Bicol Region', 174, 'PH', '13.42098850', '123.41367360'),
        (1305, 'Western Visayas', 174, 'PH', '11.00498360', '122.53727410'),
        (1306, 'Cebu', 174, 'PH', '10.31569920', '123.88543660'),
        (1307, 'Cavite', 174, 'PH', '14.47912970', '120.89696340'),
        (1308, 'Central Visayas', 174, 'PH', '9.81687500', '124.06414190'),
        (1309, 'Davao Occidental', 174, 'PH', '6.09413960', '125.60954740'),
        (1310, 'Soccsksargen', 174, 'PH', '6.27069180', '124.68565090'),
        (1311, 'Compostela Valley', 174, 'PH', '7.51251500', '126.17626150'),
        (1312, 'Kalinga', 174, 'PH', '17.47404220', '121.35416310'),
        (1313, 'Isabela', 174, 'PH', '18.50077590', '-67.02434620'),
        (1314, 'Caraga', 174, 'PH', '8.80145620', '125.74068820'),
        (1315, 'Iloilo', 174, 'PH', '10.72015010', '122.56210630'),
        (1316, 'Autonomous Region in Muslim Mindanao', 174, 'PH', '6.95683130', '124.24215970'),
        (1317, 'La Union', 174, 'PH', '38.87668780', '-77.12809120'),
        (1318, 'Davao del Sur', 174, 'PH', '6.76626870', '125.32842690'),
        (1319, 'Davao del Norte', 174, 'PH', '7.56176990', '125.65328480'),
        (1320, 'Cotabato', 174, 'PH', '7.20466680', '124.23104390'),
        (1321, 'Ilocos Sur', 174, 'PH', '17.22786640', '120.57395790'),
        (1322, 'Eastern Visayas', 174, 'PH', '12.24455330', '125.03881640'),
        (1323, 'Agusan del Norte', 174, 'PH', '8.94562590', '125.53192340'),
        (1324, 'Abra', 174, 'PH', '42.49708300', '-96.38441000'),
        (1325, 'Zamboanga Peninsula', 174, 'PH', '8.15407700', '123.25879300'),
        (1326, 'Agusan del Sur', 174, 'PH', '8.04638880', '126.06153840'),
        (1327, 'Lanao del Norte', 174, 'PH', '7.87218110', '123.88577470'),
        (1328, 'Laguna', 174, 'PH', '33.54271890', '-117.78535680'),
        (1329, 'Marinduque', 174, 'PH', '13.47671710', '121.90321920'),
        (1330, 'Maguindanao', 174, 'PH', '6.94225810', '124.41982430'),
        (1331, 'Aklan', 174, 'PH', '11.81661090', '122.09415410'),
        (1332, 'Leyte', 174, 'PH', '10.86245360', '124.88111950'),
        (1333, 'Lanao del Sur', 174, 'PH', '7.82317600', '124.41982430'),
        (1334, 'Apayao', 174, 'PH', '18.01203040', '121.17103890'),
        (1335, 'Cordillera Administrative Region', 174, 'PH', '17.35125420', '121.17188510'),
        (1336, 'Antique', 174, 'PH', '37.03586950', '-95.63616940'),
        (1337, 'Albay', 174, 'PH', '13.17748270', '123.52800720'),
        (1338, 'Masbate', 174, 'PH', '12.35743460', '123.55040760'),
        (1339, 'Northern Mindanao', 174, 'PH', '8.02016350', '124.68565090'),
        (1340, 'Davao Region', 174, 'PH', '7.30416220', '126.08934060'),
        (1341, 'Aurora', 174, 'PH', '36.97089100', '-93.71797900'),
        (1342, 'Cagayan Valley', 174, 'PH', '16.97537580', '121.81070790'),
        (1343, 'Misamis Occidental', 174, 'PH', '8.33749030', '123.70706190'),
        (1344, 'Bataan', 174, 'PH', '14.64168420', '120.48184460'),
        (1345, 'Central Luzon', 174, 'PH', '15.48277220', '120.71200230'),
        (1346, 'Basilan', 174, 'PH', '6.42963490', '121.98701650'),
        (1347, 'Metro Manila', 174, 'PH', '14.60905370', '121.02225650'),
        (1348, 'Misamis Oriental', 174, 'PH', '8.50455580', '124.62195920'),
        (1349, 'Northern Samar', 174, 'PH', '12.36131990', '124.77407930'),
        (1350, 'Negros Oriental', 174, 'PH', '9.62820830', '122.98883190'),
        (1351, 'Negros Occidental', 174, 'PH', '10.29256090', '123.02465180'),
        (1352, 'Batanes', 174, 'PH', '20.44850740', '121.97081290'),
        (1353, 'Mountain Province', 174, 'PH', '40.70754370', '-73.95010330'),
        (1354, 'Oriental Mindoro', 174, 'PH', '13.05645980', '121.40694170'),
        (1355, 'Ilocos Region', 174, 'PH', '16.08321440', '120.61998950'),
        (1356, 'Occidental Mindoro', 174, 'PH', '13.10241110', '120.76512840'),
        (1357, 'Zamboanga del Sur', 174, 'PH', '7.83830540', '123.29666570'),
        (1358, 'Nueva Vizcaya', 174, 'PH', '16.33011070', '121.17103890'),
        (1359, 'Batangas', 174, 'PH', '13.75646510', '121.05830760'),
        (1360, 'Nueva Ecija', 174, 'PH', '15.57837500', '121.11126150'),
        (1361, 'Palawan', 174, 'PH', '9.83494930', '118.73836150'),
        (1362, 'Zamboanga Sibugay', 174, 'PH', '7.52252470', '122.31075170'),
        (1363, 'Benguet', 174, 'PH', '16.55772570', '120.80394740'),
        (1364, 'Pangasinan', 174, 'PH', '15.89490550', '120.28631830'),
        (1365, 'Pampanga', 174, 'PH', '15.07940900', '120.61998950'),
        (1366, 'Northern District', 106, 'IL', '36.15118640', '-95.99517630'),
        (1367, 'Central District', 106, 'IL', '47.60875830', '-122.29642350'),
        (1368, 'Southern District', 106, 'IL', '40.71375860', '-74.00090590'),
        (1369, 'Haifa District', 106, 'IL', '32.48141110', '34.99475100'),
        (1370, 'Jerusalem District', 106, 'IL', '31.76482430', '34.99475100'),
        (1371, 'Tel Aviv District', 106, 'IL', '32.09290750', '34.80721650'),
        (1372, 'Limburg', 22, 'BE', NULL, NULL),
        (1373, 'Flanders', 22, 'BE', '51.01087060', '3.72646130'),
        (1374, 'Flemish Brabant', 22, 'BE', '50.88154340', '4.56459700'),
        (1375, 'Hainaut', 22, 'BE', '50.52570760', '4.06210170'),
        (1376, 'Brussels-Capital Region', 22, 'BE', '50.85034630', '4.35172110'),
        (1377, 'East Flanders', 22, 'BE', '51.03621010', '3.73731240'),
        (1378, 'Namur', 22, 'BE', '50.46738830', '4.87198540'),
        (1379, 'Luxembourg', 22, 'BE', '49.81527300', '6.12958300'),
        (1380, 'Wallonia', 22, 'BE', '50.41756370', '4.45100660'),
        (1381, 'Antwerp', 22, 'BE', '51.21944750', '4.40246430'),
        (1382, 'Walloon Brabant', 22, 'BE', '50.63324100', '4.52431500'),
        (1383, 'West Flanders', 22, 'BE', '40.01793340', '-105.28067330'),
        (1384, 'Liège', 22, 'BE', '50.63255740', '5.57966620'),
        (1385, 'Darién Province', 170, 'PA', '7.86817130', '-77.83672820'),
        (1386, 'Colón Province', 170, 'PA', '9.18519890', '-80.05349230'),
        (1387, 'Coclé Province', 170, 'PA', '8.62660680', '-80.36586500'),
        (1388, 'Guna Yala', 170, 'PA', '9.23443950', '-78.19262500'),
        (1389, 'Herrera Province', 170, 'PA', '7.77042820', '-80.72144170'),
        (1390, 'Los Santos Province', 170, 'PA', '7.59093020', '-80.36586500'),
        (1391, 'Ngöbe-Buglé Comarca', 170, 'PA', '8.65958330', '-81.77870210'),
        (1392, 'Veraguas Province', 170, 'PA', '8.12310330', '-81.07546570'),
        (1393, 'Bocas del Toro Province', 170, 'PA', '9.41655210', '-82.52077870'),
        (1394, 'Panamá Oeste Province', 170, 'PA', '9.11967510', '-79.29021330'),
        (1395, 'Panamá Province', 170, 'PA', '9.11967510', '-79.29021330'),
        (1396, 'Emberá-Wounaan Comarca', 170, 'PA', '8.37669830', '-77.65361250'),
        (1397, 'Chiriquí Province', 170, 'PA', '8.58489800', '-82.38857830'),
        (1398, 'Howland Island', 233, 'US', '0.81132190', '-176.61827360'),
        (1399, 'Delaware', 233, 'US', '38.91083250', '-75.52766990'),
        (1400, 'Alaska', 233, 'US', '64.20084130', '-149.49367330'),
        (1401, 'Maryland', 233, 'US', '39.04575490', '-76.64127120'),
        (1402, 'Baker Island', 233, 'US', '0.19362660', '-176.47690800'),
        (1403, 'Kingman Reef', 233, 'US', '6.38333300', '-162.41666700'),
        (1404, 'New Hampshire', 233, 'US', '43.19385160', '-71.57239530'),
        (1405, 'Wake Island', 233, 'US', '19.27961900', '166.64993480'),
        (1406, 'Kansas', 233, 'US', '39.01190200', '-98.48424650'),
        (1407, 'Texas', 233, 'US', '31.96859880', '-99.90181310'),
        (1408, 'Nebraska', 233, 'US', '41.49253740', '-99.90181310'),
        (1409, 'Vermont', 233, 'US', '44.55880280', '-72.57784150'),
        (1410, 'Jarvis Island', 233, 'US', '-0.37435030', '-159.99672060'),
        (1411, 'Hawaii', 233, 'US', '19.89676620', '-155.58278180'),
        (1412, 'Guam', 233, 'US', '13.44430400', '144.79373100'),
        (1413, 'United States Virgin Islands', 233, 'US', '18.33576500', '-64.89633500'),
        (1414, 'Utah', 233, 'US', '39.32098010', '-111.09373110'),
        (1415, 'Oregon', 233, 'US', '43.80413340', '-120.55420120'),
        (1416, 'California', 233, 'US', '36.77826100', '-119.41793240'),
        (1417, 'New Jersey', 233, 'US', '40.05832380', '-74.40566120'),
        (1418, 'North Dakota', 233, 'US', '47.55149260', '-101.00201190'),
        (1419, 'Kentucky', 233, 'US', '37.83933320', '-84.27001790'),
        (1420, 'Minnesota', 233, 'US', '46.72955300', '-94.68589980'),
        (1421, 'Oklahoma', 233, 'US', '35.46756020', '-97.51642760'),
        (1422, 'Pennsylvania', 233, 'US', '41.20332160', '-77.19452470'),
        (1423, 'New Mexico', 233, 'US', '34.51994020', '-105.87009010'),
        (1424, 'American Samoa', 233, 'US', '-14.27097200', '-170.13221700'),
        (1425, 'Illinois', 233, 'US', '40.63312490', '-89.39852830'),
        (1426, 'Michigan', 233, 'US', '44.31484430', '-85.60236430'),
        (1427, 'Virginia', 233, 'US', '37.43157340', '-78.65689420'),
        (1428, 'Johnston Atoll', 233, 'US', '16.72950350', '-169.53364770'),
        (1429, 'West Virginia', 233, 'US', '38.59762620', '-80.45490260'),
        (1430, 'Mississippi', 233, 'US', '32.35466790', '-89.39852830'),
        (1431, 'Northern Mariana Islands', 233, 'US', '15.09790000', '145.67390000'),
        (1432, 'United States Minor Outlying Islands', 233, 'US', '19.28231920', '166.64704700'),
        (1433, 'Massachusetts', 233, 'US', '42.40721070', '-71.38243740'),
        (1434, 'Arizona', 233, 'US', '34.04892810', '-111.09373110'),
        (1435, 'Connecticut', 233, 'US', '41.60322070', '-73.08774900'),
        (1436, 'Florida', 233, 'US', '27.66482740', '-81.51575350'),
        (1437, 'District of Columbia', 233, 'US', '38.90719230', '-77.03687070'),
        (1438, 'Midway Atoll', 233, 'US', '28.20721680', '-177.37349260'),
        (1439, 'Navassa Island', 233, 'US', '18.41006890', '-75.01146120'),
        (1440, 'Indiana', 233, 'US', '40.26719410', '-86.13490190'),
        (1441, 'Wisconsin', 233, 'US', '43.78443970', '-88.78786780'),
        (1442, 'Wyoming', 233, 'US', '43.07596780', '-107.29028390'),
        (1443, 'South Carolina', 233, 'US', '33.83608100', '-81.16372450'),
        (1444, 'Arkansas', 233, 'US', '35.20105000', '-91.83183340'),
        (1445, 'South Dakota', 233, 'US', '43.96951480', '-99.90181310'),
        (1446, 'Montana', 233, 'US', '46.87968220', '-110.36256580'),
        (1447, 'North Carolina', 233, 'US', '35.75957310', '-79.01929970'),
        (1448, 'Palmyra Atoll', 233, 'US', '5.88850260', '-162.07866560'),
        (1449, 'Puerto Rico', 233, 'US', '18.22083300', '-66.59014900'),
        (1450, 'Colorado', 233, 'US', '39.55005070', '-105.78206740'),
        (1451, 'Missouri', 233, 'US', '37.96425290', '-91.83183340'),
        (1452, 'New York', 233, 'US', '40.71277530', '-74.00597280'),
        (1453, 'Maine', 233, 'US', '45.25378300', '-69.44546890'),
        (1454, 'Tennessee', 233, 'US', '35.51749130', '-86.58044730'),
        (1455, 'Georgia', 233, 'US', '32.16562210', '-82.90007510'),
        (1456, 'Alabama', 233, 'US', '32.31823140', '-86.90229800'),
        (1457, 'Louisiana', 233, 'US', '30.98429770', '-91.96233270'),
        (1458, 'Nevada', 233, 'US', '38.80260970', '-116.41938900'),
        (1459, 'Iowa', 233, 'US', '41.87800250', '-93.09770200'),
        (1460, 'Idaho', 233, 'US', '44.06820190', '-114.74204080'),
        (1461, 'Rhode Island', 233, 'US', '41.58009450', '-71.47742910'),
        (1462, 'Washington', 233, 'US', '47.75107410', '-120.74013850'),
        (1463, 'Shinyanga', 218, 'TZ', '-3.68099610', '33.42714030'),
        (1464, 'Simiyu', 218, 'TZ', '-2.83087380', '34.15319470'),
        (1465, 'Kagera', 218, 'TZ', '-1.30011150', '31.26263660'),
        (1466, 'Dodoma', 218, 'TZ', '-6.57382280', '36.26308460'),
        (1467, 'Kilimanjaro', 218, 'TZ', '-4.13369270', '37.80876930'),
        (1468, 'Mara', 218, 'TZ', '-1.77535380', '34.15319470'),
        (1469, 'Tabora', 218, 'TZ', '-5.03421380', '32.80844960'),
        (1470, 'Morogoro', 218, 'TZ', '-8.81371730', '36.95410700'),
        (1471, 'Zanzibar South', 218, 'TZ', '-6.26428510', '39.44502810'),
        (1472, 'Pemba South', 218, 'TZ', '-5.31469610', '39.75495110'),
        (1473, 'Zanzibar North', 218, 'TZ', '-5.93950930', '39.27910110'),
        (1474, 'Singida', 218, 'TZ', '-6.74533520', '34.15319470'),
        (1475, 'Zanzibar West', 218, 'TZ', '-6.22981360', '39.25832930'),
        (1476, 'Mtwara', 218, 'TZ', '-10.33984550', '40.16574660'),
        (1477, 'Rukwa', 218, 'TZ', '-8.01094440', '31.44561790'),
        (1478, 'Kigoma', 218, 'TZ', '-4.88240920', '29.66150550'),
        (1479, 'Mwanza', 218, 'TZ', '-2.46711970', '32.89868120'),
        (1480, 'Njombe', 218, 'TZ', '-9.24226320', '35.12687810'),
        (1481, 'Geita', 218, 'TZ', '-2.82422570', '32.26538870'),
        (1482, 'Katavi', 218, 'TZ', '-6.36771250', '31.26263660'),
        (1483, 'Lindi', 218, 'TZ', '-9.23433940', '38.31657250'),
        (1484, 'Manyara', 218, 'TZ', '-4.31500580', '36.95410700'),
        (1485, 'Pwani', 218, 'TZ', '-7.32377140', '38.82054540'),
        (1486, 'Ruvuma', 218, 'TZ', '-10.68787170', '36.26308460'),
        (1487, 'Tanga', 218, 'TZ', '-5.30497890', '38.31657250'),
        (1488, 'Pemba North', 218, 'TZ', '-5.03193520', '39.77555710'),
        (1489, 'Iringa', 218, 'TZ', '-7.78874420', '35.56578620'),
        (1490, 'Dar es Salaam', 218, 'TZ', '-6.79235400', '39.20832840'),
        (1491, 'Arusha', 218, 'TZ', '-3.38692540', '36.68299270'),
        (1492, 'Eastern Finland Province', 74, 'FI', '62.56338910', '28.50240420'),
        (1493, 'Tavastia Proper', 74, 'FI', '60.90701500', '24.30054980'),
        (1494, 'Central Ostrobothnia', 74, 'FI', '63.56217350', '24.00136310'),
        (1495, 'Southern Savonia', 74, 'FI', '61.69451480', '27.80050150'),
        (1496, 'Kainuu', 74, 'FI', '64.37365640', '28.74374750'),
        (1497, 'South Karelia', 74, 'FI', '61.11819490', '28.10243720'),
        (1498, 'Southern Ostrobothnia', 74, 'FI', '62.94330990', '23.52852670'),
        (1499, 'Oulu Province', 74, 'FI', '65.01207480', '25.46504960'),
        (1500, 'Lapland', 74, 'FI', '67.92223040', '26.50464380'),
        (1501, 'Satakunta', 74, 'FI', '61.59327580', '22.14830810'),
        (1502, 'Päijänne Tavastia', 74, 'FI', '61.32300410', '25.73224960'),
        (1503, 'Northern Savonia', 74, 'FI', '63.08448000', '27.02535040'),
        (1504, 'North Karelia', 74, 'FI', '62.80620780', '30.15538870'),
        (1505, 'Northern Ostrobothnia', 74, 'FI', '65.27949300', '26.28904170'),
        (1506, 'Pirkanmaa', 74, 'FI', '61.69869180', '23.78955980'),
        (1507, 'Finland Proper', 74, 'FI', '60.36279140', '22.44393690'),
        (1508, 'Ostrobothnia', 74, 'FI', '63.11817570', '21.90610620'),
        (1509, 'Åland Islands', 74, 'FI', '60.17852470', '19.91561050'),
        (1510, 'Uusimaa', 74, 'FI', '60.21872000', '25.27162100'),
        (1511, 'Central Finland', 74, 'FI', '62.56667430', '25.55494450'),
        (1512, 'Kymenlaakso', 74, 'FI', '60.78051200', '26.88293360'),
        (1513, 'Canton of Diekirch', 127, 'LU', '49.86717840', '6.15956330'),
        (1514, 'Luxembourg District', 127, 'LU', '49.59537060', '6.13331780'),
        (1515, 'Canton of Echternach', 127, 'LU', '49.81141330', '6.41756350'),
        (1516, 'Canton of Redange', 127, 'LU', '49.76455000', '5.88948000'),
        (1517, 'Canton of Esch-sur-Alzette', 127, 'LU', '49.50088050', '5.98609250'),
        (1518, 'Canton of Capellen', 127, 'LU', '49.64039310', '5.95538460'),
        (1519, 'Canton of Remich', 127, 'LU', '49.54501700', '6.36742220'),
        (1520, 'Grevenmacher District', 127, 'LU', '49.68085100', '6.44075240'),
        (1521, 'Canton of Clervaux', 127, 'LU', '50.05463130', '6.02858750'),
        (1522, 'Canton of Mersch', 127, 'LU', '49.75429060', '6.12921850'),
        (1523, 'Canton of Vianden', 127, 'LU', '49.93419240', '6.20199170'),
        (1524, 'Diekirch District', 127, 'LU', '49.86717200', '6.15963620'),
        (1525, 'Canton of Grevenmacher', 127, 'LU', '49.68084100', '6.44075930'),
        (1526, 'Canton of Wiltz', 127, 'LU', '49.96622000', '5.93243060'),
        (1527, 'Canton of Luxembourg', 127, 'LU', '49.63010250', '6.15201850'),
        (1528, 'Region Zealand', 59, 'DK', '55.46325180', '11.72149790'),
        (1529, 'Region of Southern Denmark', 59, 'DK', '55.33077140', '9.09249030'),
        (1530, 'Capital Region of Denmark', 59, 'DK', '55.67518120', '12.54932610'),
        (1531, 'Central Denmark Region', 59, 'DK', '56.30213900', '9.30277700'),
        (1532, 'North Denmark Region', 59, 'DK', '56.83074160', '9.49305270'),
        (1533, 'Gävleborg County', 213, 'SE', '61.30119930', '16.15342140'),
        (1534, 'Dalarna County', 213, 'SE', '61.09170120', '14.66636530'),
        (1535, 'Värmland County', 213, 'SE', '59.72940650', '13.23540240'),
        (1536, 'Östergötland County', 213, 'SE', '58.34536350', '15.51978440'),
        (1537, 'Blekinge', 213, 'SE', '56.27838370', '15.01800580'),
        (1538, 'Norrbotten County', 213, 'SE', '66.83092160', '20.39919660'),
        (1539, 'Örebro County', 213, 'SE', '59.53503600', '15.00657310'),
        (1540, 'Södermanland County', 213, 'SE', '59.03363490', '16.75188990'),
        (1541, 'Skåne County', 213, 'SE', '55.99025720', '13.59576920'),
        (1542, 'Kronoberg County', 213, 'SE', '56.71834030', '14.41146730'),
        (1543, 'Västerbotten County', 213, 'SE', '65.33373110', '16.51616940'),
        (1544, 'Kalmar County', 213, 'SE', '57.23501560', '16.18493490'),
        (1545, 'Uppsala County', 213, 'SE', '60.00922620', '17.27145880'),
        (1546, 'Gotland County', 213, 'SE', '57.46841210', '18.48674470'),
        (1547, 'Västra Götaland County', 213, 'SE', '58.25279260', '13.05964250'),
        (1548, 'Halland County', 213, 'SE', '56.89668050', '12.80339930'),
        (1549, 'Västmanland County', 213, 'SE', '59.67138790', '16.21589530'),
        (1550, 'Jönköping County', 213, 'SE', '57.37084340', '14.34391740'),
        (1551, 'Stockholm County', 213, 'SE', '59.60249580', '18.13843830'),
        (1552, 'Västernorrland County', 213, 'SE', '63.42764730', '17.72924440'),
        (1553, 'Plungė District Municipality', 126, 'LT', '55.91078400', '21.84540690'),
        (1554, 'Šiauliai District Municipality', 126, 'LT', '55.97214560', '23.03323710'),
        (1555, 'Jurbarkas District Municipality', 126, 'LT', '55.07740700', '22.74195690'),
        (1556, 'Kaunas County', 126, 'LT', '54.98728630', '23.95257360'),
        (1557, 'Mažeikiai District Municipality', 126, 'LT', '56.30924390', '22.34146800'),
        (1558, 'Panevėžys County', 126, 'LT', '55.97480490', '25.07947670'),
        (1559, 'Elektrėnai municipality', 126, 'LT', '54.76539340', '24.77405830'),
        (1560, 'Švenčionys District Municipality', 126, 'LT', '55.10280980', '26.00718550'),
        (1561, 'Akmenė District Municipality', 126, 'LT', '56.24550290', '22.74711690'),
        (1562, 'Ignalina District Municipality', 126, 'LT', '55.40903420', '26.32848930'),
        (1563, 'Neringa Municipality', 126, 'LT', '55.45724030', '21.08390050'),
        (1564, 'Visaginas Municipality', 126, 'LT', '55.59411800', '26.43079540'),
        (1565, 'Kaunas District Municipality', 126, 'LT', '54.99362360', '23.63249410'),
        (1566, 'Biržai District Municipality', 126, 'LT', '56.20177190', '24.75601180'),
        (1567, 'Jonava District Municipality', 126, 'LT', '55.07272420', '24.27933370'),
        (1568, 'Radviliškis District Municipality', 126, 'LT', '55.81083990', '23.54648700'),
        (1569, 'Telšiai County', 126, 'LT', '56.10266160', '22.11139150'),
        (1570, 'Marijampolė County', 126, 'LT', '54.78199710', '23.13413650'),
        (1571, 'Kretinga District Municipality', 126, 'LT', '55.88384200', '21.23509190'),
        (1572, 'Tauragė District Municipality', 126, 'LT', '55.25036600', '22.29095000'),
        (1573, 'Tauragė County', 126, 'LT', '55.30725860', '22.35729390'),
        (1574, 'Alytus County', 126, 'LT', '54.20002140', '24.15126340'),
        (1575, 'Kazlų Rūda municipality', 126, 'LT', '54.78075260', '23.48402430'),
        (1576, 'Šakiai District Municipality', 126, 'LT', '54.95267100', '23.04801990'),
        (1577, 'Šalčininkai District Municipality', 126, 'LT', '54.30976700', '25.38756400'),
        (1578, 'Prienai District Municipality', 126, 'LT', '54.63835800', '23.94680090'),
        (1579, 'Druskininkai municipality', 126, 'LT', '53.99336850', '24.03424380'),
        (1580, 'Kaunas City Municipality', 126, 'LT', '54.91453260', '23.90535180'),
        (1581, 'Joniškis District Municipality', 126, 'LT', '56.23607300', '23.61365790'),
        (1582, 'Molėtai District Municipality', 126, 'LT', '55.22653090', '25.41800110'),
        (1583, 'Kaišiadorys District Municipality', 126, 'LT', '54.85886690', '24.42779290'),
        (1584, 'Kėdainiai District Municipality', 126, 'LT', '55.35609470', '23.98326830'),
        (1585, 'Kupiškis District Municipality', 126, 'LT', '55.84287410', '25.02958160'),
        (1586, 'Šiauliai County', 126, 'LT', '55.99857510', '23.13800510'),
        (1587, 'Raseiniai District Municipality', 126, 'LT', '55.38194990', '23.11561290'),
        (1588, 'Palanga City Municipality', 126, 'LT', '55.92019800', '21.06776140'),
        (1589, 'Panevėžys City Municipality', 126, 'LT', '55.73479150', '24.35747740'),
        (1590, 'Rietavas municipality', 126, 'LT', '55.70217190', '21.99865640'),
        (1591, 'Kalvarija municipality', 126, 'LT', '54.37616740', '23.19203210'),
        (1592, 'Vilnius District Municipality', 126, 'LT', '54.77325780', '25.58671130'),
        (1593, 'Trakai District Municipality', 126, 'LT', '54.63791130', '24.93468940'),
        (1594, 'Širvintos District Municipality', 126, 'LT', '55.04310200', '24.95698100'),
        (1595, 'Pakruojis District Municipality', 126, 'LT', '56.07326050', '23.93899060'),
        (1596, 'Ukmergė District Municipality', 126, 'LT', '55.24526500', '24.77607490'),
        (1597, 'Klaipeda City Municipality', 126, 'LT', '55.70329480', '21.14427950'),
        (1598, 'Utena District Municipality', 126, 'LT', '55.50846140', '25.68326420'),
        (1599, 'Alytus District Municipality', 126, 'LT', '54.32974960', '24.19609310'),
        (1600, 'Klaipėda County', 126, 'LT', '55.65197440', '21.37439560'),
        (1601, 'Vilnius County', 126, 'LT', '54.80865020', '25.21821390'),
        (1602, 'Varėna District Municipality', 126, 'LT', '54.22033300', '24.57899700'),
        (1603, 'Birštonas Municipality', 126, 'LT', '54.56696640', '24.00930980'),
        (1604, 'Klaipėda District Municipality', 126, 'LT', '55.68416150', '21.44164640'),
        (1605, 'Alytus City Municipality', 126, 'LT', '54.39629380', '24.04587610'),
        (1606, 'Vilnius City Municipality', 126, 'LT', '54.67107610', '25.28787210'),
        (1607, 'Šilutė District Municipality', 126, 'LT', '55.35041400', '21.46598590'),
        (1608, 'Telšiai District Municipality', 126, 'LT', '55.91752150', '22.34518400'),
        (1609, 'Šiauliai City Municipality', 126, 'LT', '55.93490850', '23.31368230'),
        (1610, 'Marijampolė Municipality', 126, 'LT', '54.57110940', '23.48593710'),
        (1611, 'Lazdijai District Municipality', 126, 'LT', '54.23432670', '23.51565050'),
        (1612, 'Pagėgiai municipality', 126, 'LT', '55.17213200', '21.96836140'),
        (1613, 'Šilalė District Municipality', 126, 'LT', '55.49268000', '22.18455590'),
        (1614, 'Panevėžys District Municipality', 126, 'LT', '55.61667280', '24.31422830'),
        (1615, 'Rokiškis District Municipality', 126, 'LT', '55.95550390', '25.58592490'),
        (1616, 'Pasvalys District Municipality', 126, 'LT', '56.06046190', '24.39629100'),
        (1617, 'Skuodas District Municipality', 126, 'LT', '56.27021690', '21.52143310'),
        (1618, 'Kelmė District Municipality', 126, 'LT', '55.62663520', '22.87817200'),
        (1619, 'Zarasai District Municipality', 126, 'LT', '55.73096090', '26.24529500'),
        (1620, 'Vilkaviškis District Municipality', 126, 'LT', '54.65194500', '23.03515500'),
        (1621, 'Utena County', 126, 'LT', '55.53189690', '25.79046990'),
        (1622, 'Opole Voivodeship', 176, 'PL', '50.80037610', '17.93798900'),
        (1623, 'Silesian Voivodeship', 176, 'PL', '50.57165950', '19.32197680'),
        (1624, 'Pomeranian Voivodeship', 176, 'PL', '54.29442520', '18.15311640'),
        (1625, 'Kuyavian-Pomeranian Voivodeship', 176, 'PL', '53.16483630', '18.48342240'),
        (1626, 'Podkarpackie Voivodeship', 176, 'PL', '50.05747490', '22.08956910'),
        (1628, 'Warmian-Masurian Voivodeship', 176, 'PL', '53.86711170', '20.70278610'),
        (1629, 'Lower Silesian Voivodeship', 176, 'PL', '51.13398610', '16.88419610'),
        (1630, 'Świętokrzyskie Voivodeship', 176, 'PL', '50.62610410', '20.94062790'),
        (1631, 'Lubusz Voivodeship', 176, 'PL', '52.22746120', '15.25591030'),
        (1632, 'Podlaskie Voivodeship', 176, 'PL', '53.06971590', '22.96746390'),
        (1633, 'West Pomeranian Voivodeship', 176, 'PL', '53.46578910', '15.18225810'),
        (1634, 'Greater Poland Voivodeship', 176, 'PL', '52.27998600', '17.35229390'),
        (1635, 'Lesser Poland Voivodeship', 176, 'PL', '49.72253060', '20.25033580'),
        (1636, 'Łódź Voivodeship', 176, 'PL', '51.46347710', '19.17269740'),
        (1637, 'Masovian Voivodeship', 176, 'PL', '51.89271820', '21.00216790'),
        (1638, 'Lublin Voivodeship', 176, 'PL', '51.24935190', '23.10113920'),
        (1639, 'Aargau', 214, 'CH', '47.38766640', '8.25542950'),
        (1640, 'Canton of Fribourg', 214, 'CH', '46.68167480', '7.11726350'),
        (1641, 'Basel-Landschaft', 214, 'CH', '47.44181220', '7.76440020'),
        (1642, 'Uri', 214, 'CH', '41.48606470', '-71.53085370'),
        (1643, 'Ticino', 214, 'CH', '46.33173400', '8.80045290'),
        (1644, 'Canton of St. Gallen', 214, 'CH', '47.14562540', '9.35043320'),
        (1645, 'canton of Bern', 214, 'CH', '46.79886210', '7.70807010'),
        (1646, 'Canton of Zug', 214, 'CH', '47.16615050', '8.51547490'),
        (1647, 'Canton of Geneva', 214, 'CH', '46.21800730', '6.12169250'),
        (1648, 'Canton of Valais', 214, 'CH', '46.19046140', '7.54492260'),
        (1649, 'Appenzell Innerrhoden', 214, 'CH', '47.31619250', '9.43165730'),
        (1650, 'Obwalden', 214, 'CH', '46.87785800', '8.25124900'),
        (1651, 'Canton of Vaud', 214, 'CH', '46.56131350', '6.53676500'),
        (1652, 'Nidwalden', 214, 'CH', '46.92670160', '8.38499820'),
        (1653, 'Schwyz', 214, 'CH', '47.02071380', '8.65298840'),
        (1654, 'Canton of Schaffhausen', 214, 'CH', '47.70093640', '8.56800400'),
        (1655, 'Appenzell Ausserrhoden', 214, 'CH', '47.36648100', '9.30009160'),
        (1656, 'canton of Zürich', 214, 'CH', '47.35953600', '8.63564520'),
        (1657, 'Thurgau', 214, 'CH', '47.60378560', '9.05573710'),
        (1658, 'Canton of Jura', 214, 'CH', '47.34444740', '7.14306080'),
        (1659, 'Canton of Neuchâtel', 214, 'CH', '46.98998740', '6.92927320'),
        (1660, 'Graubünden', 214, 'CH', '46.65698710', '9.57802570'),
        (1661, 'Glarus', 214, 'CH', '47.04112320', '9.06790000'),
        (1662, 'Canton of Solothurn', 214, 'CH', '47.33207170', '7.63883850'),
        (1663, 'Canton of Lucerne', 214, 'CH', '47.07956710', '8.16624450'),
        (1664, 'Tuscany', 107, 'IT', '43.77105130', '11.24862080'),
        (1665, 'Province of Padua', 107, 'IT', '45.36618640', '11.82091390'),
        (1666, 'Province of Parma', 107, 'IT', '44.80153220', '10.32793540'),
        (1667, 'Libero consorzio comunale di Siracusa', 107, 'IT', '37.06569240', '15.28571090'),
        (1668, 'Metropolitan City of Palermo', 107, 'IT', '38.11569000', '13.36148680'),
        (1669, 'Campania', 107, 'IT', '40.66708870', '15.10681130'),
        (1670, 'Marche', 107, 'IT', '30.55670700', '-81.44930300'),
        (1671, 'Metropolitan City of Reggio Calabria', 107, 'IT', '38.10843960', '15.64370480'),
        (1672, 'Province of Ancona', 107, 'IT', '43.54932450', '13.26634790'),
        (1673, 'Metropolitan City of Venice', 107, 'IT', '45.44146850', '12.31526720'),
        (1674, 'Province of Latina', 107, 'IT', '41.40874760', '13.08179030'),
        (1675, 'Province of Lecce', 107, 'IT', '40.23473930', '18.14286690'),
        (1676, 'Province of Pavia', 107, 'IT', '45.32181660', '8.84662360'),
        (1677, 'Province of Lecco', 107, 'IT', '45.93829410', '9.38572900'),
        (1678, 'Lazio', 107, 'IT', '45.69916670', '-73.65583330'),
        (1679, 'Abruzzo', 107, 'IT', '42.19201190', '13.72891670'),
        (1680, 'Metropolitan City of Florence', 107, 'IT', '43.76791780', '11.25237920'),
        (1681, 'Province of Ascoli Piceno', 107, 'IT', '42.86389330', '13.58997330'),
        (1682, 'Metropolitan City of Cagliari', 107, 'IT', '39.22384110', '9.12166130'),
        (1683, 'Umbria', 107, 'IT', '42.93800400', '12.62162110'),
        (1684, 'Metropolitan City of Bologna', 107, 'IT', '44.49488700', '11.34261620'),
        (1685, 'Province of Pisa', 107, 'IT', '43.72283150', '10.40171940'),
        (1686, 'Province of Barletta-Andria-Trani', 107, 'IT', '41.20045430', '16.20514840'),
        (1687, 'Province of Pistoia', 107, 'IT', '43.95437330', '10.89030990'),
        (1688, 'Apulia', 107, 'IT', '40.79283930', '17.10119310'),
        (1689, 'Province of Belluno', 107, 'IT', '46.24976590', '12.19695650'),
        (1690, 'Province of Pordenone', 107, 'IT', '46.03788620', '12.71083500'),
        (1691, 'Province of Perugia', 107, 'IT', '42.93800400', '12.62162110'),
        (1692, 'Province of Avellino', 107, 'IT', '40.99645100', '15.12589550'),
        (1693, 'Pesaro and Urbino Province', 107, 'IT', '43.61301180', '12.71351210'),
        (1694, 'Province of Pescara', 107, 'IT', '42.35706550', '13.96080910'),
        (1695, 'Molise', 107, 'IT', '41.67388650', '14.75209390'),
        (1696, 'Province of Piacenza', 107, 'IT', '44.82631120', '9.52914470'),
        (1697, 'Province of Potenza', 107, 'IT', '40.41821940', '15.87600400'),
        (1698, 'Metropolitan City of Milan', 107, 'IT', '45.45862600', '9.18187300'),
        (1699, 'Metropolitan City of Genoa', 107, 'IT', '44.40564930', '8.94625640'),
        (1700, 'Province of Prato', 107, 'IT', '44.04539000', '11.11644520'),
        (1701, 'Benevento Province', 107, 'IT', '41.20350930', '14.75209390'),
        (1702, 'Piedmont', 107, 'IT', '45.05223660', '7.51538850'),
        (1703, 'Calabria', 107, 'IT', '39.30877140', '16.34637910'),
        (1704, 'Province of Bergamo', 107, 'IT', '45.69826420', '9.67726980'),
        (1705, 'Lombardy', 107, 'IT', '45.47906710', '9.84524330'),
        (1706, 'Basilicata', 107, 'IT', '40.64307660', '15.96998780'),
        (1707, 'Province of Ravenna', 107, 'IT', '44.41844430', '12.20359980'),
        (1708, 'Province of Reggio Emilia', 107, 'IT', '44.58565800', '10.55647360'),
        (1709, 'Sicily', 107, 'IT', '37.59999380', '14.01535570'),
        (1710, 'Metropolitan City of Turin', 107, 'IT', '45.06329900', '7.66928900'),
        (1711, 'Metropolitan City of Rome', 107, 'IT', '41.90270080', '12.49623520'),
        (1712, 'Province of Rieti', 107, 'IT', '42.36744050', '12.89750980'),
        (1713, 'Province of Rimini', 107, 'IT', '44.06782880', '12.56951580'),
        (1714, 'Province of Brindisi', 107, 'IT', '40.61126630', '17.76362100'),
        (1715, 'Sardinia', 107, 'IT', '40.12087520', '9.01289260'),
        (1716, 'Aosta Valley', 107, 'IT', '45.73888780', '7.42618660'),
        (1717, 'Province of Brescia', 107, 'IT', '45.54155260', '10.21180190'),
        (1718, 'Libero consorzio comunale di Caltanissetta', 107, 'IT', '37.48601300', '14.06149820'),
        (1719, 'Province of Rovigo', 107, 'IT', '45.02418180', '11.82381620'),
        (1720, 'Province of Salerno', 107, 'IT', '40.42878320', '15.21948080'),
        (1721, 'Province of Campobasso', 107, 'IT', '41.67388650', '14.75209390'),
        (1722, 'Province of Sassari', 107, 'IT', '40.79679070', '8.57504070'),
        (1723, 'Libero consorzio comunale di Enna', 107, 'IT', '37.56762160', '14.27953490'),
        (1724, 'Metropolitan City of Naples', 107, 'IT', '40.90197500', '14.33264400'),
        (1725, 'Trentino-South Tyrol', 107, 'IT', '46.43366620', '11.16932960'),
        (1726, 'Province of Verbano-Cusio-Ossola', 107, 'IT', '46.13996880', '8.27246490'),
        (1727, 'Libero consorzio comunale di Agrigento', 107, 'IT', '37.31052020', '13.58579780'),
        (1728, 'Province of Catanzaro', 107, 'IT', '38.88963480', '16.44058720'),
        (1729, 'Libero consorzio comunale di Ragusa', 107, 'IT', '36.92692730', '14.72551290'),
        (1730, 'Province of Carbonia-Iglesias', 107, 'IT', '39.25346590', '8.57210160'),
        (1731, 'Province of Caserta', 107, 'IT', '41.20783540', '14.10013260'),
        (1732, 'Province of Savona', 107, 'IT', '44.28879950', '8.26505800'),
        (1733, 'Libero consorzio comunale di Trapani', 107, 'IT', '38.01831160', '12.51482650'),
        (1734, 'Province of Siena', 107, 'IT', '43.29377320', '11.43391480'),
        (1735, 'Province of Viterbo', 107, 'IT', '42.40024200', '11.88917210'),
        (1736, 'Province of Verona', 107, 'IT', '45.44184980', '11.07353160'),
        (1737, 'Province of Vibo Valentia', 107, 'IT', '38.63785650', '16.20514840'),
        (1738, 'Province of Vicenza', 107, 'IT', '45.69839950', '11.56614650'),
        (1739, 'Province of Chieti', 107, 'IT', '42.03344280', '14.37919120'),
        (1740, 'Province of Como', 107, 'IT', '45.80804160', '9.08517930'),
        (1741, 'Province of Sondrio', 107, 'IT', '46.17276360', '9.79949170'),
        (1742, 'Province of Cosenza', 107, 'IT', '39.56441050', '16.25221430'),
        (1743, 'Province of Taranto', 107, 'IT', '40.57409010', '17.24299760'),
        (1744, 'Province of Fermo', 107, 'IT', '43.09313670', '13.58997330'),
        (1745, 'Province of Livorno', 107, 'IT', '43.02398480', '10.66471010'),
        (1746, 'Province of Ferrara', 107, 'IT', '44.76636800', '11.76440680'),
        (1747, 'Province of Lodi', 107, 'IT', '45.24050360', '9.52925120'),
        (1748, 'Trentino', 107, 'IT', '46.05120040', '11.11753920'),
        (1749, 'Province of Lucca', 107, 'IT', '43.83767360', '10.49505300'),
        (1750, 'Province of Macerata', 107, 'IT', '43.24593220', '13.26634790'),
        (1751, 'Province of Cremona', 107, 'IT', '45.20143750', '9.98365820'),
        (1752, 'Province of Teramo', 107, 'IT', '42.58956080', '13.63627150'),
        (1753, 'Veneto', 107, 'IT', '45.44146620', '12.31525950'),
        (1754, 'Province of Crotone', 107, 'IT', '39.13098560', '17.00670310'),
        (1755, 'Province of Terni', 107, 'IT', '42.56345340', '12.52980280'),
        (1756, 'Friuli–Venezia Giulia', 107, 'IT', '46.22591770', '13.10336460'),
        (1757, 'Province of Modena', 107, 'IT', '44.55137990', '10.91804800'),
        (1758, 'Province of Mantua', 107, 'IT', '45.16677280', '10.77536130'),
        (1759, 'Province of Massa and Carrara', 107, 'IT', '44.22139980', '10.03596610'),
        (1760, 'Province of Matera', 107, 'IT', '40.66634960', '16.60436360'),
        (1761, 'Province of Medio Campidano', 107, 'IT', '39.53173890', '8.70407500'),
        (1762, 'Province of Treviso', 107, 'IT', '45.66685170', '12.24306170'),
        (1763, 'Province of Trieste', 107, 'IT', '45.68948230', '13.78330720'),
        (1764, 'Province of Udine', 107, 'IT', '46.14079720', '13.16628960'),
        (1765, 'Province of Varese', 107, 'IT', '45.79902600', '8.73009450'),
        (1766, 'Metropolitan City of Catania', 107, 'IT', '37.45154380', '15.05574150'),
        (1767, 'South Tyrol', 107, 'IT', '46.49494500', '11.34026570'),
        (1768, 'Liguria', 107, 'IT', '44.31679170', '8.39649380'),
        (1769, 'Province of Monza and Brianza', 107, 'IT', '45.62359900', '9.25880150'),
        (1770, 'Metropolitan City of Messina', 107, 'IT', '38.19373350', '15.55420570'),
        (1771, 'Province of Foggia', 107, 'IT', '41.63844800', '15.59433880'),
        (1772, 'Metropolitan City of Bari', 107, 'IT', '41.11714320', '16.87187150'),
        (1773, 'Emilia-Romagna', 107, 'IT', '44.59676070', '11.21863960'),
        (1774, 'Province of Novara', 107, 'IT', '45.54851330', '8.51507930'),
        (1775, 'Province of Cuneo', 107, 'IT', '44.59703140', '7.61142170'),
        (1776, 'Province of Frosinone', 107, 'IT', '41.65765280', '13.63627150'),
        (1777, 'Province of Gorizia', 107, 'IT', '45.90538990', '13.51637250'),
        (1778, 'Province of Biella', 107, 'IT', '45.56281760', '8.05827170'),
        (1779, 'Province of Forlì-Cesena', 107, 'IT', '43.99476810', '11.98046130'),
        (1780, 'Province of Asti', 107, 'IT', '44.90076520', '8.20643150'),
        (1781, 'Province of L\'Aquila', 107, 'IT', '42.12563170', '13.63627150'),
        (1782, 'Province of Ogliastra', 107, 'IT', '39.84105360', '9.45615500'),
        (1783, 'Province of Alessandria', 107, 'IT', '44.81755870', '8.70466270'),
        (1784, 'Province of Olbia-Tempio', 107, 'IT', '40.82683830', '9.27855830'),
        (1785, 'Province of Vercelli', 107, 'IT', '45.32022040', '8.41850800'),
        (1786, 'Province of Oristano', 107, 'IT', '40.05990680', '8.74811670'),
        (1787, 'Province of Grosseto', 107, 'IT', '42.85180070', '11.25237920'),
        (1788, 'Province of Imperia', 107, 'IT', '43.94186600', '7.82863680'),
        (1789, 'Province of Isernia', 107, 'IT', '41.58915550', '14.19309180'),
        (1790, 'Province of Nuoro', 107, 'IT', '40.32869040', '9.45615500'),
        (1791, 'Province of La Spezia', 107, 'IT', '44.24479130', '9.76786870'),
        (1792, 'Sumatera Utara', 102, 'ID', '2.11535470', '99.54509740'),
        (1793, 'Bengkulu', 102, 'ID', '-3.79284510', '102.26076410'),
        (1794, 'Kalimantan Tengah', 102, 'ID', '-1.68148780', '113.38235450'),
        (1795, 'Sulawesi Selatan', 102, 'ID', '-3.66879940', '119.97405340'),
        (1796, 'Sulawesi Tenggara', 102, 'ID', '-4.14491000', '122.17460500'),
        (1798, 'Papua', 102, 'ID', '-5.01222020', '141.34701590'),
        (1799, 'Papua Barat', 102, 'ID', '-1.33611540', '133.17471620'),
        (1800, 'Maluku', 102, 'ID', '-3.23846160', '130.14527340'),
        (1801, 'Maluku Utara', 102, 'ID', '1.57099930', '127.80876930'),
        (1802, 'Jawa Tengah', 102, 'ID', '-7.15097500', '110.14025940'),
        (1804, 'Kalimantan Timur', 102, 'ID', '0.53865860', '116.41938900'),
        (1805, 'DKI Jakarta', 102, 'ID', '-6.20876340', '106.84559900'),
        (1806, 'Kalimantan Barat', 102, 'ID', '0.96188340', '114.55484950'),
        (1807, 'Kepulauan Riau', 102, 'ID', '3.94565140', '108.14286690'),
        (1808, 'Sulawesi Utara', 102, 'ID', '0.62469320', '123.97500180'),
        (1809, 'Riau', 102, 'ID', '0.29334690', '101.70682940'),
        (1810, 'Banten', 102, 'ID', '-6.40581720', '106.06401790'),
        (1811, 'Lampung', 102, 'ID', '-4.55858490', '105.40680790'),
        (1812, 'Gorontalo', 102, 'ID', '0.54354420', '123.05676930'),
        (1813, 'Sulawesi Tengah', 102, 'ID', '-1.43002540', '121.44561790'),
        (1814, 'Nusa Tenggara Barat', 102, 'ID', '-8.65293340', '117.36164760'),
        (1815, 'Jambi', 102, 'ID', '-1.61012290', '103.61312030'),
        (1816, 'Sumatera Selatan', 102, 'ID', '-3.31943740', '103.91439900'),
        (1817, 'Sulawesi Barat', 102, 'ID', '-2.84413710', '119.23207840'),
        (1818, 'Nusa Tenggara Timur', 102, 'ID', '-8.65738190', '121.07937050'),
        (1819, 'Kalimantan Selatan', 102, 'ID', '-3.09264150', '115.28375850'),
        (1820, 'Kepulauan Bangka Belitung', 102, 'ID', '-2.74105130', '106.44058720'),
        (1822, 'Aceh', 102, 'ID', '4.69513500', '96.74939930'),
        (1824, 'Kalimantan Utara', 102, 'ID', '3.07309290', '116.04138890'),
        (1825, 'Jawa Barat', 102, 'ID', '-7.09091100', '107.66888700'),
        (1826, 'Bali', 102, 'ID', '-8.34053890', '115.09195090'),
        (1827, 'Jawa Timur', 102, 'ID', '-7.53606390', '112.23840170'),
        (1828, 'Sumatera Barat', 102, 'ID', '-0.73993970', '100.80000510'),
        (1829, 'DI Yogyakarta', 102, 'ID', '-7.87538490', '110.42620880'),
        (1830, 'Phoenix Islands', 114, 'KI', '33.32843690', '-111.98247740'),
        (1831, 'Gilbert Islands', 114, 'KI', '0.35242620', '174.75526340'),
        (1832, 'Line Islands', 114, 'KI', '1.74294390', '-157.21328260'),
        (1833, 'Primorsky Krai', 182, 'RU', '45.05256410', '135.00000000'),
        (1834, 'Novgorod Oblast', 182, 'RU', '58.24275520', '32.56651900'),
        (1835, 'Jewish Autonomous Oblast', 182, 'RU', '48.48081470', '131.76573670'),
        (1836, 'Nenets Autonomous Okrug', 182, 'RU', '67.60783370', '57.63383310'),
        (1837, 'Rostov Oblast', 182, 'RU', '47.68532470', '41.82589520'),
        (1838, 'Khanty-Mansi Autonomous Okrug', 182, 'RU', '62.22870620', '70.64100570'),
        (1839, 'Magadan Oblast', 182, 'RU', '62.66434170', '153.91499100'),
        (1840, 'Krasnoyarsk Krai', 182, 'RU', '64.24797580', '95.11041760'),
        (1841, 'Republic of Karelia', 182, 'RU', '63.15587020', '32.99055520'),
        (1842, 'Republic of Buryatia', 182, 'RU', '54.83311460', '112.40605300'),
        (1843, 'Murmansk Oblast', 182, 'RU', '67.84426740', '35.08841020'),
        (1844, 'Kaluga Oblast', 182, 'RU', '54.38726660', '35.18890940'),
        (1845, 'Chelyabinsk Oblast', 182, 'RU', '54.43194220', '60.87889630'),
        (1846, 'Omsk Oblast', 182, 'RU', '55.05546690', '73.31673420'),
        (1847, 'Yamalo-Nenets Autonomous Okrug', 182, 'RU', '66.06530570', '76.93451930'),
        (1848, 'Sakha Republic', 182, 'RU', '66.76134510', '124.12375300'),
        (1849, 'Arkhangelsk', 182, 'RU', '64.54585490', '40.55057690'),
        (1850, 'Republic of Dagestan', 182, 'RU', '42.14318860', '47.09497990'),
        (1851, 'Yaroslavl Oblast', 182, 'RU', '57.89915230', '38.83886330'),
        (1852, 'Republic of Adygea', 182, 'RU', '44.82291550', '40.17544630'),
        (1853, 'Republic of North Ossetia-Alania', 182, 'RU', '43.04513020', '44.28709720'),
        (1854, 'Republic of Bashkortostan', 182, 'RU', '54.23121720', '56.16452570'),
        (1855, 'Kursk Oblast', 182, 'RU', '51.76340260', '35.38118120'),
        (1856, 'Ulyanovsk Oblast', 182, 'RU', '53.97933570', '47.77624250'),
        (1857, 'Nizhny Novgorod Oblast', 182, 'RU', '55.79951590', '44.02967690'),
        (1858, 'Amur Oblast', 182, 'RU', '54.60350650', '127.48017210'),
        (1859, 'Chukotka Autonomous Okrug', 182, 'RU', '65.62983550', '171.69521590'),
        (1860, 'Tver Oblast', 182, 'RU', '57.00216540', '33.98531420'),
        (1861, 'Republic of Tatarstan', 182, 'RU', '55.18023640', '50.72639450'),
        (1862, 'Samara Oblast', 182, 'RU', '53.41838390', '50.47255280'),
        (1863, 'Pskov Oblast', 182, 'RU', '56.77085990', '29.09400900'),
        (1864, 'Ivanovo Oblast', 182, 'RU', '57.10568540', '41.48300840'),
        (1865, 'Kamchatka Krai', 182, 'RU', '61.43439810', '166.78841310'),
        (1866, 'Astrakhan Oblast', 182, 'RU', '46.13211660', '48.06101150'),
        (1867, 'Bryansk Oblast', 182, 'RU', '53.04085990', '33.26909000'),
        (1868, 'Stavropol Krai', 182, 'RU', '44.66809930', '43.52021400'),
        (1869, 'Karachay-Cherkess Republic', 182, 'RU', '43.88451430', '41.73039390'),
        (1870, 'Mari El Republic', 182, 'RU', '56.43845700', '47.96077580'),
        (1871, 'Perm Krai', 182, 'RU', '58.82319290', '56.58724810'),
        (1872, 'Tomsk Oblast', 182, 'RU', '58.89698820', '82.67655000'),
        (1873, 'Khabarovsk Krai', 182, 'RU', '50.58884310', '135.00000000'),
        (1874, 'Vologda Oblast', 182, 'RU', '59.87067110', '40.65554110'),
        (1875, 'Sakhalin', 182, 'RU', '50.69098480', '142.95056890'),
        (1876, 'Altai Republic', 182, 'RU', '50.61819240', '86.21993080'),
        (1877, 'Republic of Khakassia', 182, 'RU', '53.04522810', '90.39821450'),
        (1878, 'Tambov Oblast', 182, 'RU', '52.64165890', '41.42164510'),
        (1879, 'Saint Petersburg', 182, 'RU', '59.93105840', '30.36090960'),
        (1880, 'Irkutsk', 182, 'RU', '52.28548340', '104.28902220'),
        (1881, 'Vladimir Oblast', 182, 'RU', '56.15534650', '40.59266850'),
        (1882, 'Moscow Oblast', 182, 'RU', '55.34039600', '38.29176510'),
        (1883, 'Republic of Kalmykia', 182, 'RU', '46.18671760', '45.00000000'),
        (1884, 'Republic of Ingushetia', 182, 'RU', '43.40516980', '44.82029990'),
        (1885, 'Smolensk Oblast', 182, 'RU', '54.98829940', '32.66773780'),
        (1886, 'Orenburg Oblast', 182, 'RU', '51.76340260', '54.61881880'),
        (1887, 'Saratov Oblast', 182, 'RU', '51.83692630', '46.75393970'),
        (1888, 'Novosibirsk', 182, 'RU', '54.98326930', '82.89638310'),
        (1889, 'Lipetsk Oblast', 182, 'RU', '52.52647020', '39.20322690'),
        (1890, 'Kirov Oblast', 182, 'RU', '58.41985290', '50.20972480'),
        (1891, 'Krasnodar Krai', 182, 'RU', '45.64152890', '39.70559770'),
        (1892, 'Kabardino-Balkar Republic', 182, 'RU', '43.39324690', '43.56284980'),
        (1893, 'Chechen Republic', 182, 'RU', '43.40233010', '45.71874680'),
        (1894, 'Sverdlovsk', 182, 'RU', '56.84309930', '60.64540860'),
        (1895, 'Tula Oblast', 182, 'RU', '54.16376800', '37.56495070'),
        (1896, 'Leningrad Oblast', 182, 'RU', '60.07932080', '31.89266450'),
        (1897, 'Kemerovo Oblast', 182, 'RU', '54.75746480', '87.40552880'),
        (1898, 'Republic of Mordovia', 182, 'RU', '54.23694410', '44.06839700'),
        (1899, 'Komi Republic', 182, 'RU', '63.86305390', '54.83126900'),
        (1900, 'Tuva Republic', 182, 'RU', '51.88726690', '95.62601720'),
        (1901, 'Moscow', 182, 'RU', '55.75582600', '37.61729990'),
        (1902, 'Kaliningrad', 182, 'RU', '54.71042640', '20.45221440'),
        (1903, 'Belgorod Oblast', 182, 'RU', '50.71069260', '37.75333770'),
        (1904, 'Zabaykalsky Krai', 182, 'RU', '53.09287710', '116.96765610'),
        (1905, 'Ryazan Oblast', 182, 'RU', '54.38759640', '41.25956610'),
        (1906, 'Voronezh Oblast', 182, 'RU', '50.85897130', '39.86443740'),
        (1907, 'Tyumen Oblast', 182, 'RU', '56.96343870', '66.94827800'),
        (1908, 'Oryol Oblast', 182, 'RU', '52.78564140', '36.92423440'),
        (1909, 'Penza Oblast', 182, 'RU', '53.14121050', '44.09400480'),
        (1910, 'Kostroma Oblast', 182, 'RU', '58.55010690', '43.95411020'),
        (1911, 'Altai Krai', 182, 'RU', '51.79362980', '82.67585960'),
        (1912, 'Sevastopol', 182, 'RU', '44.61665000', '33.52536710'),
        (1913, 'Udmurt Republic', 182, 'RU', '57.06702180', '53.02779480'),
        (1914, 'Chuvash Republic', 182, 'RU', '55.55959920', '46.92835350'),
        (1915, 'Kurgan Oblast', 182, 'RU', '55.44815480', '65.11809750'),
        (1916, 'Lomaiviti', 73, 'FJ', '-17.70900000', '179.09100000'),
        (1917, 'Ba', 73, 'FJ', '36.06138930', '-95.80058720'),
        (1918, 'Tailevu', 73, 'FJ', '-17.82691110', '178.29324800'),
        (1919, 'Nadroga-Navosa', 73, 'FJ', '-17.98652780', '177.65811300'),
        (1920, 'Rewa', 73, 'FJ', '34.79235170', '-82.36092640'),
        (1921, 'Northern Division', 73, 'FJ', '32.87687660', '-117.21563450'),
        (1922, 'Macuata', 73, 'FJ', '-16.48649220', '179.28472510'),
        (1923, 'Western Division', 73, 'FJ', '42.96621980', '-78.70211340'),
        (1924, 'Cakaudrove', 73, 'FJ', '-16.58141050', '179.51200840'),
        (1925, 'Serua', 73, 'FJ', '-18.18047490', '178.05097900'),
        (1926, 'Ra', 73, 'FJ', '37.10031530', '-95.67442460'),
        (1927, 'Naitasiri', 73, 'FJ', '-17.89757540', '178.20715980'),
        (1928, 'Namosi', 73, 'FJ', '-18.08641760', '178.12913870'),
        (1929, 'Central Division', 73, 'FJ', '34.04400660', '-118.24727380'),
        (1930, 'Bua', 73, 'FJ', '43.09645840', '-89.50088000'),
        (1931, 'Rotuma', 73, 'FJ', '-12.50250690', '177.07241640'),
        (1932, 'Eastern Division', 73, 'FJ', '32.80943050', '-117.12899370'),
        (1933, 'Lau', 73, 'FJ', '31.66870150', '-106.39557630'),
        (1934, 'Kadavu', 73, 'FJ', '-19.01271220', '178.18766760'),
        (1935, 'Labuan', 132, 'MY', '5.28314560', '115.23082500'),
        (1936, 'Sabah', 132, 'MY', '5.97883980', '116.07531990'),
        (1937, 'Sarawak', 132, 'MY', '1.55327830', '110.35921270'),
        (1938, 'Perlis', 132, 'MY', '29.92270940', '-90.12285590'),
        (1939, 'Penang', 132, 'MY', '5.41639350', '100.33267860'),
        (1940, 'Pahang', 132, 'MY', '3.81263180', '103.32562040'),
        (1941, 'Malacca', 132, 'MY', '2.18959400', '102.25008680'),
        (1942, 'Terengganu', 132, 'MY', '5.31169160', '103.13241540'),
        (1943, 'Perak', 132, 'MY', '4.59211260', '101.09010900'),
        (1944, 'Selangor', 132, 'MY', '3.07383790', '101.51834690'),
        (1945, 'Putrajaya', 132, 'MY', '2.92636100', '101.69644500'),
        (1946, 'Kelantan', 132, 'MY', '6.12539690', '102.23807100'),
        (1947, 'Kedah', 132, 'MY', '6.11839640', '100.36845950'),
        (1948, 'Negeri Sembilan', 132, 'MY', '2.72580580', '101.94237820'),
        (1949, 'Kuala Lumpur', 132, 'MY', '3.13900300', '101.68685500'),
        (1950, 'Johor', 132, 'MY', '1.48536820', '103.76181540'),
        (1951, 'Mashonaland East Province', 247, 'ZW', '-18.58716420', '31.26263660'),
        (1952, 'Matabeleland South Province', 247, 'ZW', '-21.05233700', '29.04599270'),
        (1953, 'Mashonaland West Province', 247, 'ZW', '-17.48510290', '29.78892480'),
        (1954, 'Matabeleland North Province', 247, 'ZW', '-18.53315660', '27.54958460'),
        (1955, 'Mashonaland Central Province', 247, 'ZW', '-16.76442950', '31.07937050'),
        (1956, 'Bulawayo Province', 247, 'ZW', '-20.14895050', '28.53310380'),
        (1957, 'Midlands Province', 247, 'ZW', '-19.05520090', '29.60354950'),
        (1958, 'Harare Province', 247, 'ZW', '-17.82162880', '31.04922590'),
        (1959, 'Manicaland', 247, 'ZW', '-18.92163860', '32.17460500'),
        (1960, 'Masvingo Province', 247, 'ZW', '-20.62415090', '31.26263660'),
        (1961, 'Bulgan Province', 146, 'MN', '48.96909130', '102.88317230'),
        (1962, 'Darkhan-Uul Province', 146, 'MN', '49.46484340', '105.97459190'),
        (1963, 'Dornod Province', 146, 'MN', '47.46581540', '115.39271200'),
        (1964, 'Khovd Province', 146, 'MN', '47.11296540', '92.31107520'),
        (1965, 'Övörkhangai Province', 146, 'MN', '45.76243920', '103.09170320'),
        (1966, 'Orkhon Province', 146, 'MN', '49.00470500', '104.30165270'),
        (1967, 'Ömnögovi Province', 146, 'MN', '43.50002400', '104.28611160'),
        (1968, 'Töv Province', 146, 'MN', '47.21240560', '106.41541000'),
        (1969, 'Bayan-Ölgii Province', 146, 'MN', '48.39832540', '89.66259150'),
        (1970, 'Dundgovi Province', 146, 'MN', '45.58227860', '106.76442090'),
        (1971, 'Uvs Province', 146, 'MN', '49.64497070', '93.27365760'),
        (1972, 'Govi-Altai Province', 146, 'MN', '45.45112270', '95.85057660'),
        (1973, 'Arkhangai Province', 146, 'MN', '47.89711010', '100.72401650'),
        (1974, 'Khentii Province', 146, 'MN', '47.60812090', '109.93728560'),
        (1975, 'Khövsgöl Province', 146, 'MN', '50.22044840', '100.32137680'),
        (1976, 'Bayankhongor Province', 146, 'MN', '45.15267070', '100.10736670'),
        (1977, 'Sükhbaatar Province', 146, 'MN', '46.56531630', '113.53808360'),
        (1978, 'Govisümber Province', 146, 'MN', '46.47627540', '108.55706270'),
        (1979, 'Zavkhan Province', 146, 'MN', '48.23881470', '96.07030190'),
        (1980, 'Selenge Province', 146, 'MN', '50.00592730', '106.44341080'),
        (1981, 'Dornogovi Province', 146, 'MN', '43.96538890', '109.17734590'),
        (1982, 'Northern Province', 246, 'ZM', '8.88550270', '80.27673270'),
        (1983, 'Western Province', 246, 'ZM', '6.90160860', '80.00877460'),
        (1984, 'Copperbelt Province', 246, 'ZM', '-13.05700730', '27.54958460'),
        (1985, 'Northwestern Province', 246, 'ZM', '-13.00502580', '24.90422080'),
        (1986, 'Central Province', 246, 'ZM', '7.25649960', '80.72144170'),
        (1987, 'Luapula Province', 246, 'ZM', '-11.56483100', '29.04599270'),
        (1988, 'Lusaka Province', 246, 'ZM', '-15.36571290', '29.23207840'),
        (1989, 'Muchinga Province', 246, 'ZM', '-15.38219300', '28.26158000'),
        (1990, 'Southern Province', 246, 'ZM', '6.23737500', '80.54384500'),
        (1991, 'Eastern Province', 246, 'ZM', '23.16696880', '49.36531490'),
        (1992, 'Capital Governorate', 18, 'BH', NULL, NULL),
        (1993, 'Southern Governorate', 18, 'BH', '25.93810180', '50.57568870'),
        (1994, 'Northern Governorate', 18, 'BH', '26.15519140', '50.48251730'),
        (1995, 'Muharraq Governorate', 18, 'BH', '26.26856530', '50.64825170'),
        (1996, 'Central Governorate', 18, 'BH', '26.14260930', '50.56532940'),
        (1997, 'Rio de Janeiro', 31, 'BR', '-22.90684670', '-43.17289650'),
        (1998, 'Minas Gerais', 31, 'BR', '-18.51217800', '-44.55503080'),
        (1999, 'Amapá', 31, 'BR', '0.90199250', '-52.00295650'),
        (2000, 'Goiás', 31, 'BR', '-15.82703690', '-49.83622370'),
        (2001, 'Rio Grande do Sul', 31, 'BR', '-30.03463160', '-51.21769860'),
        (2002, 'Bahia', 31, 'BR', '26.11353900', '-80.10620400'),
        (2003, 'Sergipe', 31, 'BR', '-10.57409340', '-37.38565810'),
        (2004, 'Amazonas', 31, 'BR', NULL, NULL),
        (2005, 'Paraíba', 31, 'BR', '-7.23996090', '-36.78195050'),
        (2006, 'Pernambuco', 31, 'BR', '-8.81371730', '-36.95410700'),
        (2007, 'Alagoas', 31, 'BR', '-9.57130580', '-36.78195050'),
        (2008, 'Piauí', 31, 'BR', '-7.71834010', '-42.72892360'),
        (2009, 'Pará', 31, 'BR', '-1.99812710', '-54.93061520'),
        (2010, 'Mato Grosso do Sul', 31, 'BR', '-20.77222950', '-54.78515310'),
        (2011, 'Mato Grosso', 31, 'BR', '-12.68187120', '-56.92109900'),
        (2012, 'Acre', 31, 'BR', '32.93305200', '35.08267800'),
        (2013, 'Rondônia', 31, 'BR', '-11.50573410', '-63.58061100'),
        (2014, 'Santa Catarina', 31, 'BR', NULL, NULL),
        (2015, 'Maranhão', 31, 'BR', '-4.96094980', '-45.27441590'),
        (2016, 'Ceará', 31, 'BR', '-5.49839770', '-39.32062410'),
        (2017, 'Distrito Federal', 31, 'BR', '-15.79976540', '-47.86447150'),
        (2018, 'Espírito Santo', 31, 'BR', '-19.18342290', '-40.30886260'),
        (2019, 'Rio Grande do Norte', 31, 'BR', '-5.40258030', '-36.95410700'),
        (2020, 'Tocantins', 31, 'BR', '-10.17528000', '-48.29824740'),
        (2021, 'São Paulo', 31, 'BR', '-23.55051990', '-46.63330940'),
        (2022, 'Paraná', 31, 'BR', '-25.25208880', '-52.02154150'),
        (2023, 'Aragatsotn Region', 12, 'AM', '40.33473010', '44.37482960'),
        (2024, 'Ararat Province', 12, 'AM', '39.91394150', '44.72000040'),
        (2025, 'Vayots Dzor Region', 12, 'AM', '39.76419960', '45.33375280'),
        (2026, 'Armavir Region', 12, 'AM', '40.15546310', '44.03724460'),
        (2027, 'Syunik Province', 12, 'AM', '39.51331120', '46.33932340'),
        (2028, 'Gegharkunik Province', 12, 'AM', '40.35264260', '45.12604140'),
        (2029, 'Lori Region', 12, 'AM', '40.96984520', '44.49001380'),
        (2030, 'Yerevan', 12, 'AM', '40.18720230', '44.51520900'),
        (2031, 'Shirak Region', 12, 'AM', '40.96308140', '43.81024610'),
        (2032, 'Tavush Region', 12, 'AM', '40.88662960', '45.33934900'),
        (2033, 'Kotayk Region', 12, 'AM', '40.54102140', '44.76901480'),
        (2034, 'Cojedes', 239, 'VE', '9.38166820', '-68.33392750'),
        (2035, 'Falcón', 239, 'VE', '11.18106740', '-69.85974060'),
        (2036, 'Portuguesa', 239, 'VE', '9.09439990', '-69.09702300'),
        (2037, 'Miranda', 239, 'VE', '42.35193830', '-71.52907660'),
        (2038, 'Lara', 239, 'VE', '33.98221650', '-118.13227470'),
        (2039, 'Bolívar', 239, 'VE', '37.61448380', '-93.41047490'),
        (2040, 'Carabobo', 239, 'VE', '10.11764330', '-68.04775090'),
        (2041, 'Yaracuy', 239, 'VE', '10.33938900', '-68.81088490'),
        (2042, 'Zulia', 239, 'VE', '10.29102370', '-72.14161320'),
        (2043, 'Trujillo', 239, 'VE', '36.67343430', '-121.62875880'),
        (2044, 'Amazonas', 239, 'VE', '-3.41684270', '-65.85606460'),
        (2045, 'Guárico', 239, 'VE', '8.74893090', '-66.23671720'),
        (2046, 'Federal Dependencies of Venezuela', 239, 'VE', '10.93770530', '-65.35695730'),
        (2047, 'Aragua', 239, 'VE', '10.06357580', '-67.28478750'),
        (2048, 'Táchira', 239, 'VE', '7.91370010', '-72.14161320'),
        (2049, 'Barinas', 239, 'VE', '8.62314980', '-70.23710450'),
        (2050, 'Anzoátegui', 239, 'VE', '8.59130730', '-63.95861110'),
        (2051, 'Delta Amacuro', 239, 'VE', '8.84993070', '-61.14031960'),
        (2052, 'Nueva Esparta', 239, 'VE', '10.99707230', '-63.91132960'),
        (2053, 'Mérida', 239, 'VE', '20.96737020', '-89.59258570'),
        (2054, 'Monagas', 239, 'VE', '9.32416520', '-63.01475780'),
        (2055, 'Vargas', 239, 'VE', '29.30522680', '-94.79138540'),
        (2056, 'Sucre', 239, 'VE', '-19.03534500', '-65.25921280'),
        (2057, 'Carinthia', 15, 'AT', '46.72220300', '14.18058820'),
        (2058, 'Upper Austria', 15, 'AT', '48.02585400', '13.97236650'),
        (2059, 'Styria', 15, 'AT', '47.35934420', '14.46998270'),
        (2060, 'Vienna', 15, 'AT', '48.20817430', '16.37381890'),
        (2061, 'Salzburg', 15, 'AT', '47.80949000', '13.05501000'),
        (2062, 'Burgenland', 15, 'AT', '47.15371650', '16.26887970'),
        (2063, 'Vorarlberg', 15, 'AT', '47.24974270', '9.97973730'),
        (2064, 'Tyrol', 15, 'AT', '47.25374140', '11.60148700'),
        (2065, 'Lower Austria', 15, 'AT', '48.10807700', '15.80495580'),
        (2066, 'Mid-Western Region', 154, 'NP', '38.41118410', '-90.38320980'),
        (2067, 'Western Region', 154, 'NP', NULL, NULL),
        (2068, 'Far-Western Development Region', 154, 'NP', '29.29878710', '80.98710740'),
        (2069, 'Eastern Development Region', 154, 'NP', '27.33090720', '87.06242610'),
        (2070, 'Mechi Zone', 154, 'NP', '26.87600070', '87.93348030'),
        (2071, 'Bheri Zone', 154, 'NP', '28.51745600', '81.77870210'),
        (2072, 'Kosi Zone', 154, 'NP', '27.05365240', '87.30161320'),
        (2073, 'Central Region', 154, 'NP', NULL, NULL),
        (2074, 'Lumbini Zone', 154, 'NP', '27.45000000', '83.25000000'),
        (2075, 'Narayani Zone', 154, 'NP', '27.36117660', '84.85679320'),
        (2076, 'Janakpur Zone', 154, 'NP', '27.21108990', '86.01215730'),
        (2077, 'Rapti Zone', 154, 'NP', '28.27434700', '82.38857830'),
        (2078, 'Seti Zone', 154, 'NP', '29.69054270', '81.33994140'),
        (2079, 'Karnali Zone', 154, 'NP', '29.38625550', '82.38857830'),
        (2080, 'Dhaulagiri Zone', 154, 'NP', '28.61117600', '83.50702030'),
        (2081, 'Gandaki Zone', 154, 'NP', '28.37320370', '84.43827210'),
        (2082, 'Bagmati Zone', 154, 'NP', '28.03675770', '85.43755740'),
        (2083, 'Mahakali Zone', 154, 'NP', '29.36010790', '80.54384500'),
        (2084, 'Sagarmatha Zone', 154, 'NP', '27.32382630', '86.74163740'),
        (2085, 'Unity', 206, 'SS', '37.78712760', '-122.40340790'),
        (2086, 'Upper Nile', 206, 'SS', '9.88942020', '32.71813750'),
        (2087, 'Warrap', 206, 'SS', '8.08862380', '28.64106410'),
        (2088, 'Northern Bahr el Ghazal', 206, 'SS', '8.53604490', '26.79678490'),
        (2089, 'Western Equatoria', 206, 'SS', '5.34717990', '28.29943500'),
        (2090, 'Lakes', 206, 'SS', '37.16282550', '-95.69116230'),
        (2091, 'Western Bahr el Ghazal', 206, 'SS', '8.64523990', '25.28375850'),
        (2092, 'Central Equatoria', 206, 'SS', '4.61440630', '31.26263660'),
        (2093, 'Eastern Equatoria', 206, 'SS', '5.06929950', '33.43835300'),
        (2094, 'Jonglei State', 206, 'SS', '7.18196190', '32.35609520'),
        (2095, 'Karditsa Regional Unit', 85, 'GR', '39.36402580', '21.92140490'),
        (2096, 'West Greece Region', 85, 'GR', '38.51154960', '21.57067860'),
        (2097, 'Thessaloniki Regional Unit', 85, 'GR', '40.64006290', '22.94441910'),
        (2098, 'Arcadia Prefecture', 85, 'GR', '37.55578250', '22.33377690'),
        (2099, 'Imathia Regional Unit', 85, 'GR', '40.60600670', '22.14302150'),
        (2100, 'Kastoria Regional Unit', 85, 'GR', '40.51926910', '21.26871710'),
        (2101, 'Euboea', 85, 'GR', '38.52360360', '23.85847370'),
        (2102, 'Grevena Prefecture', 85, 'GR', '40.08376260', '21.42732990'),
        (2103, 'Preveza Prefecture', 85, 'GR', '38.95926490', '20.75171550'),
        (2104, 'Lefkada Regional Unit', 85, 'GR', '38.83336630', '20.70691080'),
        (2105, 'Argolis Regional Unit', 85, 'GR', NULL, NULL),
        (2106, 'Laconia', 85, 'GR', '43.52785460', '-71.47035090'),
        (2107, 'Pella Regional Unit', 85, 'GR', '40.91480390', '22.14302150'),
        (2108, 'West Macedonia Region', 85, 'GR', '40.30040580', '21.79035590'),
        (2109, 'Crete Region', 85, 'GR', '35.24011700', '24.80926910'),
        (2110, 'Epirus Region', 85, 'GR', '39.57064130', '20.76428430'),
        (2111, 'Kilkis Regional Unit', 85, 'GR', '40.99370710', '22.87536740'),
        (2112, 'Kozani Prefecture', 85, 'GR', '40.30055860', '21.78877370'),
        (2113, 'Ioannina Regional Unit', 85, 'GR', '39.66502880', '20.85374660'),
        (2114, 'Phthiotis Prefecture', 85, 'GR', '38.99978500', '22.33377690'),
        (2115, 'Chania Regional Unit', 85, 'GR', '35.51382980', '24.01803670'),
        (2116, 'Achaea Regional Unit', 85, 'GR', '38.11587290', '21.95224910'),
        (2117, 'East Macedonia and Thrace', 85, 'GR', '41.12951260', '24.88771910'),
        (2118, 'South Aegean', 85, 'GR', '37.08553020', '25.14892150'),
        (2119, 'Peloponnese Region', 85, 'GR', '37.50794720', '22.37349000'),
        (2120, 'East Attica Regional Unit', 85, 'GR', '38.20540930', '23.85847370'),
        (2121, 'Serres Prefecture', 85, 'GR', '41.08638540', '23.54838190'),
        (2122, 'Attica Region', 85, 'GR', '38.04575680', '23.85847370'),
        (2123, 'Aetolia-Acarnania Regional Unit', 85, 'GR', '38.70843860', '21.37989280'),
        (2124, 'Corfu Prefecture', 85, 'GR', '39.62498380', '19.92234610'),
        (2125, 'Central Macedonia', 85, 'GR', '40.62117300', '23.19180210'),
        (2126, 'Boeotia Regional Unit', 85, 'GR', '38.36636640', '23.09650640'),
        (2127, 'Kefalonia Prefecture', 85, 'GR', '38.17536750', '20.56921790'),
        (2128, 'Central Greece Region', 85, 'GR', '38.60439840', '22.71521310'),
        (2129, 'Corinthia Regional Unit', 85, 'GR', NULL, NULL),
        (2130, 'Drama Regional Unit', 85, 'GR', '41.23400230', '24.23904980'),
        (2131, 'Ionian Islands Region', 85, 'GR', '37.96948980', '21.38023720'),
        (2132, 'Larissa Prefecture', 85, 'GR', '39.63902240', '22.41912540'),
        (2133, 'Kayin State', 151, 'MM', '16.94593460', '97.95928630'),
        (2134, 'Mandalay Region', 151, 'MM', '21.56190580', '95.89871390'),
        (2135, 'Yangon Region', 151, 'MM', '16.91434880', '96.15269850'),
        (2136, 'Magway Region', 151, 'MM', '19.88713860', '94.72775280'),
        (2137, 'Chin State', 151, 'MM', '22.00869780', '93.58126920'),
        (2138, 'Rakhine State', 151, 'MM', '20.10408180', '93.58126920'),
        (2139, 'Shan State', 151, 'MM', '22.03619850', '98.13385580'),
        (2140, 'Tanintharyi Region', 151, 'MM', '12.47068760', '99.01289260'),
        (2141, 'Bago', 151, 'MM', '17.32207110', '96.46632860'),
        (2142, 'Ayeyarwady Region', 151, 'MM', '17.03421250', '95.22666750'),
        (2143, 'Kachin State', 151, 'MM', '25.85090400', '97.43813550'),
        (2144, 'Kayah State', 151, 'MM', '19.23420610', '97.26528580'),
        (2145, 'Sagaing Region', 151, 'MM', '24.42838100', '95.39395510'),
        (2146, 'Naypyidaw Union Territory', 151, 'MM', '19.93862450', '96.15269850'),
        (2147, 'Mon State', 151, 'MM', '16.30031330', '97.69822720'),
        (2148, 'Bartın Province', 225, 'TR', '41.58105090', '32.46097940'),
        (2149, 'Kütahya Province', 225, 'TR', '39.35813700', '29.60354950'),
        (2150, 'Sakarya Province', 225, 'TR', '40.78885500', '30.40595400'),
        (2151, 'Edirne Province', 225, 'TR', '41.15172220', '26.51379640'),
        (2152, 'Van Province', 225, 'TR', '38.36794170', '43.71827870'),
        (2153, 'Bingöl Province', 225, 'TR', '39.06263540', '40.76960950'),
        (2154, 'Kilis Province', 225, 'TR', '36.82047750', '37.16873390'),
        (2155, 'Adıyaman Province', 225, 'TR', '37.90782910', '38.48499230'),
        (2156, 'Mersin Province', 225, 'TR', '36.81208580', '34.64147500'),
        (2157, 'Denizli Province', 225, 'TR', '37.61283950', '29.23207840'),
        (2158, 'Malatya Province', 225, 'TR', '38.40150570', '37.95362980'),
        (2159, 'Elazığ Province', 225, 'TR', '38.49648040', '39.21990290'),
        (2160, 'Erzincan Province', 225, 'TR', '39.76819140', '39.05013060'),
        (2161, 'Amasya Province', 225, 'TR', '40.65166080', '35.90379660'),
        (2162, 'Muş Province', 225, 'TR', '38.94618880', '41.75389310'),
        (2163, 'Bursa Province', 225, 'TR', '40.06554590', '29.23207840'),
        (2164, 'Eskişehir Province', 225, 'TR', '39.63296570', '31.26263660'),
        (2165, 'Erzurum Province', 225, 'TR', '40.07467990', '41.66945620'),
        (2166, 'Iğdır Province', 225, 'TR', '39.88798410', '44.00483650'),
        (2167, 'Tekirdağ Province', 225, 'TR', '41.11212270', '27.26761160'),
        (2168, 'Çankırı Province', 225, 'TR', '40.53690730', '33.58838930'),
        (2169, 'Antalya Province', 225, 'TR', '37.09516720', '31.07937050'),
        (2170, 'Istanbul Province', 225, 'TR', '41.16343020', '28.76644080'),
        (2171, 'Konya Province', 225, 'TR', '37.98381340', '32.71813750'),
        (2172, 'Bolu Province', 225, 'TR', '40.57597660', '31.57880860'),
        (2173, 'Çorum Province', 225, 'TR', '40.49982110', '34.59862630'),
        (2174, 'Ordu Province', 225, 'TR', '40.79905800', '37.38990050'),
        (2175, 'Balıkesir Province', 225, 'TR', '39.76167820', '28.11226790'),
        (2176, 'Kırklareli Province', 225, 'TR', '41.72597950', '27.48383900'),
        (2177, 'Bayburt Province', 225, 'TR', '40.26032000', '40.22804800'),
        (2178, 'Kırıkkale Province', 225, 'TR', '39.88768780', '33.75552480'),
        (2179, 'Afyonkarahisar Province', 225, 'TR', '38.73910990', '30.71200230'),
        (2180, 'Kırşehir Province', 225, 'TR', '39.22689050', '33.97500180'),
        (2181, 'Sivas Province', 225, 'TR', '39.44880390', '37.12944970'),
        (2182, 'Muğla Province', 225, 'TR', '37.18358190', '28.48639630'),
        (2183, 'Şanlıurfa Province', 225, 'TR', '37.35691020', '39.15436770'),
        (2184, 'Karaman Province', 225, 'TR', '37.24363360', '33.61757700'),
        (2185, 'Ardahan Province', 225, 'TR', '41.11129640', '42.78316740'),
        (2186, 'Giresun Province', 225, 'TR', '40.64616720', '38.59355110'),
        (2187, 'Aydın Province', 225, 'TR', '37.81170330', '28.48639630'),
        (2188, 'Yozgat Province', 225, 'TR', '39.72719790', '35.10778580'),
        (2189, 'Niğde Province', 225, 'TR', '38.09930860', '34.68565090'),
        (2190, 'Hakkâri Province', 225, 'TR', '37.44593190', '43.74498410'),
        (2191, 'Artvin Province', 225, 'TR', '41.07866400', '41.76282230'),
        (2192, 'Tunceli Province', 225, 'TR', '39.30735540', '39.43877780'),
        (2193, 'Ağrı Province', 225, 'TR', '39.62692180', '43.02159650'),
        (2194, 'Batman Province', 225, 'TR', '37.83624960', '41.36057390'),
        (2195, 'Kocaeli Province', 225, 'TR', '40.85327040', '29.88152030'),
        (2196, 'Nevşehir Province', 225, 'TR', '38.69393990', '34.68565090'),
        (2197, 'Kastamonu Province', 225, 'TR', '41.41038630', '33.69983340'),
        (2198, 'Manisa Province', 225, 'TR', '38.84193730', '28.11226790'),
        (2199, 'Tokat Province', 225, 'TR', '40.39027130', '36.62518630'),
        (2200, 'Kayseri Province', 225, 'TR', '38.62568540', '35.74068820'),
        (2201, 'Uşak Province', 225, 'TR', '38.54313190', '29.23207840'),
        (2202, 'Düzce Province', 225, 'TR', '40.87705310', '31.31927130'),
        (2203, 'Gaziantep Province', 225, 'TR', '37.07638820', '37.38272340'),
        (2204, 'Gümüşhane Province', 225, 'TR', '40.28036730', '39.31432530'),
        (2205, 'İzmir Province', 225, 'TR', '38.35916930', '27.26761160'),
        (2206, 'Trabzon Province', 225, 'TR', '40.79924100', '39.58479440'),
        (2207, 'Siirt Province', 225, 'TR', '37.86588620', '42.14945230'),
        (2208, 'Kars Province', 225, 'TR', '40.28076360', '42.99195270'),
        (2209, 'Burdur Province', 225, 'TR', '37.46126690', '30.06652360'),
        (2210, 'Aksaray Province', 225, 'TR', '38.33520430', '33.97500180'),
        (2211, 'Hatay Province', 225, 'TR', '36.40184880', '36.34980970'),
        (2212, 'Adana Province', 225, 'TR', '37.26123150', '35.39050460'),
        (2213, 'Zonguldak Province', 225, 'TR', '41.31249170', '31.85982510'),
        (2214, 'Osmaniye Province', 225, 'TR', '37.21302580', '36.17626150'),
        (2215, 'Bitlis Province', 225, 'TR', '38.65231330', '42.42020280'),
        (2216, 'Çanakkale Province', 225, 'TR', '40.05101040', '26.98524220'),
        (2217, 'Ankara Province', 225, 'TR', '39.78052450', '32.71813750'),
        (2218, 'Yalova Province', 225, 'TR', '40.57759860', '29.20883030'),
        (2219, 'Rize Province', 225, 'TR', '40.95814970', '40.92269850'),
        (2220, 'Samsun Province', 225, 'TR', '41.18648590', '36.13226780'),
        (2221, 'Bilecik Province', 225, 'TR', '40.05665550', '30.06652360'),
        (2222, 'Isparta Province', 225, 'TR', '38.02114640', '31.07937050'),
        (2223, 'Karabük Province', 225, 'TR', '41.18748900', '32.74174190'),
        (2224, 'Mardin Province', 225, 'TR', '37.34429290', '40.61964870'),
        (2225, 'Şırnak Province', 225, 'TR', '37.41874810', '42.49183380'),
        (2226, 'Diyarbakır Province', 225, 'TR', '38.10663720', '40.54268960'),
        (2227, 'Kahramanmaraş Province', 225, 'TR', '37.75030360', '36.95410700'),
        (2228, 'Lisbon', 177, 'PT', '38.72232630', '-9.13927140'),
        (2229, 'Bragança', 177, 'PT', '41.80616520', '-6.75674270'),
        (2230, 'Beja', 177, 'PT', '37.96877860', '-7.87216000'),
        (2231, 'Madeira', 177, 'PT', '32.76070740', '-16.95947230'),
        (2232, 'Portalegre', 177, 'PT', '39.29670860', '-7.42847550'),
        (2233, 'Açores', 177, 'PT', '37.74124880', '-25.67559440'),
        (2234, 'Vila Real', 177, 'PT', '41.30035270', '-7.74572740'),
        (2235, 'Aveiro', 177, 'PT', '40.72090230', '-8.57210160'),
        (2236, 'Évora', 177, 'PT', '38.57444680', '-7.90765530'),
        (2237, 'Viseu', 177, 'PT', '40.65884240', '-7.91475600'),
        (2238, 'Santarém', 177, 'PT', '39.23666870', '-8.68599440'),
        (2239, 'Faro', 177, 'PT', '37.01935480', '-7.93043970'),
        (2240, 'Leiria', 177, 'PT', '39.77095320', '-8.79218360'),
        (2241, 'Castelo Branco', 177, 'PT', '39.86313230', '-7.48141630'),
        (2242, 'Setúbal', 177, 'PT', '38.52409330', '-8.89258760'),
        (2243, 'Porto', 177, 'PT', '41.14766290', '-8.60789730'),
        (2244, 'Braga', 177, 'PT', '41.55038800', '-8.42613010'),
        (2245, 'Viana do Castelo', 177, 'PT', '41.69180460', '-8.83445100'),
        (2246, 'Coimbra', 177, 'PT', '40.20579940', '-8.41369000'),
        (2247, 'Zhejiang', 45, 'CN', '29.14164320', '119.78892480'),
        (2248, 'Fujian', 45, 'CN', '26.48368420', '117.92490020'),
        (2249, 'Shanghai', 45, 'CN', '31.23041600', '121.47370100'),
        (2250, 'Jiangsu', 45, 'CN', '33.14017150', '119.78892480'),
        (2251, 'Anhui', 45, 'CN', '30.60067730', '117.92490020'),
        (2252, 'Shandong', 45, 'CN', '37.80060640', '-122.26999180'),
        (2253, 'Jilin', 45, 'CN', '43.83788300', '126.54957200'),
        (2254, 'Shanxi', 45, 'CN', '37.24256490', '111.85685860'),
        (2255, 'Taiwan Province, People\'s Republic of China', 45, 'CN', '23.69781000', '120.96051500'),
        (2256, 'Jiangxi', 45, 'CN', '27.08745640', '114.90422080'),
        (2257, 'Beijing', 45, 'CN', '39.90419990', '116.40739630'),
        (2258, 'Hunan', 45, 'CN', '36.73412940', '-95.93449020'),
        (2259, 'Henan', 45, 'CN', '34.29043020', '113.38235450'),
        (2260, 'Yunnan', 45, 'CN', '24.47528470', '101.34310580'),
        (2261, 'Guizhou', 45, 'CN', '26.84296450', '107.29028390'),
        (2262, 'Ningxia Hui Autonomous Region', 45, 'CN', '37.19873100', '106.15809370'),
        (2263, 'Xinjiang', 45, 'CN', '42.52463570', '87.53958550'),
        (2264, 'Tibet Autonomous Region', 45, 'CN', '30.15336050', '88.78786780'),
        (2265, 'Heilongjiang', 45, 'CN', '47.12164720', '128.73823100'),
        (2266, 'Macau', 45, 'CN', '22.19874500', '113.54387300'),
        (2267, 'Hong Kong', 45, 'CN', '22.31930390', '114.16936110'),
        (2268, 'Liaoning', 45, 'CN', '41.94365430', '122.52903760'),
        (2269, 'Inner Mongolia', 45, 'CN', '43.37822000', '115.05948150'),
        (2270, 'Qinghai', 45, 'CN', '35.74479800', '96.40773580'),
        (2271, 'Chongqing', 45, 'CN', '29.43158610', '106.91225100'),
        (2272, 'Shaanxi', 45, 'CN', '35.39399080', '109.18800470'),
        (2273, 'Hainan', 45, 'CN', '19.56639470', '109.94968600'),
        (2274, 'Hubei', 45, 'CN', '30.73781180', '112.23840170'),
        (2275, 'Gansu', 45, 'CN', '35.75183260', '104.28611160'),
        (2276, 'Keelung', 45, 'CN', '25.12760330', '121.73918330'),
        (2277, 'Sichuan', 45, 'CN', '30.26380320', '102.80547530'),
        (2278, 'Guangxi Zhuang Autonomous Region', 45, 'CN', '23.72475990', '108.80761950'),
        (2279, 'Guangdong', 45, 'CN', '23.37903330', '113.76328280'),
        (2280, 'Hebei', 45, 'CN', '37.89565940', '114.90422080'),
        (2281, 'South Governorate', 121, 'LB', '33.27214790', '35.20327780'),
        (2282, 'Mount Lebanon Governorate', 121, 'LB', '33.81008580', '35.59731390'),
        (2283, 'Baalbek-Hermel Governorate', 121, 'LB', '34.26585560', '36.34980970'),
        (2284, 'North Governorate', 121, 'LB', '34.43806250', '35.83082330'),
        (2285, 'Akkar Governorate', 121, 'LB', '34.53287630', '36.13281320'),
        (2286, 'Beirut Governorate', 121, 'LB', '33.88861060', '35.49547720'),
        (2287, 'Beqaa Governorate', 121, 'LB', '33.84626620', '35.90194890'),
        (2288, 'Nabatieh Governorate', 121, 'LB', '33.37716930', '35.48382930'),
        (2289, 'Isle of Wight', 232, 'GB', '50.69384790', '-1.30473400'),
        (2290, 'St Helens', 232, 'GB', '45.85896100', '-122.82123560'),
        (2291, 'London Borough of Brent', 232, 'GB', '51.56728080', '-0.27105680'),
        (2292, 'Walsall', 232, 'GB', '52.58621400', '-1.98291900'),
        (2293, 'Trafford', 232, 'GB', '40.38562460', '-79.75893470'),
        (2294, 'City of Southampton', 232, 'GB', '50.90970040', '-1.40435090'),
        (2295, 'Sheffield', 232, 'GB', '36.09507430', '-80.27884660'),
        (2296, 'West Sussex', 232, 'GB', '50.92801430', '-0.46170750'),
        (2297, 'City of Peterborough', 232, 'GB', '44.30936360', '-78.32015300'),
        (2298, 'Caerphilly County Borough', 232, 'GB', '51.66044650', '-3.21787240'),
        (2299, 'Vale of Glamorgan', 232, 'GB', '51.40959580', '-3.48481670'),
        (2300, 'Shetland Islands', 232, 'GB', '60.52965070', '-1.26594090'),
        (2301, 'Rhondda Cynon Taf', 232, 'GB', '51.64902070', '-3.42886920'),
        (2302, 'Poole', 232, 'GB', '50.71505000', '-1.98724800'),
        (2303, 'Central Bedfordshire', 232, 'GB', '52.00297440', '-0.46513890'),
        (2304, 'Down District Council', 232, 'GB', '54.24342870', '-5.95779590'),
        (2305, 'City of Portsmouth', 232, 'GB', '36.83291500', '-76.29755490'),
        (2306, 'London Borough of Haringey', 232, 'GB', '51.59061130', '-0.11097090'),
        (2307, 'London Borough of Bexley', 232, 'GB', '51.45190210', '0.11717860'),
        (2308, 'Rotherham', 232, 'GB', '53.43260350', '-1.36350090'),
        (2309, 'Hartlepool', 232, 'GB', '54.69174500', '-1.21292600'),
        (2310, 'Telford and Wrekin', 232, 'GB', '52.74099160', '-2.48685860'),
        (2311, 'Belfast district', 232, 'GB', '54.61703660', '-5.95318610'),
        (2312, 'Cornwall', 232, 'GB', '50.26604710', '-5.05271250'),
        (2313, 'London Borough of Sutton', 232, 'GB', '51.35737620', '-0.17527960'),
        (2314, 'Omagh District Council', 232, 'GB', '54.45135240', '-7.71250180'),
        (2315, 'Banbridge', 232, 'GB', '54.34872900', '-6.27048030'),
        (2316, 'Causeway Coast and Glens', 232, 'GB', '55.04318300', '-6.67412880'),
        (2317, 'Newtownabbey Borough Council', 232, 'GB', '54.67924220', '-5.95911020'),
        (2318, 'City of Leicester', 232, 'GB', '52.63687780', '-1.13975920'),
        (2319, 'London Borough of Islington', 232, 'GB', '51.54650630', '-0.10580580'),
        (2320, 'Metropolitan Borough of Wigan', 232, 'GB', '53.51348120', '-2.61069990'),
        (2321, 'Oxfordshire', 232, 'GB', '51.76120560', '-1.24646740'),
        (2322, 'Magherafelt District Council', 232, 'GB', '54.75532790', '-6.60774870'),
        (2323, 'Southend-on-Sea', 232, 'GB', '51.54592690', '0.70771230'),
        (2324, 'Armagh, Banbridge and Craigavon', 232, 'GB', '54.39325920', '-6.45634010'),
        (2325, 'Perth and Kinross', 232, 'GB', '56.39538170', '-3.42835470'),
        (2326, 'London Borough of Waltham Forest', 232, 'GB', '51.58863830', '-0.01176250'),
        (2327, 'Rochdale', 232, 'GB', '53.60971360', '-2.15610000'),
        (2328, 'Merthyr Tydfil County Borough', 232, 'GB', '51.74674740', '-3.38132750'),
        (2329, 'Blackburn with Darwen', 232, 'GB', '53.69575220', '-2.46829850'),
        (2330, 'Knowsley', 232, 'GB', '53.45459400', '-2.85290700'),
        (2331, 'Armagh City and District Council', 232, 'GB', '54.39325920', '-6.45634010'),
        (2332, 'Middlesbrough', 232, 'GB', '54.57422700', '-1.23495600'),
        (2333, 'East Renfrewshire', 232, 'GB', '55.77047350', '-4.33598210'),
        (2334, 'Cumbria', 232, 'GB', '54.57723230', '-2.79748350'),
        (2335, 'Scotland', 232, 'GB', '56.49067120', '-4.20264580'),
        (2336, 'England', 232, 'GB', '52.35551770', '-1.17431970'),
        (2337, 'Northern Ireland', 232, 'GB', '54.78771490', '-6.49231450'),
        (2338, 'Wales', 232, 'GB', '52.13066070', '-3.78371170'),
        (2339, 'Bath and North East Somerset', 232, 'GB', '51.32501020', '-2.47662410'),
        (2340, 'Liverpool', 232, 'GB', '32.65649810', '-115.47632410'),
        (2341, 'Sandwell', 232, 'GB', '52.53616740', '-2.01079300'),
        (2342, 'Bournemouth', 232, 'GB', '50.71916400', '-1.88076900'),
        (2343, 'Isles of Scilly', 232, 'GB', '49.92772610', '-6.32749660'),
        (2344, 'Falkirk', 232, 'GB', '56.00187750', '-3.78391310'),
        (2345, 'Dorset', 232, 'GB', '50.74876350', '-2.34447860'),
        (2346, 'Scottish Borders', 232, 'GB', '55.54856970', '-2.78613880'),
        (2347, 'London Borough of Havering', 232, 'GB', '51.57792400', '0.21208290'),
        (2348, 'Moyle District Council', 232, 'GB', '55.20473270', '-6.25317400'),
        (2349, 'London Borough of Camden', 232, 'GB', '51.54547360', '-0.16279020'),
        (2350, 'Newry and Mourne District Council', 232, 'GB', '54.17425050', '-6.33919920'),
        (2351, 'Neath Port Talbot County Borough', 232, 'GB', '51.59785190', '-3.78396680'),
        (2352, 'Conwy County Borough', 232, 'GB', '53.29350130', '-3.72651610'),
        (2353, 'Outer Hebrides', 232, 'GB', '57.75989180', '-7.01940340'),
        (2354, 'West Lothian', 232, 'GB', '55.90701980', '-3.55171670'),
        (2355, 'Lincolnshire', 232, 'GB', '52.94518890', '-0.16012460'),
        (2356, 'London Borough of Barking and Dagenham', 232, 'GB', '51.55406660', '0.13401700'),
        (2357, 'City of Westminster', 232, 'GB', '39.57659770', '-76.99721260'),
        (2358, 'London Borough of Lewisham', 232, 'GB', '51.44145790', '-0.01170060'),
        (2359, 'City of Nottingham', 232, 'GB', '52.95478320', '-1.15810860'),
        (2360, 'Moray', 232, 'GB', '57.64984760', '-3.31680390'),
        (2361, 'Ballymoney', 232, 'GB', '55.07048880', '-6.51737080'),
        (2362, 'South Lanarkshire', 232, 'GB', '55.67359090', '-3.78196610'),
        (2363, 'Ballymena Borough', 232, 'GB', '54.86426000', '-6.27910740'),
        (2364, 'Doncaster', 232, 'GB', '53.52282000', '-1.12846200'),
        (2365, 'Northumberland', 232, 'GB', '55.20825420', '-2.07841380'),
        (2366, 'Fermanagh and Omagh', 232, 'GB', '54.45135240', '-7.71250180'),
        (2367, 'Tameside', 232, 'GB', '53.48058280', '-2.08098910'),
        (2368, 'Royal Borough of Kensington and Chelsea', 232, 'GB', '51.49908050', '-0.19382530'),
        (2369, 'Hertfordshire', 232, 'GB', '51.80978230', '-0.23767440'),
        (2370, 'East Riding of Yorkshire', 232, 'GB', '53.84161680', '-0.43441060'),
        (2371, 'Kirklees', 232, 'GB', '53.59334320', '-1.80095090'),
        (2372, 'City of Sunderland', 232, 'GB', '54.88614890', '-1.47857970'),
        (2373, 'Gloucestershire', 232, 'GB', '51.86421120', '-2.23803350'),
        (2374, 'East Ayrshire', 232, 'GB', '55.45184960', '-4.26444780'),
        (2375, 'United Kingdom', 232, 'GB', '55.37805100', '-3.43597300'),
        (2376, 'London Borough of Hillingdon', 232, 'GB', '51.53518320', '-0.44813780'),
        (2377, 'South Ayrshire', 232, 'GB', '55.45889880', '-4.62919940'),
        (2378, 'Ascension Island', 232, 'GB', '-7.94671660', '-14.35591580'),
        (2379, 'Gwynedd', 232, 'GB', '52.92772660', '-4.13348360'),
        (2380, 'London Borough of Hounslow', 232, 'GB', '51.48283580', '-0.38820620'),
        (2381, 'Medway', 232, 'GB', '42.14176410', '-71.39672560'),
        (2382, 'Limavady Borough Council', 232, 'GB', '55.05168200', '-6.94919440'),
        (2383, 'Highland', 232, 'GB', '36.29675080', '-95.83803660'),
        (2384, 'North East Lincolnshire', 232, 'GB', '53.56682010', '-0.08150660'),
        (2385, 'London Borough of Harrow', 232, 'GB', '51.58816270', '-0.34228510'),
        (2386, 'Somerset', 232, 'GB', '51.10509700', '-2.92623070'),
        (2387, 'Angus', 232, 'GB', '37.27578860', '-95.65010330'),
        (2388, 'Inverclyde', 232, 'GB', '55.93165690', '-4.68001580'),
        (2389, 'Darlington', 232, 'GB', '34.29987620', '-79.87617410'),
        (2390, 'London Borough of Tower Hamlets', 232, 'GB', '51.52026070', '-0.02933960'),
        (2391, 'Wiltshire', 232, 'GB', '51.34919960', '-1.99271050'),
        (2392, 'Argyll and Bute', 232, 'GB', '56.40062140', '-5.48074800'),
        (2393, 'Strabane District Council', 232, 'GB', '54.82738650', '-7.46331030'),
        (2394, 'Stockport', 232, 'GB', '53.41063160', '-2.15753320'),
        (2395, 'Brighton and Hove', 232, 'GB', '50.82262880', '-0.13704700'),
        (2396, 'London Borough of Lambeth', 232, 'GB', '51.45714770', '-0.12306810'),
        (2397, 'London Borough of Redbridge', 232, 'GB', '51.58861210', '0.08239820'),
        (2398, 'Manchester', 232, 'GB', '53.48075930', '-2.24263050'),
        (2399, 'Mid Ulster', 232, 'GB', '54.64113010', '-6.75225490'),
        (2400, 'South Gloucestershire', 232, 'GB', '51.52643610', '-2.47284870'),
        (2401, 'Aberdeenshire', 232, 'GB', '57.28687230', '-2.38156840'),
        (2402, 'Monmouthshire', 232, 'GB', '51.81161000', '-2.71634170'),
        (2403, 'Derbyshire', 232, 'GB', '53.10467820', '-1.56238850'),
        (2404, 'Glasgow', 232, 'GB', '55.86423700', '-4.25180600'),
        (2405, 'Buckinghamshire', 232, 'GB', '51.80722040', '-0.81276640'),
        (2406, 'County Durham', 232, 'GB', '54.72940990', '-1.88115980'),
        (2407, 'Shropshire', 232, 'GB', '52.70636570', '-2.74178490'),
        (2408, 'Wirral', 232, 'GB', '53.37271810', '-3.07375400'),
        (2409, 'South Tyneside', 232, 'GB', '54.96366930', '-1.44186340'),
        (2410, 'Essex', 232, 'GB', '51.57424470', '0.48567810'),
        (2411, 'London Borough of Hackney', 232, 'GB', '51.57344500', '-0.07243760'),
        (2412, 'Antrim and Newtownabbey', 232, 'GB', '54.69568870', '-5.94810690'),
        (2413, 'City of Bristol', 232, 'GB', '41.67352200', '-72.94653750'),
        (2414, 'East Sussex', 232, 'GB', '50.90859550', '0.24941660'),
        (2415, 'Dumfries and Galloway', 232, 'GB', '55.07010730', '-3.60525810'),
        (2416, 'Milton Keynes', 232, 'GB', '52.08520380', '-0.73331330'),
        (2417, 'Derry City Council', 232, 'GB', '54.96907780', '-7.19583510'),
        (2418, 'London Borough of Newham', 232, 'GB', '51.52551620', '0.03521630'),
        (2419, 'Wokingham', 232, 'GB', '51.41045700', '-0.83386100'),
        (2420, 'Warrington', 232, 'GB', '40.24927410', '-75.13406040'),
        (2421, 'Stockton-on-Tees', 232, 'GB', '54.57045510', '-1.32898210'),
        (2422, 'Swindon', 232, 'GB', '51.55577390', '-1.77971760'),
        (2423, 'Cambridgeshire', 232, 'GB', '52.20529730', '0.12181950'),
        (2424, 'City of London', 232, 'GB', '51.51234430', '-0.09098520'),
        (2425, 'Birmingham', 232, 'GB', '33.51858920', '-86.81035670'),
        (2426, 'City of York', 232, 'GB', '53.95996510', '-1.08729790'),
        (2427, 'Slough', 232, 'GB', '51.51053840', '-0.59504060'),
        (2428, 'Edinburgh', 232, 'GB', '55.95325200', '-3.18826700'),
        (2429, 'Mid and East Antrim', 232, 'GB', '54.93993410', '-6.11374230'),
        (2430, 'North Somerset', 232, 'GB', '51.38790280', '-2.77810910'),
        (2431, 'Gateshead', 232, 'GB', '54.95268000', '-1.60341100'),
        (2432, 'London Borough of Southwark', 232, 'GB', '51.48805720', '-0.07628380'),
        (2433, 'City and County of Swansea', 232, 'GB', '51.62144000', '-3.94364600'),
        (2434, 'London Borough of Wandsworth', 232, 'GB', '51.45682740', '-0.18966380'),
        (2435, 'Hampshire', 232, 'GB', '51.05769480', '-1.30806290'),
        (2436, 'Wrexham County Borough', 232, 'GB', '53.03013780', '-3.02614870'),
        (2437, 'Flintshire', 232, 'GB', '53.16686580', '-3.14189080'),
        (2438, 'Coventry', 232, 'GB', '52.40682200', '-1.51969300'),
        (2439, 'Carrickfergus Borough Council', 232, 'GB', '54.72568430', '-5.80937190'),
        (2440, 'West Dunbartonshire', 232, 'GB', '55.94509250', '-4.56462590'),
        (2441, 'Powys', 232, 'GB', '52.64642490', '-3.32609040'),
        (2442, 'Cheshire West and Chester', 232, 'GB', '53.23029740', '-2.71511170'),
        (2443, 'Renfrewshire', 232, 'GB', '55.84665400', '-4.53312590'),
        (2444, 'Cheshire East', 232, 'GB', '53.16104460', '-2.21859320'),
        (2445, 'Cookstown District Council', 232, 'GB', '54.64181580', '-6.74438950'),
        (2446, 'Derry City and Strabane', 232, 'GB', '55.00474430', '-7.32092220'),
        (2447, 'Staffordshire', 232, 'GB', '52.87927450', '-2.05718680'),
        (2448, 'London Borough of Hammersmith and Fulham', 232, 'GB', '51.49901560', '-0.22915000'),
        (2449, 'Craigavon Borough Council', 232, 'GB', '54.39325920', '-6.45634010'),
        (2450, 'Clackmannanshire', 232, 'GB', '56.10753510', '-3.75294090'),
        (2451, 'Blackpool', 232, 'GB', '53.81750530', '-3.03567480'),
        (2452, 'Bridgend County Borough', 232, 'GB', '51.50831990', '-3.58120750'),
        (2453, 'North Lincolnshire', 232, 'GB', '53.60555920', '-0.55965820'),
        (2454, 'East Dunbartonshire', 232, 'GB', '55.97431620', '-4.20229800'),
        (2455, 'Reading', 232, 'GB', '36.14866590', '-95.98400120'),
        (2456, 'Nottinghamshire', 232, 'GB', '53.10031900', '-0.99363060'),
        (2457, 'Dudley', 232, 'GB', '42.04336610', '-71.92760330'),
        (2458, 'Newcastle upon Tyne', 232, 'GB', '54.97825200', '-1.61778000'),
        (2459, 'Bury', 232, 'GB', '53.59334980', '-2.29660540'),
        (2460, 'Lisburn and Castlereagh', 232, 'GB', '54.49815840', '-6.13067910'),
        (2461, 'Coleraine Borough Council', 232, 'GB', '55.14515700', '-6.67598140'),
        (2462, 'East Lothian', 232, 'GB', '55.94933830', '-2.77044640'),
        (2463, 'Aberdeen', 232, 'GB', '57.14971700', '-2.09427800'),
        (2464, 'Kent', 232, 'GB', '41.15366740', '-81.35788590'),
        (2465, 'Wakefield', 232, 'GB', '42.50393950', '-71.07233910'),
        (2466, 'Halton', 232, 'GB', '43.53253720', '-79.87448360'),
        (2467, 'Suffolk', 232, 'GB', '52.18724720', '0.97078010'),
        (2468, 'Thurrock', 232, 'GB', '51.49345570', '0.35291970'),
        (2469, 'Solihull', 232, 'GB', '52.41181100', '-1.77761000'),
        (2470, 'Bracknell Forest', 232, 'GB', '51.41538280', '-0.75364950'),
        (2471, 'West Berkshire', 232, 'GB', '51.43082550', '-1.14449270'),
        (2472, 'Rutland', 232, 'GB', '43.61062370', '-72.97260650'),
        (2473, 'Norfolk', 232, 'GB', '36.85076890', '-76.28587260'),
        (2474, 'Orkney Islands', 232, 'GB', '58.98094010', '-2.96052060'),
        (2475, 'City of Kingston upon Hull', 232, 'GB', '53.76762360', '-0.32741980'),
        (2476, 'London Borough of Enfield', 232, 'GB', '51.66229090', '-0.11806510'),
        (2477, 'Oldham', 232, 'GB', '42.20405980', '-71.20481190'),
        (2478, 'Torbay', 232, 'GB', '50.43923290', '-3.53698990'),
        (2479, 'Fife', 232, 'GB', '56.20820780', '-3.14951750'),
        (2480, 'Northamptonshire', 232, 'GB', '52.27299440', '-0.87555150'),
        (2481, 'Royal Borough of Kingston upon Thames', 232, 'GB', '51.37811700', '-0.29270900'),
        (2482, 'Windsor and Maidenhead', 232, 'GB', '51.47997120', '-0.62425650'),
        (2483, 'London Borough of Merton', 232, 'GB', '51.40977420', '-0.21080840'),
        (2484, 'Carmarthenshire', 232, 'GB', '51.85723090', '-4.31159590'),
        (2485, 'City of Derby', 232, 'GB', '37.54837550', '-97.24851910'),
        (2486, 'Pembrokeshire', 232, 'GB', '51.67407800', '-4.90887850'),
        (2487, 'North Lanarkshire', 232, 'GB', '55.86624320', '-3.96131440'),
        (2488, 'Stirling', 232, 'GB', '56.11652270', '-3.93690290'),
        (2489, 'City of Wolverhampton', 232, 'GB', '52.58891200', '-2.15646300'),
        (2490, 'London Borough of Bromley', 232, 'GB', '51.36797050', '0.07006200'),
        (2491, 'Devon', 232, 'GB', '50.71555910', '-3.53087500'),
        (2492, 'Royal Borough of Greenwich', 232, 'GB', '51.48346270', '0.05862020'),
        (2493, 'Salford', 232, 'GB', '53.48752350', '-2.29012640'),
        (2494, 'Lisburn City Council', 232, 'GB', '54.49815840', '-6.13067910'),
        (2495, 'Lancashire', 232, 'GB', '53.76322540', '-2.70440520'),
        (2496, 'Torfaen', 232, 'GB', '51.70022530', '-3.04460150'),
        (2497, 'Denbighshire', 232, 'GB', '53.18422880', '-3.42249850'),
        (2498, 'Ards', 232, 'GB', '42.13918510', '-87.86149720'),
        (2499, 'Barnsley', 232, 'GB', '34.29949560', '-84.98458090'),
        (2500, 'Herefordshire', 232, 'GB', '52.07651640', '-2.65441820'),
        (2501, 'London Borough of Richmond upon Thames', 232, 'GB', '51.46130540', '-0.30377090'),
        (2502, 'Saint Helena', 232, 'GB', '-15.96501040', '-5.70892410'),
        (2503, 'Leeds', 232, 'GB', '53.80075540', '-1.54907740'),
        (2504, 'Bolton', 232, 'GB', '44.37264760', '-72.87876250'),
        (2505, 'Warwickshire', 232, 'GB', '52.26713530', '-1.46752160'),
        (2506, 'City of Stoke-on-Trent', 232, 'GB', '53.00266800', '-2.17940400'),
        (2507, 'Bedford', 232, 'GB', '32.84401700', '-97.14306710'),
        (2508, 'Dungannon and South Tyrone Borough Council', 232, 'GB', '54.50826840', '-6.76658910'),
        (2509, 'Ceredigion', 232, 'GB', '52.21914290', '-3.93212560'),
        (2510, 'Worcestershire', 232, 'GB', '52.25452250', '-2.26683820'),
        (2511, 'Dundee', 232, 'GB', '56.46201800', '-2.97072100'),
        (2512, 'London Borough of Croydon', 232, 'GB', '51.38274460', '-0.09851630'),
        (2513, 'North Down Borough Council', 232, 'GB', '54.65362970', '-5.67249250'),
        (2514, 'City of Plymouth', 232, 'GB', '42.37089410', '-83.46971410'),
        (2515, 'Larne Borough Council', 232, 'GB', '54.85780030', '-5.82362240'),
        (2516, 'Leicestershire', 232, 'GB', '52.77257100', '-1.20521260'),
        (2517, 'Calderdale', 232, 'GB', '53.72478450', '-1.86583570'),
        (2518, 'Sefton', 232, 'GB', '53.50344490', '-2.97035900'),
        (2519, 'Midlothian', 232, 'GB', '32.47533500', '-97.01031810'),
        (2520, 'London Borough of Barnet', 232, 'GB', '51.60496730', '-0.20762950'),
        (2521, 'North Tyneside', 232, 'GB', '55.01823990', '-1.48584360'),
        (2522, 'North Yorkshire', 232, 'GB', '53.99150280', '-1.54120150'),
        (2523, 'Ards and North Down', 232, 'GB', '54.58996450', '-5.59849720'),
        (2524, 'Newport', 232, 'GB', '37.52782340', '-94.10438760'),
        (2525, 'Castlereagh', 232, 'GB', '54.57567900', '-5.88840280'),
        (2526, 'Surrey', 232, 'GB', '51.31475930', '-0.55995010'),
        (2527, 'Redcar and Cleveland', 232, 'GB', '54.59713440', '-1.07759970'),
        (2528, 'City and County of Cardiff', 232, 'GB', '51.48158100', '-3.17909000'),
        (2529, 'Bradford', 232, 'GB', '53.79598400', '-1.75939800'),
        (2530, 'Blaenau Gwent County Borough', 232, 'GB', '51.78757790', '-3.20439310'),
        (2531, 'Fermanagh District Council', 232, 'GB', '54.34479780', '-7.63842180'),
        (2532, 'London Borough of Ealing', 232, 'GB', '51.52503660', '-0.34139650'),
        (2533, 'Antrim', 232, 'GB', '54.71953380', '-6.20724980'),
        (2534, 'Newry, Mourne and Down', 232, 'GB', '54.24342870', '-5.95779590'),
        (2535, 'North Ayrshire', 232, 'GB', '55.64167310', '-4.75946000'),
        (2536, 'Tashkent', 236, 'UZ', '41.29949580', '69.24007340'),
        (2537, 'Namangan Region', 236, 'UZ', '41.05100370', '71.09731700'),
        (2538, 'Fergana Region', 236, 'UZ', '40.45680810', '71.28742090'),
        (2539, 'Xorazm Region', 236, 'UZ', '41.35653360', '60.85666860'),
        (2540, 'Andijan Region', 236, 'UZ', '40.76859410', '72.23637900'),
        (2541, 'Bukhara Region', 236, 'UZ', '40.25041620', '63.20321510'),
        (2542, 'Navoiy Region', 236, 'UZ', '42.69885750', '64.63376850'),
        (2543, 'Qashqadaryo Region', 236, 'UZ', '38.89862310', '66.04635340'),
        (2544, 'Samarqand Region', 236, 'UZ', '39.62701200', '66.97497310'),
        (2545, 'Jizzakh Region', 236, 'UZ', '40.47064150', '67.57085360'),
        (2546, 'Surxondaryo Region', 236, 'UZ', '37.94090050', '67.57085360'),
        (2547, 'Sirdaryo Region', 236, 'UZ', '40.38638080', '68.71549750'),
        (2548, 'Karakalpakstan', 236, 'UZ', '43.80413340', '59.44579880'),
        (2549, 'Tashkent Region', 236, 'UZ', '41.22132340', '69.85974060'),
        (2550, 'Ariana Governorate', 224, 'TN', '36.99227510', '10.12551640'),
        (2551, 'Bizerte Governorate', 224, 'TN', '37.16093970', '9.63413500'),
        (2552, 'Jendouba Governorate', 224, 'TN', '36.71818620', '8.74811670'),
        (2553, 'Monastir Governorate', 224, 'TN', '35.76425150', '10.81128850'),
        (2554, 'Tunis Governorate', 224, 'TN', '36.83749460', '10.19273890'),
        (2555, 'Manouba Governorate', 224, 'TN', '36.84465040', '9.85714160'),
        (2556, 'Gafsa Governorate', 224, 'TN', '34.37885050', '8.66005860'),
        (2557, 'Sfax Governorate', 224, 'TN', '34.86065810', '10.34978950'),
        (2558, 'Gabès Governorate', 224, 'TN', '33.94596480', '9.72326730'),
        (2559, 'Tataouine Governorate', 224, 'TN', '32.13441220', '10.08072980'),
        (2560, 'Medenine Governorate', 224, 'TN', '33.22805650', '10.89030990'),
        (2561, 'Kef Governorate', 224, 'TN', '36.12305120', '8.66005860'),
        (2562, 'Kebili Governorate', 224, 'TN', '33.70715510', '8.97146230'),
        (2563, 'Siliana Governorate', 224, 'TN', '36.08872080', '9.36453350'),
        (2564, 'Kairouan Governorate', 224, 'TN', '35.67116630', '10.10054690'),
        (2565, 'Zaghouan Governorate', 224, 'TN', '36.40911880', '10.14231720'),
        (2566, 'Ben Arous Governorate', 224, 'TN', '36.64356060', '10.21515780'),
        (2567, 'Sidi Bouzid Governorate', 224, 'TN', '35.03543860', '9.48393920'),
        (2568, 'Mahdia Governorate', 224, 'TN', '35.33525580', '10.89030990'),
        (2569, 'Tozeur Governorate', 224, 'TN', '33.97894910', '8.04651850'),
        (2570, 'Kasserine Governorate', 224, 'TN', '35.08091480', '8.66005860'),
        (2571, 'Sousse Governorate', 224, 'TN', '35.90222670', '10.34978950'),
        (2572, 'Kassrine', 224, 'TN', '35.17227160', '8.83076260'),
        (2573, 'Ratak Chain', 137, 'MH', '10.27632760', '170.55009370'),
        (2574, 'Ralik Chain', 137, 'MH', '8.13614600', '164.88679560'),
        (2575, 'Centrale Region', 220, 'TG', '8.65860290', '1.05861350'),
        (2576, 'Maritime', 220, 'TG', '41.65514930', '-83.52784670'),
        (2577, 'Plateaux Region', 220, 'TG', '7.61013780', '1.05861350'),
        (2578, 'Savanes Region', 220, 'TG', '10.52917810', '0.52578230'),
        (2579, 'Kara Region', 220, 'TG', '9.72163930', '1.05861350'),
        (2580, 'Chuuk State', 143, 'FM', '7.13867590', '151.55930650'),
        (2581, 'Pohnpei State', 143, 'FM', '6.85412540', '158.26238220'),
        (2582, 'Yap State', 143, 'FM', '8.67164900', '142.84393350'),
        (2583, 'Kosrae State', 143, 'FM', '5.30956180', '162.98148770'),
        (2584, 'Vaavu Atoll', 133, 'MV', '3.39554380', '73.51229280'),
        (2585, 'Shaviyani Atoll', 133, 'MV', '6.17511000', '73.13496050'),
        (2586, 'Haa Alif Atoll', 133, 'MV', '6.99034880', '72.94605660'),
        (2587, 'Alif Alif Atoll', 133, 'MV', '4.08500000', '72.85154790'),
        (2588, 'North Province', 133, 'MV', '8.88550270', '80.27673270'),
        (2589, 'North Central Province', 133, 'MV', NULL, NULL),
        (2590, 'Dhaalu Atoll', 133, 'MV', '2.84685020', '72.94605660'),
        (2591, 'Thaa Atoll', 133, 'MV', '2.43111610', '73.18216230'),
        (2592, 'Noonu Atoll', 133, 'MV', '5.85512760', '73.32370800'),
        (2593, 'Upper South Province', 133, 'MV', '0.23070000', '73.27948460'),
        (2594, 'Addu Atoll', 133, 'MV', '-0.63009950', '73.15856260'),
        (2595, 'Gnaviyani Atoll', 133, 'MV', '-0.30064250', '73.42391430'),
        (2596, 'Kaafu Atoll', 133, 'MV', '4.45589790', '73.55941280'),
        (2597, 'Haa Dhaalu Atoll', 133, 'MV', '6.57827170', '72.94605660'),
        (2598, 'Gaafu Alif Atoll', 133, 'MV', '0.61248130', '73.32370800'),
        (2599, 'Faafu Atoll', 133, 'MV', '3.23094090', '72.94605660'),
        (2600, 'Alif Dhaal Atoll', 133, 'MV', '3.65433020', '72.80427970'),
        (2601, 'Laamu Atoll', 133, 'MV', '1.94307370', '73.41802110'),
        (2602, 'Raa Atoll', 133, 'MV', '5.60064570', '72.94605660'),
        (2603, 'Gaafu Dhaalu Atoll', 133, 'MV', '0.35880400', '73.18216230'),
        (2604, 'Central Province', 133, 'MV', NULL, NULL),
        (2605, 'South Province', 133, 'MV', '-21.74820060', '166.17837390'),
        (2606, 'South Central Province', 133, 'MV', '7.25649960', '80.72144170'),
        (2607, 'Lhaviyani Atoll', 133, 'MV', '5.37470210', '73.51229280'),
        (2608, 'Meemu Atoll', 133, 'MV', '3.00903450', '73.51229280'),
        (2609, 'Malé', 133, 'MV', '46.34888670', '10.90724890'),
        (2610, 'Utrecht', 156, 'NL', '52.09073740', '5.12142010'),
        (2611, 'Gelderland', 156, 'NL', '52.04515500', '5.87182350'),
        (2612, 'North Holland', 156, 'NL', '52.52058690', '4.78847400'),
        (2613, 'Drenthe', 156, 'NL', '52.94760120', '6.62305860'),
        (2614, 'South Holland', 156, 'NL', '41.60086810', '-87.60698940'),
        (2615, 'Limburg', 156, 'NL', '51.44272380', '6.06087260'),
        (2616, 'Sint Eustatius', 156, 'NL', '17.48903060', '-62.97355500'),
        (2617, 'Groningen', 156, 'NL', '53.21938350', '6.56650170'),
        (2618, 'Overijssel', 156, 'NL', '52.43878140', '6.50164110'),
        (2619, 'Flevoland', 156, 'NL', '52.52797810', '5.59535080'),
        (2620, 'Zeeland', 156, 'NL', '51.49403090', '3.84968150'),
        (2621, 'Saba', 156, 'NL', '17.63546420', '-63.23267630'),
        (2622, 'Friesland', 156, 'NL', '53.16416420', '5.78175420'),
        (2623, 'North Brabant', 156, 'NL', '51.48265370', '5.23216870'),
        (2624, 'Bonaire', 156, 'NL', '12.20189020', '-68.26238220'),
        (2625, 'Savanes Region', 54, 'CI', NULL, NULL),
        (2626, 'Agnéby', 54, 'CI', '5.32245030', '-4.34495290'),
        (2627, 'Lagunes District', 54, 'CI', '5.88273340', '-4.23333550'),
        (2628, 'Sud-Bandama', 54, 'CI', '5.53570830', '-5.56172790'),
        (2629, 'Montagnes District', 54, 'CI', '7.37623730', '-7.43813550'),
        (2630, 'Moyen-Comoé', 54, 'CI', '6.65149170', '-3.50034540'),
        (2631, 'Marahoué Region', 54, 'CI', '6.88462070', '-5.89871390'),
        (2632, 'Lacs District', 54, 'CI', '48.19801690', '-80.45644120'),
        (2633, 'Fromager', 54, 'CI', '45.54502130', '-73.60462230'),
        (2634, 'Abidjan', 54, 'CI', '5.35995170', '-4.00825630'),
        (2635, 'Bas-Sassandra Region', 54, 'CI', '5.35679160', '-6.74939930'),
        (2636, 'Bafing Region', 54, 'CI', '8.32520470', '-7.52472430'),
        (2637, 'Vallée du Bandama District', 54, 'CI', '8.27897800', '-4.89356270'),
        (2638, 'Haut-Sassandra', 54, 'CI', '6.87578480', '-6.57833870'),
        (2639, 'Lagunes region', 54, 'CI', '5.88273340', '-4.23333550'),
        (2640, 'Lacs Region', 54, 'CI', '47.73958660', '-70.41866520'),
        (2641, 'Zanzan Region', 54, 'CI', '8.82079040', '-3.41955270'),
        (2642, 'Denguélé Region', 54, 'CI', '9.46623720', '-7.43813550'),
        (2643, 'Bas-Sassandra District', 54, 'CI', '5.27983560', '-6.15269850'),
        (2644, 'Denguélé District', 54, 'CI', '48.07077630', '-68.56093410'),
        (2645, 'Dix-Huit Montagnes', 54, 'CI', '7.37623730', '-7.43813550'),
        (2646, 'Moyen-Cavally', 54, 'CI', '6.52087930', '-7.61142170'),
        (2647, 'Vallée du Bandama Region', 54, 'CI', '8.27897800', '-4.89356270'),
        (2648, 'Sassandra-Marahoué District', 54, 'CI', '6.88033480', '-6.23759470'),
        (2649, 'Worodougou', 54, 'CI', '8.25489620', '-6.57833870'),
        (2650, 'Woroba District', 54, 'CI', '8.24913720', '-6.92091350'),
        (2651, 'Gôh-Djiboua District', 54, 'CI', '5.87113930', '-5.56172790'),
        (2652, 'Sud-Comoé', 54, 'CI', '5.55279300', '-3.25836260'),
        (2653, 'Yamoussoukro', 54, 'CI', '6.82762280', '-5.28934330'),
        (2654, 'Comoé District', 54, 'CI', '5.55279300', '-3.25836260'),
        (2655, 'N\'zi-Comoé', 54, 'CI', '7.24567490', '-4.23333550'),
        (2656, 'Far North', 38, 'CM', '66.76134510', '124.12375300'),
        (2657, 'Northwest', 38, 'CM', '36.37118570', '-94.19346060'),
        (2658, 'Southwest', 38, 'CM', '36.19088130', '-95.88974480'),
        (2659, 'South', 38, 'CM', '37.63159500', '-97.34584090'),
        (2660, 'Centre', 38, 'CM', NULL, NULL),
        (2661, 'East', 38, 'CM', '39.01853360', '-94.27924110'),
        (2662, 'Littoral', 38, 'CM', '48.46227570', '-68.51780710'),
        (2663, 'Adamawa', 38, 'CM', '9.32647510', '12.39838530'),
        (2664, 'West', 38, 'CM', '37.03649890', '-95.67059870'),
        (2665, 'North', 38, 'CM', '37.09024000', '-95.71289100'),
        (2666, 'Banjul', 80, 'GM', '13.45487610', '-16.57903230'),
        (2667, 'West Coast Division', 80, 'GM', '5.97727980', '116.07542880'),
        (2668, 'Upper River Division', 80, 'GM', '13.42573660', '-14.00723480'),
        (2669, 'Central River Division', 80, 'GM', '13.59944690', '-14.89216680'),
        (2670, 'Lower River Division', 80, 'GM', '13.35533060', '-15.92299000'),
        (2671, 'North Bank Division', 80, 'GM', '13.52854360', '-16.01699710'),
        (2672, 'Beyla Prefecture', 92, 'GN', '8.91981780', '-8.30884410'),
        (2673, 'Mandiana Prefecture', 92, 'GN', '10.61728270', '-8.69857160'),
        (2674, 'Yomou Prefecture', 92, 'GN', '7.56962790', '-9.25915710'),
        (2675, 'Fria Prefecture', 92, 'GN', '10.36745430', '-13.58418710'),
        (2676, 'Boké Region', 92, 'GN', '11.18646720', '-14.10013260'),
        (2677, 'Labé Region', 92, 'GN', '11.32320420', '-12.28913140'),
        (2678, 'Nzérékoré Prefecture', 92, 'GN', '7.74783590', '-8.82525020'),
        (2679, 'Dabola Prefecture', 92, 'GN', '10.72978060', '-11.11078540'),
        (2680, 'Labé Prefecture', 92, 'GN', '11.35419390', '-12.34638750'),
        (2681, 'Dubréka Prefecture', 92, 'GN', '9.79073480', '-13.51477350'),
        (2682, 'Faranah Prefecture', 92, 'GN', '9.90573990', '-10.80000510'),
        (2683, 'Forécariah Prefecture', 92, 'GN', '9.38861870', '-13.08179030'),
        (2684, 'Nzérékoré Region', 92, 'GN', '8.03858700', '-8.83627550'),
        (2685, 'Gaoual Prefecture', 92, 'GN', '11.57628040', '-13.35872880'),
        (2686, 'Conakry', 92, 'GN', '9.64118550', '-13.57840120'),
        (2687, 'Télimélé Prefecture', 92, 'GN', '10.90893640', '-13.02993310'),
        (2688, 'Dinguiraye Prefecture', 92, 'GN', '11.68442220', '-10.80000510'),
        (2689, 'Mamou Prefecture', 92, 'GN', '10.57360240', '-11.88917210'),
        (2690, 'Lélouma Prefecture', 92, 'GN', '11.18333300', '-12.93333300'),
        (2691, 'Kissidougou Prefecture', 92, 'GN', '9.22520220', '-10.08072980'),
        (2692, 'Koubia Prefecture', 92, 'GN', '11.58235400', '-11.89202370'),
        (2693, 'Kindia Prefecture', 92, 'GN', '10.10132920', '-12.71351210'),
        (2694, 'Pita Prefecture', 92, 'GN', '10.80620860', '-12.71351210'),
        (2695, 'Kouroussa Prefecture', 92, 'GN', '10.64892290', '-9.88505860'),
        (2696, 'Tougué Prefecture', 92, 'GN', '11.38415830', '-11.61577730'),
        (2697, 'Kankan Region', 92, 'GN', '10.12092300', '-9.54509740'),
        (2698, 'Mamou Region', 92, 'GN', '10.57360240', '-11.88917210'),
        (2699, 'Boffa Prefecture', 92, 'GN', '10.18082540', '-14.03916150'),
        (2700, 'Mali Prefecture', 92, 'GN', '11.98370900', '-12.25479190'),
        (2701, 'Kindia Region', 92, 'GN', '10.17816940', '-12.98961500'),
        (2702, 'Macenta Prefecture', 92, 'GN', '8.46157950', '-9.27855830'),
        (2703, 'Koundara Prefecture', 92, 'GN', '12.48940210', '-13.30675620'),
        (2704, 'Kankan Prefecture', 92, 'GN', '10.30344650', '-9.36730840'),
        (2705, 'Coyah Prefecture', 92, 'GN', '9.77155350', '-13.31252990'),
        (2706, 'Dalaba Prefecture', 92, 'GN', '10.68681760', '-12.24906970'),
        (2707, 'Siguiri Prefecture', 92, 'GN', '11.41481130', '-9.17883040'),
        (2708, 'Lola Prefecture', 92, 'GN', '7.96138180', '-8.39649380'),
        (2709, 'Boké Prefecture', 92, 'GN', '11.08473790', '-14.37919120'),
        (2710, 'Kérouané Prefecture', 92, 'GN', '9.25366430', '-9.01289260'),
        (2711, 'Guéckédou Prefecture', 92, 'GN', '8.56496880', '-10.13111630'),
        (2712, 'Tombali Region', 93, 'GW', '11.36326960', '-14.98561760'),
        (2713, 'Cacheu Region', 93, 'GW', '12.05514160', '-16.06401790'),
        (2714, 'Biombo Region', 93, 'GW', '11.85290610', '-15.73511710'),
        (2715, 'Quinara Region', 93, 'GW', '11.79556200', '-15.17268160'),
        (2716, 'Sul Province', 93, 'GW', '-10.28665780', '20.71224650'),
        (2717, 'Norte Province', 93, 'GW', '7.87218110', '123.88577470'),
        (2718, 'Oio Region', 93, 'GW', '12.27607090', '-15.31311850'),
        (2719, 'Gabú Region', 93, 'GW', '11.89624880', '-14.10013260'),
        (2720, 'Bafatá', 93, 'GW', '12.17352430', '-14.65295200'),
        (2721, 'Leste Province', 93, 'GW', NULL, NULL),
        (2722, 'Bolama Region', 93, 'GW', '11.14805910', '-16.13457050'),
        (2723, 'Woleu-Ntem Province', 79, 'GA', '2.29898270', '11.44669140'),
        (2724, 'Ogooué-Ivindo Province', 79, 'GA', '0.88183110', '13.17403480'),
        (2725, 'Nyanga Province', 79, 'GA', '-2.88210330', '11.16173560'),
        (2726, 'Haut-Ogooué Province', 79, 'GA', '-1.47625440', '13.91439900'),
        (2727, 'Estuaire Province', 79, 'GA', '0.44328640', '10.08072980'),
        (2728, 'Ogooué-Maritime Province', 79, 'GA', '-1.34659750', '9.72326730'),
        (2729, 'Ogooué-Lolo Province', 79, 'GA', '-0.88440930', '12.43805810'),
        (2730, 'Moyen-Ogooué Province', 79, 'GA', '-0.44278400', '10.43965600'),
        (2731, 'Ngounié Province', 79, 'GA', '-1.49303030', '10.98070030'),
        (2732, 'Tshuapa', 51, 'CD', '-0.99030230', '23.02888440'),
        (2733, 'Tanganyika', 51, 'CD', '-6.27401180', '27.92490020'),
        (2734, 'Haut-Uélé', 51, 'CD', '3.58451540', '28.29943500'),
        (2735, 'Kasaï Oriental', 51, 'CD', '-6.03362300', '23.57285010'),
        (2738, 'Sud-Kivu', 51, 'CD', '-3.01165800', '28.29943500'),
        (2739, 'Nord-Ubangi', 51, 'CD', '3.78787260', '21.47528510'),
        (2740, 'Kwango', 51, 'CD', '-6.43374090', '17.66888700'),
        (2741, 'Kinshasa', 51, 'CD', '-4.44193110', '15.26629310'),
        (2742, 'Kasaï Central', 51, 'CD', '-8.44045910', '20.41659340'),
        (2743, 'Sankuru', 51, 'CD', '-2.84374530', '23.38235450'),
        (2744, 'Équateur', 51, 'CD', '-1.83123900', '-78.18340600'),
        (2745, 'Maniema', 51, 'CD', '-3.07309290', '26.04138890'),
        (2746, 'Kongo Central', 51, 'CD', '-5.23656850', '13.91439900'),
        (2747, 'Lomami', 51, 'CD', '-6.14539310', '24.52426400'),
        (2748, 'Sud-Ubangi', 51, 'CD', '3.22999420', '19.18800470'),
        (2749, 'Nord-Kivu', 51, 'CD', '-0.79177290', '29.04599270'),
        (2750, 'Haut-Katanga', 51, 'CD', '-10.41020750', '27.54958460'),
        (2751, 'Ituri', 51, 'CD', '1.59576820', '29.41793240'),
        (2752, 'Mongala', 51, 'CD', '1.99623240', '21.47528510'),
        (2753, 'Bas-Uélé', 51, 'CD', '3.99010090', '24.90422080'),
        (2755, 'Mai-Ndombe', 51, 'CD', '-2.63574340', '18.42760470'),
        (2756, 'Tshopo', 51, 'CD', '0.54554620', '24.90422080'),
        (2757, 'Kasaï', 51, 'CD', '-5.04719790', '20.71224650'),
        (2758, 'Haut-Lomami', 51, 'CD', '-7.70527520', '24.90422080'),
        (2759, 'Kwilu', 51, 'CD', '-5.11888250', '18.42760470'),
        (2760, 'Cuyuni-Mazaruni', 94, 'GY', '6.46421410', '-60.21107520'),
        (2761, 'Potaro-Siparuni', 94, 'GY', '4.78558530', '-59.28799770'),
        (2762, 'Mahaica-Berbice', 94, 'GY', '6.23849600', '-57.91625550'),
        (2763, 'Upper Demerara-Berbice', 94, 'GY', '5.30648790', '-58.18929210'),
        (2764, 'Barima-Waini', 94, 'GY', '7.48824190', '-59.65644940'),
        (2765, 'Pomeroon-Supenaam', 94, 'GY', '7.12941660', '-58.92062950'),
        (2766, 'East Berbice-Corentyne', 94, 'GY', '2.74779220', '-57.46272590'),
        (2767, 'Demerara-Mahaica', 94, 'GY', '6.54642600', '-58.09820460'),
        (2768, 'Essequibo Islands-West Demerara', 94, 'GY', '6.57201320', '-58.46299970'),
        (2769, 'Upper Takutu-Upper Essequibo', 94, 'GY', '2.92395950', '-58.73736340'),
        (2770, 'Presidente Hayes Department', 172, 'PY', '-23.35126050', '-58.73736340'),
        (2771, 'Canindeyú', 172, 'PY', '-24.13787350', '-55.66896360'),
        (2772, 'Guairá Department', 172, 'PY', '-25.88109320', '-56.29293810'),
        (2773, 'Caaguazú', 172, 'PY', '-25.46458180', '-56.01385100'),
        (2774, 'Paraguarí Department', 172, 'PY', '-25.62621740', '-57.15206420'),
        (2775, 'Caazapá', 172, 'PY', '-26.18277130', '-56.37123270'),
        (2776, 'San Pedro Department', 172, 'PY', '-24.19486680', '-56.56164700'),
        (2777, 'Central Department', 172, 'PY', '36.15592290', '-95.96620750'),
        (2778, 'Itapúa', 172, 'PY', '-26.79236230', '-55.66896360'),
        (2779, 'Concepción Department', 172, 'PY', '-23.42142640', '-57.43444510'),
        (2780, 'Boquerón Department', 172, 'PY', '-21.74492540', '-60.95400730'),
        (2781, 'Ñeembucú Department', 172, 'PY', '-27.02991140', '-57.82539500'),
        (2782, 'Amambay Department', 172, 'PY', '-22.55902720', '-56.02499820'),
        (2783, 'Cordillera Department', 172, 'PY', '-25.22894910', '-57.01116810'),
        (2784, 'Alto Paraná Department', 172, 'PY', '-25.60755460', '-54.96118360'),
        (2785, 'Alto Paraguay Department', 172, 'PY', '-20.08525080', '-59.47209040'),
        (2786, 'Misiones Department', 172, 'PY', '-26.84335120', '-57.10131880'),
        (2787, 'Jaffna District', 208, 'LK', '9.69304680', '80.16518540'),
        (2788, 'Kandy District', 208, 'LK', '7.29315880', '80.63501070'),
        (2789, 'Kalutara District', 208, 'LK', '6.60846860', '80.14285840'),
        (2790, 'Badulla District', 208, 'LK', '6.99340090', '81.05498150'),
        (2791, 'Hambantota District', 208, 'LK', '6.15358160', '81.12714900'),
        (2792, 'Galle District', 208, 'LK', '6.05774900', '80.21755720'),
        (2793, 'Kilinochchi District', 208, 'LK', '9.36779710', '80.32131060'),
        (2794, 'Nuwara Eliya District', 208, 'LK', '6.96065320', '80.76927580'),
        (2795, 'Trincomalee District', 208, 'LK', '8.60130690', '81.11960750'),
        (2796, 'Puttalam District', 208, 'LK', '8.02599150', '79.84712720'),
        (2797, 'Kegalle District', 208, 'LK', '7.12040530', '80.32131060'),
        (2798, 'Central Province', 208, 'LK', NULL, NULL),
        (2799, 'Ampara District', 208, 'LK', '7.29116850', '81.67237610'),
        (2800, 'North Central Province', 208, 'LK', '8.19956380', '80.63269160'),
        (2801, 'Southern Province', 208, 'LK', NULL, NULL),
        (2802, 'Western Province', 208, 'LK', NULL, NULL),
        (2803, 'Sabaragamuwa Province', 208, 'LK', '6.73959410', '80.36586500'),
        (2804, 'Gampaha District', 208, 'LK', '7.07126190', '80.00877460'),
        (2805, 'Mannar District', 208, 'LK', '8.98095310', '79.90439750'),
        (2806, 'Matara District', 208, 'LK', '5.94493480', '80.54879970'),
        (2807, 'Ratnapura district', 208, 'LK', '6.70551680', '80.38483890'),
        (2808, 'Eastern Province', 208, 'LK', NULL, NULL),
        (2809, 'Vavuniya District', 208, 'LK', '8.75947390', '80.50003340'),
        (2810, 'Matale District', 208, 'LK', '7.46596460', '80.62342590'),
        (2811, 'Uva Province', 208, 'LK', '6.84276120', '81.33994140'),
        (2812, 'Polonnaruwa District', 208, 'LK', '7.93955670', '81.00034030'),
        (2813, 'Northern Province', 208, 'LK', NULL, NULL),
        (2814, 'Mullaitivu District', 208, 'LK', '9.26753880', '80.81282540'),
        (2815, 'Colombo District', 208, 'LK', '6.92695570', '79.86173060'),
        (2816, 'Anuradhapura District', 208, 'LK', '8.33183050', '80.40290170'),
        (2817, 'North Western Province', 208, 'LK', '7.75840910', '80.18750650'),
        (2818, 'Batticaloa District', 208, 'LK', '7.82927810', '81.47183870'),
        (2819, 'Monaragala District', 208, 'LK', '6.87277810', '81.35068320'),
        (2820, 'Mohéli', 49, 'KM', '-12.33773760', '43.73340890'),
        (2821, 'Anjouan', 49, 'KM', '-12.21381450', '44.43706060'),
        (2822, 'Grande Comore', 49, 'KM', '-11.71673380', '43.36807880'),
        (2823, 'Atacama', 44, 'CL', '-27.56605580', '-70.05031400'),
        (2824, 'Región Metropolitana de Santiago', 44, 'CL', '-33.43755450', '-70.65048960'),
        (2825, 'Coquimbo', 44, 'CL', '-30.54018100', '-70.81199530'),
        (2826, 'La Araucanía', 44, 'CL', '-38.94892100', '-72.33111300'),
        (2827, 'Biobío', 44, 'CL', '-37.44644280', '-72.14161320'),
        (2828, 'Aisén del General Carlos Ibañez del Campo', 44, 'CL', '-46.37834500', '-72.30076230'),
        (2829, 'Arica y Parinacota', 44, 'CL', '-18.59404850', '-69.47845410'),
        (2830, 'Valparaíso', 44, 'CL', '-33.04723800', '-71.61268850'),
        (2831, 'Ñuble', 44, 'CL', '-36.72257430', '-71.76224810'),
        (2832, 'Antofagasta', 44, 'CL', '-23.83691040', '-69.28775350'),
        (2833, 'Maule', 44, 'CL', '-35.51636030', '-71.57239530'),
        (2834, 'Los Ríos', 44, 'CL', '-40.23102170', '-72.33111300'),
        (2835, 'Los Lagos', 44, 'CL', '-41.91977790', '-72.14161320'),
        (2836, 'Magallanes y de la Antártica Chilena', 44, 'CL', '-52.20643160', '-72.16850010'),
        (2837, 'Tarapacá', 44, 'CL', '-20.20287990', '-69.28775350'),
        (2838, 'Libertador General Bernardo O\'Higgins', 44, 'CL', '-34.57553740', '-71.00223110'),
        (2839, 'Commewijne District', 210, 'SR', '5.74021100', '-54.87312190'),
        (2840, 'Nickerie District', 210, 'SR', '5.58554690', '-56.83111170'),
        (2841, 'Para District', 210, 'SR', '5.48173180', '-55.22592070'),
        (2842, 'Coronie District', 210, 'SR', '5.69432710', '-56.29293810'),
        (2843, 'Paramaribo District', 210, 'SR', '5.85203550', '-55.20382780'),
        (2844, 'Wanica District', 210, 'SR', '5.73237620', '-55.27012350'),
        (2845, 'Marowijne District', 210, 'SR', '5.62681280', '-54.25931180'),
        (2846, 'Brokopondo District', 210, 'SR', '4.77102470', '-55.04933750'),
        (2847, 'Sipaliwini District', 210, 'SR', '3.65673820', '-56.20353870'),
        (2848, 'Saramacca District', 210, 'SR', '5.72408130', '-55.66896360'),
        (2849, 'Riyadh', 194, 'SA', '22.75543850', '46.20915470'),
        (2850, 'Makkah', 194, 'SA', '21.52355840', '41.91964710'),
        (2851, 'Al Madinah', 194, 'SA', '24.84039770', '39.32062410'),
        (2852, 'Tabuk', 194, 'SA', '28.24533350', '37.63866220'),
        (2853, '\'Asir', 194, 'SA', '19.09690620', '42.86378750'),
        (2854, 'Northern Borders', 194, 'SA', '30.07991620', '42.86378750'),
        (2855, 'Ha\'il', 194, 'SA', '27.70761430', '41.91964710'),
        (2856, 'Eastern Province', 194, 'SA', '24.04399320', '45.65892250'),
        (2857, 'Al Jawf', 194, 'SA', '29.88735600', '39.32062410'),
        (2858, 'Jizan', 194, 'SA', '17.17381760', '42.70761070'),
        (2859, 'Al Bahah', 194, 'SA', '20.27227390', '41.44125100'),
        (2860, 'Najran', 194, 'SA', '18.35146640', '45.60071080'),
        (2861, 'Al-Qassim', 194, 'SA', '26.20782600', '43.48373800'),
        (2862, 'Plateaux Department', 50, 'CG', '-2.06800880', '15.40680790'),
        (2863, 'Pointe-Noire', 50, 'CG', '-4.76916230', '11.86636200'),
        (2864, 'Cuvette Department', 50, 'CG', '-0.28774460', '16.15809370'),
        (2865, 'Likouala Department', 50, 'CG', '2.04392400', '17.66888700'),
        (2866, 'Bouenza Department', 50, 'CG', '-4.11280790', '13.72891670'),
        (2867, 'Kouilou Department', 50, 'CG', '-4.14284130', '11.88917210'),
        (2868, 'Lékoumou Department', 50, 'CG', '-3.17038200', '13.35872880'),
        (2869, 'Cuvette-Ouest Department', 50, 'CG', '0.14475500', '14.47233010'),
        (2870, 'Brazzaville', 50, 'CG', '-4.26335970', '15.24288530'),
        (2871, 'Sangha Department', 50, 'CG', '1.46623280', '15.40680790'),
        (2872, 'Niari Department', 50, 'CG', '-3.18427000', '12.25479190'),
        (2873, 'Pool Department', 50, 'CG', '-3.77626280', '14.84546190'),
        (2874, 'Quindío', 48, 'CO', '4.46101910', '-75.66735600'),
        (2875, 'Cundinamarca', 48, 'CO', '5.02600300', '-74.03001220'),
        (2876, 'Chocó', 48, 'CO', '5.25280330', '-76.82596520'),
        (2877, 'Norte de Santander', 48, 'CO', '7.94628310', '-72.89880690'),
        (2878, 'Meta', 48, 'CO', '39.76732580', '-104.97535950'),
        (2879, 'Risaralda', 48, 'CO', '5.31584750', '-75.99276520'),
        (2880, 'Atlántico', 48, 'CO', '10.69661590', '-74.87410450'),
        (2881, 'Arauca', 48, 'CO', '6.54730600', '-71.00223110'),
        (2882, 'Guainía', 48, 'CO', '2.58539300', '-68.52471490'),
        (2883, 'Tolima', 48, 'CO', '4.09251680', '-75.15453810'),
        (2884, 'Cauca', 48, 'CO', '2.70498130', '-76.82596520'),
        (2885, 'Vaupés', 48, 'CO', '0.85535610', '-70.81199530'),
        (2886, 'Magdalena', 48, 'CO', '10.41130140', '-74.40566120'),
        (2887, 'Caldas', 48, 'CO', '5.29826000', '-75.24790610'),
        (2888, 'Guaviare', 48, 'CO', '2.04392400', '-72.33111300'),
        (2889, 'La Guajira', 48, 'CO', '11.35477430', '-72.52048270'),
        (2890, 'Antioquia', 48, 'CO', '7.19860640', '-75.34121790'),
        (2891, 'Caquetá', 48, 'CO', '0.86989200', '-73.84190630'),
        (2892, 'Casanare', 48, 'CO', '5.75892690', '-71.57239530'),
        (2893, 'Bolívar', 48, 'CO', '8.67043820', '-74.03001220'),
        (2894, 'Vichada', 48, 'CO', '4.42344520', '-69.28775350'),
        (2895, 'Amazonas', 48, 'CO', '-1.44291230', '-71.57239530'),
        (2896, 'Putumayo', 48, 'CO', '0.43595060', '-75.52766990'),
        (2897, 'Nariño', 48, 'CO', '1.28915100', '-77.35794000'),
        (2898, 'Córdoba', 48, 'CO', '8.04929300', '-75.57405000'),
        (2899, 'Cesar', 48, 'CO', '9.33729480', '-73.65362090'),
        (2900, 'San Andrés, Providencia y Santa Catalina', 48, 'CO', '12.55673240', '-81.71852530'),
        (2901, 'Santander', 48, 'CO', '6.64370760', '-73.65362090'),
        (2902, 'Sucre', 48, 'CO', '8.81397700', '-74.72328300'),
        (2903, 'Boyacá', 48, 'CO', '5.45451100', '-73.36200300'),
        (2904, 'Valle del Cauca', 48, 'CO', '3.80088930', '-76.64127120'),
        (2905, 'Galápagos Province', 64, 'EC', '-0.95376910', '-90.96560190'),
        (2906, 'Sucumbíos Province', 64, 'EC', '0.08892310', '-76.88975570'),
        (2907, 'Pastaza Province', 64, 'EC', '-1.48822650', '-78.00310570'),
        (2908, 'Tungurahua Province', 64, 'EC', '-1.26352840', '-78.56608520'),
        (2909, 'Zamora-Chinchipe Province', 64, 'EC', '-4.06558920', '-78.95035250'),
        (2910, 'Los Ríos Province', 64, 'EC', '-1.02306070', '-79.46088970'),
        (2911, 'Imbabura Province', 64, 'EC', '0.34997680', '-78.12601290'),
        (2912, 'Santa Elena Province', 64, 'EC', '-2.22671050', '-80.85949900'),
        (2913, 'Manabí Province', 64, 'EC', '-1.05434340', '-80.45264400'),
        (2914, 'Guayas Province', 64, 'EC', '-1.95748390', '-79.91927020'),
        (2915, 'Carchi Province', 64, 'EC', '0.50269120', '-77.90425210'),
        (2916, 'Napo Province', 64, 'EC', '-0.99559640', '-77.81296840'),
        (2917, 'Cañar Province', 64, 'EC', '-2.55893150', '-78.93881910'),
        (2918, 'Morona-Santiago Province', 64, 'EC', '-2.30510620', '-78.11468660'),
        (2919, 'Santo Domingo de los Tsáchilas Province', 64, 'EC', '-0.25218820', '-79.18793830'),
        (2920, 'Bolívar Province', 64, 'EC', '-1.70958280', '-79.04504290'),
        (2921, 'Cotopaxi Province', 64, 'EC', '-0.83842060', '-78.66626780'),
        (2922, 'Esmeraldas', 64, 'EC', '0.96817890', '-79.65172020'),
        (2923, 'Azuay Province', 64, 'EC', '-2.89430680', '-78.99683440'),
        (2924, 'El Oro Province', 64, 'EC', '-3.25924130', '-79.95835410'),
        (2925, 'Chimborazo Province', 64, 'EC', '-1.66479950', '-78.65432550'),
        (2926, 'Orellana Province', 64, 'EC', '-0.45451630', '-76.99502860'),
        (2927, 'Pichincha Province', 64, 'EC', '-0.14648470', '-78.47519450'),
        (2928, 'Obock Region', 60, 'DJ', '12.38956910', '43.01948970'),
        (2929, 'Djibouti', 60, 'DJ', '11.82513800', '42.59027500'),
        (2930, 'Dikhil Region', 60, 'DJ', '11.10543360', '42.37047440'),
        (2931, 'Tadjourah Region', 60, 'DJ', '11.93388850', '42.39383750'),
        (2932, 'Arta Region', 60, 'DJ', '11.52555280', '42.84794740'),
        (2933, 'Ali Sabieh Region', 60, 'DJ', '11.19289730', '42.94169800'),
        (2934, 'Hama Governorate', 215, 'SY', '35.18878650', '37.21158290'),
        (2935, 'Rif Dimashq Governorate', 215, 'SY', '33.51672890', '36.95410700'),
        (2936, 'As-Suwayda Governorate', 215, 'SY', '32.79891560', '36.78195050'),
        (2937, 'Deir ez-Zor Governorate', 215, 'SY', '35.28797980', '40.30886260'),
        (2938, 'Latakia Governorate', 215, 'SY', '35.61297910', '36.00232250'),
        (2939, 'Damascus Governorate', 215, 'SY', '33.51514440', '36.39313540'),
        (2940, 'Idlib Governorate', 215, 'SY', '35.82687980', '36.69572160'),
        (2941, 'Al-Hasakah Governorate', 215, 'SY', '36.40551500', '40.79691490'),
        (2942, 'Homs Governorate', 215, 'SY', '34.25671230', '38.31657250'),
        (2943, 'Quneitra Governorate', 215, 'SY', '33.07763180', '35.89341360'),
        (2944, 'Al-Raqqah Governorate', 215, 'SY', '35.95941060', '38.99810520'),
        (2945, 'Daraa Governorate', 215, 'SY', '32.92488130', '36.17626150'),
        (2946, 'Aleppo Governorate', 215, 'SY', '36.22623930', '37.46813960'),
        (2947, 'Tartus Governorate', 215, 'SY', '35.00066520', '36.00232250'),
        (2948, 'Fianarantsoa Province', 130, 'MG', '-22.35362400', '46.82528380'),
        (2949, 'Toliara Province', 130, 'MG', '-23.35161910', '43.68549360'),
        (2950, 'Antsiranana Province', 130, 'MG', '-13.77153900', '49.52799960'),
        (2951, 'Antananarivo Province', 130, 'MG', '-18.70514740', '46.82528380'),
        (2952, 'Toamasina Province', 130, 'MG', '-18.14428110', '49.39578360'),
        (2953, 'Mahajanga Province', 130, 'MG', '-16.52388300', '46.51626200'),
        (2954, 'Mogilev Region', 21, 'BY', '53.51017910', '30.40064440'),
        (2955, 'Gomel Region', 21, 'BY', '52.16487540', '29.13332510'),
        (2956, 'Grodno Region', 21, 'BY', '53.65999450', '25.34485710'),
        (2957, 'Minsk Region', 21, 'BY', '54.10678890', '27.41292450'),
        (2958, 'Minsk', 21, 'BY', '53.90060110', '27.55897200'),
        (2959, 'Brest Region', 21, 'BY', '52.52966410', '25.46064800'),
        (2960, 'Vitebsk Region', 21, 'BY', '55.29598330', '28.75836270'),
        (2961, 'Murqub', 124, 'LY', '32.45996770', '14.10013260'),
        (2962, 'Nuqat al Khams', 124, 'LY', '32.69149090', '11.88917210'),
        (2963, 'Zawiya District', 124, 'LY', '32.76302820', '12.73649620'),
        (2964, 'Al Wahat District', 124, 'LY', '29.04668080', '21.85685860'),
        (2965, 'Sabha District', 124, 'LY', '27.03654060', '14.42902360'),
        (2966, 'Derna District', 124, 'LY', '32.75561300', '22.63774320'),
        (2967, 'Murzuq District', 124, 'LY', '25.91822620', '13.92600010'),
        (2968, 'Marj District', 124, 'LY', '32.05503630', '21.18911510'),
        (2969, 'Ghat District', 124, 'LY', '24.96403710', '10.17592850'),
        (2970, 'Jufra', 124, 'LY', '27.98351350', '16.91225100'),
        (2971, 'Tripoli District', 124, 'LY', '32.64080210', '13.26634790'),
        (2972, 'Kufra District', 124, 'LY', '23.31123890', '21.85685860'),
        (2973, 'Wadi al Hayaa District', 124, 'LY', '26.42259260', '12.62162110'),
        (2974, 'Jabal al Gharbi District', 124, 'LY', '30.26380320', '12.80547530'),
        (2975, 'Wadi al Shatii District', 124, 'LY', '27.73514680', '12.43805810'),
        (2976, 'Nalut District', 124, 'LY', '31.87423480', '10.97504840'),
        (2977, 'Sirte District', 124, 'LY', '31.18968900', '16.57019270'),
        (2978, 'Misrata District', 124, 'LY', '32.32558840', '15.09925560'),
        (2979, 'Jafara', 124, 'LY', '32.45259040', '12.94355360'),
        (2980, 'Jabal al Akhdar', 124, 'LY', '23.18560810', '57.37138790'),
        (2981, 'Benghazi', 124, 'LY', '32.11942420', '20.08679090'),
        (2982, 'Ribeira Brava Municipality', 40, 'CV', '16.60707390', '-24.20338430'),
        (2983, 'Tarrafal', 40, 'CV', '15.27605780', '-23.74840770'),
        (2984, 'Ribeira Grande de Santiago', 40, 'CV', '14.98302980', '-23.65617250'),
        (2985, 'Santa Catarina', 40, 'CV', '-27.24233920', '-50.21885560'),
        (2986, 'São Domingos', 40, 'CV', '15.02861650', '-23.56392200'),
        (2987, 'Mosteiros', 40, 'CV', '37.89043480', '-25.82075560'),
        (2988, 'Praia', 40, 'CV', '14.93305000', '-23.51332670'),
        (2989, 'Porto Novo', 40, 'CV', '6.49685740', '2.62885230'),
        (2990, 'São Miguel', 40, 'CV', '37.78041100', '-25.49704660'),
        (2991, 'Maio Municipality', 40, 'CV', '15.20030980', '-23.16797930'),
        (2992, 'Sotavento Islands', 40, 'CV', '15.00000000', '-24.00000000'),
        (2993, 'São Lourenço dos Órgãos', 40, 'CV', '15.05378410', '-23.60856120'),
        (2994, 'Barlavento Islands', 40, 'CV', '16.82368450', '-23.99348810'),
        (2995, 'Santa Catarina do Fogo', 40, 'CV', '14.93091040', '-24.32225770'),
        (2996, 'Brava', 40, 'CV', '40.98977780', '-73.68357150'),
        (2997, 'Paul', 40, 'CV', '37.06250000', '-95.67706800'),
        (2998, 'Sal', 40, 'CV', '26.59581220', '-80.20450830'),
        (2999, 'Boa Vista', 40, 'CV', '38.74346600', '-120.73042970'),
        (3000, 'São Filipe', 40, 'CV', '14.89516790', '-24.49456360'),
        (3001, 'São Vicente', 40, 'CV', '-23.96071570', '-46.39620220'),
        (3002, 'Ribeira Grande', 40, 'CV', '37.82103690', '-25.51481370'),
        (3003, 'Tarrafal de São Nicolau', 40, 'CV', '16.56364980', '-24.35494200'),
        (3004, 'Santa Cruz', 40, 'CV', '36.97411710', '-122.03079630'),
        (3005, 'Schleswig-Holstein', 82, 'DE', '54.21936720', '9.69611670'),
        (3006, 'Baden-Württemberg', 82, 'DE', '48.66160370', '9.35013360'),
        (3007, 'Mecklenburg-Vorpommern', 82, 'DE', '53.61265050', '12.42959530'),
        (3008, 'Lower Saxony', 82, 'DE', '52.63670360', '9.84507660'),
        (3009, 'Bavaria', 82, 'DE', '48.79044720', '11.49788950'),
        (3010, 'Berlin', 82, 'DE', '52.52000660', '13.40495400'),
        (3011, 'Saxony-Anhalt', 82, 'DE', '51.95026490', '11.69227340'),
        (3013, 'Brandenburg', 82, 'DE', '52.41252870', '12.53164440'),
        (3014, 'Bremen', 82, 'DE', '53.07929620', '8.80169360'),
        (3015, 'Thuringia', 82, 'DE', '51.01098920', '10.84534600'),
        (3016, 'Hamburg', 82, 'DE', '53.55108460', '9.99368190'),
        (3017, 'North Rhine-Westphalia', 82, 'DE', '51.43323670', '7.66159380'),
        (3018, 'Hesse', 82, 'DE', '50.65205150', '9.16243760'),
        (3019, 'Rhineland-Palatinate', 82, 'DE', '50.11834600', '7.30895270'),
        (3020, 'Saarland', 82, 'DE', '49.39642340', '7.02296070'),
        (3021, 'Saxony', 82, 'DE', '51.10454070', '13.20173840'),
        (3022, 'Mafeteng District', 122, 'LS', '-29.80410080', '27.50261740'),
        (3023, 'Mohale\'s Hoek District', 122, 'LS', '-30.14259170', '27.46738450'),
        (3024, 'Mokhotlong District', 122, 'LS', '-29.25731930', '28.95286450'),
        (3025, 'Qacha\'s Nek District', 122, 'LS', '-30.11145650', '28.67897900'),
        (3026, 'Leribe District', 122, 'LS', '-28.86380650', '28.04788260'),
        (3027, 'Quthing District', 122, 'LS', '-30.40156870', '27.70801330'),
        (3028, 'Maseru District', 122, 'LS', '-29.51656500', '27.83114280'),
        (3029, 'Butha-Buthe District', 122, 'LS', '-28.76537540', '28.24681480'),
        (3030, 'Berea District', 122, 'LS', '41.36616140', '-81.85430260'),
        (3031, 'Thaba-Tseka District', 122, 'LS', '-29.52389750', '28.60897520'),
        (3032, 'Montserrado County', 123, 'LR', '6.55258150', '-10.52961150'),
        (3033, 'River Cess County', 123, 'LR', '5.90253280', '-9.45615500'),
        (3034, 'Bong County', 123, 'LR', '6.82950190', '-9.36730840'),
        (3035, 'Sinoe County', 123, 'LR', '5.49871000', '-8.66005860'),
        (3036, 'Grand Cape Mount County', 123, 'LR', '7.04677580', '-11.07117580'),
        (3037, 'Lofa County', 123, 'LR', '8.19111840', '-9.72326730'),
        (3038, 'River Gee County', 123, 'LR', '5.26048940', '-7.87216000'),
        (3039, 'Grand Gedeh County', 123, 'LR', '5.92220780', '-8.22129790'),
        (3040, 'Grand Bassa County', 123, 'LR', '6.23084520', '-9.81249350'),
        (3041, 'Bomi County', 123, 'LR', '6.75629260', '-10.84514670'),
        (3042, 'Maryland County', 123, 'LR', '39.04575490', '-76.64127120'),
        (3043, 'Margibi County', 123, 'LR', '6.51518750', '-10.30488970'),
        (3044, 'Gbarpolu County', 123, 'LR', '7.49526370', '-10.08072980'),
        (3045, 'Grand Kru County', 123, 'LR', '4.76138620', '-8.22129790'),
        (3046, 'Nimba', 123, 'LR', '7.61666670', '-8.41666670'),
        (3047, 'Ad Dhahirah Governorate', 166, 'OM', '23.21616740', '56.49074440'),
        (3048, 'Al Batinah North Governorate', 166, 'OM', '24.34198460', '56.72989040'),
        (3049, 'Al Batinah South Governorate', 166, 'OM', '23.43149030', '57.42397960'),
        (3050, 'Al Batinah Region', 166, 'OM', '24.34198460', '56.72989040'),
        (3051, 'Ash Sharqiyah Region', 166, 'OM', '22.71411960', '58.53080640'),
        (3052, 'Musandam Governorate', 166, 'OM', '26.19861440', '56.24609490'),
        (3053, 'Ash Sharqiyah North Governorate', 166, 'OM', '22.71411960', '58.53080640'),
        (3054, 'Ash Sharqiyah South Governorate', 166, 'OM', '22.01582490', '59.32519220'),
        (3055, 'Muscat Governorate', 166, 'OM', '23.58803070', '58.38287170'),
        (3056, 'Al Wusta Governorate', 166, 'OM', '19.95710780', '56.27568460'),
        (3057, 'Dhofar Governorate', 166, 'OM', '17.03221210', '54.14252140'),
        (3058, 'Ad Dakhiliyah Governorate', 166, 'OM', '22.85887580', '57.53943560'),
        (3059, 'Al Buraimi Governorate', 166, 'OM', '24.16714130', '56.11422530'),
        (3060, 'Ngamiland', 29, 'BW', '-19.19053210', '23.00119890'),
        (3061, 'Ghanzi District', 29, 'BW', '-21.86523140', '21.85685860'),
        (3062, 'Kgatleng District', 29, 'BW', '-24.19704450', '26.23046160'),
        (3063, 'Southern District', 29, 'BW', NULL, NULL),
        (3064, 'South-East District', 29, 'BW', '31.21637980', '-82.35270440'),
        (3065, 'North-West District', 29, 'BW', '39.34463070', '-76.68542830'),
        (3066, 'Kgalagadi District', 29, 'BW', '-24.75502850', '21.85685860'),
        (3067, 'Central District', 29, 'BW', NULL, NULL),
        (3068, 'North-East District', 29, 'BW', '37.58844610', '-94.68637820'),
        (3069, 'Kweneng District', 29, 'BW', '-23.83672490', '25.28375850'),
        (3070, 'Collines Department', 24, 'BJ', '8.30222970', '2.30244600'),
        (3071, 'Kouffo Department', 24, 'BJ', '7.00358940', '1.75388170'),
        (3072, 'Donga Department', 24, 'BJ', '9.71918670', '1.67606910'),
        (3073, 'Zou Department', 24, 'BJ', '7.34692680', '2.06651970'),
        (3074, 'Plateau Department', 24, 'BJ', '7.34451410', '2.53960300'),
        (3075, 'Mono Department', 24, 'BJ', '37.92186080', '-118.95286450'),
        (3076, 'Atakora Department', 24, 'BJ', '10.79549310', '1.67606910'),
        (3077, 'Alibori Department', 24, 'BJ', '10.96810930', '2.77798130'),
        (3078, 'Borgou Department', 24, 'BJ', '9.53408640', '2.77798130'),
        (3079, 'Atlantique Department', 24, 'BJ', '6.65883910', '2.22366670'),
        (3080, 'Ouémé Department', 24, 'BJ', '6.61481520', '2.49999180'),
        (3081, 'Littoral Department', 24, 'BJ', '6.38069730', '2.44063870'),
        (3082, 'Machinga District', 131, 'MW', '-14.94072630', '35.47819260'),
        (3083, 'Zomba District', 131, 'MW', '-15.37658570', '35.33565180'),
        (3084, 'Mwanza District', 131, 'MW', '-2.46711970', '32.89868120'),
        (3085, 'Nsanje District', 131, 'MW', '-16.72882020', '35.17087410'),
        (3086, 'Salima District', 131, 'MW', '-13.68095860', '34.41982430'),
        (3087, 'Chitipa district', 131, 'MW', '-9.70376550', '33.27002530'),
        (3088, 'Ntcheu District', 131, 'MW', '-14.90375380', '34.77407930'),
        (3089, 'Rumphi District', 131, 'MW', '-10.78515370', '34.33103640'),
        (3090, 'Dowa District', 131, 'MW', '-13.60412560', '33.88577470'),
        (3091, 'Karonga District', 131, 'MW', '-9.90363650', '33.97500180'),
        (3092, 'Central Region', 131, 'MW', NULL, NULL),
        (3093, 'Likoma District', 131, 'MW', '-12.05840050', '34.73540310'),
        (3094, 'Kasungu District', 131, 'MW', '-13.13670650', '33.25879300'),
        (3095, 'Nkhata Bay District', 131, 'MW', '-11.71850420', '34.33103640'),
        (3096, 'Balaka District', 131, 'MW', '-15.05065950', '35.08285880'),
        (3097, 'Dedza District', 131, 'MW', '-14.18945850', '34.24215970'),
        (3098, 'Thyolo District', 131, 'MW', '-16.12991770', '35.12687810'),
        (3099, 'Mchinji District', 131, 'MW', '-13.74015250', '32.98883190'),
        (3100, 'Nkhotakota District', 131, 'MW', '-12.75419610', '34.24215970'),
        (3101, 'Lilongwe District', 131, 'MW', '-14.04752280', '33.61757700'),
        (3102, 'Blantyre District', 131, 'MW', '-15.67785410', '34.95066250'),
        (3103, 'Mulanje District', 131, 'MW', '-15.93464340', '35.52200120'),
        (3104, 'Mzimba District', 131, 'MW', '-11.74754520', '33.52800720'),
        (3105, 'Northern Region', 131, 'MW', NULL, NULL),
        (3106, 'Southern Region', 131, 'MW', '32.75049570', '-97.33154760'),
        (3107, 'Chikwawa District', 131, 'MW', '-16.19584460', '34.77407930'),
        (3108, 'Phalombe District', 131, 'MW', '-15.70920380', '35.65328480'),
        (3109, 'Chiradzulu District', 131, 'MW', '-15.74231510', '35.25879640'),
        (3110, 'Mangochi District', 131, 'MW', '-14.13882480', '35.03881640'),
        (3111, 'Ntchisi District', 131, 'MW', '-13.28419920', '33.88577470'),
        (3112, 'Kénédougou Province', 35, 'BF', '11.39193950', '-4.97665400'),
        (3113, 'Namentenga Province', 35, 'BF', '13.08125840', '-0.52578230'),
        (3114, 'Sahel Region', 35, 'BF', '14.10008650', '-0.14949880'),
        (3115, 'Centre-Ouest Region', 35, 'BF', '11.87984660', '-2.30244600'),
        (3116, 'Nahouri Province', 35, 'BF', '11.25022670', '-1.13530200'),
        (3117, 'Passoré Province', 35, 'BF', '12.88812210', '-2.22366670'),
        (3118, 'Zoundwéogo Province', 35, 'BF', '11.61411740', '-0.98206680'),
        (3119, 'Sissili Province', 35, 'BF', '11.24412190', '-2.22366670'),
        (3120, 'Banwa Province', 35, 'BF', '12.13230530', '-4.15137640'),
        (3121, 'Bougouriba Province', 35, 'BF', '10.87226460', '-3.33889170'),
        (3122, 'Gnagna Province', 35, 'BF', '12.89749920', '0.07467670'),
        (3123, 'Mouhoun', 35, 'BF', '12.14323810', '-3.33889170'),
        (3124, 'Yagha Province', 35, 'BF', '13.35761570', '0.75328090'),
        (3125, 'Plateau-Central Region', 35, 'BF', '12.25376480', '-0.75328090'),
        (3126, 'Sanmatenga Province', 35, 'BF', '13.35653040', '-1.05861350'),
        (3127, 'Centre-Nord Region', 35, 'BF', '13.17244640', '-0.90566230'),
        (3128, 'Tapoa Province', 35, 'BF', '12.24970720', '1.67606910'),
        (3129, 'Houet Province', 35, 'BF', '11.13204470', '-4.23333550'),
        (3130, 'Zondoma Province', 35, 'BF', '13.11659260', '-2.42087130'),
        (3131, 'Boulgou', 35, 'BF', '11.43367660', '-0.37483540'),
        (3132, 'Komondjari Province', 35, 'BF', '12.71265270', '0.67730460'),
        (3133, 'Koulpélogo Province', 35, 'BF', '11.52476740', '0.14949880'),
        (3134, 'Tuy Province', 35, 'BF', '38.88868400', '-77.00471900'),
        (3135, 'Ioba Province', 35, 'BF', '11.05620340', '-3.01757120'),
        (3136, 'Centre', 35, 'BF', NULL, NULL),
        (3137, 'Sourou Province', 35, 'BF', '13.34180300', '-2.93757390'),
        (3138, 'Boucle du Mouhoun Region', 35, 'BF', '12.41660000', '-3.41955270'),
        (3139, 'Séno Province', 35, 'BF', '14.00722340', '-0.07467670'),
        (3140, 'Sud-Ouest Region', 35, 'BF', '10.42314930', '-3.25836260'),
        (3141, 'Oubritenga Province', 35, 'BF', '12.70960870', '-1.44346900'),
        (3142, 'Nayala Province', 35, 'BF', '12.69645580', '-3.01757120'),
        (3143, 'Gourma Province', 35, 'BF', '12.16244730', '0.67730460'),
        (3144, 'Oudalan Province', 35, 'BF', '14.47190200', '-0.45023680'),
        (3145, 'Ziro Province', 35, 'BF', '11.60949950', '-1.90992380'),
        (3146, 'Kossi Province', 35, 'BF', '12.96045800', '-3.90626880'),
        (3147, 'Kourwéogo Province', 35, 'BF', '12.70774950', '-1.75388170'),
        (3148, 'Ganzourgou Province', 35, 'BF', '12.25376480', '-0.75328090'),
        (3149, 'Centre-Sud Region', 35, 'BF', '11.52289110', '-1.05861350'),
        (3150, 'Yatenga Province', 35, 'BF', '13.62493440', '-2.38136210'),
        (3151, 'Loroum Province', 35, 'BF', '13.81298140', '-2.06651970'),
        (3152, 'Bazèga Province', 35, 'BF', '11.97676920', '-1.44346900'),
        (3153, 'Cascades Region', 35, 'BF', '10.40729920', '-4.56244260'),
        (3154, 'Sanguié Province', 35, 'BF', '12.15018610', '-2.69838680'),
        (3155, 'Bam Province', 35, 'BF', '13.44613300', '-1.59839590'),
        (3156, 'Noumbiel Province', 35, 'BF', '9.84409460', '-2.97755580'),
        (3157, 'Kompienga Province', 35, 'BF', '11.52383620', '0.75328090'),
        (3158, 'Est Region', 35, 'BF', '12.43655260', '0.90566230'),
        (3159, 'Léraba Province', 35, 'BF', '10.66487850', '-5.31025050'),
        (3160, 'Balé Province', 35, 'BF', '11.78206020', '-3.01757120'),
        (3161, 'Kouritenga Province', 35, 'BF', '12.16318130', '-0.22446620'),
        (3162, 'Centre-Est Region', 35, 'BF', '11.52476740', '-0.14949880'),
        (3163, 'Poni Province', 35, 'BF', '10.33259960', '-3.33889170'),
        (3164, 'Nord Region, Burkina Faso', 35, 'BF', '13.71825200', '-2.30244600'),
        (3165, 'Hauts-Bassins Region', 35, 'BF', '11.49420030', '-4.23333550'),
        (3166, 'Soum Province', 35, 'BF', '14.09628410', '-1.36621600'),
        (3167, 'Comoé Province', 35, 'BF', '10.40729920', '-4.56244260'),
        (3168, 'Kadiogo Province', 35, 'BF', '12.34258970', '-1.44346900'),
        (3169, 'Islamabad Capital Territory', 167, 'PK', '33.72049970', '73.04052770'),
        (3170, 'Gilgit-Baltistan', 167, 'PK', '35.80256670', '74.98318080'),
        (3171, 'Khyber Pakhtunkhwa', 167, 'PK', '34.95262050', '72.33111300'),
        (3172, 'Azad Kashmir', 167, 'PK', '33.92590550', '73.78103340'),
        (3173, 'Federally Administered Tribal Areas', 167, 'PK', '32.66747600', '69.85974060'),
        (3174, 'Balochistan', 167, 'PK', '28.49073320', '65.09577920'),
        (3175, 'Sindh', 167, 'PK', '25.89430180', '68.52471490'),
        (3176, 'Punjab', 167, 'PK', '31.14713050', '75.34121790'),
        (3177, 'Al Rayyan Municipality', 179, 'QA', '25.25225510', '51.43887130'),
        (3178, 'Al-Shahaniya', 179, 'QA', '25.41063860', '51.18460250'),
        (3179, 'Al Wakrah', 179, 'QA', '25.16593140', '51.59755240'),
        (3180, 'Madinat ash Shamal', 179, 'QA', '26.11827430', '51.21572650'),
        (3181, 'Doha', 179, 'QA', '25.28544730', '51.53103980'),
        (3182, 'Al Daayen', 179, 'QA', '25.57845590', '51.48213870'),
        (3183, 'Al Khor', 179, 'QA', '25.68040780', '51.49685020'),
        (3184, 'Umm Salal Municipality', 179, 'QA', '25.48752420', '51.39656800'),
        (3185, 'Rumonge Province', 36, 'BI', '-3.97540490', '29.43880140'),
        (3186, 'Muyinga Province', 36, 'BI', '-2.77935110', '30.29741990'),
        (3187, 'Mwaro Province', 36, 'BI', '-3.50259180', '29.64991620'),
        (3188, 'Makamba Province', 36, 'BI', '-4.32570620', '29.69626770'),
        (3189, 'Rutana Province', 36, 'BI', '-3.87915230', '30.06652360'),
        (3190, 'Cibitoke Province', 36, 'BI', '-2.81028970', '29.18557850'),
        (3191, 'Ruyigi Province', 36, 'BI', '-3.44620700', '30.25127280'),
        (3192, 'Kayanza Province', 36, 'BI', '-3.00779810', '29.64991620'),
        (3193, 'Muramvya Province', 36, 'BI', '-3.28983980', '29.64991620'),
        (3194, 'Karuzi Province', 36, 'BI', '-3.13403470', '30.11273500'),
        (3195, 'Kirundo Province', 36, 'BI', '-2.57628820', '30.11273500'),
        (3196, 'Bubanza Province', 36, 'BI', '-3.15724030', '29.37149090'),
        (3197, 'Gitega Province', 36, 'BI', '-3.49290510', '29.92779470'),
        (3198, 'Bujumbura Mairie Province', 36, 'BI', '-3.38841410', '29.34826460'),
        (3199, 'Ngozi Province', 36, 'BI', '-2.89582430', '29.88152030'),
        (3200, 'Bujumbura Rural Province', 36, 'BI', '-3.50901440', '29.46435900'),
        (3201, 'Cankuzo Province', 36, 'BI', '-3.15277880', '30.61998950'),
        (3202, 'Bururi Province', 36, 'BI', '-3.90068510', '29.51077080'),
        (3203, 'Flores Department', 235, 'UY', '-33.57337530', '-56.89450280'),
        (3204, 'San José Department', 235, 'UY', '37.34929680', '-121.90560490'),
        (3205, 'Artigas Department', 235, 'UY', '-30.61751120', '-56.95945590'),
        (3206, 'Maldonado Department', 235, 'UY', '-34.55979320', '-54.86285520'),
        (3207, 'Rivera Department', 235, 'UY', '-31.48174210', '-55.24357590'),
        (3208, 'Colonia Department', 235, 'UY', '-34.12946780', '-57.66051840'),
        (3209, 'Durazno Department', 235, 'UY', '-33.02324540', '-56.02846440'),
        (3210, 'Río Negro Department', 235, 'UY', '-32.76763560', '-57.42952070'),
        (3211, 'Cerro Largo Department', 235, 'UY', '-32.44110320', '-54.35217530'),
        (3212, 'Paysandú Department', 235, 'UY', '-32.06673660', '-57.33647890'),
        (3213, 'Canelones Department', 235, 'UY', '-34.54087170', '-55.93076000'),
        (3214, 'Treinta y Tres Department', 235, 'UY', '-33.06850860', '-54.28586270'),
        (3215, 'Lavalleja Department', 235, 'UY', '-33.92261750', '-54.97657940'),
        (3216, 'Rocha Department', 235, 'UY', '-33.96900810', '-54.02148500'),
        (3217, 'Florida Department', 235, 'UY', '28.03594950', '-82.45792890'),
        (3218, 'Montevideo Department', 235, 'UY', '-34.81815870', '-56.21382560'),
        (3219, 'Soriano Department', 235, 'UY', '-33.51027920', '-57.74981030'),
        (3220, 'Salto Department', 235, 'UY', '-31.38802800', '-57.96124550'),
        (3221, 'Tacuarembó Department', 235, 'UY', '-31.72068370', '-55.98598870'),
        (3222, 'Kafr el-Sheikh Governorate', 65, 'EG', '31.30854440', '30.80394740'),
        (3223, 'Cairo Governorate', 65, 'EG', '29.95375640', '31.53700030'),
        (3224, 'Damietta Governorate', 65, 'EG', '31.36257990', '31.67393710'),
        (3225, 'Aswan Governorate', 65, 'EG', '23.69664980', '32.71813750'),
        (3226, 'Sohag Governorate', 65, 'EG', '26.69383400', '32.17460500'),
        (3227, 'North Sinai Governorate', 65, 'EG', '30.28236500', '33.61757700'),
        (3228, 'Monufia Governorate', 65, 'EG', '30.59724550', '30.98763210'),
        (3229, 'Port Said Governorate', 65, 'EG', '31.07586060', '32.26538870'),
        (3230, 'Beni Suef Governorate', 65, 'EG', '28.89388370', '31.44561790'),
        (3231, 'Matrouh Governorate', 65, 'EG', '29.56963500', '26.41938900'),
        (3232, 'Qalyubia Governorate', 65, 'EG', '30.32923680', '31.21684660'),
        (3233, 'Suez Governorate', 65, 'EG', '29.36822550', '32.17460500'),
        (3234, 'Gharbia Governorate', 65, 'EG', '30.87535560', '31.03351000'),
        (3235, 'Alexandria Governorate', 65, 'EG', '30.87605680', '29.74260400'),
        (3236, 'Asyut Governorate', 65, 'EG', '27.21338310', '31.44561790'),
        (3237, 'South Sinai Governorate', 65, 'EG', '29.31018280', '34.15319470'),
        (3238, 'Faiyum Governorate', 65, 'EG', '29.30840210', '30.84284970'),
        (3239, 'Giza Governorate', 65, 'EG', '28.76662160', '29.23207840'),
        (3240, 'Red Sea Governorate', 65, 'EG', '24.68263160', '34.15319470'),
        (3241, 'Beheira Governorate', 65, 'EG', '30.84809860', '30.34355060'),
        (3242, 'Luxor Governorate', 65, 'EG', '25.39444440', '32.49200880'),
        (3243, 'Minya Governorate', 65, 'EG', '28.28472900', '30.52790960'),
        (3244, 'Ismailia Governorate', 65, 'EG', '30.58309340', '32.26538870'),
        (3245, 'Dakahlia Governorate', 65, 'EG', '31.16560440', '31.49131820'),
        (3246, 'New Valley Governorate', 65, 'EG', '24.54556380', '27.17353160'),
        (3247, 'Qena Governorate', 65, 'EG', '26.23460330', '32.98883190'),
        (3248, 'Agaléga', 140, 'MU', '-10.40000000', '56.61666670'),
        (3249, 'Rodrigues', 140, 'MU', '-19.72453850', '63.42721850'),
        (3250, 'Pamplemousses District', 140, 'MU', '-20.11360080', '57.57592600'),
        (3251, 'Cargados Carajos', 140, 'MU', '-16.58333300', '59.61666700'),
        (3252, 'Vacoas-Phoenix', 140, 'MU', '-20.29840260', '57.49383550'),
        (3253, 'Moka District', 140, 'MU', '-20.23997820', '57.57592600'),
        (3254, 'Flacq District', 140, 'MU', '-20.22578360', '57.71192740'),
        (3255, 'Curepipe', 140, 'MU', '-20.31708720', '57.52652890'),
        (3256, 'Port Louis', 140, 'MU', '-20.16089120', '57.50122220'),
        (3257, 'Savanne District', 140, 'MU', '-20.47395300', '57.48535610'),
        (3258, 'Quatre Bornes', 140, 'MU', '-20.26747180', '57.47969810'),
        (3259, 'Rivière Noire District', 140, 'MU', '-20.37084920', '57.39486490'),
        (3260, 'Port Louis District', 140, 'MU', '-20.16089120', '57.50122220'),
        (3261, 'Rivière du Rempart District', 140, 'MU', '-20.05609830', '57.65523890'),
        (3262, 'Beau Bassin-Rose Hill', 140, 'MU', '-20.22303050', '57.46838300'),
        (3263, 'Plaines Wilhems District', 140, 'MU', '-20.30548720', '57.48535610'),
        (3264, 'Grand Port District', 140, 'MU', '-20.38515460', '57.66657420'),
        (3265, 'Guelmim', 149, 'MA', '28.98836590', '-10.05274980'),
        (3266, 'Aousserd (EH)', 149, 'MA', '22.55215380', '-14.32973530'),
        (3267, 'Al Hoceïma', 149, 'MA', '35.24455890', '-3.93174680'),
        (3268, 'Larache', 149, 'MA', '35.17442710', '-6.14739640'),
        (3269, 'Ouarzazate', 149, 'MA', '30.93354360', '-6.93701600'),
        (3270, 'Boulemane', 149, 'MA', '33.36251590', '-4.73033970'),
        (3271, 'L\'Oriental', 149, 'MA', '37.06968300', '-94.51227700'),
        (3272, 'Béni Mellal', 149, 'MA', '32.34244300', '-6.37579900'),
        (3274, 'Chichaoua', 149, 'MA', '31.53835810', '-8.76463880'),
        (3275, 'Boujdour (EH)', 149, 'MA', '26.12524930', '-14.48473470'),
        (3276, 'Khémisset', 149, 'MA', '33.81537040', '-6.05733020'),
        (3277, 'Tiznit', 149, 'MA', '29.69339200', '-9.73215700'),
        (3278, 'Béni Mellal-Khénifra', 149, 'MA', '32.57191840', '-6.06791940'),
        (3279, 'Sidi Kacem', 149, 'MA', '34.22601720', '-5.71291640'),
        (3280, 'El Jadida', 149, 'MA', '33.23163260', '-8.50071160'),
        (3281, 'Nador', 149, 'MA', '34.91719260', '-2.85771050'),
        (3282, 'Settat', 149, 'MA', '32.99242420', '-7.62226650'),
        (3283, 'Zagora', 149, 'MA', '30.57860930', '-5.89871390'),
        (3284, 'Médiouna', 149, 'MA', '33.45409390', '-7.51660200'),
        (3285, 'Berkane', 149, 'MA', '34.88408760', '-2.34188700'),
        (3286, 'Tan-Tan (EH-partial)', 149, 'MA', '28.03012000', '-11.16173560'),
        (3287, 'Nouaceur', 149, 'MA', '33.36703930', '-7.57325370'),
        (3288, 'Marrakesh-Safi', 149, 'MA', '31.73308330', '-8.13385580'),
        (3289, 'Sefrou', 149, 'MA', '33.83052440', '-4.83531540'),
        (3290, 'Drâa-Tafilalet', 149, 'MA', '31.14995380', '-5.39395510'),
        (3291, 'El Hajeb', 149, 'MA', '33.68573500', '-5.36778440'),
        (3292, 'Es-Semara (EH-partial)', 149, 'MA', '26.74185600', '-11.67836710'),
        (3293, 'Laâyoune (EH)', 149, 'MA', '27.15003840', '-13.19907580'),
        (3294, 'Inezgane-Ait Melloul', 149, 'MA', '30.35090980', '-9.38951100'),
        (3295, 'Souss-Massa', 149, 'MA', '30.27506110', '-8.13385580'),
        (3296, 'Taza', 149, 'MA', '34.27889530', '-3.58126920'),
        (3297, 'Assa-Zag (EH-partial)', 149, 'MA', '28.14023950', '-9.72326730'),
        (3298, 'Laâyoune-Sakia El Hamra (EH-partial)', 149, 'MA', '27.86831940', '-11.98046130'),
        (3299, 'Errachidia', 149, 'MA', '31.90512750', '-4.72775280'),
        (3300, 'Fahs-Anjra', 149, 'MA', '35.76019920', '-5.66683060'),
        (3301, 'Figuig', 149, 'MA', '32.10926130', '-1.22980600'),
        (3302, 'Chtouka-Ait Baha', 149, 'MA', '30.10724220', '-9.27855830'),
        (3303, 'Casablanca-Settat', 149, 'MA', '33.21608720', '-7.43813550'),
        (3304, 'Benslimane', 149, 'MA', '33.61896980', '-7.13055360'),
        (3305, 'Guelmim-Oued Noun (EH-partial)', 149, 'MA', '28.48442810', '-10.08072980'),
        (3306, 'Dakhla-Oued Ed-Dahab (EH)', 149, 'MA', '22.73378920', '-14.28611160'),
        (3307, 'Jerada', 149, 'MA', '34.30617910', '-2.17941360'),
        (3308, 'Kénitra', 149, 'MA', '34.25405030', '-6.58901660'),
        (3309, 'El Kelâa des Sraghna', 149, 'MA', '32.05227670', '-7.35165580'),
        (3310, 'Chefchaouen', 149, 'MA', '35.01817200', '-5.14320680'),
        (3311, 'Safi', 149, 'MA', '32.29898720', '-9.10134980'),
        (3312, 'Tata', 149, 'MA', '29.75087700', '-7.97563430'),
        (3313, 'Fès-Meknès', 149, 'MA', '34.06252900', '-4.72775280'),
        (3314, 'Taroudannt', 149, 'MA', '30.47271260', '-8.87487650'),
        (3315, 'Moulay Yacoub', 149, 'MA', '34.08744790', '-5.17840190'),
        (3316, 'Essaouira', 149, 'MA', '31.50849260', '-9.75950410'),
        (3317, 'Khénifra', 149, 'MA', '32.93404710', '-5.66157100'),
        (3318, 'Tétouan', 149, 'MA', '35.58889950', '-5.36255160'),
        (3319, 'Oued Ed-Dahab (EH)', 149, 'MA', '22.73378920', '-14.28611160'),
        (3320, 'Al Haouz', 149, 'MA', '31.29567290', '-7.87216000'),
        (3321, 'Azilal', 149, 'MA', '32.00426200', '-6.57833870'),
        (3322, 'Taourirt', 149, 'MA', '34.21259800', '-2.69838680'),
        (3323, 'Taounate', 149, 'MA', '34.53691700', '-4.63986930'),
        (3324, 'Tanger-Tétouan-Al Hoceïma', 149, 'MA', '35.26295580', '-5.56172790'),
        (3325, 'Ifrane', 149, 'MA', '33.52280620', '-5.11095520'),
        (3326, 'Khouribga', 149, 'MA', '32.88602300', '-6.92086550'),
        (3327, 'Cabo Delgado Province', 150, 'MZ', '-12.33354740', '39.32062410'),
        (3328, 'Zambezia Province', 150, 'MZ', '-16.56389870', '36.60939260'),
        (3329, 'Gaza Province', 150, 'MZ', '-23.02219280', '32.71813750'),
        (3330, 'Inhambane Province', 150, 'MZ', '-22.85279970', '34.55087580'),
        (3331, 'Sofala Province', 150, 'MZ', '-19.20390730', '34.86241660'),
        (3332, 'Maputo Province', 150, 'MZ', '-25.25698760', '32.53727410'),
        (3333, 'Niassa Province', 150, 'MZ', '-12.78262020', '36.60939260'),
        (3334, 'Tete Province', 150, 'MZ', '-15.65960560', '32.71813750'),
        (3335, 'Maputo', 150, 'MZ', '-25.96924800', '32.57317460'),
        (3336, 'Nampula Province', 150, 'MZ', '-14.76049310', '39.32062410'),
        (3337, 'Manica Province', 150, 'MZ', '-19.50597870', '33.43835300'),
        (3338, 'Hodh Ech Chargui Region', 139, 'MR', '18.67370260', '-7.09287700'),
        (3339, 'Brakna Region', 139, 'MR', '17.23175610', '-13.17403480'),
        (3340, 'Tiris Zemmour Region', 139, 'MR', '24.57737640', '-9.90181310'),
        (3341, 'Gorgol Region', 139, 'MR', '15.97173570', '-12.62162110'),
        (3342, 'Inchiri Region', 139, 'MR', '20.02805610', '-15.40680790'),
        (3343, 'Nouakchott-Nord Region', 139, 'MR', '18.11302050', '-15.89949560'),
        (3344, 'Adrar Region', 139, 'MR', '19.86521760', '-12.80547530'),
        (3345, 'Tagant Region', 139, 'MR', '18.54675270', '-9.90181310'),
        (3346, 'Dakhlet Nouadhibou', 139, 'MR', '20.59855880', '-16.25221430'),
        (3347, 'Nouakchott-Sud Region', 139, 'MR', '17.97092880', '-15.94648740'),
        (3348, 'Trarza Region', 139, 'MR', '17.86649640', '-14.65878210'),
        (3349, 'Assaba Region', 139, 'MR', '16.77595580', '-11.52480550'),
        (3350, 'Guidimaka Region', 139, 'MR', '15.25573310', '-12.25479190'),
        (3351, 'Hodh El Gharbi Region', 139, 'MR', '16.69121490', '-9.54509740'),
        (3352, 'Nouakchott-Ouest Region', 139, 'MR', '18.15113570', '-15.99349100'),
        (3353, 'Western Tobago', 223, 'TT', '11.18970720', '-60.77954520'),
        (3354, 'Couva-Tabaquite-Talparo Regional Corporation', 223, 'TT', '10.42971450', '-61.37352100'),
        (3355, 'Eastern Tobago', 223, 'TT', '11.29793480', '-60.55885240'),
        (3356, 'Rio Claro-Mayaro Regional Corporation', 223, 'TT', '10.24128320', '-61.09372060'),
        (3357, 'San Juan-Laventille Regional Corporation', 223, 'TT', '10.69085780', '-61.45522130'),
        (3358, 'Tunapuna-Piarco Regional Corporation', 223, 'TT', '10.68590960', '-61.30352480'),
        (3359, 'San Fernando', 223, 'TT', '34.28194610', '-118.43897190'),
        (3360, 'Point Fortin', 223, 'TT', '10.17027370', '-61.67133860'),
        (3361, 'Sangre Grande Regional Corporation', 223, 'TT', '10.58529390', '-61.13158130'),
        (3362, 'Arima', 223, 'TT', '46.79316040', '-71.25843110'),
        (3363, 'Port of Spain', 223, 'TT', '10.66031960', '-61.50856250'),
        (3364, 'Siparia Regional Corporation', 223, 'TT', '10.12456260', '-61.56032440'),
        (3365, 'Penal-Debe Regional Corporation', 223, 'TT', '10.13374020', '-61.44354740'),
        (3366, 'Chaguanas', 223, 'TT', '10.51683870', '-61.41144820'),
        (3367, 'Diego Martin Regional Corporation', 223, 'TT', '10.73622860', '-61.55448360'),
        (3368, 'Princes Town Regional Corporation', 223, 'TT', '10.17867460', '-61.28019960'),
        (3369, 'Mary Region', 226, 'TM', '36.94816230', '62.45041540'),
        (3370, 'Lebap Region', 226, 'TM', '38.12724620', '64.71624150'),
        (3371, 'Ashgabat', 226, 'TM', '37.96007660', '58.32606290'),
        (3372, 'Balkan Region', 226, 'TM', '41.81014720', '21.09373110'),
        (3373, 'Daşoguz Region', 226, 'TM', '41.83687370', '59.96519040'),
        (3374, 'Ahal Region', 226, 'TM', '38.63993980', '59.47209040'),
        (3375, 'Beni Department', 27, 'BO', '-14.37827470', '-65.09577920'),
        (3376, 'Oruro Department', 27, 'BO', '-18.57115790', '-67.76159830'),
        (3377, 'Santa Cruz Department', 27, 'BO', '-16.74760370', '-62.07509980'),
        (3378, 'Tarija Department', 27, 'BO', '-21.58315950', '-63.95861110'),
        (3379, 'Pando Department', 27, 'BO', '-10.79889010', '-66.99880110'),
        (3380, 'La Paz Department', 27, 'BO', NULL, NULL),
        (3381, 'Cochabamba Department', 27, 'BO', '-17.56816750', '-65.47573600'),
        (3382, 'Chuquisaca Department', 27, 'BO', '-20.02491440', '-64.14782360'),
        (3383, 'Potosí Department', 27, 'BO', '-20.62471300', '-66.99880110'),
        (3384, 'Saint George Parish', 188, 'VC', '42.95760900', '-81.32670500'),
        (3385, 'Saint Patrick Parish', 188, 'VC', '39.75091860', '-94.84505560'),
        (3386, 'Saint Andrew Parish', 188, 'VC', '43.02429990', '-81.20250000'),
        (3387, 'Saint David Parish', 188, 'VC', '43.85230950', '-79.52366540'),
        (3388, 'Grenadines Parish', 188, 'VC', '13.01229650', '-61.22773010'),
        (3389, 'Charlotte Parish', 188, 'VC', '13.21754510', '-61.16362440'),
        (3390, 'Sharjah Emirate', 231, 'AE', '25.07539740', '55.75784030'),
        (3391, 'Dubai', 231, 'AE', '25.20484930', '55.27078280'),
        (3392, 'Umm al-Quwain', 231, 'AE', '25.54263240', '55.54753480'),
        (3393, 'Fujairah', 231, 'AE', '25.12880990', '56.32648490'),
        (3394, 'Ras al-Khaimah', 231, 'AE', '25.67413430', '55.98041730'),
        (3395, 'Ajman Emirate', 231, 'AE', '25.40521650', '55.51364330'),
        (3396, 'Abu Dhabi Emirate', 231, 'AE', '24.45388400', '54.37734380'),
        (3397, 'districts of Republican Subordination', 217, 'TJ', '39.08579020', '70.24083250'),
        (3398, 'Khatlon Province', 217, 'TJ', '37.91135620', '69.09702300'),
        (3399, 'Gorno-Badakhshan Autonomous Province', 217, 'TJ', '38.41273200', '73.08774900'),
        (3400, 'Sughd Province', 217, 'TJ', '39.51553260', '69.09702300'),
        (3401, 'Tainan County', 216, 'TW', '22.99972810', '120.22702770'),
        (3402, 'Yilan County', 216, 'TW', '24.70210730', '121.73775020'),
        (3403, 'Penghu County', 216, 'TW', '23.57118990', '119.57931570'),
        (3404, 'Changhua County', 216, 'TW', '24.05179630', '120.51613520'),
        (3405, 'Pingtung County', 216, 'TW', '22.55197590', '120.54875970'),
        (3406, 'Taichung', 216, 'TW', '24.14773580', '120.67364820'),
        (3407, 'Nantou County', 216, 'TW', '23.96099810', '120.97186380'),
        (3408, 'Chiayi County', 216, 'TW', '23.45184280', '120.25546150'),
        (3409, 'Kaohsiung County', 216, 'TW', '22.62727840', '120.30143530'),
        (3410, 'Taitung County', 216, 'TW', '22.79724470', '121.07137020'),
        (3411, 'Hualien County', 216, 'TW', '23.98715890', '121.60157140'),
        (3412, 'Kaohsiung', 216, 'TW', '22.62727840', '120.30143530'),
        (3413, 'Miaoli County', 216, 'TW', '24.56015900', '120.82142650'),
        (3414, 'Taichung County', 216, 'TW', '24.14773580', '120.67364820'),
        (3415, 'Kinmen', 216, 'TW', '24.34877920', '118.32856440'),
        (3416, 'Yunlin County', 216, 'TW', '23.70920330', '120.43133730'),
        (3417, 'Hsinchu', 216, 'TW', '24.81382870', '120.96747980'),
        (3418, 'Chiayi City', 216, 'TW', '23.48007510', '120.44911130'),
        (3419, 'Taoyuan City', 216, 'TW', '24.99362810', '121.30097980'),
        (3420, 'Lienchiang County', 216, 'TW', '26.15055560', '119.92888890'),
        (3421, 'Tainan', 216, 'TW', '22.99972810', '120.22702770'),
        (3422, 'Taipei', 216, 'TW', '25.03296940', '121.56541770'),
        (3423, 'Hsinchu County', 216, 'TW', '24.83872260', '121.01772460'),
        (3424, 'Northern Red Sea Region', 68, 'ER', '16.25839970', '38.82054540'),
        (3425, 'Anseba Region', 68, 'ER', '16.47455310', '37.80876930'),
        (3426, 'Maekel Region', 68, 'ER', '15.35514090', '38.86236830'),
        (3427, 'Debub Region', 68, 'ER', '14.94786920', '39.15436770'),
        (3428, 'Gash-Barka Region', 68, 'ER', '15.40688250', '37.63866220'),
        (3429, 'Southern Red Sea Region', 68, 'ER', '13.51371030', '41.76064720'),
        (3430, 'Southern Peninsula Region', 100, 'IS', '63.91548030', '-22.36496670'),
        (3431, 'Capital Region', 100, 'IS', '38.56569570', '-92.18169490'),
        (3432, 'Westfjords', 100, 'IS', '65.91961500', '-21.88117640'),
        (3433, 'Eastern Region', 100, 'IS', NULL, NULL),
        (3434, 'Southern Region', 100, 'IS', NULL, NULL),
        (3435, 'Northwestern Region', 100, 'IS', '41.91339320', '-73.04716880'),
        (3436, 'Western Region', 100, 'IS', NULL, NULL),
        (3437, 'Northeastern Region', 100, 'IS', '43.29942850', '-74.21793260'),
        (3438, 'Río Muni', 67, 'GQ', '1.46106060', '9.67868940'),
        (3439, 'Kié-Ntem Province', 67, 'GQ', '2.02809300', '11.07117580'),
        (3440, 'Wele-Nzas Province', 67, 'GQ', '1.41661620', '11.07117580'),
        (3441, 'Litoral Province', 67, 'GQ', '1.57502440', '9.81249350'),
        (3442, 'Insular Region', 67, 'GQ', '37.09024000', '-95.71289100'),
        (3443, 'Bioko Sur Province', 67, 'GQ', '3.42097850', '8.61606740'),
        (3444, 'Annobón Province', 67, 'GQ', '-1.42687820', '5.63528010'),
        (3445, 'Centro Sur Province', 67, 'GQ', '1.34360840', '10.43965600'),
        (3446, 'Bioko Norte Province', 67, 'GQ', '3.65950720', '8.79218360'),
        (3447, 'Chihuahua', 142, 'MX', '28.63299570', '-106.06910040'),
        (3448, 'Oaxaca', 142, 'MX', '17.07318420', '-96.72658890'),
        (3449, 'Sinaloa', 142, 'MX', '25.17210910', '-107.47951730'),
        (3450, 'México', 142, 'MX', '23.63450100', '-102.55278400'),
        (3451, 'Chiapas', 142, 'MX', '16.75693180', '-93.12923530'),
        (3452, 'Nuevo León', 142, 'MX', '25.59217200', '-99.99619470'),
        (3453, 'Durango', 142, 'MX', '37.27528000', '-107.88006670'),
        (3454, 'Tabasco', 142, 'MX', '17.84091730', '-92.61892730'),
        (3455, 'Querétaro', 142, 'MX', '20.58879320', '-100.38988810'),
        (3456, 'Aguascalientes', 142, 'MX', '21.88525620', '-102.29156770'),
        (3457, 'Baja California', 142, 'MX', '30.84063380', '-115.28375850'),
        (3458, 'Tlaxcala', 142, 'MX', '19.31815400', '-98.23749540'),
        (3459, 'Guerrero', 142, 'MX', '17.43919260', '-99.54509740'),
        (3460, 'Baja California Sur', 142, 'MX', '26.04444460', '-111.66607250'),
        (3461, 'San Luis Potosí', 142, 'MX', '22.15646990', '-100.98554090'),
        (3462, 'Zacatecas', 142, 'MX', '22.77085550', '-102.58324260'),
        (3463, 'Tamaulipas', 142, 'MX', '24.26694000', '-98.83627550'),
        (3464, 'Veracruz', 142, 'MX', '19.17377300', '-96.13422410'),
        (3465, 'Morelos', 142, 'MX', '18.68130490', '-99.10134980'),
        (3466, 'Yucatán', 142, 'MX', '20.70987860', '-89.09433770'),
        (3467, 'Quintana Roo', 142, 'MX', '19.18173930', '-88.47913760'),
        (3468, 'Sonora', 142, 'MX', '37.98294960', '-120.38217240'),
        (3469, 'Guanajuato', 142, 'MX', '21.01901450', '-101.25735860'),
        (3470, 'Hidalgo', 142, 'MX', '26.10035470', '-98.26306840'),
        (3471, 'Coahuila', 142, 'MX', '27.05867600', '-101.70682940'),
        (3472, 'Colima', 142, 'MX', '19.24523420', '-103.72408680'),
        (3473, 'Mexico City', 142, 'MX', '19.43260770', '-99.13320800'),
        (3474, 'Michoacán', 142, 'MX', '19.56651920', '-101.70682940'),
        (3475, 'Campeche', 142, 'MX', '19.83012510', '-90.53490870'),
        (3476, 'Puebla', 142, 'MX', '19.04143980', '-98.20627270'),
        (3477, 'Nayarit', 142, 'MX', '21.75138440', '-104.84546190'),
        (3478, 'Krabi', 219, 'TH', '8.08629970', '98.90628350'),
        (3479, 'Ranong', 219, 'TH', '9.95287020', '98.60846410'),
        (3480, 'Nong Bua Lam Phu', 219, 'TH', '17.22182470', '102.42603680'),
        (3481, 'Samut Prakan', 219, 'TH', '13.59909610', '100.59983190'),
        (3482, 'Surat Thani', 219, 'TH', '9.13419490', '99.33341980'),
        (3483, 'Lamphun', 219, 'TH', '18.57446060', '99.00872210'),
        (3484, 'Nong Khai', 219, 'TH', '17.87828030', '102.74126380'),
        (3485, 'Khon Kaen', 219, 'TH', '16.43219380', '102.82362140'),
        (3486, 'Chanthaburi', 219, 'TH', '12.61124850', '102.10378060'),
        (3487, 'Saraburi', 219, 'TH', '14.52891540', '100.91014210'),
        (3488, 'Phatthalung', 219, 'TH', '7.61668230', '100.07402310'),
        (3489, 'Uttaradit', 219, 'TH', '17.62008860', '100.09929420'),
        (3490, 'Sing Buri', 219, 'TH', '14.89362530', '100.39673140'),
        (3491, 'Chiang Mai', 219, 'TH', '18.78834390', '98.98530080'),
        (3492, 'Nakhon Sawan', 219, 'TH', '15.69873820', '100.11996000'),
        (3493, 'Yala', 219, 'TH', '44.05791170', '-123.16538480'),
        (3494, 'Phra Nakhon Si Ayutthaya', 219, 'TH', '14.36923250', '100.58766340'),
        (3495, 'Nonthaburi', 219, 'TH', '13.85910840', '100.52165080'),
        (3496, 'Trat', 219, 'TH', '12.24275630', '102.51747340'),
        (3497, 'Nakhon Ratchasima', 219, 'TH', '14.97384930', '102.08365200'),
        (3498, 'Chiang Rai', 219, 'TH', '19.91047980', '99.84057600'),
        (3499, 'Ratchaburi', 219, 'TH', '13.52828930', '99.81342110'),
        (3500, 'Pathum Thani', 219, 'TH', '14.02083910', '100.52502760'),
        (3501, 'Sakon Nakhon', 219, 'TH', '17.16642110', '104.14860550'),
        (3502, 'Samut Songkhram', 219, 'TH', '13.40982170', '100.00226450'),
        (3503, 'Nakhon Pathom', 219, 'TH', '13.81402930', '100.03729290'),
        (3504, 'Samut Sakhon', 219, 'TH', '13.54752160', '100.27439560'),
        (3505, 'Mae Hong Son', 219, 'TH', '19.30202960', '97.96543680'),
        (3506, 'Phitsanulok', 219, 'TH', '16.82112380', '100.26585160'),
        (3507, 'Pattaya', 219, 'TH', '12.92355570', '100.88245510'),
        (3508, 'Prachuap Khiri Khan', 219, 'TH', '11.79383890', '99.79575640'),
        (3509, 'Loei', 219, 'TH', '17.48602320', '101.72230020'),
        (3510, 'Roi Et', 219, 'TH', '16.05381960', '103.65200360'),
        (3511, 'Kanchanaburi', 219, 'TH', '14.10113930', '99.41794310'),
        (3512, 'Ubon Ratchathani', 219, 'TH', '15.24484530', '104.84729950'),
        (3513, 'Chon Buri', 219, 'TH', '13.36114310', '100.98467170'),
        (3514, 'Phichit', 219, 'TH', '16.27408760', '100.33469910'),
        (3515, 'Phetchabun', 219, 'TH', '16.30166900', '101.11928040'),
        (3516, 'Kamphaeng Phet', 219, 'TH', '16.48277980', '99.52266180'),
        (3517, 'Maha Sarakham', 219, 'TH', '16.01320150', '103.16151690'),
        (3518, 'Rayong', 219, 'TH', '12.68139570', '101.28162610'),
        (3519, 'Ang Thong', 219, 'TH', '14.58960540', '100.45505200'),
        (3520, 'Nakhon Si Thammarat', 219, 'TH', '8.43248310', '99.95990330'),
        (3521, 'Yasothon', 219, 'TH', '15.79264100', '104.14528270'),
        (3522, 'Chai Nat', 219, 'TH', '15.18519710', '100.12512500'),
        (3523, 'Amnat Charoen', 219, 'TH', '15.86567830', '104.62577740'),
        (3524, 'Suphan Buri', 219, 'TH', '14.47448920', '100.11771280'),
        (3525, 'Tak', 219, 'TH', '45.02996460', '-93.10498150'),
        (3526, 'Chumphon', 219, 'TH', '10.49304960', '99.18001990'),
        (3527, 'Udon Thani', 219, 'TH', '17.36469690', '102.81589240'),
        (3528, 'Phrae', 219, 'TH', '18.14457740', '100.14028310'),
        (3529, 'Sa Kaeo', 219, 'TH', '13.82403800', '102.06458390'),
        (3530, 'Nan', 219, 'TH', '45.52220800', '-122.98632810'),
        (3531, 'Surin', 219, 'TH', '37.03582710', '-95.62763670'),
        (3532, 'Phetchaburi', 219, 'TH', '12.96492150', '99.64258830'),
        (3533, 'Bueng Kan', 219, 'TH', '18.36091040', '103.64644630'),
        (3534, 'Buri Ram', 219, 'TH', '14.99510030', '103.11159150'),
        (3535, 'Nakhon Nayok', 219, 'TH', '14.20694660', '101.21305110'),
        (3536, 'Phuket', 219, 'TH', '7.88044790', '98.39225040'),
        (3537, 'Satun', 219, 'TH', '6.62381580', '100.06737440'),
        (3538, 'Phayao', 219, 'TH', '19.21543670', '100.20236920'),
        (3539, 'Songkhla', 219, 'TH', '7.18976590', '100.59538130'),
        (3540, 'Pattani', 219, 'TH', '6.76183080', '101.32325490'),
        (3541, 'Trang', 219, 'TH', '7.56448330', '99.62393340'),
        (3542, 'Prachin Buri', 219, 'TH', '14.04206990', '101.66008740'),
        (3543, 'Lop Buri', 219, 'TH', '14.79950810', '100.65337060'),
        (3544, 'Lampang', 219, 'TH', '18.28553950', '99.51278950'),
        (3545, 'Sukhothai', 219, 'TH', '43.64855560', '-79.37466390'),
        (3546, 'Mukdahan', 219, 'TH', '16.54359140', '104.70241210'),
        (3547, 'Si Sa Ket', 219, 'TH', '15.11860090', '104.32200950'),
        (3548, 'Nakhon Phanom', 219, 'TH', '17.39203900', '104.76955080'),
        (3549, 'Phangnga', 219, 'TH', '8.45014140', '98.52553170'),
        (3550, 'Kalasin', 219, 'TH', '16.43850800', '103.50609940'),
        (3551, 'Uthai Thani', 219, 'TH', '15.38350010', '100.02455270'),
        (3552, 'Chachoengsao', 219, 'TH', '13.69041940', '101.07795960'),
        (3553, 'Narathiwat', 219, 'TH', '6.42546070', '101.82531430'),
        (3554, 'Bangkok', 219, 'TH', '13.75633090', '100.50176510'),
        (3555, 'Hiiu County', 69, 'EE', '58.92395530', '22.59194680'),
        (3556, 'Viljandi County', 69, 'EE', '58.28217460', '25.57522330'),
        (3557, 'Tartu County', 69, 'EE', '58.40571280', '26.80157600'),
        (3558, 'Valga County', 69, 'EE', '57.91034410', '26.16018190'),
        (3559, 'Rapla County', 69, 'EE', '58.84926250', '24.73465690'),
        (3560, 'Võru County', 69, 'EE', '57.73773720', '27.13989380'),
        (3561, 'Saare County', 69, 'EE', '58.48497210', '22.61364080'),
        (3562, 'Pärnu County', 69, 'EE', '58.52619520', '24.40201590'),
        (3563, 'Põlva County', 69, 'EE', '58.11606220', '27.20663940'),
        (3564, 'Lääne-Viru County', 69, 'EE', '59.30188160', '26.32803120'),
        (3565, 'Jõgeva County', 69, 'EE', '58.75061430', '26.36048780'),
        (3566, 'Järva County', 69, 'EE', '58.88667130', '25.50006240'),
        (3567, 'Harju County', 69, 'EE', '59.33342390', '25.24669740'),
        (3568, 'Lääne County', 69, 'EE', '58.97227420', '23.87408340'),
        (3569, 'Ida-Viru County', 69, 'EE', '59.25926630', '27.41365350'),
        (3570, 'Moyen-Chari Region', 43, 'TD', '9.06399980', '18.42760470'),
        (3571, 'Mayo-Kebbi Ouest Region', 43, 'TD', '10.41130140', '15.59433880'),
        (3572, 'Sila Region', 43, 'TD', '12.13074000', '21.28450250'),
        (3573, 'Hadjer-Lamis', 43, 'TD', '12.45772730', '16.72346390'),
        (3574, 'Borkou', 43, 'TD', '17.86888450', '18.80761950'),
        (3575, 'Ennedi-Est', 43, 'TD', '16.34204960', '23.00119890'),
        (3576, 'Guéra Region', 43, 'TD', '11.12190150', '18.42760470'),
        (3577, 'Lac Region', 43, 'TD', '13.69153770', '14.10013260'),
        (3578, 'Ennedi Region', 43, 'TD', '17.54145780', '21.85685860'),
        (3579, 'Tandjilé Region', 43, 'TD', '9.66257290', '16.72346390'),
        (3580, 'Mayo-Kebbi Est Region', 43, 'TD', '9.40460390', '14.84546190'),
        (3581, 'Wadi Fira Region', 43, 'TD', '15.08924160', '21.47528510'),
        (3582, 'Ouaddaï Region', 43, 'TD', '13.74847600', '20.71224650'),
        (3583, 'Bahr el Gazel', 43, 'TD', '14.77022660', '16.91225100'),
        (3584, 'Ennedi-Ouest', 43, 'TD', '18.97756300', '21.85685860'),
        (3585, 'Logone Occidental Region', 43, 'TD', '8.75967600', '15.87600400'),
        (3586, 'N\'Djamena', 43, 'TD', '12.13484570', '15.05574150'),
        (3587, 'Tibesti Region', 43, 'TD', '21.36500310', '16.91225100'),
        (3588, 'Kanem Region', 43, 'TD', '14.87812620', '15.40680790'),
        (3589, 'Mandoul Region', 43, 'TD', '8.60309100', '17.47951730'),
        (3590, 'Batha Region', 43, 'TD', '13.93717750', '18.42760470'),
        (3591, 'Logone Oriental Region', 43, 'TD', '8.31499490', '16.34637910'),
        (3592, 'Salamat Region', 43, 'TD', '10.96916010', '20.71224650'),
        (3593, 'Berry Islands', 17, 'BS', '25.62500420', '-77.82522030'),
        (3594, 'Nichollstown and Berry Islands', 17, 'BS', '25.72362340', '-77.83101040'),
        (3595, 'Green Turtle Cay', 17, 'BS', '26.77471070', '-77.32957080'),
        (3596, 'Central Eleuthera', 17, 'BS', '25.13620370', '-76.14359150'),
        (3597, 'Governor\'s Harbour', 17, 'BS', '25.19480960', '-76.24396220'),
        (3598, 'High Rock', 17, 'BS', '46.68434150', '-121.90174610'),
        (3599, 'West Grand Bahama', 17, 'BS', '26.65944700', '-78.52065000'),
        (3600, 'Rum Cay District', 17, 'BS', '23.68546760', '-74.83901620'),
        (3601, 'Acklins', 17, 'BS', '22.36577080', '-74.05351260'),
        (3602, 'North Eleuthera', 17, 'BS', '25.46475170', '-76.67592200'),
        (3603, 'Central Abaco', 17, 'BS', '26.35550290', '-77.14851630'),
        (3604, 'Marsh Harbour', 17, 'BS', '26.52416530', '-77.09098090'),
        (3605, 'Black Point', 17, 'BS', '41.39510240', '-71.46505560'),
        (3606, 'Sandy Point', 17, 'BS', '39.01454640', '-76.39989250'),
        (3607, 'South Eleuthera', 17, 'BS', '24.77085620', '-76.21314740'),
        (3608, 'South Abaco', 17, 'BS', '26.06405910', '-77.26350380'),
        (3609, 'Inagua', 17, 'BS', '21.06560660', '-73.32370800'),
        (3610, 'Long Island', 17, 'BS', '40.78914200', '-73.13496100'),
        (3611, 'Cat Island', 17, 'BS', '30.22801360', '-89.10149330'),
        (3612, 'Exuma', 17, 'BS', '23.61925980', '-75.96954650'),
        (3613, 'Harbour Island', 17, 'BS', '25.50011000', '-76.63405110'),
        (3614, 'East Grand Bahama', 17, 'BS', '26.65828230', '-78.22482910'),
        (3615, 'Ragged Island', 17, 'BS', '41.59743100', '-71.26020200'),
        (3616, 'North Abaco', 17, 'BS', '26.78716970', '-77.43577390'),
        (3617, 'North Andros', 17, 'BS', '24.70638050', '-78.01953870'),
        (3618, 'Kemps Bay', 17, 'BS', '24.02364000', '-77.54534900'),
        (3619, 'Fresh Creek', 17, 'BS', '40.65437560', '-73.89479390'),
        (3620, 'San Salvador and Rum Cay', 17, 'BS', '23.68546760', '-74.83901620'),
        (3621, 'Crooked Island', 17, 'BS', '22.63909820', '-74.00650900'),
        (3622, 'South Andros', 17, 'BS', '23.97135560', '-77.60778650'),
        (3623, 'Rock Sound', 17, 'BS', '39.01424430', '-95.67089890'),
        (3624, 'Hope Town', 17, 'BS', '26.50095040', '-76.99598720'),
        (3625, 'Mangrove Cay', 17, 'BS', '24.14814250', '-77.76809520'),
        (3626, 'Freeport', 17, 'BS', '42.29668610', '-89.62122710'),
        (3627, 'San Salvador Island', 17, 'BS', '24.07755460', '-74.47600880'),
        (3628, 'Acklins and Crooked Islands', 17, 'BS', '22.36577080', '-74.05351260'),
        (3629, 'Bimini', 17, 'BS', '24.64153250', '-79.85062260'),
        (3630, 'Spanish Wells', 17, 'BS', '26.32505990', '-81.79803280'),
        (3631, 'Central Andros', 17, 'BS', '24.46884820', '-77.97386500'),
        (3632, 'Grand Cay', 17, 'BS', '27.21626150', '-78.32305590'),
        (3633, 'Mayaguana District', 17, 'BS', '22.40177140', '-73.06413960'),
        (3634, 'San Juan Province', 11, 'AR', NULL, NULL),
        (3635, 'Santiago del Estero Province', 11, 'AR', '-27.78335740', '-64.26416700'),
        (3636, 'San Luis Province', 11, 'AR', '-33.29620420', '-66.32949480'),
        (3637, 'Tucumán Province', 11, 'AR', '-26.82211270', '-65.21929030'),
        (3638, 'Corrientes', 11, 'AR', '-27.46921310', '-58.83063490'),
        (3639, 'Río Negro Province', 11, 'AR', '-40.82614340', '-63.02663390'),
        (3640, 'Chaco Province', 11, 'AR', '-27.42571750', '-59.02437840'),
        (3641, 'Santa Fe Province', 11, 'AR', '-31.58551090', '-60.72380160'),
        (3642, 'Córdoba Province', 11, 'AR', NULL, NULL),
        (3643, 'Salta Province', 11, 'AR', '-24.79976880', '-65.41503670'),
        (3644, 'Misiones Province', 11, 'AR', '-27.42692550', '-55.94670760'),
        (3645, 'Jujuy Province', 11, 'AR', '-24.18433970', '-65.30217700'),
        (3646, 'Mendoza', 11, 'AR', '-32.88945870', '-68.84583860'),
        (3647, 'Catamarca Province', 11, 'AR', '-28.47158770', '-65.78772090'),
        (3648, 'Neuquén Province', 11, 'AR', '-38.94587000', '-68.07309250'),
        (3649, 'Santa Cruz Province', 11, 'AR', '-51.63528210', '-69.24743530'),
        (3650, 'Tierra del Fuego Province', 11, 'AR', '-54.80539980', '-68.32420610'),
        (3651, 'Chubut Province', 11, 'AR', '-43.29342460', '-65.11148180'),
        (3652, 'Formosa Province', 11, 'AR', '-26.18948040', '-58.22428060'),
        (3653, 'La Rioja Province', 11, 'AR', '-29.41937930', '-66.85599320'),
        (3654, 'Entre Ríos Province', 11, 'AR', '-31.77466540', '-60.49564610'),
        (3655, 'La Pampa', 11, 'AR', '-36.61475730', '-64.28392090'),
        (3656, 'Buenos Aires Province', 11, 'AR', '-37.20172850', '-59.84106970'),
        (3657, 'Quiché Department', 90, 'GT', '15.49838080', '-90.98206680'),
        (3658, 'Jalapa Department', 90, 'GT', '14.61214460', '-89.96267990'),
        (3659, 'Izabal Department', 90, 'GT', '15.49765170', '-88.86469800'),
        (3660, 'Suchitepéquez Department', 90, 'GT', '14.42159820', '-91.40482490'),
        (3661, 'Sololá Department', 90, 'GT', '14.74852300', '-91.28910360'),
        (3662, 'El Progreso Department', 90, 'GT', '14.93887320', '-90.07467670'),
        (3663, 'Totonicapán Department', 90, 'GT', '14.91734020', '-91.36139230'),
        (3664, 'Retalhuleu Department', 90, 'GT', '14.52454850', '-91.68578800'),
        (3665, 'Santa Rosa Department', 90, 'GT', '38.44057590', '-122.70375430'),
        (3666, 'Chiquimula Department', 90, 'GT', '14.75149990', '-89.47421770'),
        (3667, 'San Marcos Department', 90, 'GT', '14.93095690', '-91.90992380'),
        (3668, 'Quetzaltenango Department', 90, 'GT', '14.79243300', '-91.71495800'),
        (3669, 'Petén Department', 90, 'GT', '16.91203300', '-90.29957850'),
        (3670, 'Huehuetenango Department', 90, 'GT', '15.58799140', '-91.67606910'),
        (3671, 'Alta Verapaz Department', 90, 'GT', '15.59428830', '-90.14949880'),
        (3672, 'Guatemala Department', 90, 'GT', '14.56494010', '-90.52578230'),
        (3673, 'Jutiapa Department', 90, 'GT', '14.19308020', '-89.92532330'),
        (3674, 'Baja Verapaz Department', 90, 'GT', '15.12558670', '-90.37483540'),
        (3675, 'Chimaltenango Department', 90, 'GT', '14.56347870', '-90.98206680'),
        (3676, 'Sacatepéquez Department', 90, 'GT', '14.51783790', '-90.71527490'),
        (3677, 'Escuintla Department', 90, 'GT', '14.19109120', '-90.98206680'),
        (3678, 'Madre de Dios', 173, 'PE', '-11.76687050', '-70.81199530'),
        (3679, 'Huancavelica', 173, 'PE', '-12.78619780', '-74.97640240'),
        (3680, 'Áncash', 173, 'PE', '-9.32504970', '-77.56194190'),
        (3681, 'Arequipa', 173, 'PE', '-16.40904740', '-71.53745100'),
        (3682, 'Puno', 173, 'PE', '-15.84022180', '-70.02188050'),
        (3683, 'La Libertad', 173, 'PE', '13.49069700', '-89.30846070'),
        (3684, 'Ucayali', 173, 'PE', '-9.82511830', '-73.08774900'),
        (3685, 'Amazonas', 173, 'PE', NULL, NULL),
        (3686, 'Pasco', 173, 'PE', '46.23050490', '-119.09223160'),
        (3687, 'Huanuco', 173, 'PE', '-9.92076480', '-76.24108430'),
        (3688, 'Cajamarca', 173, 'PE', '-7.16174650', '-78.51278550'),
        (3689, 'Tumbes', 173, 'PE', '-3.55649210', '-80.42708850'),
        (3691, 'Cusco', 173, 'PE', '-13.53195000', '-71.96746260'),
        (3692, 'Ayacucho', 173, 'PE', '-13.16387370', '-74.22356410'),
        (3693, 'Junín', 173, 'PE', '-11.15819250', '-75.99263060'),
        (3694, 'San Martín', 173, 'PE', '37.08494640', '-121.61022160'),
        (3695, 'Lima', 173, 'PE', '-12.04637310', '-77.04275400'),
        (3696, 'Tacna', 173, 'PE', '-18.00656790', '-70.24627410'),
        (3697, 'Piura', 173, 'PE', '-5.17828840', '-80.65488820'),
        (3698, 'Moquegua', 173, 'PE', '-17.19273610', '-70.93281380'),
        (3699, 'Apurímac', 173, 'PE', '-14.05045330', '-73.08774900'),
        (3700, 'Ica', 173, 'PE', '42.35288320', '-71.04300970'),
        (3701, 'Callao', 173, 'PE', '-12.05084910', '-77.12598430'),
        (3702, 'Lambayeque', 173, 'PE', '-6.71976660', '-79.90807570'),
        (3703, 'Redonda', 10, 'AG', '16.93841600', '-62.34551480'),
        (3704, 'Saint Peter Parish', 10, 'AG', NULL, NULL),
        (3705, 'Saint Paul Parish', 10, 'AG', NULL, NULL),
        (3706, 'Saint John Parish', 10, 'AG', NULL, NULL),
        (3707, 'Saint Mary Parish', 10, 'AG', NULL, NULL),
        (3708, 'Barbuda', 10, 'AG', '17.62662420', '-61.77130280'),
        (3709, 'Saint George Parish', 10, 'AG', NULL, NULL),
        (3710, 'Saint Philip Parish', 10, 'AG', '40.43682580', '-80.06855320'),
        (3711, 'South Bačka District', 196, 'RS', '45.48903440', '19.69761870'),
        (3712, 'Pirot District', 196, 'RS', '43.08740360', '22.59830440'),
        (3713, 'South Banat District', 196, 'RS', '45.00274570', '21.05425090'),
        (3714, 'North Bačka District', 196, 'RS', '45.98033940', '19.59070010'),
        (3715, 'Jablanica District', 196, 'RS', '42.94815600', '21.81293210'),
        (3716, 'Central Banat District', 196, 'RS', '45.47884850', '20.60825220'),
        (3717, 'Bor District', 196, 'RS', '44.06989180', '22.09850860'),
        (3718, 'Toplica District', 196, 'RS', '43.19065920', '21.34077620'),
        (3719, 'Mačva District', 196, 'RS', '44.59253140', '19.50822460'),
        (3720, 'Rasina District', 196, 'RS', '43.52635250', '21.15881780'),
        (3721, 'Pčinja District', 196, 'RS', '42.58363620', '22.14302150'),
        (3722, 'Nišava District', 196, 'RS', '43.37389020', '21.93223310'),
        (3723, 'Prizren District', 248, 'XK', '42.21525220', '20.74147720'),
        (3724, 'Kolubara District', 196, 'RS', '44.35098110', '20.00043050'),
        (3725, 'Raška District', 196, 'RS', '43.33734610', '20.57340050'),
        (3726, 'West Bačka District', 196, 'RS', '45.73553850', '19.18973640'),
        (3727, 'Moravica District', 196, 'RS', '43.84147000', '20.29049870'),
        (3728, 'Belgrade', 196, 'RS', '44.78656800', '20.44892160'),
        (3729, 'Zlatibor District', 196, 'RS', '43.64541700', '19.71014550'),
        (3731, 'Zaječar District', 196, 'RS', '43.90150480', '22.27380110'),
        (3732, 'Braničevo District', 196, 'RS', '44.69822460', '21.54467750'),
        (3733, 'Vojvodina', 196, 'RS', '45.26086510', '19.83193380'),
        (3734, 'Šumadija District', 196, 'RS', '44.20506780', '20.78565650'),
        (3736, 'North Banat District', 196, 'RS', '45.90683900', '19.99934170'),
        (3737, 'Pomoravlje District', 196, 'RS', '43.95913790', '21.27135300'),
        (3738, 'Peć District', 248, 'XK', '42.65921550', '20.28876240'),
        (3740, 'Srem District', 196, 'RS', '45.00291710', '19.80137730'),
        (3741, 'Podunavlje District', 196, 'RS', '44.47291560', '20.99014260'),
        (3742, 'Westmoreland Parish', 108, 'JM', '18.29443780', '-78.15644320'),
        (3743, 'Saint Elizabeth Parish', 108, 'JM', '38.99253080', '-94.58992000'),
        (3744, 'Saint Ann Parish', 108, 'JM', '37.28714520', '-77.41035330'),
        (3745, 'Saint James Parish', 108, 'JM', '30.01792920', '-90.79132270'),
        (3746, 'Saint Catherine Parish', 108, 'JM', '18.03641340', '-77.05644640'),
        (3747, 'Saint Mary Parish', 108, 'JM', '36.09252200', '-95.97384400'),
        (3748, 'Kingston Parish', 108, 'JM', '17.96832710', '-76.78270200'),
        (3749, 'Hanover Parish', 108, 'JM', '18.40977070', '-78.13363800'),
        (3750, 'Saint Thomas Parish', 108, 'JM', '41.44253890', '-81.74022180'),
        (3751, 'Saint Andrew', 108, 'JM', '37.22451030', '-95.70211890'),
        (3752, 'Portland Parish', 108, 'JM', '18.08442740', '-76.41002670'),
        (3753, 'Clarendon Parish', 108, 'JM', '17.95571830', '-77.24051530'),
        (3754, 'Manchester Parish', 108, 'JM', '18.06696540', '-77.51607880'),
        (3755, 'Trelawny Parish', 108, 'JM', '18.35261430', '-77.60778650'),
        (3756, 'Dennery Quarter', 186, 'LC', '13.92673930', '-60.91909880'),
        (3757, 'Anse la Raye Quarter', 186, 'LC', '13.94594240', '-61.03694680'),
        (3758, 'Castries Quarter', 186, 'LC', '14.01010940', '-60.98746870'),
        (3759, 'Laborie Quarter', 186, 'LC', '13.75227830', '-60.99328890'),
        (3760, 'Choiseul Quarter', 186, 'LC', '13.77501540', '-61.04859100'),
        (3761, 'Canaries', 186, 'LC', '28.29156370', '-16.62913040'),
        (3762, 'Micoud Quarter', 186, 'LC', '13.82118710', '-60.90019340'),
        (3763, 'Vieux Fort Quarter', 186, 'LC', '13.72060800', '-60.94964330'),
        (3764, 'Soufrière Quarter', 186, 'LC', '13.85709860', '-61.05732480'),
        (3765, 'Praslin Quarter', 186, 'LC', '13.87523920', '-60.89946630'),
        (3766, 'Gros Islet Quarter', 186, 'LC', '14.08435780', '-60.94527940'),
        (3767, 'Dauphin Quarter', 186, 'LC', '14.01033960', '-60.91909880'),
        (3768, 'Hưng Yên', 240, 'VN', '20.85257110', '106.01699710'),
        (3769, 'Đồng Tháp', 240, 'VN', '10.49379890', '105.68817880'),
        (3770, 'Bà Rịa-Vũng Tàu', 240, 'VN', '10.54173970', '107.24299760'),
        (3771, 'Thanh Hóa', 240, 'VN', '19.80669200', '105.78518160'),
        (3772, 'Kon Tum', 240, 'VN', '14.34974030', '108.00046060'),
        (3773, 'Điện Biên', 240, 'VN', '21.80423090', '103.10765250'),
        (3774, 'Vĩnh Phúc', 240, 'VN', '21.36088050', '105.54743730'),
        (3775, 'Thái Bình', 240, 'VN', '20.44634710', '106.33658280'),
        (3776, 'Quảng Nam', 240, 'VN', '15.53935380', '108.01910200'),
        (3777, 'Hậu Giang', 240, 'VN', '9.75789800', '105.64125270'),
        (3778, 'Cà Mau', 240, 'VN', '9.15267280', '105.19607950'),
        (3779, 'Hà Giang', 240, 'VN', '22.80255880', '104.97844940'),
        (3780, 'Nghệ An', 240, 'VN', '19.23424890', '104.92003650'),
        (3781, 'Tiền Giang', 240, 'VN', '10.44933240', '106.34205040'),
        (3782, 'Cao Bằng', 240, 'VN', '22.63568900', '106.25221430'),
        (3783, 'Hải Phòng', 240, 'VN', '20.84491150', '106.68808410'),
        (3784, 'Yên Bái', 240, 'VN', '21.71676890', '104.89858780'),
        (3785, 'Bình Dương', 240, 'VN', '11.32540240', '106.47701700'),
        (3786, 'Ninh Bình', 240, 'VN', '20.25061490', '105.97445360'),
        (3787, 'Bình Thuận', 240, 'VN', '11.09037030', '108.07207810'),
        (3788, 'Ninh Thuận', 240, 'VN', '11.67387670', '108.86295720'),
        (3789, 'Nam Định', 240, 'VN', '20.43882250', '106.16210530'),
        (3790, 'Vĩnh Long', 240, 'VN', '10.23957400', '105.95719280'),
        (3791, 'Bắc Ninh', 240, 'VN', '21.12144400', '106.11105010'),
        (3792, 'Lạng Sơn', 240, 'VN', '21.85370800', '106.76151900'),
        (3793, 'Khánh Hòa', 240, 'VN', '12.25850980', '109.05260760'),
        (3794, 'An Giang', 240, 'VN', '10.52158360', '105.12589550'),
        (3795, 'Tuyên Quang', 240, 'VN', '21.77672460', '105.22801960'),
        (3796, 'Bến Tre', 240, 'VN', '10.24335560', '106.37555100'),
        (3797, 'Bình Phước', 240, 'VN', '11.75118940', '106.72346390'),
        (3798, 'Thừa Thiên-Huế', 240, 'VN', '16.46739700', '107.59053260'),
        (3799, 'Hòa Bình', 240, 'VN', '20.68612650', '105.31311850'),
        (3800, 'Kiên Giang', 240, 'VN', '9.82495870', '105.12589550'),
        (3801, 'Phú Thọ', 240, 'VN', '21.26844300', '105.20455730'),
        (3802, 'Hà Nam', 240, 'VN', '20.58351960', '105.92299000'),
        (3803, 'Quảng Trị', 240, 'VN', '16.74030740', '107.18546790'),
        (3804, 'Bạc Liêu', 240, 'VN', '9.29400270', '105.72156630'),
        (3805, 'Trà Vinh', 240, 'VN', '9.81274100', '106.29929120'),
        (3806, 'Đà Nẵng', 240, 'VN', '16.05440680', '108.20216670'),
        (3807, 'Thái Nguyên', 240, 'VN', '21.56715590', '105.82520380'),
        (3808, 'Long An', 240, 'VN', '10.56071680', '106.64976230'),
        (3809, 'Quảng Bình', 240, 'VN', '17.61027150', '106.34874740'),
        (3810, 'Hà Nội', 240, 'VN', '21.02776440', '105.83415980'),
        (3811, 'Hồ Chí Minh', 240, 'VN', '10.82309890', '106.62966380'),
        (3812, 'Sơn La', 240, 'VN', '21.10222840', '103.72891670'),
        (3813, 'Gia Lai', 240, 'VN', '13.80789430', '108.10937500'),
        (3814, 'Quảng Ninh', 240, 'VN', '21.00638200', '107.29251440'),
        (3815, 'Bắc Giang', 240, 'VN', '21.28199210', '106.19747690'),
        (3816, 'Hà Tĩnh', 240, 'VN', '18.35595370', '105.88774940'),
        (3817, 'Lào Cai', 240, 'VN', '22.48094310', '103.97549590'),
        (3818, 'Lâm Đồng', 240, 'VN', '11.57527910', '108.14286690'),
        (3819, 'Sóc Trăng', 240, 'VN', '9.60252100', '105.97390490'),
        (3821, 'Đồng Nai', 240, 'VN', '11.06863050', '107.16759760'),
        (3822, 'Bắc Kạn', 240, 'VN', '22.30329230', '105.87600400'),
        (3823, 'Đắk Nông', 240, 'VN', '12.26464760', '107.60980600'),
        (3824, 'Phú Yên', 240, 'VN', '13.08818610', '109.09287640'),
        (3825, 'Lai Châu', 240, 'VN', '22.38622270', '103.47026310'),
        (3826, 'Tây Ninh', 240, 'VN', '11.33515540', '106.10988540'),
        (3827, 'Hải Dương', 240, 'VN', '20.93734130', '106.31455420'),
        (3828, 'Quảng Ngãi', 240, 'VN', '15.12138730', '108.80441450'),
        (3829, 'Đắk Lắk', 240, 'VN', '12.71001160', '108.23775190'),
        (3830, 'Bình Định', 240, 'VN', '14.16653240', '108.90268300'),
        (3831, 'Saint Peter Basseterre Parish', 185, 'KN', '17.31029110', '-62.71475330'),
        (3832, 'Nevis', 185, 'KN', '17.15535580', '-62.57960260'),
        (3833, 'Christ Church Nichola Town Parish', 185, 'KN', '17.36048120', '-62.76178370'),
        (3834, 'Saint Paul Capisterre Parish', 185, 'KN', '17.40166830', '-62.82573320'),
        (3835, 'Saint James Windward Parish', 185, 'KN', '17.17696330', '-62.57960260'),
        (3836, 'Saint Anne Sandy Point Parish', 185, 'KN', '17.37253330', '-62.84411330'),
        (3837, 'Saint George Gingerland Parish', 185, 'KN', '17.12577590', '-62.56198110'),
        (3838, 'Saint Paul Charlestown Parish', 185, 'KN', '17.13462970', '-62.61338160'),
        (3839, 'Saint Thomas Lowland Parish', 185, 'KN', '17.16505130', '-62.60897530'),
        (3840, 'Saint John Figtree Parish', 185, 'KN', '17.11557480', '-62.60310040'),
        (3841, 'Saint Kitts', 185, 'KN', '17.34337960', '-62.75590430'),
        (3842, 'Saint Thomas Middle Island Parish', 185, 'KN', '17.33488130', '-62.80882510'),
        (3843, 'Trinity Palmetto Point Parish', 185, 'KN', '17.30635190', '-62.76178370'),
        (3844, 'Saint Mary Cayon Parish', 185, 'KN', '17.34620710', '-62.73826710'),
        (3845, 'Saint John Capisterre Parish', 185, 'KN', '17.38103410', '-62.79118330'),
        (3846, 'Daegu', 116, 'KR', '35.87143540', '128.60144500'),
        (3847, 'Gyeonggi Province', 116, 'KR', '37.41380000', '127.51830000'),
        (3848, 'Incheon', 116, 'KR', '37.45625570', '126.70520620'),
        (3849, 'Seoul', 116, 'KR', '37.56653500', '126.97796920'),
        (3850, 'Daejeon', 116, 'KR', '36.35041190', '127.38454750'),
        (3851, 'North Jeolla Province', 116, 'KR', '35.71750000', '127.15300000'),
        (3852, 'Ulsan', 116, 'KR', '35.53837730', '129.31135960'),
        (3853, 'Jeju', 116, 'KR', '33.95682780', '-84.13135000'),
        (3854, 'North Chungcheong Province', 116, 'KR', '36.80000000', '127.70000000'),
        (3855, 'North Gyeongsang Province', 116, 'KR', '36.49190000', '128.88890000'),
        (3856, 'South Jeolla Province', 116, 'KR', '34.86790000', '126.99100000'),
        (3857, 'South Gyeongsang Province', 116, 'KR', '35.46060000', '128.21320000'),
        (3858, 'Gwangju', 116, 'KR', '35.15954540', '126.85260120'),
        (3859, 'South Chungcheong Province', 116, 'KR', '36.51840000', '126.80000000'),
        (3860, 'Busan', 116, 'KR', '35.17955430', '129.07564160'),
        (3861, 'Sejong City', 116, 'KR', '34.05233230', '-118.30848970'),
        (3862, 'Gangwon Province', 116, 'KR', '37.82280000', '128.15550000'),
        (3863, 'Saint Patrick Parish', 87, 'GD', NULL, NULL),
        (3864, 'Saint George Parish', 87, 'GD', NULL, NULL),
        (3865, 'Saint Andrew Parish', 87, 'GD', NULL, NULL),
        (3866, 'Saint Mark Parish', 87, 'GD', '40.58818630', '-73.94957010'),
        (3867, 'Carriacou and Petite Martinique', 87, 'GD', '12.47858880', '-61.44938420'),
        (3868, 'Saint John Parish', 87, 'GD', '30.11183310', '-90.48799160'),
        (3869, 'Saint David Parish', 87, 'GD', NULL, NULL),
        (3870, 'Ghazni', 1, 'AF', '33.54505870', '68.41739720'),
        (3871, 'Badghis', 1, 'AF', '35.16713390', '63.76953840'),
        (3872, 'Bamyan', 1, 'AF', '34.81000670', '67.82121040'),
        (3873, 'Helmand', 1, 'AF', '39.29893610', '-76.61604720'),
        (3874, 'Zabul', 1, 'AF', '32.19187820', '67.18944880'),
        (3875, 'Baghlan', 1, 'AF', '36.17890260', '68.74530640'),
        (3876, 'Kunar', 1, 'AF', '34.84658930', '71.09731700'),
        (3877, 'Paktika', 1, 'AF', '32.26453860', '68.52471490'),
        (3878, 'Khost', 1, 'AF', '33.33384720', '69.93716730'),
        (3879, 'Kapisa', 1, 'AF', '34.98105720', '69.62145620'),
        (3880, 'Nuristan', 1, 'AF', '35.32502230', '70.90712360'),
        (3881, 'Panjshir', 1, 'AF', '38.88023910', '-77.17172380'),
        (3882, 'Nangarhar', 1, 'AF', '34.17183130', '70.62167940'),
        (3883, 'Samangan', 1, 'AF', '36.31555060', '67.96428630'),
        (3884, 'Balkh', 1, 'AF', '36.75506030', '66.89753720'),
        (3885, 'Sar-e Pol', 1, 'AF', '36.21662800', '65.93336000'),
        (3886, 'Jowzjan', 1, 'AF', '36.89696920', '65.66585680'),
        (3887, 'Herat', 1, 'AF', '34.35286500', '62.20402870'),
        (3888, 'Ghōr', 1, 'AF', '34.09957760', '64.90595500'),
        (3889, 'Faryab', 1, 'AF', '36.07956130', '64.90595500'),
        (3890, 'Kandahar', 1, 'AF', '31.62887100', '65.73717490'),
        (3891, 'Laghman', 1, 'AF', '34.68976870', '70.14558050'),
        (3892, 'Daykundi', 1, 'AF', '33.66949500', '66.04635340'),
        (3893, 'Takhar', 1, 'AF', '36.66980130', '69.47845410'),
        (3894, 'Paktia', 1, 'AF', '33.70619900', '69.38310790'),
        (3895, 'Parwan', 1, 'AF', '34.96309770', '68.81088490'),
        (3896, 'Nimruz', 1, 'AF', '31.02614880', '62.45041540'),
        (3897, 'Logar', 1, 'AF', '34.01455180', '69.19239160'),
        (3898, 'Urozgan', 1, 'AF', '32.92712870', '66.14152630'),
        (3899, 'Farah', 1, 'AF', '32.49532800', '62.26266270'),
        (3900, 'Kunduz Province', 1, 'AF', '36.72855110', '68.86789820'),
        (3901, 'Badakhshan', 1, 'AF', '36.73477250', '70.81199530'),
        (3902, 'Kabul', 1, 'AF', '34.55534940', '69.20748600'),
        (3903, 'Victoria', 14, 'AU', NULL, NULL),
        (3904, 'South Australia', 14, 'AU', '-30.00023150', '136.20915470'),
        (3905, 'Queensland', 14, 'AU', '-20.91757380', '142.70279560'),
        (3906, 'Western Australia', 14, 'AU', '-27.67281680', '121.62830980'),
        (3907, 'Australian Capital Territory', 14, 'AU', '-35.47346790', '149.01236790'),
        (3908, 'Tasmania', 14, 'AU', '-41.45451960', '145.97066470'),
        (3909, 'New South Wales', 14, 'AU', '-31.25321830', '146.92109900'),
        (3910, 'Northern Territory', 14, 'AU', '-19.49141080', '132.55096030'),
        (3911, 'Vavaʻu', 222, 'TO', '-18.62275600', '-173.99029820'),
        (3912, 'Tongatapu', 222, 'TO', '-21.14659680', '-175.25154820'),
        (3913, 'Haʻapai', 222, 'TO', '-19.75000000', '-174.36666700'),
        (3914, 'Niuas', 222, 'TO', '-15.95940000', '-173.78300000'),
        (3915, 'ʻEua', 222, 'TO', '37.09024000', '-95.71289100'),
        (3916, 'Markazi Province', 103, 'IR', '34.61230500', '49.85472660'),
        (3917, 'Khuzestan Province', 103, 'IR', '31.43601490', '49.04131200'),
        (3918, 'Ilam Province', 103, 'IR', '33.29576180', '46.67053400'),
        (3919, 'Kermanshah Province', 103, 'IR', '34.45762330', '46.67053400'),
        (3920, 'Gilan Province', 103, 'IR', '37.28094550', '49.59241340'),
        (3921, 'Chaharmahal and Bakhtiari Province', 103, 'IR', '31.99704190', '50.66138490'),
        (3922, 'Qom Province', 103, 'IR', '34.64157640', '50.87460350'),
        (3923, 'Isfahan Province', 103, 'IR', '33.27710730', '52.36133780'),
        (3924, 'West Azarbaijan Province', 103, 'IR', '37.45500620', '45.00000000'),
        (3925, 'Zanjan Province', 103, 'IR', '36.50181850', '48.39881860'),
        (3926, 'Kohgiluyeh and Boyer-Ahmad Province', 103, 'IR', '30.72458600', '50.84563230'),
        (3927, 'Razavi Khorasan Province', 103, 'IR', '35.10202530', '59.10417580'),
        (3928, 'Lorestan Province', 103, 'IR', '33.58183940', '48.39881860'),
        (3929, 'Alborz Province', 103, 'IR', '35.99604670', '50.92892460'),
        (3930, 'South Khorasan Province', 103, 'IR', '32.51756430', '59.10417580'),
        (3931, 'Sistan and Baluchestan', 103, 'IR', '27.52999060', '60.58206760'),
        (3932, 'Bushehr Province', 103, 'IR', '28.76207390', '51.51500770'),
        (3933, 'Golestan Province', 103, 'IR', '37.28981230', '55.13758340'),
        (3934, 'Ardabil Province', 103, 'IR', '38.48532760', '47.89112090'),
        (3935, 'Kurdistan Province', 103, 'IR', '35.95535790', '47.13621250'),
        (3936, 'Yazd Province', 103, 'IR', '32.10063870', '54.43421380'),
        (3937, 'Hormozgan Province', 103, 'IR', '27.13872300', '55.13758340'),
        (3938, 'Mazandaran Province', 103, 'IR', '36.22623930', '52.53186040'),
        (3939, 'Fars Province', 103, 'IR', '29.10438130', '53.04589300'),
        (3940, 'Semnan Province', 103, 'IR', '35.22555850', '54.43421380'),
        (3941, 'Qazvin Province', 103, 'IR', '36.08813170', '49.85472660'),
        (3942, 'North Khorasan Province', 103, 'IR', '37.47103530', '57.10131880'),
        (3943, 'Kerman Province', 103, 'IR', '29.48500890', '57.64390480'),
        (3944, 'East Azerbaijan Province', 103, 'IR', '37.90357330', '46.26821090'),
        (3945, 'Tehran Province', 103, 'IR', '35.72484160', '51.38165300'),
        (3946, 'Niutao Island Council', 228, 'TV', '-6.10642580', '177.34384290'),
        (3947, 'Nanumanga', 228, 'TV', '-6.28580190', '176.31992800'),
        (3948, 'Nui', 228, 'TV', '-7.23887680', '177.14852320'),
        (3949, 'Nanumea', 228, 'TV', '-5.68816170', '176.13701480'),
        (3950, 'Vaitupu', 228, 'TV', '-7.47673270', '178.67476750'),
        (3951, 'Funafuti', 228, 'TV', '-8.52114710', '179.19619260'),
        (3952, 'Nukufetau', 228, 'TV', '-8.00000000', '178.50000000'),
        (3953, 'Nukulaelae', 228, 'TV', '-9.38111100', '179.85222200'),
        (3954, 'Dhi Qar Governorate', 104, 'IQ', '31.10422920', '46.36246860'),
        (3955, 'Babylon Governorate', 104, 'IQ', '32.46819100', '44.55019350'),
        (3956, 'Al-Qādisiyyah Governorate', 104, 'IQ', '32.04369100', '45.14945050'),
        (3957, 'Karbala Governorate', 104, 'IQ', '32.40454930', '43.86732220'),
        (3958, 'Al Muthanna Governorate', 104, 'IQ', '29.91331710', '45.29938620'),
        (3959, 'Baghdad Governorate', 104, 'IQ', '33.31526180', '44.36606530'),
        (3960, 'Basra Governorate', 104, 'IQ', '30.51142520', '47.82962530'),
        (3961, 'Saladin Governorate', 104, 'IQ', '34.53375270', '43.48373800'),
        (3962, 'Najaf Governorate', 104, 'IQ', '31.35174860', '44.09603110'),
        (3963, 'Nineveh Governorate', 104, 'IQ', '36.22957400', '42.23624350'),
        (3964, 'Al Anbar Governorate', 104, 'IQ', '32.55976140', '41.91964710'),
        (3965, 'Diyala Governorate', 104, 'IQ', '33.77334870', '45.14945050'),
        (3966, 'Maysan Governorate', 104, 'IQ', '31.87340020', '47.13621250'),
        (3967, 'Dohuk Governorate', 104, 'IQ', '36.90772520', '43.06316890'),
        (3968, 'Erbil Governorate', 104, 'IQ', '36.55706280', '44.38512630'),
        (3969, 'Sulaymaniyah Governorate', 104, 'IQ', '35.54663480', '45.30036830'),
        (3970, 'Wasit Governorate', 104, 'IQ', '32.60240940', '45.75209850'),
        (3971, 'Kirkuk Governorate', 104, 'IQ', '35.32920140', '43.94367880'),
        (3972, 'Svay Rieng Province', 37, 'KH', '11.14272200', '105.82902980'),
        (3973, 'Preah Vihear Province', 37, 'KH', '14.00857970', '104.84546190'),
        (3974, 'Prey Veng Province', 37, 'KH', '11.38024420', '105.50054830'),
        (3975, 'Takéo Province', 37, 'KH', '10.93215190', '104.79877100'),
        (3976, 'Battambang Province', 37, 'KH', '13.02869710', '102.98961500'),
        (3977, 'Pursat Province', 37, 'KH', '12.27209560', '103.72891670'),
        (3978, 'Kep Province', 37, 'KH', '10.53608900', '104.35591580'),
        (3979, 'Kampong Chhnang Province', 37, 'KH', '12.13923520', '104.56552730'),
        (3980, 'Pailin Province', 37, 'KH', '12.90929620', '102.66755750'),
        (3981, 'Kampot Province', 37, 'KH', '10.73253510', '104.37919120'),
        (3982, 'Koh Kong Province', 37, 'KH', '11.57628040', '103.35872880'),
        (3983, 'Kandal Province', 37, 'KH', '11.22373830', '105.12589550'),
        (3984, 'Banteay Meanchey Province', 37, 'KH', '13.75319140', '102.98961500'),
        (3985, 'Mondulkiri Province', 37, 'KH', '12.78794270', '107.10119310'),
        (3986, 'Kratié Province', 37, 'KH', '12.50436080', '105.96998780'),
        (3987, 'Oddar Meanchey Province', 37, 'KH', '14.16097380', '103.82162610'),
        (3988, 'Kampong Speu Province', 37, 'KH', '11.61551090', '104.37919120'),
        (3989, 'Sihanoukville Province', 37, 'KH', '10.75818990', '103.82162610'),
        (3990, 'Ratanakiri Province', 37, 'KH', '13.85766070', '107.10119310'),
        (3991, 'Kampong Cham Province', 37, 'KH', '12.09829180', '105.31311850'),
        (3992, 'Siem Reap Province', 37, 'KH', '13.33026600', '104.10013260'),
        (3993, 'Stung Treng Province', 37, 'KH', '13.57647300', '105.96998780'),
        (3994, 'Phnom Penh', 37, 'KH', '11.55637380', '104.92820990'),
        (3995, 'North Hamgyong Province', 115, 'KP', '41.81487580', '129.45819550'),
        (3996, 'Ryanggang Province', 115, 'KP', '41.23189210', '128.50763590'),
        (3997, 'South Pyongan Province', 115, 'KP', '39.35391780', '126.16827100'),
        (3998, 'Chagang Province', 115, 'KP', '40.72028090', '126.56211370'),
        (3999, 'Kangwon Province', 115, 'KP', '38.84323930', '127.55970670'),
        (4000, 'South Hamgyong Province', 115, 'KP', '40.37253390', '128.29888400'),
        (4001, 'Rason', 115, 'KP', '42.25690630', '130.29771860'),
        (4002, 'North Pyongan Province', 115, 'KP', '39.92556180', '125.39280250'),
        (4003, 'South Hwanghae Province', 115, 'KP', '38.20072150', '125.47819260'),
        (4004, 'North Hwanghae Province', 115, 'KP', '38.37860850', '126.43643630'),
        (4005, 'Pyongyang', 115, 'KP', '39.03921930', '125.76252410'),
        (4006, 'Meghalaya', 101, 'IN', '25.46703080', '91.36621600'),
        (4007, 'Haryana', 101, 'IN', '29.05877570', '76.08560100'),
        (4008, 'Maharashtra', 101, 'IN', '19.75147980', '75.71388840'),
        (4009, 'Goa', 101, 'IN', '15.29932650', '74.12399600'),
        (4010, 'Manipur', 101, 'IN', '24.66371730', '93.90626880'),
        (4011, 'Puducherry', 101, 'IN', '11.94159150', '79.80831330'),
        (4012, 'Telangana', 101, 'IN', '18.11243720', '79.01929970'),
        (4013, 'Odisha', 101, 'IN', '20.95166580', '85.09852360'),
        (4014, 'Rajasthan', 101, 'IN', '27.02380360', '74.21793260'),
        (4015, 'Punjab', 101, 'IN', NULL, NULL),
        (4016, 'Uttarakhand', 101, 'IN', '30.06675300', '79.01929970'),
        (4017, 'Andhra Pradesh', 101, 'IN', '15.91289980', '79.73998750'),
        (4018, 'Nagaland', 101, 'IN', '26.15843540', '94.56244260'),
        (4019, 'Lakshadweep', 101, 'IN', '10.32802650', '72.78463360'),
        (4020, 'Himachal Pradesh', 101, 'IN', '31.10482940', '77.17339010'),
        (4021, 'Delhi', 101, 'IN', '28.70405920', '77.10249020'),
        (4022, 'Uttar Pradesh', 101, 'IN', '26.84670880', '80.94615920'),
        (4023, 'Andaman and Nicobar Islands', 101, 'IN', '11.74008670', '92.65864010'),
        (4024, 'Arunachal Pradesh', 101, 'IN', '28.21799940', '94.72775280'),
        (4025, 'Jharkhand', 101, 'IN', '23.61018080', '85.27993540'),
        (4026, 'Karnataka', 101, 'IN', '15.31727750', '75.71388840'),
        (4027, 'Assam', 101, 'IN', '26.20060430', '92.93757390'),
        (4028, 'Kerala', 101, 'IN', '10.85051590', '76.27108330'),
        (4029, 'Jammu and Kashmir', 101, 'IN', '33.27783900', '75.34121790'),
        (4030, 'Gujarat', 101, 'IN', '22.25865200', '71.19238050'),
        (4031, 'Chandigarh', 101, 'IN', '30.73331480', '76.77941790'),
        (4033, 'Dadra and Nagar Haveli and Daman and Diu', 101, 'IN', '20.39737360', '72.83279910'),
        (4034, 'Sikkim', 101, 'IN', '27.53297180', '88.51221780'),
        (4035, 'Tamil Nadu', 101, 'IN', '11.12712250', '78.65689420'),
        (4036, 'Mizoram', 101, 'IN', '23.16454300', '92.93757390'),
        (4037, 'Bihar', 101, 'IN', '25.09607420', '85.31311940'),
        (4038, 'Tripura', 101, 'IN', '23.94084820', '91.98815270'),
        (4039, 'Madhya Pradesh', 101, 'IN', '22.97342290', '78.65689420'),
        (4040, 'Chhattisgarh', 101, 'IN', '21.27865670', '81.86614420'),
        (4041, 'Choluteca Department', 97, 'HN', '13.25043250', '-87.14228950'),
        (4042, 'Comayagua Department', 97, 'HN', '14.55348280', '-87.61863790'),
        (4043, 'El Paraíso Department', 97, 'HN', '13.98212940', '-86.49965460'),
        (4044, 'Intibucá Department', 97, 'HN', '14.37273400', '-88.24611830'),
        (4045, 'Bay Islands Department', 97, 'HN', '16.48266140', '-85.87932520'),
        (4046, 'Cortés Department', 97, 'HN', '15.49235080', '-88.09007620'),
        (4047, 'Atlántida Department', 97, 'HN', '15.66962830', '-87.14228950'),
        (4048, 'Gracias a Dios Department', 97, 'HN', '15.34180600', '-84.60604490'),
        (4049, 'Copán Department', 97, 'HN', '14.93608380', '-88.86469800'),
        (4050, 'Olancho Department', 97, 'HN', '14.80674060', '-85.76666450'),
        (4051, 'Colón Department', 97, 'HN', '15.64259650', '-85.52002400'),
        (4052, 'Francisco Morazán Department', 97, 'HN', '14.45411000', '-87.06242610'),
        (4053, 'Santa Bárbara Department', 97, 'HN', '15.12027950', '-88.40160410'),
        (4054, 'Lempira Department', 97, 'HN', '14.18876980', '-88.55653100'),
        (4055, 'Valle Department', 97, 'HN', '13.57829360', '-87.57912870'),
        (4056, 'Ocotepeque Department', 97, 'HN', '14.51703470', '-89.05615320'),
        (4057, 'Yoro Department', 97, 'HN', '15.29496790', '-87.14228950'),
        (4058, 'La Paz Department', 97, 'HN', '-15.08924160', '-68.52471490'),
        (4059, 'Northland Region', 158, 'NZ', '-35.41361720', '173.93208060'),
        (4060, 'Manawatu-Wanganui Region', 158, 'NZ', '-39.72733560', '175.43755740'),
        (4061, 'Waikato Region', 158, 'NZ', '-37.61908620', '175.02334600'),
        (4062, 'Otago Region', 158, 'NZ', '-45.47906710', '170.15475670'),
        (4063, 'Marlborough Region', 158, 'NZ', '-41.59168830', '173.76240530'),
        (4064, 'West Coast Region', 158, 'NZ', '62.41136340', '-149.07297140'),
        (4065, 'Wellington Region', 158, 'NZ', '-41.02993230', '175.43755740'),
        (4066, 'Canterbury Region', 158, 'NZ', '-43.75422750', '171.16372450'),
        (4067, 'Chatham Islands', 158, 'NZ', '-44.00575230', '-176.54006740'),
        (4068, 'Gisborne District', 158, 'NZ', '-38.13581740', '178.32393090'),
        (4069, 'Taranaki Region', 158, 'NZ', '-39.35381490', '174.43827210'),
        (4070, 'Nelson Region', 158, 'NZ', '-41.29853970', '173.24414910'),
        (4071, 'Southland Region', 158, 'NZ', '-45.84891590', '167.67553870'),
        (4072, 'Auckland Region', 158, 'NZ', '-36.66753280', '174.77333250'),
        (4073, 'Tasman District', 158, 'NZ', '-41.45711840', '172.82097400'),
        (4074, 'Bay of Plenty Region', 158, 'NZ', '-37.42339170', '176.74163740'),
        (4075, 'Hawke\'s Bay Region', 158, 'NZ', '-39.60165970', '176.58044730'),
        (4076, 'Saint John Parish', 61, 'DM', NULL, NULL),
        (4077, 'Saint Mark Parish', 61, 'DM', NULL, NULL),
        (4078, 'Saint David Parish', 61, 'DM', NULL, NULL),
        (4079, 'Saint George Parish', 61, 'DM', NULL, NULL),
        (4080, 'Saint Patrick Parish', 61, 'DM', NULL, NULL),
        (4081, 'Saint Peter Parish', 61, 'DM', '40.45241940', '-80.00850560'),
        (4082, 'Saint Andrew Parish', 61, 'DM', NULL, NULL),
        (4083, 'Saint Luke Parish', 61, 'DM', '42.10513630', '-80.05707220'),
        (4084, 'Saint Paul Parish', 61, 'DM', '38.86146000', '-90.74356190'),
        (4085, 'Saint Joseph Parish', 61, 'DM', '39.02227120', '-94.71765040'),
        (4086, 'El Seibo Province', 62, 'DO', '18.76584960', '-69.04066800'),
        (4087, 'La Romana Province', 62, 'DO', '18.43102710', '-68.98373730'),
        (4088, 'Sánchez Ramírez Province', 62, 'DO', '19.05270600', '-70.14922640'),
        (4089, 'Hermanas Mirabal Province', 62, 'DO', '19.37475590', '-70.35132350'),
        (4090, 'Barahona Province', 62, 'DO', '18.21390660', '-71.10437590'),
        (4091, 'San Cristóbal Province', 62, 'DO', '18.41804140', '-70.10658490'),
        (4092, 'Puerto Plata Province', 62, 'DO', '19.75432250', '-70.83328470'),
        (4093, 'Santo Domingo Province', 62, 'DO', '18.51042530', '-69.84040540'),
        (4094, 'María Trinidad Sánchez Province', 62, 'DO', '19.37345970', '-69.85144390'),
        (4095, 'Distrito Nacional', 62, 'DO', '18.48605750', '-69.93121170'),
        (4096, 'Peravia Province', 62, 'DO', '18.27865940', '-70.33358870'),
        (4097, 'Independencia', 62, 'DO', '32.63357480', '-115.42892940'),
        (4098, 'San Juan Province', 62, 'DO', '-31.52871270', '-68.53604030'),
        (4099, 'Monseñor Nouel Province', 62, 'DO', '18.92152340', '-70.38368150'),
        (4100, 'Santiago Rodríguez Province', 62, 'DO', '19.47131810', '-71.33958010'),
        (4101, 'Pedernales Province', 62, 'DO', '17.85376260', '-71.33032090'),
        (4102, 'Espaillat Province', 62, 'DO', '19.62776580', '-70.27867750'),
        (4103, 'Samaná Province', 62, 'DO', '19.20583710', '-69.33629490'),
        (4104, 'Valverde Province', 62, 'DO', '19.58812210', '-70.98033100'),
        (4105, 'Baoruco Province', 62, 'DO', '18.48798980', '-71.41822490'),
        (4106, 'Hato Mayor Province', 62, 'DO', '18.76357990', '-69.25576370'),
        (4107, 'Dajabón Province', 62, 'DO', '19.54992410', '-71.70865140'),
        (4108, 'Santiago Province', 62, 'DO', '-33.45000000', '-70.66670000'),
        (4109, 'La Altagracia Province', 62, 'DO', '18.58502360', '-68.62010720'),
        (4110, 'San Pedro de Macorís', 62, 'DO', '18.46266000', '-69.30512340'),
        (4111, 'Monte Plata Province', 62, 'DO', '18.80808780', '-69.78691460'),
        (4112, 'San José de Ocoa Province', 62, 'DO', '18.54385800', '-70.50418160'),
        (4113, 'Duarte Province', 62, 'DO', '19.20908230', '-70.02700040'),
        (4114, 'Azua Province', 62, 'DO', '18.45527090', '-70.73809280'),
        (4115, 'Monte Cristi Province', 62, 'DO', '19.73968990', '-71.44339840'),
        (4116, 'La Vega Province', 62, 'DO', '19.22115540', '-70.52887530'),
        (4117, 'Nord', 95, 'HT', '43.19052600', '-89.43792100'),
        (4118, 'Nippes', 95, 'HT', '18.39907350', '-73.41802110'),
        (4119, 'Grand\'Anse', 95, 'HT', '12.01666670', '-61.76666670'),
        (4120, 'Ouest', 95, 'HT', '45.45472490', '-73.65023650'),
        (4121, 'Nord-Est', 95, 'HT', '19.48897230', '-71.85713310'),
        (4122, 'Sud', 95, 'HT', '29.92132480', '-90.09737720'),
        (4123, 'Artibonite', 95, 'HT', '19.36290200', '-72.42581450'),
        (4124, 'Sud-Est', 95, 'HT', '18.27835980', '-72.35479150'),
        (4125, 'Centre', 95, 'HT', '32.83702510', '-96.77738820'),
        (4126, 'Nord-Ouest', 95, 'HT', '19.83740090', '-73.04052770'),
        (4127, 'San Vicente Department', 66, 'SV', '13.58685610', '-88.74939980'),
        (4128, 'Santa Ana Department', 66, 'SV', '14.14611210', '-89.51200840'),
        (4129, 'Usulután Department', 66, 'SV', '13.44706340', '-88.55653100'),
        (4130, 'Morazán Department', 66, 'SV', '13.76820000', '-88.12913870'),
        (4131, 'Chalatenango Department', 66, 'SV', '14.19166480', '-89.17059980'),
        (4132, 'Cabañas Department', 66, 'SV', '13.86482880', '-88.74939980'),
        (4133, 'San Salvador Department', 66, 'SV', '13.77399970', '-89.20867730'),
        (4134, 'La Libertad Department', 66, 'SV', '13.68176610', '-89.36062980'),
        (4135, 'San Miguel Department', 66, 'SV', '13.44510410', '-88.24611830'),
        (4136, 'La Paz Department', 66, 'SV', NULL, NULL),
        (4137, 'Cuscatlán Department', 66, 'SV', '13.86619570', '-89.05615320'),
        (4138, 'La Unión Department', 66, 'SV', '13.48864430', '-87.89424510'),
        (4139, 'Ahuachapán Department', 66, 'SV', '13.82161480', '-89.92532330'),
        (4140, 'Sonsonate Department', 66, 'SV', '13.68235800', '-89.66281110'),
        (4141, 'Braslovče Municipality', 201, 'SI', '46.28361920', '15.04183200'),
        (4142, 'Lenart Municipality', 201, 'SI', '46.58344240', '15.82621250'),
        (4143, 'Oplotnica', 201, 'SI', '46.38716300', '15.44581310'),
        (4144, 'Velike Lašče Municipality', 201, 'SI', '45.83365910', '14.63623630'),
        (4145, 'Hajdina Municipality', 201, 'SI', '46.41850140', '15.82447220'),
        (4146, 'Podčetrtek Municipality', 201, 'SI', '46.17395420', '15.60138160'),
        (4147, 'Cankova Municipality', 201, 'SI', '46.71823700', '16.01972220'),
        (4148, 'Vitanje Municipality', 201, 'SI', '46.38153230', '15.29506870'),
        (4149, 'Sežana Municipality', 201, 'SI', '45.72751090', '13.86619310'),
        (4150, 'Kidričevo Municipality', 201, 'SI', '46.39575720', '15.79259060'),
        (4151, 'Črenšovci Municipality', 201, 'SI', '46.57200290', '16.28773460'),
        (4152, 'Idrija Municipality', 201, 'SI', '46.00409390', '13.97754930'),
        (4153, 'Trnovska Vas Municipality', 201, 'SI', '46.52940350', '15.88531180'),
        (4154, 'Vodice Municipality', 201, 'SI', '46.18966430', '14.49385390'),
        (4155, 'Ravne na Koroškem Municipality', 201, 'SI', '46.55211940', '14.95990840'),
        (4156, 'Lovrenc na Pohorju Municipality', 201, 'SI', '46.54196380', '15.40004430'),
        (4157, 'Majšperk Municipality', 201, 'SI', '46.35030190', '15.73405950'),
        (4158, 'Loški Potok Municipality', 201, 'SI', '45.69096370', '14.59859700'),
        (4159, 'Domžale Municipality', 201, 'SI', '46.14382690', '14.63752790'),
        (4160, 'Rečica ob Savinji Municipality', 201, 'SI', '46.32337900', '14.92236700'),
        (4161, 'Podlehnik Municipality', 201, 'SI', '46.33107820', '15.87858360'),
        (4162, 'Cerknica Municipality', 201, 'SI', '45.79662550', '14.39217700'),
        (4163, 'Vransko Municipality', 201, 'SI', '46.23900600', '14.95272490'),
        (4164, 'Sveta Ana Municipality', 201, 'SI', '46.65000000', '15.84527800'),
        (4165, 'Brezovica Municipality', 201, 'SI', '45.95593510', '14.43499520'),
        (4166, 'Benedikt Municipality', 201, 'SI', '46.61558410', '15.89572810'),
        (4167, 'Divača Municipality', 201, 'SI', '45.68060690', '13.97203120'),
        (4168, 'Moravče Municipality', 201, 'SI', '46.13627810', '14.74600100'),
        (4169, 'Slovenj Gradec City Municipality', 201, 'SI', '46.48777180', '15.07294780'),
        (4170, 'Škocjan Municipality', 201, 'SI', '45.91754540', '15.31017360'),
        (4171, 'Šentjur Municipality', 201, 'SI', '46.26543390', '15.40800000'),
        (4172, 'Pesnica Municipality', 201, 'SI', '46.60887550', '15.67570510'),
        (4173, 'Dol pri Ljubljani Municipality', 201, 'SI', '46.08843860', '14.64247920'),
        (4174, 'Loška Dolina Municipality', 201, 'SI', '45.64779080', '14.49731470'),
        (4175, 'Hoče–Slivnica Municipality', 201, 'SI', '46.47785800', '15.64760050'),
        (4176, 'Cerkvenjak Municipality', 201, 'SI', '46.56707110', '15.94297530'),
        (4177, 'Naklo Municipality', 201, 'SI', '46.27186630', '14.31569320'),
        (4178, 'Cerkno Municipality', 201, 'SI', '46.12884140', '13.98940270'),
        (4179, 'Bistrica ob Sotli Municipality', 201, 'SI', '46.05655790', '15.66259470'),
        (4180, 'Kamnik Municipality', 201, 'SI', '46.22216660', '14.60707270'),
        (4181, 'Bovec Municipality', 201, 'SI', '46.33804950', '13.55241740'),
        (4182, 'Zavrč Municipality', 201, 'SI', '46.35713000', '16.04777470'),
        (4183, 'Ajdovščina Municipality', 201, 'SI', '45.88707760', '13.90428180'),
        (4184, 'Pivka Municipality', 201, 'SI', '45.67892960', '14.25426890'),
        (4185, 'Štore Municipality', 201, 'SI', '46.22225140', '15.31261160'),
        (4186, 'Kozje Municipality', 201, 'SI', '46.07332110', '15.55967190'),
        (4187, 'Municipality of Škofljica', 201, 'SI', '45.98409620', '14.57466260'),
        (4188, 'Prebold Municipality', 201, 'SI', '46.23591360', '15.09369120'),
        (4189, 'Dobrovnik Municipality', 201, 'SI', '46.65386620', '16.35065940'),
        (4190, 'Mozirje Municipality', 201, 'SI', '46.33943500', '14.96024130'),
        (4191, 'City Municipality of Celje', 201, 'SI', '46.23974950', '15.26770630'),
        (4192, 'Žiri Municipality', 201, 'SI', '46.04724990', '14.10984510'),
        (4193, 'Horjul Municipality', 201, 'SI', '46.02253780', '14.29862690'),
        (4194, 'Tabor Municipality', 201, 'SI', '46.21079210', '15.01742490'),
        (4195, 'Radeče Municipality', 201, 'SI', '46.06669540', '15.18204380'),
        (4196, 'Vipava Municipality', 201, 'SI', '45.84126740', '13.96096130'),
        (4197, 'Kungota', 201, 'SI', '46.64187930', '15.60362880'),
        (4198, 'Slovenske Konjice Municipality', 201, 'SI', '46.33691910', '15.42147080'),
        (4199, 'Osilnica Municipality', 201, 'SI', '45.54184670', '14.71563030'),
        (4200, 'Borovnica Municipality', 201, 'SI', '45.90445250', '14.38241890'),
        (4201, 'Piran Municipality', 201, 'SI', '45.52888560', '13.56807350'),
        (4202, 'Bled Municipality', 201, 'SI', '46.36832660', '14.11457980'),
        (4203, 'Jezersko Municipality', 201, 'SI', '46.39427940', '14.49855590'),
        (4204, 'Rače–Fram Municipality', 201, 'SI', '46.45420830', '15.63294670'),
        (4205, 'Nova Gorica City Municipality', 201, 'SI', '45.97627600', '13.73088810'),
        (4206, 'Razkrižje Municipality', 201, 'SI', '46.52263390', '16.26686380'),
        (4207, 'Ribnica na Pohorju Municipality', 201, 'SI', '46.53561450', '15.26745380'),
        (4208, 'Muta Municipality', 201, 'SI', '46.60973660', '15.16299950'),
        (4209, 'Rogatec Municipality', 201, 'SI', '46.22866260', '15.69913380'),
        (4210, 'Gorišnica Municipality', 201, 'SI', '46.41202710', '16.01330890'),
        (4211, 'Kuzma Municipality', 201, 'SI', '46.83510380', '16.08071000'),
        (4212, 'Mislinja Municipality', 201, 'SI', '46.44294030', '15.19876780'),
        (4213, 'Duplek Municipality', 201, 'SI', '46.50100160', '15.75463070'),
        (4214, 'Trebnje Municipality', 201, 'SI', '45.90801630', '15.01319050'),
        (4215, 'Brežice Municipality', 201, 'SI', '45.90410960', '15.59436390'),
        (4216, 'Dobrepolje Municipality', 201, 'SI', '45.85249510', '14.70831090'),
        (4217, 'Grad Municipality', 201, 'SI', '46.80873200', '16.10920600'),
        (4218, 'Moravske Toplice Municipality', 201, 'SI', '46.68569320', '16.22245820'),
        (4219, 'Luče Municipality', 201, 'SI', '46.35449250', '14.74715040'),
        (4220, 'Miren–Kostanjevica Municipality', 201, 'SI', '45.84360290', '13.62766470'),
        (4221, 'Ormož Municipality', 201, 'SI', '46.43533330', '16.15437400'),
        (4222, 'Šalovci Municipality', 201, 'SI', '46.85335680', '16.25917910'),
        (4223, 'Miklavž na Dravskem Polju Municipality', 201, 'SI', '46.50826280', '15.69520650'),
        (4224, 'Makole Municipality', 201, 'SI', '46.31686970', '15.66641260'),
        (4225, 'Lendava Municipality', 201, 'SI', '46.55134830', '16.44198390'),
        (4226, 'Vuzenica Municipality', 201, 'SI', '46.59808360', '15.16572370'),
        (4227, 'Kanal ob Soči Municipality', 201, 'SI', '46.06735300', '13.62033500'),
        (4228, 'Ptuj City Municipality', 201, 'SI', '46.41995350', '15.86968840'),
        (4229, 'Sveti Andraž v Slovenskih Goricah Municipality', 201, 'SI', '46.51897470', '15.94982620'),
        (4230, 'Selnica ob Dravi Municipality', 201, 'SI', '46.55139180', '15.49294100'),
        (4231, 'Radovljica Municipality', 201, 'SI', '46.33558270', '14.20945340'),
        (4232, 'Črna na Koroškem Municipality', 201, 'SI', '46.47045290', '14.84999980'),
        (4233, 'Rogaška Slatina Municipality', 201, 'SI', '46.24539730', '15.62650140'),
        (4234, 'Podvelka Municipality', 201, 'SI', '46.62219520', '15.38899220'),
        (4235, 'Ribnica Municipality', 201, 'SI', '45.74003030', '14.72657820'),
        (4236, 'City Municipality of Novo Mesto', 201, 'SI', '45.80108240', '15.17100890'),
        (4237, 'Mirna Peč Municipality', 201, 'SI', '45.84815740', '15.08794500'),
        (4238, 'Križevci Municipality', 201, 'SI', '46.57018210', '16.10926530'),
        (4239, 'Poljčane Municipality', 201, 'SI', '46.31398530', '15.57847910'),
        (4240, 'Brda Municipality', 201, 'SI', '45.99756520', '13.52704740'),
        (4241, 'Šentjernej Municipality', 201, 'SI', '45.84341300', '15.33783120'),
        (4242, 'Maribor City Municipality', 201, 'SI', '46.55064960', '15.62054390'),
        (4243, 'Kobarid Municipality', 201, 'SI', '46.24569710', '13.57869490'),
        (4244, 'Markovci Municipality', 201, 'SI', '46.38793090', '15.95860140'),
        (4245, 'Vojnik Municipality', 201, 'SI', '46.29205810', '15.30205800'),
        (4246, 'Trbovlje Municipality', 201, 'SI', '46.15035630', '15.04531370'),
        (4247, 'Tolmin Municipality', 201, 'SI', '46.18571880', '13.73198380'),
        (4248, 'Šoštanj Municipality', 201, 'SI', '46.37828360', '15.04613780'),
        (4249, 'Žetale Municipality', 201, 'SI', '46.27428330', '15.79133590'),
        (4250, 'Tržič Municipality', 201, 'SI', '46.35935140', '14.30066230'),
        (4251, 'Turnišče Municipality', 201, 'SI', '46.61375040', '16.32021000'),
        (4252, 'Dobrna Municipality', 201, 'SI', '46.33561410', '15.22597320'),
        (4253, 'Renče–Vogrsko Municipality', 201, 'SI', '45.89546170', '13.67856730'),
        (4254, 'Kostanjevica na Krki Municipality', 201, 'SI', '45.83166380', '15.44119060'),
        (4255, 'Sveti Jurij ob Ščavnici Municipality', 201, 'SI', '46.56874520', '16.02225280'),
        (4256, 'Železniki Municipality', 201, 'SI', '46.22563770', '14.16936170'),
        (4257, 'Veržej Municipality', 201, 'SI', '46.58411350', '16.16208000'),
        (4258, 'Žalec Municipality', 201, 'SI', '46.25197120', '15.16500720'),
        (4259, 'Starše Municipality', 201, 'SI', '46.46743310', '15.76405460'),
        (4260, 'Sveta Trojica v Slovenskih Goricah Municipality', 201, 'SI', '46.56808090', '15.88230640'),
        (4261, 'Solčava Municipality', 201, 'SI', '46.40235260', '14.68023040'),
        (4262, 'Vrhnika Municipality', 201, 'SI', '45.95027190', '14.32764220'),
        (4263, 'Središče ob Dravi', 201, 'SI', '46.39592820', '16.27049150'),
        (4264, 'Rogašovci Municipality', 201, 'SI', '46.80557850', '16.03452370'),
        (4265, 'Mežica Municipality', 201, 'SI', '46.52150270', '14.85213400'),
        (4266, 'Juršinci Municipality', 201, 'SI', '46.48986510', '15.98092300'),
        (4267, 'Velika Polana Municipality', 201, 'SI', '46.57317150', '16.34441260'),
        (4268, 'Sevnica Municipality', 201, 'SI', '46.00703170', '15.30456790'),
        (4269, 'Zagorje ob Savi Municipality', 201, 'SI', '46.13452020', '14.99643840'),
        (4270, 'Ljubljana City Municipality', 201, 'SI', '46.05694650', '14.50575150'),
        (4271, 'Gornji Petrovci Municipality', 201, 'SI', '46.80371280', '16.21913790'),
        (4272, 'Polzela Municipality', 201, 'SI', '46.28089700', '15.07373210'),
        (4273, 'Sveti Tomaž Municipality', 201, 'SI', '46.48352830', '16.07944200'),
        (4274, 'Prevalje Municipality', 201, 'SI', '46.56211460', '14.88478610'),
        (4275, 'Radlje ob Dravi Municipality', 201, 'SI', '46.61357320', '15.23544380'),
        (4276, 'Žirovnica Municipality', 201, 'SI', '46.39544030', '14.15396320'),
        (4277, 'Sodražica Municipality', 201, 'SI', '45.76165650', '14.63528530'),
        (4278, 'Bloke Municipality', 201, 'SI', '45.77281410', '14.50634590'),
        (4279, 'Šmartno pri Litiji Municipality', 201, 'SI', '46.04549710', '14.84101330'),
        (4280, 'Ruše Municipality', 201, 'SI', '46.52062650', '15.48178690'),
        (4281, 'Dolenjske Toplice Municipality', 201, 'SI', '45.73457110', '15.01294930'),
        (4282, 'Bohinj Municipality', 201, 'SI', '46.30056520', '13.94271950'),
        (4283, 'Komenda Municipality', 201, 'SI', '46.20648800', '14.53824990'),
        (4284, 'Gorje Municipality', 201, 'SI', '46.38024580', '14.06853390'),
        (4285, 'Šmarje pri Jelšah Municipality', 201, 'SI', '46.22870250', '15.51903530'),
        (4286, 'Ig Municipality', 201, 'SI', '45.95888680', '14.52705280'),
        (4287, 'Kranj City Municipality', 201, 'SI', '46.25850210', '14.35435690'),
        (4288, 'Puconci Municipality', 201, 'SI', '46.72004180', '16.09977920'),
        (4289, 'Šmarješke Toplice Municipality', 201, 'SI', '45.86803770', '15.23474220'),
        (4290, 'Dornava Municipality', 201, 'SI', '46.44435130', '15.98891590'),
        (4291, 'Črnomelj Municipality', 201, 'SI', '45.53612250', '15.19441430'),
        (4292, 'Radenci Municipality', 201, 'SI', '46.62311210', '16.05069030'),
        (4293, 'Gorenja Vas–Poljane Municipality', 201, 'SI', '46.11165820', '14.11493480'),
        (4294, 'Ljubno Municipality', 201, 'SI', '46.34431250', '14.83354920'),
        (4295, 'Dobje Municipality', 201, 'SI', '46.13700370', '15.39412900'),
        (4296, 'Šmartno ob Paki Municipality', 201, 'SI', '46.32903720', '15.03339370'),
        (4297, 'Mokronog–Trebelno Municipality', 201, 'SI', '45.90885290', '15.15967360'),
        (4298, 'Mirna Municipality', 201, 'SI', '45.95156470', '15.06209770'),
        (4299, 'Šenčur Municipality', 201, 'SI', '46.24336990', '14.41922230'),
        (4300, 'Videm Municipality', 201, 'SI', '46.36383300', '15.87812120'),
        (4301, 'Beltinci Municipality', 201, 'SI', '46.60791530', '16.23651270'),
        (4302, 'Lukovica Municipality', 201, 'SI', '46.16962930', '14.69072590'),
        (4303, 'Preddvor Municipality', 201, 'SI', '46.30171390', '14.42181650'),
        (4304, 'Destrnik Municipality', 201, 'SI', '46.49223680', '15.87779560'),
        (4305, 'Ivančna Gorica Municipality', 201, 'SI', '45.93958410', '14.80476260'),
        (4306, 'Log–Dragomer Municipality', 201, 'SI', '46.01787470', '14.36877670'),
        (4307, 'Žužemberk Municipality', 201, 'SI', '45.82003500', '14.95359190'),
        (4308, 'Dobrova–Polhov Gradec Municipality', 201, 'SI', '46.06488960', '14.31681950'),
        (4309, 'Municipality of Cirkulane', 201, 'SI', '46.32983220', '15.99806660'),
        (4310, 'Cerklje na Gorenjskem Municipality', 201, 'SI', '46.25170540', '14.48579790'),
        (4311, 'Šentrupert Municipality', 201, 'SI', '45.98731420', '15.08297830'),
        (4312, 'Tišina Municipality', 201, 'SI', '46.65418840', '16.07547810'),
        (4313, 'Murska Sobota City Municipality', 201, 'SI', '46.64321470', '16.15157540'),
        (4314, 'Municipality of Krško', 201, 'SI', '45.95896090', '15.49235550'),
        (4315, 'Komen Municipality', 201, 'SI', '45.81752350', '13.74827110'),
        (4316, 'Škofja Loka Municipality', 201, 'SI', '46.14098440', '14.28118730'),
        (4317, 'Šempeter–Vrtojba Municipality', 201, 'SI', '45.92900950', '13.64155940'),
        (4318, 'Municipality of Apače', 201, 'SI', '46.69746790', '15.91025340'),
        (4319, 'Koper City Municipality', 201, 'SI', '45.54805900', '13.73018770'),
        (4320, 'Odranci Municipality', 201, 'SI', '46.59010170', '16.27881650'),
        (4321, 'Hrpelje–Kozina Municipality', 201, 'SI', '45.60911920', '13.93791480'),
        (4322, 'Izola Municipality', 201, 'SI', '45.53135570', '13.66646490'),
        (4323, 'Metlika Municipality', 201, 'SI', '45.64807150', '15.31778380'),
        (4324, 'Šentilj Municipality', 201, 'SI', '46.68628390', '15.71035670'),
        (4325, 'Kobilje Municipality', 201, 'SI', '46.68518000', '16.39367190'),
        (4326, 'Ankaran Municipality', 201, 'SI', '45.57845100', '13.73691740'),
        (4327, 'Hodoš Municipality', 201, 'SI', '46.83141340', '16.32106800'),
        (4328, 'Sveti Jurij v Slovenskih Goricah Municipality', 201, 'SI', '46.61707910', '15.78046770'),
        (4329, 'Nazarje Municipality', 201, 'SI', '46.28217410', '14.92256290'),
        (4330, 'Postojna Municipality', 201, 'SI', '45.77493900', '14.21342630'),
        (4331, 'Kostel Municipality', 201, 'SI', '45.49282550', '14.87082350'),
        (4332, 'Slovenska Bistrica Municipality', 201, 'SI', '46.39198130', '15.57278690'),
        (4333, 'Straža Municipality', 201, 'SI', '45.77684280', '15.09486940'),
        (4334, 'Trzin Municipality', 201, 'SI', '46.12982410', '14.55776370'),
        (4335, 'Kočevje Municipality', 201, 'SI', '45.64280000', '14.86158380'),
        (4336, 'Grosuplje Municipality', 201, 'SI', '45.95576450', '14.65889900'),
        (4337, 'Jesenice Municipality', 201, 'SI', '46.43670470', '14.05260570'),
        (4338, 'Laško Municipality', 201, 'SI', '46.15422360', '15.23614910'),
        (4339, 'Gornji Grad Municipality', 201, 'SI', '46.29617120', '14.80623470'),
        (4340, 'Kranjska Gora Municipality', 201, 'SI', '46.48452930', '13.78571450'),
        (4341, 'Hrastnik Municipality', 201, 'SI', '46.14172880', '15.08448940'),
        (4342, 'Zreče Municipality', 201, 'SI', '46.41777860', '15.37094310'),
        (4343, 'Gornja Radgona Municipality', 201, 'SI', '46.67670990', '15.99108470'),
        (4344, 'Municipality of Ilirska Bistrica', 201, 'SI', '45.57913230', '14.28097290'),
        (4345, 'Dravograd Municipality', 201, 'SI', '46.58921900', '15.02460210'),
        (4346, 'Semič Municipality', 201, 'SI', '45.65205340', '15.18207010'),
        (4347, 'Litija Municipality', 201, 'SI', '46.05732260', '14.83096360'),
        (4348, 'Mengeš Municipality', 201, 'SI', '46.16591220', '14.57196940'),
        (4349, 'Medvode Municipality', 201, 'SI', '46.14190800', '14.40325960'),
        (4350, 'Logatec Municipality', 201, 'SI', '45.91761100', '14.23514510'),
        (4351, 'Ljutomer Municipality', 201, 'SI', '46.51908480', '16.18932160'),
        (4352, 'Banská Bystrica Region', 200, 'SK', '48.53124990', '19.38287400'),
        (4353, 'Košice Region', 200, 'SK', '48.63757370', '21.08342250'),
        (4354, 'Prešov Region', 200, 'SK', '49.17167730', '21.37420010'),
        (4355, 'Trnava Region', 200, 'SK', '48.39438980', '17.72162050'),
        (4356, 'Bratislava Region', 200, 'SK', '48.31183040', '17.19732990'),
        (4357, 'Nitra Region', 200, 'SK', '48.01437650', '18.54165040'),
        (4358, 'Trenčín Region', 200, 'SK', '48.80867580', '18.23240260'),
        (4359, 'Žilina Region', 200, 'SK', '49.20314350', '19.36457330'),
        (4360, 'Cimișlia District', 144, 'MD', '46.52508510', '28.77218350'),
        (4361, 'Orhei District', 144, 'MD', '47.38604000', '28.83030820'),
        (4362, 'Bender Municipality', 144, 'MD', '46.82275510', '29.46201010'),
        (4363, 'Nisporeni District', 144, 'MD', '47.07513490', '28.17681550'),
        (4364, 'Sîngerei District', 144, 'MD', '47.63891340', '28.13718160'),
        (4365, 'Căușeni District', 144, 'MD', '46.65547150', '29.40912220'),
        (4366, 'Călărași District', 144, 'MD', '47.28694600', '28.27453100'),
        (4367, 'Glodeni District', 144, 'MD', '47.77901560', '27.51680100'),
        (4368, 'Anenii Noi District', 144, 'MD', '46.87956630', '29.23121750'),
        (4369, 'Ialoveni District', 144, 'MD', '46.86308600', '28.82342180'),
        (4370, 'Florești District', 144, 'MD', '47.86678490', '28.33918640'),
        (4371, 'Telenești District', 144, 'MD', '47.49839620', '28.36760190'),
        (4372, 'Taraclia District', 144, 'MD', '45.89865100', '28.66716440'),
        (4373, 'Chișinău Municipality', 144, 'MD', '47.01045290', '28.86381020'),
        (4374, 'Soroca District', 144, 'MD', '48.15497430', '28.28707830'),
        (4375, 'Briceni District', 144, 'MD', '48.36320220', '27.07503980'),
        (4376, 'Rîșcani District', 144, 'MD', '47.90701530', '27.53749960'),
        (4377, 'Strășeni District', 144, 'MD', '47.14502670', '28.61367360'),
        (4378, 'Ștefan Vodă District', 144, 'MD', '46.55404880', '29.70224200'),
        (4379, 'Basarabeasca District', 144, 'MD', '46.42370600', '28.89354920'),
        (4380, 'Cantemir District', 144, 'MD', '46.27717420', '28.20096530'),
        (4381, 'Fălești District', 144, 'MD', '47.56477250', '27.72655930'),
        (4382, 'Hîncești District', 144, 'MD', '46.82811470', '28.58508890'),
        (4383, 'Dubăsari District', 144, 'MD', '47.26439420', '29.15503480'),
        (4384, 'Dondușeni District', 144, 'MD', '48.23383050', '27.59980870'),
        (4385, 'Gagauzia', 144, 'MD', '46.09794350', '28.63846450'),
        (4386, 'Ungheni District', 144, 'MD', '47.23057670', '27.78926610'),
        (4387, 'Edineț District', 144, 'MD', '48.16789910', '27.29361430'),
        (4388, 'Șoldănești District', 144, 'MD', '47.81473890', '28.78895860'),
        (4389, 'Ocnița District', 144, 'MD', '48.41104350', '27.47680920'),
        (4390, 'Criuleni District', 144, 'MD', '47.21361140', '29.15575190'),
        (4391, 'Cahul District', 144, 'MD', '45.89394040', '28.18902750'),
        (4392, 'Drochia District', 144, 'MD', '48.07977880', '27.86041140'),
        (4393, 'Bălți Municipality', 144, 'MD', '47.75399470', '27.91841480'),
        (4394, 'Rezina District', 144, 'MD', '47.71804470', '28.88710240'),
        (4395, 'Transnistria autonomous territorial unit', 144, 'MD', '47.21529720', '29.46380540'),
        (4396, 'Salacgrīva Municipality', 120, 'LV', '57.75808830', '24.35431810'),
        (4397, 'Vecumnieki Municipality', 120, 'LV', '56.60623370', '24.52218910'),
        (4398, 'Naukšēni Municipality', 120, 'LV', '57.92953610', '25.51192660'),
        (4399, 'Ilūkste Municipality', 120, 'LV', '55.97825470', '26.29650880'),
        (4400, 'Gulbene Municipality', 120, 'LV', '57.21556450', '26.64529550'),
        (4401, 'Līvāni Municipality', 120, 'LV', '56.35509420', '26.17251900'),
        (4402, 'Salaspils Municipality', 120, 'LV', '56.86081520', '24.34978810'),
        (4403, 'Ventspils Municipality', 120, 'LV', '57.28336820', '21.85875580'),
        (4404, 'Rundāle Municipality', 120, 'LV', '56.40972100', '24.01241390'),
        (4405, 'Pļaviņas Municipality', 120, 'LV', '56.61773130', '25.71940430'),
        (4406, 'Vārkava Municipality', 120, 'LV', '56.24657440', '26.56643710'),
        (4407, 'Jaunpiebalga Municipality', 120, 'LV', '57.14334710', '25.99518880'),
        (4408, 'Sēja Municipality', 120, 'LV', '57.20069950', '24.59228210'),
        (4409, 'Tukums Municipality', 120, 'LV', '56.96728680', '23.15243790'),
        (4410, 'Cibla Municipality', 120, 'LV', '56.61023440', '27.86965980'),
        (4411, 'Burtnieki Municipality', 120, 'LV', '57.69490040', '25.27647770'),
        (4412, 'Ķegums Municipality', 120, 'LV', '56.74753570', '24.71736450'),
        (4413, 'Krustpils Municipality', 120, 'LV', '56.54155780', '26.24463970'),
        (4414, 'Cesvaine Municipality', 120, 'LV', '56.96792640', '26.30831720'),
        (4415, 'Skrīveri Municipality', 120, 'LV', '56.67613910', '25.09788490'),
        (4416, 'Ogre Municipality', 120, 'LV', '56.81473550', '24.60445550'),
        (4417, 'Olaine Municipality', 120, 'LV', '56.79523530', '24.01535890'),
        (4418, 'Limbaži Municipality', 120, 'LV', '57.54032270', '24.71344510'),
        (4419, 'Lubāna Municipality', 120, 'LV', '56.89992690', '26.71987890'),
        (4420, 'Kandava Municipality', 120, 'LV', '57.03406730', '22.78018130'),
        (4421, 'Ventspils', 120, 'LV', '57.39372160', '21.56470660'),
        (4422, 'Krimulda Municipality', 120, 'LV', '57.17912730', '24.71401270'),
        (4423, 'Rugāji Municipality', 120, 'LV', '57.00560230', '27.13172030'),
        (4424, 'Jelgava Municipality', 120, 'LV', '56.58956890', '23.66104810'),
        (4425, 'Valka Municipality', 120, 'LV', '57.77439000', '26.01700500'),
        (4426, 'Rūjiena Municipality', 120, 'LV', '57.89372910', '25.33910080'),
        (4427, 'Babīte Municipality', 120, 'LV', '56.95415500', '23.94539900'),
        (4428, 'Dundaga Municipality', 120, 'LV', '57.50491670', '22.35051140'),
        (4429, 'Priekule Municipality', 120, 'LV', '56.41794130', '21.55033360'),
        (4430, 'Zilupe Municipality', 120, 'LV', '56.30189850', '28.13395900'),
        (4431, 'Varakļāni Municipality', 120, 'LV', '56.66880060', '26.56364140'),
        (4432, 'Nereta Municipality', 120, 'LV', '56.19866550', '25.32529690'),
        (4433, 'Madona Municipality', 120, 'LV', '56.85989230', '26.22762010'),
        (4434, 'Sala Municipality', 120, 'LV', '59.96796130', '16.49782170'),
        (4435, 'Ķekava Municipality', 120, 'LV', '56.80643510', '24.19394930'),
        (4436, 'Nīca Municipality', 120, 'LV', '56.34649830', '21.06549300'),
        (4437, 'Dobele Municipality', 120, 'LV', '56.62630500', '23.28090660'),
        (4438, 'Jēkabpils Municipality', 120, 'LV', '56.29193200', '25.98120170'),
        (4439, 'Saldus Municipality', 120, 'LV', '56.66650880', '22.49354930'),
        (4440, 'Roja Municipality', 120, 'LV', '57.50467130', '22.80121640'),
        (4441, 'Iecava Municipality', 120, 'LV', '56.59867930', '24.19962720'),
        (4442, 'Ozolnieki Municipality', 120, 'LV', '56.67563050', '23.89948160'),
        (4443, 'Saulkrasti Municipality', 120, 'LV', '57.25794180', '24.41831460'),
        (4444, 'Ērgļi Municipality', 120, 'LV', '56.92370650', '25.67538520'),
        (4445, 'Aglona Municipality', 120, 'LV', '56.10890060', '27.12862270'),
        (4446, 'Jūrmala', 120, 'LV', '56.94707900', '23.61684850'),
        (4447, 'Skrunda Municipality', 120, 'LV', '56.66434580', '22.00457290'),
        (4448, 'Engure Municipality', 120, 'LV', '57.16235000', '23.21966340'),
        (4449, 'Inčukalns Municipality', 120, 'LV', '57.09943420', '24.68555700'),
        (4450, 'Mārupe Municipality', 120, 'LV', '56.89657170', '24.04600490'),
        (4451, 'Mērsrags Municipality', 120, 'LV', '57.33068810', '23.10237070'),
        (4452, 'Koknese Municipality', 120, 'LV', '56.72055600', '25.48939090'),
        (4453, 'Kārsava Municipality', 120, 'LV', '56.76458420', '27.73582950'),
        (4454, 'Carnikava Municipality', 120, 'LV', '57.10241210', '24.21086620'),
        (4455, 'Rēzekne Municipality', 120, 'LV', '56.32736380', '27.32843310'),
        (4456, 'Viesīte Municipality', 120, 'LV', '56.31130850', '25.50704640'),
        (4457, 'Ape Municipality', 120, 'LV', '57.53926970', '26.69416490'),
        (4458, 'Durbe Municipality', 120, 'LV', '56.62798570', '21.49162450'),
        (4459, 'Talsi Municipality', 120, 'LV', '57.34152080', '22.57131250'),
        (4460, 'Liepāja', 120, 'LV', '56.50466780', '21.01080600'),
        (4461, 'Mālpils Municipality', 120, 'LV', '57.00841190', '24.95742780'),
        (4462, 'Smiltene Municipality', 120, 'LV', '57.42303320', '25.90027800'),
        (4463, 'Daugavpils', 120, 'LV', '55.87473600', '26.53617900'),
        (4464, 'Jēkabpils', 120, 'LV', '56.50145500', '25.87829900'),
        (4465, 'Bauska Municipality', 120, 'LV', '56.41018680', '24.20006890'),
        (4466, 'Vecpiebalga Municipality', 120, 'LV', '57.06033560', '25.81615920'),
        (4467, 'Pāvilosta Municipality', 120, 'LV', '56.88654240', '21.19468490'),
        (4468, 'Brocēni Municipality', 120, 'LV', '56.73475410', '22.63573710'),
        (4469, 'Cēsis Municipality', 120, 'LV', '57.31028970', '25.26761250'),
        (4470, 'Grobiņa Municipality', 120, 'LV', '56.53963200', '21.16689200'),
        (4471, 'Beverīna Municipality', 120, 'LV', '57.51971090', '25.60736540'),
        (4472, 'Aizkraukle Municipality', 120, 'LV', '56.64610800', '25.23708540'),
        (4473, 'Valmiera', 120, 'LV', '57.53846590', '25.42636180'),
        (4474, 'Krāslava Municipality', 120, 'LV', '55.89514640', '27.18145770'),
        (4475, 'Jaunjelgava Municipality', 120, 'LV', '56.52836590', '25.39214430'),
        (4476, 'Sigulda Municipality', 120, 'LV', '57.10550920', '24.83142590'),
        (4477, 'Viļaka Municipality', 120, 'LV', '57.17222630', '27.66731880'),
        (4478, 'Stopiņi Municipality', 120, 'LV', '56.93644900', '24.28729490'),
        (4479, 'Rauna Municipality', 120, 'LV', '57.33169300', '25.61003390'),
        (4480, 'Tērvete Municipality', 120, 'LV', '56.41192010', '23.31883320'),
        (4481, 'Auce Municipality', 120, 'LV', '56.46016800', '22.90547810'),
        (4482, 'Baldone Municipality', 120, 'LV', '56.74246000', '24.39115440'),
        (4483, 'Preiļi Municipality', 120, 'LV', '56.15111570', '26.74397670'),
        (4484, 'Aloja Municipality', 120, 'LV', '57.76713600', '24.87708390'),
        (4485, 'Alsunga Municipality', 120, 'LV', '56.98285310', '21.55559190'),
        (4486, 'Viļāni Municipality', 120, 'LV', '56.54561710', '26.91679270'),
        (4487, 'Alūksne Municipality', 120, 'LV', '57.42544850', '27.04249680'),
        (4488, 'Līgatne Municipality', 120, 'LV', '57.19442040', '25.09406810'),
        (4489, 'Jaunpils Municipality', 120, 'LV', '56.73141940', '23.01256160'),
        (4490, 'Kuldīga Municipality', 120, 'LV', '56.96872570', '21.96137390'),
        (4491, 'Riga', 120, 'LV', '56.94964870', '24.10518650'),
        (4492, 'Daugavpils Municipality', 120, 'LV', '55.89917830', '26.61020120'),
        (4493, 'Ropaži Municipality', 120, 'LV', '56.96157860', '24.60104760'),
        (4494, 'Strenči Municipality', 120, 'LV', '57.62254710', '25.80480860'),
        (4495, 'Kocēni Municipality', 120, 'LV', '57.52262920', '25.33495070'),
        (4496, 'Aizpute Municipality', 120, 'LV', '56.71825960', '21.60727590'),
        (4497, 'Amata Municipality', 120, 'LV', '56.99387260', '25.26276750'),
        (4498, 'Baltinava Municipality', 120, 'LV', '56.94584680', '27.64410660'),
        (4499, 'Aknīste Municipality', 120, 'LV', '56.16130370', '25.74848270'),
        (4500, 'Jelgava', 120, 'LV', '56.65110910', '23.72135410'),
        (4501, 'Ludza Municipality', 120, 'LV', '56.54595900', '27.71431990'),
        (4502, 'Riebiņi Municipality', 120, 'LV', '56.34361900', '26.80181380'),
        (4503, 'Rucava Municipality', 120, 'LV', '56.15931240', '21.16181210'),
        (4504, 'Dagda Municipality', 120, 'LV', '56.09560890', '27.53245900'),
        (4505, 'Balvi Municipality', 120, 'LV', '57.13262400', '27.26466850'),
        (4506, 'Priekuļi Municipality', 120, 'LV', '57.36171380', '25.44104230'),
        (4507, 'Pārgauja Municipality', 120, 'LV', '57.36481220', '24.98220450'),
        (4508, 'Vaiņode Municipality', 120, 'LV', '56.41542710', '21.85139840'),
        (4509, 'Rēzekne', 120, 'LV', '56.50992230', '27.33313570'),
        (4510, 'Garkalne Municipality', 120, 'LV', '57.01903870', '24.38261810'),
        (4511, 'Ikšķile Municipality', 120, 'LV', '56.83736670', '24.49747450'),
        (4512, 'Lielvārde Municipality', 120, 'LV', '56.73929760', '24.97116180'),
        (4513, 'Mazsalaca Municipality', 120, 'LV', '57.92677490', '25.06698950'),
        (4514, 'Viqueque Municipality', 63, 'TL', '-8.85979180', '126.36335160'),
        (4515, 'Liquiçá Municipality', 63, 'TL', '-8.66740950', '125.25879640'),
        (4516, 'Ermera District', 63, 'TL', '-8.75248020', '125.39872940'),
        (4517, 'Manatuto District', 63, 'TL', '-8.51556080', '126.01592550'),
        (4518, 'Ainaro Municipality', 63, 'TL', '-9.01131710', '125.52200120'),
        (4519, 'Manufahi Municipality', 63, 'TL', '-9.01454950', '125.82799590'),
        (4520, 'Aileu municipality', 63, 'TL', '-8.70439940', '125.60954740'),
        (4521, 'Baucau Municipality', 63, 'TL', '-8.47143080', '126.45759910'),
        (4522, 'Cova Lima Municipality', 63, 'TL', '-9.26503750', '125.25879640'),
        (4523, 'Lautém Municipality', 63, 'TL', '-8.36423070', '126.90438450'),
        (4524, 'Dili municipality', 63, 'TL', '-8.24496130', '125.58766970'),
        (4525, 'Bobonaro Municipality', 63, 'TL', '-8.96554060', '125.25879640'),
        (4526, 'Peleliu', 168, 'PW', '7.00229060', '134.24316280'),
        (4527, 'Ngardmau', 168, 'PW', '7.58504860', '134.55960890'),
        (4528, 'Airai', 168, 'PW', '7.39661180', '134.56902250'),
        (4529, 'Hatohobei', 168, 'PW', '3.00706580', '131.12377810'),
        (4530, 'Melekeok', 168, 'PW', '7.51502860', '134.59725180'),
        (4531, 'Ngatpang', 168, 'PW', '7.47109940', '134.52664660'),
        (4532, 'Koror', 168, 'PW', '7.33756460', '134.48894690'),
        (4533, 'Ngarchelong', 168, 'PW', '7.71054690', '134.63016460'),
        (4534, 'Ngiwal', 168, 'PW', '7.56147640', '134.61606190'),
        (4535, 'Sonsorol', 168, 'PW', '5.32681190', '132.22391170'),
        (4536, 'Ngchesar', 168, 'PW', '7.45232800', '134.57843420'),
        (4537, 'Ngaraard', 168, 'PW', '7.60794000', '134.63486450'),
        (4538, 'Angaur', 168, 'PW', '6.90922300', '134.13879340'),
        (4539, 'Kayangel', 168, 'PW', '8.07000000', '134.70277800'),
        (4540, 'Aimeliik', 168, 'PW', '7.44558590', '134.50308780'),
        (4541, 'Ngeremlengui', 168, 'PW', '7.51983970', '134.55960890'),
        (4542, 'Břeclav', 58, 'CZ', '48.75314000', '16.88251690'),
        (4543, 'Český Krumlov', 58, 'CZ', '48.81273540', '14.31746570'),
        (4544, 'Plzeň-město', 58, 'CZ', '49.73843140', '13.37363710'),
        (4545, 'Brno-venkov', 58, 'CZ', '49.12501380', '16.45588240'),
        (4546, 'Příbram', 58, 'CZ', '49.69479590', '14.08238100'),
        (4547, 'Pardubice', 58, 'CZ', '49.94444790', '16.28569160'),
        (4548, 'Nový Jičín', 58, 'CZ', '49.59432510', '18.01353560'),
        (4550, 'Náchod', 58, 'CZ', '50.41457220', '16.16563470'),
        (4551, 'Prostějov', 58, 'CZ', '49.44184010', '17.12779040'),
        (4552, 'Zlínský kraj', 58, 'CZ', '49.21622960', '17.77203530'),
        (4553, 'Chomutov', 58, 'CZ', '50.45838720', '13.30179100'),
        (4554, 'Středočeský kraj', 58, 'CZ', '49.87822230', '14.93629550'),
        (4556, 'České Budějovice', 58, 'CZ', '48.97755530', '14.51507470'),
        (4558, 'Rakovník', 58, 'CZ', '50.10612300', '13.73966230'),
        (4559, 'Frýdek-Místek', 58, 'CZ', '49.68193050', '18.36732160'),
        (4560, 'Písek', 58, 'CZ', '49.34199380', '14.24697600'),
        (4561, 'Hodonín', 58, 'CZ', '48.85293910', '17.12600250'),
        (4563, 'Zlín', 58, 'CZ', '49.16960520', '17.80252200'),
        (4564, 'Plzeň-sever', 58, 'CZ', '49.87748930', '13.25374280'),
        (4565, 'Tábor', 58, 'CZ', '49.36462930', '14.71912930'),
        (4568, 'Brno-město', 58, 'CZ', '49.19506020', '16.60683710'),
        (4571, 'Svitavy', 58, 'CZ', '49.75516290', '16.46918610'),
        (4572, 'Vsetín', 58, 'CZ', '49.37932500', '18.06181620'),
        (4573, 'Cheb', 58, 'CZ', '50.07953340', '12.36986360'),
        (4574, 'Olomouc', 58, 'CZ', '49.59377800', '17.25087870'),
        (4575, 'Kraj Vysočina', 58, 'CZ', '49.44900520', '15.64059340'),
        (4576, 'Ústecký kraj', 58, 'CZ', '50.61190370', '13.78700860'),
        (4578, 'Prachatice', 58, 'CZ', '49.01091000', '14.00000050'),
        (4579, 'Trutnov', 58, 'CZ', '50.56538380', '15.90909230'),
        (4580, 'Hradec Králové', 58, 'CZ', '50.24148050', '15.67430000'),
        (4581, 'Karlovarský kraj', 58, 'CZ', '50.14350000', '12.75018990'),
        (4582, 'Nymburk', 58, 'CZ', '50.18558160', '15.04366040'),
        (4583, 'Rokycany', 58, 'CZ', '49.82628270', '13.68749430'),
        (4584, 'Ostrava-město', 58, 'CZ', '49.82092260', '18.26252430'),
        (4586, 'Karviná', 58, 'CZ', '49.85665240', '18.54321860'),
        (4588, 'Pardubický kraj', 58, 'CZ', '49.94444790', '16.28569160'),
        (4589, 'Olomoucký kraj', 58, 'CZ', '49.65865490', '17.08114060'),
        (4590, 'Liberec', 58, 'CZ', '50.75641010', '14.99650410'),
        (4591, 'Klatovy', 58, 'CZ', '49.39555490', '13.29509370'),
        (4592, 'Uherské Hradiště', 58, 'CZ', '49.05979690', '17.49585010'),
        (4593, 'Kroměříž', 58, 'CZ', '49.29165820', '17.39938000'),
        (4595, 'Sokolov', 58, 'CZ', '50.20134340', '12.60546360'),
        (4596, 'Semily', 58, 'CZ', '50.60515760', '15.32814090'),
        (4597, 'Třebíč', 58, 'CZ', '49.21478690', '15.87955160'),
        (4598, 'Praha, Hlavní město', 58, 'CZ', '50.07553810', '14.43780050'),
        (4599, 'Ústí nad Labem', 58, 'CZ', '50.61190370', '13.78700860'),
        (4600, 'Moravskoslezský kraj', 58, 'CZ', '49.73053270', '18.23326370'),
        (4601, 'Liberecký kraj', 58, 'CZ', '50.65942400', '14.76324240'),
        (4602, 'Jihomoravský kraj', 58, 'CZ', '48.95445280', '16.76768990'),
        (4604, 'Karlovy Vary', 58, 'CZ', '50.14350000', '12.75018990'),
        (4605, 'Litoměřice', 58, 'CZ', '50.53841970', '14.13054580'),
        (4606, 'Praha-východ', 58, 'CZ', '49.93893070', '14.79244720'),
        (4607, 'Plzeňský kraj', 58, 'CZ', '49.41348120', '13.31572460'),
        (4608, 'Plzeň-jih', 58, 'CZ', '49.59048850', '13.57158610'),
        (4609, 'Děčín', 58, 'CZ', '50.77255630', '14.21276120'),
        (4611, 'Havlíčkův Brod', 58, 'CZ', '49.60433640', '15.57965520'),
        (4612, 'Jablonec nad Nisou', 58, 'CZ', '50.72205280', '15.17031350'),
        (4613, 'Jihlava', 58, 'CZ', '49.39837820', '15.58704150'),
        (4614, 'Královéhradecký kraj', 58, 'CZ', '50.35124840', '15.79764590'),
        (4615, 'Blansko', 58, 'CZ', '49.36485020', '16.64775520'),
        (4617, 'Louny', 58, 'CZ', '50.35398120', '13.80335510'),
        (4618, 'Kolín', 58, 'CZ', '49.98832930', '15.05519770'),
        (4619, 'Praha-západ', 58, 'CZ', '49.89352350', '14.32937790'),
        (4620, 'Beroun', 58, 'CZ', '49.95734280', '13.98407150'),
        (4621, 'Teplice', 58, 'CZ', '50.65846050', '13.75132270'),
        (4622, 'Vyškov', 58, 'CZ', '49.21274450', '16.98559270'),
        (4623, 'Opava', 58, 'CZ', '49.90837570', '17.91633800'),
        (4624, 'Jindřichův Hradec', 58, 'CZ', '49.14448230', '15.00613890'),
        (4625, 'Jeseník', 58, 'CZ', '50.22462490', '17.19804710'),
        (4626, 'Přerov', 58, 'CZ', '49.46713560', '17.50773320'),
        (4627, 'Benešov', 58, 'CZ', '49.69008280', '14.77643990'),
        (4628, 'Strakonice', 58, 'CZ', '49.26040430', '13.91030850'),
        (4629, 'Most', 58, 'CZ', '37.15540830', '-94.29488840'),
        (4630, 'Znojmo', 58, 'CZ', '48.92723270', '16.10378080'),
        (4631, 'Kladno', 58, 'CZ', '50.19402580', '14.10436570'),
        (4633, 'Česká Lípa', 58, 'CZ', '50.67852010', '14.53969910'),
        (4634, 'Chrudim', 58, 'CZ', '49.88302160', '15.82908660'),
        (4636, 'Rychnov nad Kněžnou', 58, 'CZ', '50.16596510', '16.27768420'),
        (4638, 'Mělník', 58, 'CZ', '50.31044150', '14.51792230'),
        (4639, 'Jihočeský kraj', 58, 'CZ', '48.94577890', '14.44160550'),
        (4640, 'Jičín', 58, 'CZ', '50.43533250', '15.36104400'),
        (4641, 'Domažlice', 58, 'CZ', '49.43970270', '12.93114350'),
        (4642, 'Šumperk', 58, 'CZ', '49.97784070', '16.97177540'),
        (4643, 'Mladá Boleslav', 58, 'CZ', '50.42523170', '14.93624770'),
        (4644, 'Bruntál', 58, 'CZ', '49.98817670', '17.46369410'),
        (4645, 'Pelhřimov', 58, 'CZ', '49.43062070', '15.22298300'),
        (4646, 'Tachov', 58, 'CZ', '49.79878030', '12.63619210'),
        (4647, 'Ústí nad Orlicí', 58, 'CZ', '49.97218010', '16.39966170'),
        (4648, 'Žďár nad Sázavou', 58, 'CZ', '49.56430120', '15.93910300'),
        (4649, 'North East Community Development Council', 199, 'SG', '45.01181130', '-93.24681070'),
        (4650, 'South East Community Development Council', 199, 'SG', '39.28630700', '-76.56912370'),
        (4651, 'Central Singapore Community Development Council', 199, 'SG', '1.28951400', '103.81438790'),
        (4652, 'South West Community Development Council', 199, 'SG', '39.92569100', '-75.23105800'),
        (4653, 'North West Community Development Council', 199, 'SG', '39.10709300', '-94.45733600'),
        (4654, 'Ewa District', 153, 'NR', '-0.50872410', '166.93693840'),
        (4655, 'Uaboe District', 153, 'NR', '-0.52022220', '166.93117610'),
        (4656, 'Aiwo District', 153, 'NR', '-0.53400120', '166.91388730'),
        (4657, 'Meneng District', 153, 'NR', '-0.54672400', '166.93837900'),
        (4658, 'Anabar District', 153, 'NR', '-0.51335170', '166.94846240'),
        (4659, 'Nibok District', 153, 'NR', '-0.51962080', '166.91893010'),
        (4660, 'Baiti District', 153, 'NR', '-0.51043100', '166.92757440'),
        (4661, 'Ijuw District', 153, 'NR', '-0.52027670', '166.95710460'),
        (4662, 'Buada District', 153, 'NR', '-0.53287770', '166.92685410'),
        (4663, 'Anibare District', 153, 'NR', '-0.52947580', '166.95134320'),
        (4664, 'Yaren District', 153, 'NR', '-0.54668570', '166.92109130'),
        (4665, 'Boe District', 153, 'NR', '39.07327760', '-94.57104980'),
        (4666, 'Denigomodu District', 153, 'NR', '-0.52479640', '166.91676890'),
        (4667, 'Anetan District', 153, 'NR', '-0.50643430', '166.94270060'),
        (4668, 'Zhytomyr Oblast', 230, 'UA', '50.25465000', '28.65866690'),
        (4669, 'Vinnytsia Oblast', 230, 'UA', '49.23308300', '28.46821690'),
        (4670, 'Zakarpattia Oblast', 230, 'UA', '48.62080000', '22.28788300'),
        (4671, 'Kyiv Oblast', 230, 'UA', '50.05295060', '30.76671340'),
        (4672, 'Lviv Oblast', 230, 'UA', '49.83968300', '24.02971700'),
        (4673, 'Luhansk Oblast', 230, 'UA', '48.57404100', '39.30781500'),
        (4674, 'Ternopil Oblast', 230, 'UA', '49.55351700', '25.59476700'),
        (4675, 'Dnipropetrovsk Oblast', 230, 'UA', '48.46471700', '35.04618300'),
        (4676, 'Kiev', 230, 'UA', '50.45010000', '30.52340000'),
        (4677, 'Kirovohrad Oblast', 230, 'UA', '48.50793300', '32.26231700'),
        (4678, 'Chernivtsi Oblast', 230, 'UA', '48.29168300', '25.93521700'),
        (4679, 'Mykolaiv Oblast', 230, 'UA', '46.97503300', '31.99458290'),
        (4680, 'Cherkasy Oblast', 230, 'UA', '49.44443300', '32.05976700'),
        (4681, 'Khmelnytsky Oblast', 230, 'UA', '49.42298300', '26.98713310'),
        (4682, 'Ivano-Frankivsk Oblast', 230, 'UA', '48.92263300', '24.71111700'),
        (4683, 'Rivne Oblast', 230, 'UA', '50.61990000', '26.25161700'),
        (4684, 'Kherson Oblast', 230, 'UA', '46.63541700', '32.61686700'),
        (4685, 'Sumy Oblast', 230, 'UA', '50.90770000', '34.79810000'),
        (4686, 'Kharkiv Oblast', 230, 'UA', '49.99350000', '36.23038300'),
        (4687, 'Zaporizhzhya Oblast', 230, 'UA', '47.83880000', '35.13956700'),
        (4688, 'Odessa Oblast', 230, 'UA', '46.48458300', '30.73260000'),
        (4689, 'Autonomous Republic of Crimea', 230, 'UA', '44.95211700', '34.10241700'),
        (4690, 'Volyn Oblast', 230, 'UA', '50.74723300', '25.32538300'),
        (4691, 'Donetsk Oblast', 230, 'UA', '48.01588300', '37.80285000'),
        (4692, 'Chernihiv Oblast', 230, 'UA', '51.49820000', '31.28934990'),
        (4693, 'Gabrovo Province', 34, 'BG', '42.86847000', '25.31688900'),
        (4694, 'Smolyan Province', 34, 'BG', '41.57741480', '24.70108710'),
        (4695, 'Pernik Province', 34, 'BG', '42.60519900', '23.03779160'),
        (4696, 'Montana Province', 34, 'BG', '43.40851480', '23.22575890'),
        (4697, 'Vidin Province', 34, 'BG', '43.99617390', '22.86795150'),
        (4698, 'Razgrad Province', 34, 'BG', '43.52717050', '26.52412280'),
        (4699, 'Blagoevgrad Province', 34, 'BG', '42.02086140', '23.09433560'),
        (4700, 'Sliven Province', 34, 'BG', '42.68167020', '26.32285690'),
        (4701, 'Plovdiv Province', 34, 'BG', '42.13540790', '24.74529040'),
        (4702, 'Kardzhali Province', 34, 'BG', '41.63384160', '25.37766870'),
        (4703, 'Kyustendil Province', 34, 'BG', '42.28687990', '22.69396350'),
        (4704, 'Haskovo Province', 34, 'BG', '41.93441780', '25.55546720'),
        (4705, 'Sofia City Province', 34, 'BG', '42.75701090', '23.45046830'),
        (4706, 'Pleven Province', 34, 'BG', '43.41701690', '24.60667080'),
        (4707, 'Stara Zagora Province', 34, 'BG', '42.42577090', '25.63448550'),
        (4708, 'Silistra Province', 34, 'BG', '44.11471010', '27.26714540'),
        (4709, 'Veliko Tarnovo Province', 34, 'BG', '43.07565390', '25.61715000'),
        (4710, 'Lovech Province', 34, 'BG', '43.13677980', '24.71393350'),
        (4711, 'Vratsa Province', 34, 'BG', '43.21018060', '23.55292100'),
        (4712, 'Pazardzhik Province', 34, 'BG', '42.19275670', '24.33362260'),
        (4713, 'Ruse Province', 34, 'BG', '43.83559640', '25.96561440'),
        (4714, 'Targovishte Province', 34, 'BG', '43.24623490', '26.56912510'),
        (4715, 'Burgas Province', 34, 'BG', '42.50480000', '27.46260790'),
        (4716, 'Yambol Province', 34, 'BG', '42.48414940', '26.50352960'),
        (4717, 'Varna Province', 34, 'BG', '43.20464770', '27.91054880'),
        (4718, 'Dobrich Province', 34, 'BG', '43.57278600', '27.82728020'),
        (4719, 'Sofia Province', 34, 'BG', '42.67344000', '23.83349370'),
        (4720, 'Suceava County', 181, 'RO', '47.55055480', '25.74106200'),
        (4721, 'Hunedoara County', 181, 'RO', '45.79363800', '22.99759930'),
        (4722, 'Arges', 181, 'RO', '45.07225270', '24.81427260'),
        (4723, 'Bihor County', 181, 'RO', '47.01575160', '22.17226600'),
        (4724, 'Alba', 181, 'RO', '44.70091530', '8.03569110'),
        (4725, 'Ilfov County', 181, 'RO', '44.53554800', '26.23248860'),
        (4726, 'Giurgiu County', 181, 'RO', '43.90370760', '25.96992650'),
        (4727, 'Tulcea County', 181, 'RO', '45.04505650', '29.03249120'),
        (4728, 'Teleorman County', 181, 'RO', '44.01604910', '25.29866280'),
        (4729, 'Prahova County', 181, 'RO', '45.08919060', '26.08293130'),
        (4730, 'Bucharest', 181, 'RO', '44.42676740', '26.10253840'),
        (4731, 'Neamț County', 181, 'RO', '46.97586850', '26.38187640'),
        (4732, 'Călărași County', 181, 'RO', '44.36587150', '26.75486070'),
        (4733, 'Bistrița-Năsăud County', 181, 'RO', '47.24861070', '24.53228140'),
        (4734, 'Cluj County', 181, 'RO', '46.79417970', '23.61214920'),
        (4735, 'Iași County', 181, 'RO', '47.26796530', '27.21856620'),
        (4736, 'Braila', 181, 'RO', '45.26524630', '27.95947140'),
        (4737, 'Constanța County', 181, 'RO', '44.21298700', '28.25500550'),
        (4738, 'Olt County', 181, 'RO', '44.20079700', '24.50229810'),
        (4739, 'Arad County', 181, 'RO', '46.22836510', '21.65978190'),
        (4740, 'Botoșani County', 181, 'RO', '47.89240420', '26.75917810'),
        (4741, 'Sălaj County', 181, 'RO', '47.20908130', '23.21219010'),
        (4742, 'Dolj County', 181, 'RO', '44.16230220', '23.63250540'),
        (4743, 'Ialomița County', 181, 'RO', '44.60313300', '27.37899140'),
        (4744, 'Bacău County', 181, 'RO', '46.32581840', '26.66237800'),
        (4745, 'Dâmbovița County', 181, 'RO', '44.92898930', '25.42538500'),
        (4746, 'Satu Mare County', 181, 'RO', '47.76689050', '22.92413770'),
        (4747, 'Galați County', 181, 'RO', '45.78005690', '27.82515760'),
        (4748, 'Timiș County', 181, 'RO', '45.81389020', '21.33310550'),
        (4749, 'Harghita County', 181, 'RO', '46.49285070', '25.64566960'),
        (4750, 'Gorj County', 181, 'RO', '44.94855950', '23.24270790'),
        (4751, 'Mehedinți County', 181, 'RO', '44.55150530', '22.90441570'),
        (4752, 'Vaslui County', 181, 'RO', '46.46310590', '27.73980310'),
        (4753, 'Caraș-Severin County', 181, 'RO', '45.11396460', '22.07409930'),
        (4754, 'Covasna County', 181, 'RO', '45.94263470', '25.89189840'),
        (4755, 'Sibiu County', 181, 'RO', '45.92691060', '24.22548070'),
        (4756, 'Buzău County', 181, 'RO', '45.33509120', '26.71075780'),
        (4757, 'Vâlcea County', 181, 'RO', '45.07980510', '24.08352830'),
        (4758, 'Vrancea County', 181, 'RO', '45.81348760', '27.06575310'),
        (4759, 'Brașov County', 181, 'RO', '45.77818440', '25.22258000'),
        (4760, 'Maramureș County', 181, 'RO', '46.55699040', '24.67232150'),
        (4761, 'Aiga-i-le-Tai', 191, 'WS', '-13.85137910', '-172.03254010'),
        (4762, 'Satupa\'itea', 191, 'WS', '-13.65382140', '-172.61592710'),
        (4763, 'A\'ana', 191, 'WS', '-13.89841800', '-171.97529950'),
        (4764, 'Fa\'asaleleaga', 191, 'WS', '-13.63076380', '-172.23659810'),
        (4765, 'Atua', 191, 'WS', '-13.97870530', '-171.62542830'),
        (4766, 'Vaisigano', 191, 'WS', '-13.54138270', '-172.70233830'),
        (4767, 'Palauli', 191, 'WS', '-13.72945790', '-172.45361150'),
        (4768, 'Va\'a-o-Fonoti', 191, 'WS', '-13.94709030', '-171.54318720'),
        (4769, 'Gaga\'emauga', 191, 'WS', '-13.54286660', '-172.36688700'),
        (4770, 'Tuamasaga', 191, 'WS', '-13.91635920', '-171.82243620'),
        (4771, 'Gaga\'ifomauga', 191, 'WS', '-13.54680070', '-172.49693310'),
        (4772, 'Torba', 237, 'VU', '37.07653000', '27.45657300'),
        (4773, 'Penama', 237, 'VU', '-15.37957580', '167.90531820'),
        (4774, 'Shefa', 237, 'VU', '32.80576500', '35.16997100'),
        (4775, 'Malampa', 237, 'VU', '-16.40114050', '167.60778650'),
        (4776, 'Sanma', 237, 'VU', '-15.48400170', '166.91820970'),
        (4777, 'Tafea', 237, 'VU', '-18.72378270', '169.06450560'),
        (4778, 'Honiara', 202, 'SB', '-9.44563810', '159.97289990'),
        (4779, 'Temotu Province', 202, 'SB', '-10.68692900', '166.06239790'),
        (4780, 'Isabel Province', 202, 'SB', '-8.05923530', '159.14470810'),
        (4781, 'Choiseul Province', 202, 'SB', '-7.05014940', '156.95114590'),
        (4782, 'Makira-Ulawa Province', 202, 'SB', '-10.57374470', '161.80969410'),
        (4783, 'Malaita Province', 202, 'SB', '-8.94461680', '160.90712360'),
        (4784, 'Central Province', 202, 'SB', NULL, NULL),
        (4785, 'Guadalcanal Province', 202, 'SB', '-9.57732840', '160.14558050'),
        (4786, 'Western Province', 202, 'SB', NULL, NULL),
        (4787, 'Rennell and Bellona Province', 202, 'SB', '-11.61314350', '160.16939490'),
        (4788, 'Burgundy', 75, 'FR', '47.05250470', '4.38372150'),
        (4789, 'Auvergne', 75, 'FR', '45.70326950', '3.34485360'),
        (4790, 'Picardy', 75, 'FR', '49.66361270', '2.52807320'),
        (4791, 'Champagne-Ardenne', 75, 'FR', '48.79340920', '4.47252490'),
        (4792, 'Limousin', 75, 'FR', '45.89322310', '1.56960180'),
        (4793, 'Nord-Pas-de-Calais', 75, 'FR', '50.48011530', '2.79372650'),
        (4794, 'Saint Barthélemy', 75, 'FR', '17.90051340', '-62.82058710'),
        (4795, 'Nouvelle-Aquitaine', 75, 'FR', '45.70871820', '0.62689100'),
        (4796, 'Île-de-France', 75, 'FR', '48.84991980', '2.63704110'),
        (4797, 'Mayotte', 75, 'FR', '-12.82750000', '45.16624400'),
        (4798, 'Auvergne-Rhône-Alpes', 75, 'FR', '45.44714310', '4.38525070'),
        (4799, 'Occitania', 75, 'FR', '43.89272320', '3.28276250'),
        (4800, 'Alo', 75, 'FR', '40.71583620', '-73.95963170'),
        (4801, 'Lorraine', 75, 'FR', '48.87442330', '6.20809320'),
        (4802, 'Pays de la Loire', 75, 'FR', '47.76328360', '-0.32996870'),
        (4803, 'Languedoc-Roussillon', 75, 'FR', '43.59123560', '3.25836260'),
        (4804, 'Normandy', 75, 'FR', '48.87987040', '0.17125290'),
        (4805, 'Franche-Comté', 75, 'FR', '47.13432070', '6.02230160'),
        (4806, 'Corsica', 75, 'FR', '42.03960420', '9.01289260'),
        (4807, 'Brittany', 75, 'FR', '48.20204710', '-2.93264350'),
        (4808, 'Aquitaine', 75, 'FR', '44.70022220', '-0.29957850'),
        (4809, 'Saint Martin', 75, 'FR', '18.07082980', '-63.05008090'),
        (4810, 'Wallis and Futuna', 75, 'FR', '-14.29380000', '-178.11650000'),
        (4811, 'Alsace', 75, 'FR', '48.31817950', '7.44162410'),
        (4812, 'Provence-Alpes-Côte d\'Azur', 75, 'FR', '43.93516910', '6.06791940'),
        (4813, 'Rhône-Alpes', 75, 'FR', '45.64029050', '5.68649940'),
        (4814, 'Lower Normandy', 75, 'FR', '48.87884720', '-0.51574920'),
        (4815, 'Poitou-Charentes', 75, 'FR', '45.90355200', '-0.30918370'),
        (4816, 'Paris', 75, 'FR', '48.85661400', '2.35222190'),
        (4817, 'Uvea', 75, 'FR', '41.98329800', '-87.66836200'),
        (4818, 'Centre-Val de Loire', 75, 'FR', '47.75156860', '1.67506310'),
        (4819, 'Sigave', 75, 'FR', '-14.27325920', '-178.16329000'),
        (4820, 'Grand Est', 75, 'FR', '48.69980300', '6.18780740'),
        (4821, 'Saint Pierre and Miquelon', 75, 'FR', '46.88520000', '-56.31590000'),
        (4822, 'French Guiana', 75, 'FR', '3.93388900', '-53.12578200'),
        (4823, 'Réunion', 75, 'FR', '-21.11514100', '55.53638400'),
        (4824, 'French Polynesia', 75, 'FR', '-17.67974200', '-149.40684300'),
        (4825, 'Bourgogne-Franche-Comté', 75, 'FR', '47.28051270', '4.99943720'),
        (4826, 'Upper Normandy', 75, 'FR', '49.52464100', '0.88283290'),
        (4827, 'Martinique', 75, 'FR', '14.64152800', '-61.02417400'),
        (4828, 'Hauts-de-France', 75, 'FR', '50.48011530', '2.79372650'),
        (4829, 'Guadeloupe', 75, 'FR', '16.26500000', '-61.55100000'),
        (4830, 'West New Britain Province', 171, 'PG', '-5.70474320', '150.02594660'),
        (4831, 'Bougainville', 171, 'PG', '-6.37539190', '155.38071010'),
        (4832, 'Jiwaka Province', 171, 'PG', '-5.86911540', '144.69727740'),
        (4833, 'Hela', 171, 'PG', '42.33295160', '-83.04826180'),
        (4834, 'East New Britain', 171, 'PG', '-4.61289430', '151.88773210'),
        (4835, 'Morobe Province', 171, 'PG', '-6.80137370', '146.56164700'),
        (4836, 'Sandaun Province', 171, 'PG', '-3.71261790', '141.68342750'),
        (4837, 'Port Moresby', 171, 'PG', '-9.44380040', '147.18026710'),
        (4838, 'Oro Province', 171, 'PG', '-8.89880630', '148.18929210'),
        (4839, 'Gulf', 171, 'PG', '37.05483150', '-94.43704190'),
        (4840, 'Western Highlands Province', 171, 'PG', '-5.62681280', '144.25931180'),
        (4841, 'New Ireland Province', 171, 'PG', '-4.28532560', '152.92059180'),
        (4842, 'Manus Province', 171, 'PG', '-2.09411690', '146.87609510'),
        (4843, 'Madang Province', 171, 'PG', '-4.98497330', '145.13758340'),
        (4844, 'Southern Highlands Province', 171, 'PG', '-6.41790830', '143.56356370'),
        (4845, 'Eastern Highlands Province', 171, 'PG', '-6.58616740', '145.66896360'),
        (4846, 'Chimbu Province', 171, 'PG', '-6.30876820', '144.87312190'),
        (4847, 'Central Province', 171, 'PG', NULL, NULL),
        (4848, 'Enga Province', 171, 'PG', '-5.30058490', '143.56356370'),
        (4849, 'Milne Bay Province', 171, 'PG', '-9.52214510', '150.67496530'),
        (4850, 'Western Province', 171, 'PG', NULL, NULL),
        (4851, 'Ohio', 233, 'US', '40.41728710', '-82.90712300'),
        (4852, 'Ladakh', 101, 'IN', '34.22684750', '77.56194190'),
        (4853, 'West Bengal', 101, 'IN', '22.98675690', '87.85497550'),
        (4854, 'Sinop Province', 225, 'TR', '41.55947490', '34.85805320'),
        (4855, 'Capital District', 239, 'VE', '41.26148460', '-95.93108070'),
        (4856, 'Apure', 239, 'VE', '6.92694830', '-68.52471490'),
        (4857, 'Jalisco', 142, 'MX', '20.65953820', '-103.34943760'),
        (4858, 'Roraima', 31, 'BR', '2.73759710', '-62.07509980'),
        (4859, 'Guarda', 177, 'PT', '40.53859720', '-7.26757720'),
        (4860, 'Devonshire Parish', 25, 'BM', '32.30380620', '-64.76069540'),
        (4861, 'Hamilton Parish', 25, 'BM', '32.34494320', '-64.72365000'),
        (4862, 'Hamilton Municipality', 25, 'BM', '43.32394400', '-79.90592190'),
        (4863, 'Paget Parish', 25, 'BM', '32.28107400', '-64.77847870'),
        (4864, 'Pembroke Parish', 25, 'BM', '32.30076720', '-64.79626300'),
        (4865, 'Saint George\'s Municipality', 25, 'BM', '37.09652780', '-113.56841640'),
        (4866, 'Saint George\'s Parish', 25, 'BM', '17.12577590', '-62.56198110'),
        (4867, 'Sandys Parish', 25, 'BM', '32.29995280', '-64.86741030'),
        (4868, 'Smith\'s Parish,', 25, 'BM', '32.31339660', '-64.73105880'),
        (4869, 'Southampton Parish', 25, 'BM', '32.25400950', '-64.82590580'),
        (4870, 'Warwick Parish', 25, 'BM', '32.26615340', '-64.80811980'),
        (4871, 'Huila', 48, 'CO', '2.53593490', '-75.52766990'),
        (4874, 'Uroševac District (Ferizaj)', 248, 'XK', '42.37018440', '21.14832810'),
        (4876, 'Đakovica District (Gjakove)', 248, 'XK', '42.43757560', '20.37854380'),
        (4877, 'Gjilan District', 248, 'XK', '42.46352060', '21.46940110'),
        (4878, 'Kosovska Mitrovica District', 248, 'XK', '42.89139090', '20.86599950'),
        (4879, 'Pristina (Priştine)', 248, 'XK', '42.66291380', '21.16550280'),
        (4880, 'Autonomous City Of Buenos Aires', 11, 'AR', '-34.60368440', '-58.38155910'),
        (4881, 'New Providence', 17, 'BS', '40.69843480', '-74.40154050'),
        (4882, 'Shumen', 34, 'BG', '43.27123980', '26.93612860'),
        (4883, 'Yuen Long District', 98, 'HK', '22.44559000', '114.02218000'),
        (4884, 'Tsuen Wan District', 98, 'HK', '22.36281000', '114.12907000'),
        (4885, 'Tai Po District', 98, 'KH', '22.45085000', '114.16422000'),
        (4887, 'Sai Kung District', 98, 'HK', '22.38143000', '114.27052000'),
        (4888, 'Islands District', 98, 'HK', '22.26114000', '113.94608000'),
        (4889, 'Central and Western District', 98, 'HK', '22.28666000', '114.15497000'),
        (4890, 'Wan Chai', 98, 'HK', '22.27968000', '114.17168000'),
        (4891, 'Eastern', 98, 'HK', '22.28411000', '114.22414000'),
        (4892, 'Southern', 98, 'HK', '22.24725000', '114.15884000'),
        (4893, 'Yau Tsim Mong', 98, 'HK', '22.32138000', '114.17260000'),
        (4894, 'Sham Shui Po', 98, 'HK', '22.33074000', '114.16220000'),
        (4895, 'Kowloon City', 98, 'HK', '22.32820000', '114.19155000'),
        (4896, 'Wong Tai Sin', 98, 'HK', '22.33353000', '114.19686000'),
        (4897, 'Kwun Tong', 98, 'HK', '22.31326000', '114.22581000'),
        (4898, 'Kwai Tsing', 98, 'HK', '22.35488000', '114.08401000'),
        (4899, 'Tuen Mun', 98, 'HK', '22.39163000', '113.97708850'),
        (4900, 'North', 98, 'HK', '22.49471000', '114.13812000'),
        (4901, 'Sha Tin', 98, 'HK', '22.38715000', '114.19534000'),
        (4902, 'Sidi Bel Abbès', 4, 'DZ', '34.68060240', '-1.09994950'),
        (4905, 'El M\'ghair', 4, 'DZ', '33.95405610', '5.13464180'),
        (4906, 'El Menia', 4, 'DZ', '31.36422500', '2.57844950'),
        (4907, 'Ouled Djellal', 4, 'DZ', '34.41782210', '4.96858430'),
        (4908, 'Bordj Baji Mokhtar', 4, 'DZ', '22.96633500', '-3.94727320'),
        (4909, 'Béni Abbès', 4, 'DZ', '30.08310420', '-2.83450520'),
        (4910, 'Timimoun', 4, 'DZ', '29.67890600', '0.50046080'),
        (4911, 'Touggourt', 4, 'DZ', '33.12484760', '5.78327150'),
        (4912, 'Djanet', 4, 'DZ', '23.83108720', '8.70046720'),
        (4913, 'In Salah', 4, 'DZ', '27.21492290', '1.84843960'),
        (4914, 'In Guezzam', 4, 'DZ', '20.38643230', '4.77893940'),
        (4915, 'Mureș County', 181, 'RO', '46.55699040', '24.67232150'),
        (4916, 'Volgograd Oblast', 182, 'RU', '49.25873930', '39.81544630'),
        (4917, 'La Colle', 145, 'MC', '43.73274650', '7.41372760'),
        (4918, 'La Condamine', 145, 'MC', '43.73506650', '7.41990600'),
        (4919, 'Moneghetti', 145, 'MC', '43.73649270', '7.41533830'),
        (4920, 'Hamadan Province', 103, 'IR', '34.91936070', '47.48329250'),
        (4921, 'Bogotá', 48, 'CO', '4.28204150', '-74.50270420'),
        (4922, 'Loreto', 173, 'PE', '-4.37416430', '-76.13042640'),
        (4923, 'Kutná Hora', 58, 'CZ', '49.94920890', '15.24704400'),
        (4924, 'Kōchi Prefecture', 109, 'JP', '33.28791610', '132.27592620'),
        (4925, 'Cần Thơ', 240, 'VN', '10.03418510', '105.72255070'),
        (4926, 'Rivers', 161, 'NG', '5.02134200', '6.43760220'),
        (4927, 'Rabat-Salé-Kénitra', 149, 'MA', '34.07686400', '-7.34544760'),
        (4928, 'Agadir-Ida-Ou-Tanane', 149, 'MA', '30.64620910', '-9.83390610'),
        (4929, 'Berrechid', 149, 'MA', '33.26025230', '-7.59848370'),
        (4930, 'Casablanca', 149, 'MA', '33.57226780', '-7.65703260'),
        (4931, 'Driouch', 149, 'MA', '34.97603200', '-3.39644930'),
        (4932, 'Fès', 149, 'MA', '34.02395790', '-5.03675990'),
        (4933, 'Fquih Ben Salah', 149, 'MA', '32.50016800', '-6.71007170'),
        (4934, 'Guercif', 149, 'MA', '34.23450360', '-3.38130050'),
        (4935, 'Marrakech', 149, 'MA', '31.63460230', '-8.07789320'),
        (4936, 'M’diq-Fnideq', 149, 'MA', '35.77330190', '-5.51433000'),
        (4937, 'Meknès', 149, 'MA', '33.88100000', '-5.57303970'),
        (4938, 'Midelt', 149, 'MA', '32.68550790', '-4.75017090'),
        (4939, 'Mohammadia', 149, 'MA', '33.68737490', '-7.42391420'),
        (4940, 'Oujda-Angad', 149, 'MA', '34.68375040', '-2.29932390'),
        (4941, 'Ouezzane', 149, 'MA', '34.80634500', '-5.59145050'),
        (4942, 'Rabat', 149, 'MA', '33.96919900', '-6.92730290'),
        (4943, 'Rehamna', 149, 'MA', '32.20329050', '-8.56896710'),
        (4944, 'Salé', 149, 'MA', '34.03775700', '-6.84270730'),
        (4945, 'Sidi Bennour', 149, 'MA', '32.64926020', '-8.44714530'),
        (4946, 'Sidi Ifni', 149, 'MA', '29.36657970', '-10.21084850'),
        (4947, 'Skhirate-Témara', 149, 'MA', '33.76224250', '-7.04190520'),
        (4948, 'Tarfaya (EH-partial)', 149, 'MA', '27.93777010', '-12.92940630'),
        (4949, 'Tinghir', 149, 'MA', '31.48507940', '-6.20192980'),
        (4950, 'Tanger-Assilah', 149, 'MA', '35.76325390', '-5.90450980'),
        (4951, 'Youssoufia', 149, 'MA', '32.02006790', '-8.86926480'),
        (4952, 'Sidi Slimane', 149, 'MA', '34.27378280', '-5.98059720'),
        (4953, 'Lualaba', 51, 'CD', '-10.48086980', '25.62978160'),
        (4954, 'Chaiyaphum', 219, 'TH', '16.00749740', '101.61291720'),
        (4955, 'Mbeya', 218, 'TZ', '-8.28661120', '32.81325370'),
        (4956, 'Songwe', 218, 'TZ', '-8.27261200', '31.71131740');";
    $inserted = $wpdb->query($query);   // Dump data into table
    if($inserted){
        $result = $inserted;
        $msg = 'States added successfully';
    }else{
        $result = $inserted;
        $msg = $wpdb->last_error;
    }
    $commit = $wpdb->query("ALTER TABLE `".esc_sql($wp_iws_states)."` ADD CONSTRAINT `iws_country_region_final` FOREIGN KEY (`country_id`) REFERENCES `".esc_sql($wp_iws_countries)."` (`id`);");
    $commit = $wpdb->query("COMMIT;");   // COMMIT changes
}else{
    $result = $table_created;
    $msg = $wpdb->last_error;
}
